/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.spark;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.adapter.jdbc.JdbcConvention;
import org.apache.calcite.adapter.jdbc.JdbcImplementor;
import org.apache.calcite.adapter.jdbc.JdbcRel;
import org.apache.calcite.adapter.jdbc.JdbcSchema;
import org.apache.calcite.adapter.spark.SparkRel;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterImpl;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rel2sql.SqlImplementor;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.util.BuiltInMethod;

public class JdbcToSparkConverter
extends ConverterImpl
implements SparkRel {
    protected JdbcToSparkConverter(RelOptCluster cluster, RelTraitSet traits, RelNode input) {
        super(cluster, (RelTraitDef)ConventionTraitDef.INSTANCE, traits, input);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new JdbcToSparkConverter(this.getCluster(), traitSet, (RelNode)JdbcToSparkConverter.sole(inputs));
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.1);
    }

    @Override
    public SparkRel.Result implementSpark(SparkRel.Implementor implementor) {
        BlockBuilder list = new BlockBuilder();
        JdbcRel child = (JdbcRel)this.getInput();
        PhysType physType = PhysTypeImpl.of((JavaTypeFactory)implementor.getTypeFactory(), (RelDataType)this.getRowType(), (JavaRowFormat)JavaRowFormat.CUSTOM);
        JdbcConvention jdbcConvention = (JdbcConvention)child.getConvention();
        String sql = this.generateSql(jdbcConvention.dialect);
        if (((Boolean)CalciteSystemProperty.DEBUG.value()).booleanValue()) {
            System.out.println("[" + sql + "]");
        }
        Expression sqlLiteral = list.append("sql", (Expression)Expressions.constant((Object)sql));
        ArrayList<Primitive> primitives = new ArrayList<Primitive>();
        for (int i = 0; i < this.getRowType().getFieldCount(); ++i) {
            Primitive primitive = Primitive.ofBoxOr((Type)physType.fieldClass(i));
            primitives.add(primitive != null ? primitive : Primitive.OTHER);
        }
        Expression primitivesLiteral = list.append("primitives", (Expression)Expressions.constant((Object)primitives.toArray(new Primitive[0])));
        Expression enumerable = list.append("enumerable", (Expression)Expressions.call((Method)BuiltInMethod.RESULT_SET_ENUMERABLE_OF.method, (Expression[])new Expression[]{Expressions.call((Expression)Expressions.convert_((Expression)jdbcConvention.expression, JdbcSchema.class), (Method)BuiltInMethod.JDBC_SCHEMA_DATA_SOURCE.method, (Expression[])new Expression[0]), sqlLiteral, primitivesLiteral}));
        list.add((Statement)Expressions.return_(null, (Expression)enumerable));
        return implementor.result(physType, list.toBlock());
    }

    private String generateSql(SqlDialect dialect) {
        JdbcImplementor jdbcImplementor = new JdbcImplementor(dialect, (JavaTypeFactory)this.getCluster().getTypeFactory());
        SqlImplementor.Result result = jdbcImplementor.visitChild(0, this.getInput());
        return result.asStatement().toSqlString(dialect).getSql();
    }
}

