/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import org.apache.calcite.sql.parser.SqlParserImplFactory;
import org.apache.calcite.sql.parser.SqlParserTest;
import org.apache.calcite.sql.parser.ddl.SqlDdlParserImpl;
import org.junit.Test;

public class ServerParserTest
extends SqlParserTest {
    protected SqlParserImplFactory parserImplFactory() {
        return SqlDdlParserImpl.FACTORY;
    }

    @Test
    public void testCreateSchema() {
        this.sql("create schema x").ok("CREATE SCHEMA `X`");
    }

    @Test
    public void testCreateOrReplaceSchema() {
        this.sql("create or replace schema x").ok("CREATE OR REPLACE SCHEMA `X`");
    }

    @Test
    public void testCreateForeignSchema() {
        String sql = "create or replace foreign schema x\ntype 'jdbc'\noptions (\n  aBoolean true,\n  anInteger -45,\n  aDate DATE '1970-03-21',\n  \"quoted.id\" TIMESTAMP '1970-03-21 12:4:56.78',\n  aString 'foo''bar')";
        String expected = "CREATE OR REPLACE FOREIGN SCHEMA `X` TYPE 'jdbc' OPTIONS (`ABOOLEAN` TRUE, `ANINTEGER` -45, `ADATE` DATE '1970-03-21', `quoted.id` TIMESTAMP '1970-03-21 12:04:56.78', `ASTRING` 'foo''bar')";
        this.sql("create or replace foreign schema x\ntype 'jdbc'\noptions (\n  aBoolean true,\n  anInteger -45,\n  aDate DATE '1970-03-21',\n  \"quoted.id\" TIMESTAMP '1970-03-21 12:4:56.78',\n  aString 'foo''bar')").ok("CREATE OR REPLACE FOREIGN SCHEMA `X` TYPE 'jdbc' OPTIONS (`ABOOLEAN` TRUE, `ANINTEGER` -45, `ADATE` DATE '1970-03-21', `quoted.id` TIMESTAMP '1970-03-21 12:04:56.78', `ASTRING` 'foo''bar')");
    }

    @Test
    public void testCreateForeignSchema2() {
        String sql = "create or replace foreign schema x\nlibrary 'com.example.ExampleSchemaFactory'\noptions ()";
        String expected = "CREATE OR REPLACE FOREIGN SCHEMA `X` LIBRARY 'com.example.ExampleSchemaFactory' OPTIONS ()";
        this.sql("create or replace foreign schema x\nlibrary 'com.example.ExampleSchemaFactory'\noptions ()").ok("CREATE OR REPLACE FOREIGN SCHEMA `X` LIBRARY 'com.example.ExampleSchemaFactory' OPTIONS ()");
    }

    @Test
    public void testCreateTypeWithAttributeList() {
        this.sql("create type x.mytype1 as (i int not null, j varchar(5) null)").ok("CREATE TYPE `X`.`MYTYPE1` AS (`I` INTEGER NOT NULL, `J` VARCHAR(5))");
    }

    @Test
    public void testCreateTypeWithBaseType() {
        this.sql("create type mytype1 as varchar(5)").ok("CREATE TYPE `MYTYPE1` AS VARCHAR(5)");
    }

    @Test
    public void testCreateOrReplaceTypeWith() {
        this.sql("create or replace type mytype1 as varchar(5)").ok("CREATE OR REPLACE TYPE `MYTYPE1` AS VARCHAR(5)");
    }

    @Test
    public void testCreateTable() {
        this.sql("create table x (i int not null, j varchar(5) null)").ok("CREATE TABLE `X` (`I` INTEGER NOT NULL, `J` VARCHAR(5))");
    }

    @Test
    public void testCreateTableAsSelect() {
        String expected = "CREATE TABLE `X` AS\nSELECT *\nFROM `EMP`";
        this.sql("create table x as select * from emp").ok("CREATE TABLE `X` AS\nSELECT *\nFROM `EMP`");
    }

    @Test
    public void testCreateTableIfNotExistsAsSelect() {
        String expected = "CREATE TABLE IF NOT EXISTS `X`.`Y` AS\nSELECT *\nFROM `EMP`";
        this.sql("create table if not exists x.y as select * from emp").ok("CREATE TABLE IF NOT EXISTS `X`.`Y` AS\nSELECT *\nFROM `EMP`");
    }

    @Test
    public void testCreateTableAsValues() {
        String expected = "CREATE TABLE `X` AS\nVALUES (ROW(1)),\n(ROW(2))";
        this.sql("create table x as values 1, 2").ok("CREATE TABLE `X` AS\nVALUES (ROW(1)),\n(ROW(2))");
    }

    @Test
    public void testCreateTableAsSelectColumnList() {
        String expected = "CREATE TABLE `X` (`A`, `B`) AS\nSELECT *\nFROM `EMP`";
        this.sql("create table x (a, b) as select * from emp").ok("CREATE TABLE `X` (`A`, `B`) AS\nSELECT *\nFROM `EMP`");
    }

    @Test
    public void testCreateTableCheck() {
        String expected = "CREATE TABLE `X` (`I` INTEGER NOT NULL, CONSTRAINT `C1` CHECK (`I` < 10), `J` INTEGER)";
        this.sql("create table x (i int not null, constraint c1 check (i < 10), j int)").ok("CREATE TABLE `X` (`I` INTEGER NOT NULL, CONSTRAINT `C1` CHECK (`I` < 10), `J` INTEGER)");
    }

    @Test
    public void testCreateTableVirtualColumn() {
        String sql = "create table if not exists x (\n i int not null,\n j int generated always as (i + 1) stored,\n k int as (j + 1) virtual,\n m int as (k + 1))";
        String expected = "CREATE TABLE IF NOT EXISTS `X` (`I` INTEGER NOT NULL, `J` INTEGER AS (`I` + 1) STORED, `K` INTEGER AS (`J` + 1) VIRTUAL, `M` INTEGER AS (`K` + 1) VIRTUAL)";
        this.sql("create table if not exists x (\n i int not null,\n j int generated always as (i + 1) stored,\n k int as (j + 1) virtual,\n m int as (k + 1))").ok("CREATE TABLE IF NOT EXISTS `X` (`I` INTEGER NOT NULL, `J` INTEGER AS (`I` + 1) STORED, `K` INTEGER AS (`J` + 1) VIRTUAL, `M` INTEGER AS (`K` + 1) VIRTUAL)");
    }

    @Test
    public void testCreateView() {
        String sql = "create or replace view v as\nselect * from (values (1, '2'), (3, '45')) as t (x, y)";
        String expected = "CREATE OR REPLACE VIEW `V` AS\nSELECT *\nFROM (VALUES (ROW(1, '2')),\n(ROW(3, '45'))) AS `T` (`X`, `Y`)";
        this.sql("create or replace view v as\nselect * from (values (1, '2'), (3, '45')) as t (x, y)").ok("CREATE OR REPLACE VIEW `V` AS\nSELECT *\nFROM (VALUES (ROW(1, '2')),\n(ROW(3, '45'))) AS `T` (`X`, `Y`)");
    }

    @Test
    public void testCreateMaterializedView() {
        String sql = "create materialized view mv (d, v) as\nselect deptno, count(*) from emp\ngroup by deptno order by deptno desc";
        String expected = "CREATE MATERIALIZED VIEW `MV` (`D`, `V`) AS\nSELECT `DEPTNO`, COUNT(*)\nFROM `EMP`\nGROUP BY `DEPTNO`\nORDER BY `DEPTNO` DESC";
        this.sql("create materialized view mv (d, v) as\nselect deptno, count(*) from emp\ngroup by deptno order by deptno desc").ok("CREATE MATERIALIZED VIEW `MV` (`D`, `V`) AS\nSELECT `DEPTNO`, COUNT(*)\nFROM `EMP`\nGROUP BY `DEPTNO`\nORDER BY `DEPTNO` DESC");
    }

    @Test
    public void testCreateMaterializedView2() {
        String sql = "create materialized view if not exists mv as\nselect deptno, count(*) from emp\ngroup by deptno order by deptno desc";
        String expected = "CREATE MATERIALIZED VIEW IF NOT EXISTS `MV` AS\nSELECT `DEPTNO`, COUNT(*)\nFROM `EMP`\nGROUP BY `DEPTNO`\nORDER BY `DEPTNO` DESC";
        this.sql("create materialized view if not exists mv as\nselect deptno, count(*) from emp\ngroup by deptno order by deptno desc").ok("CREATE MATERIALIZED VIEW IF NOT EXISTS `MV` AS\nSELECT `DEPTNO`, COUNT(*)\nFROM `EMP`\nGROUP BY `DEPTNO`\nORDER BY `DEPTNO` DESC");
    }

    @Test
    public void testCreateOrReplaceMaterializedView() {
        String sql = "create or replace materialized view mv as\nselect * from emp";
        String expected = "CREATE MATERIALIZED VIEW `MV` AS\nSELECT *\nFROM `EMP`";
        this.sql("create or replace materialized view mv as\nselect * from emp").ok("CREATE MATERIALIZED VIEW `MV` AS\nSELECT *\nFROM `EMP`");
    }

    @Test
    public void testCreateOrReplaceFunction() {
        String sql = "create or replace function if not exists x.udf\n as 'org.apache.calcite.udf.TableFun.demoUdf'\nusing jar 'file:/path/udf/udf-0.0.1-SNAPSHOT.jar',\n jar 'file:/path/udf/udf2-0.0.1-SNAPSHOT.jar',\n file 'file:/path/udf/logback.xml'";
        String expected = "CREATE OR REPLACE FUNCTION IF NOT EXISTS `X`.`UDF` AS 'org.apache.calcite.udf.TableFun.demoUdf' USING JAR 'file:/path/udf/udf-0.0.1-SNAPSHOT.jar', JAR 'file:/path/udf/udf2-0.0.1-SNAPSHOT.jar', FILE 'file:/path/udf/logback.xml'";
        this.sql("create or replace function if not exists x.udf\n as 'org.apache.calcite.udf.TableFun.demoUdf'\nusing jar 'file:/path/udf/udf-0.0.1-SNAPSHOT.jar',\n jar 'file:/path/udf/udf2-0.0.1-SNAPSHOT.jar',\n file 'file:/path/udf/logback.xml'").ok("CREATE OR REPLACE FUNCTION IF NOT EXISTS `X`.`UDF` AS 'org.apache.calcite.udf.TableFun.demoUdf' USING JAR 'file:/path/udf/udf-0.0.1-SNAPSHOT.jar', JAR 'file:/path/udf/udf2-0.0.1-SNAPSHOT.jar', FILE 'file:/path/udf/logback.xml'");
    }

    @Test
    public void testCreateOrReplaceFunction2() {
        String sql = "create function \"my Udf\"\n as 'org.apache.calcite.udf.TableFun.demoUdf'";
        String expected = "CREATE FUNCTION `my Udf` AS 'org.apache.calcite.udf.TableFun.demoUdf'";
        this.sql("create function \"my Udf\"\n as 'org.apache.calcite.udf.TableFun.demoUdf'").ok("CREATE FUNCTION `my Udf` AS 'org.apache.calcite.udf.TableFun.demoUdf'");
    }

    @Test
    public void testDropSchema() {
        this.sql("drop schema x").ok("DROP SCHEMA `X`");
    }

    @Test
    public void testDropSchemaIfExists() {
        this.sql("drop schema if exists x").ok("DROP SCHEMA IF EXISTS `X`");
    }

    @Test
    public void testDropForeignSchema() {
        this.sql("drop foreign schema x").ok("DROP FOREIGN SCHEMA `X`");
    }

    @Test
    public void testDropType() {
        this.sql("drop type X").ok("DROP TYPE `X`");
    }

    @Test
    public void testDropTypeIfExists() {
        this.sql("drop type if exists X").ok("DROP TYPE IF EXISTS `X`");
    }

    @Test
    public void testDropTypeTrailingIfExistsFails() {
        this.sql("drop type X ^if^ exists").fails("(?s)Encountered \"if\" at.*");
    }

    @Test
    public void testDropTable() {
        this.sql("drop table x").ok("DROP TABLE `X`");
    }

    @Test
    public void testDropTableComposite() {
        this.sql("drop table x.y").ok("DROP TABLE `X`.`Y`");
    }

    @Test
    public void testDropTableIfExists() {
        this.sql("drop table if exists x").ok("DROP TABLE IF EXISTS `X`");
    }

    @Test
    public void testDropView() {
        this.sql("drop view x").ok("DROP VIEW `X`");
    }

    @Test
    public void testDropMaterializedView() {
        this.sql("drop materialized view x").ok("DROP MATERIALIZED VIEW `X`");
    }

    @Test
    public void testDropMaterializedViewIfExists() {
        this.sql("drop materialized view if exists x").ok("DROP MATERIALIZED VIEW IF EXISTS `X`");
    }

    @Test
    public void testDropFunction() {
        String sql = "drop function x.udf";
        String expected = "DROP FUNCTION `X`.`UDF`";
        this.sql("drop function x.udf").ok("DROP FUNCTION `X`.`UDF`");
    }

    @Test
    public void testDropFunctionIfExists() {
        String sql = "drop function if exists \"my udf\"";
        String expected = "DROP FUNCTION IF EXISTS `my udf`";
        this.sql("drop function if exists \"my udf\"").ok("DROP FUNCTION IF EXISTS `my udf`");
    }
}

