/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.ddl;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.runtime.Resources;
import org.apache.calcite.sql.SqlDrop;
import org.apache.calcite.sql.SqlExecutableStatement;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.Static;

abstract class SqlDropObject
extends SqlDrop
implements SqlExecutableStatement {
    protected final SqlIdentifier name;

    SqlDropObject(SqlOperator operator, SqlParserPos pos, boolean ifExists, SqlIdentifier name) {
        super(operator, pos, ifExists);
        this.name = name;
    }

    public List<SqlNode> getOperandList() {
        return ImmutableList.of((Object)this.name);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword(this.getOperator().getName());
        if (this.ifExists) {
            writer.keyword("IF EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
    }

    public void execute(CalcitePrepare.Context context) {
        List path = context.getDefaultSchemaPath();
        CalciteSchema schema = context.getRootSchema();
        for (String p : path) {
            schema = schema.getSubSchema(p, true);
        }
        switch (this.getKind()) {
            case DROP_TABLE: 
            case DROP_MATERIALIZED_VIEW: {
                boolean existed = schema.removeTable(this.name.getSimple());
                if (existed || this.ifExists) break;
                throw SqlUtil.newContextException((SqlParserPos)this.name.getParserPosition(), (Resources.ExInst)Static.RESOURCE.tableNotFound(this.name.getSimple()));
            }
            case DROP_VIEW: {
                boolean existed = schema.removeFunction(this.name.getSimple());
                if (existed || this.ifExists) break;
                throw SqlUtil.newContextException((SqlParserPos)this.name.getParserPosition(), (Resources.ExInst)Static.RESOURCE.viewNotFound(this.name.getSimple()));
            }
            case DROP_TYPE: {
                boolean existed = schema.removeType(this.name.getSimple());
                if (existed || this.ifExists) break;
                throw SqlUtil.newContextException((SqlParserPos)this.name.getParserPosition(), (Resources.ExInst)Static.RESOURCE.typeNotFound(this.name.getSimple()));
            }
            default: {
                throw new AssertionError(this.getKind());
            }
        }
    }
}

