/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.ddl;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlCreate;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlExecutableStatement;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.ddl.SqlAttributeDefinition;
import org.apache.calcite.sql.ddl.SqlDdlNodes;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.calcite.util.Pair;

public class SqlCreateType
extends SqlCreate
implements SqlExecutableStatement {
    private final SqlIdentifier name;
    private final SqlNodeList attributeDefs;
    private final SqlDataTypeSpec dataType;
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("CREATE TYPE", SqlKind.CREATE_TYPE);

    SqlCreateType(SqlParserPos pos, boolean replace, SqlIdentifier name, SqlNodeList attributeDefs, SqlDataTypeSpec dataType) {
        super(OPERATOR, pos, replace, false);
        this.name = Objects.requireNonNull(name);
        this.attributeDefs = attributeDefs;
        this.dataType = dataType;
    }

    public void execute(CalcitePrepare.Context context) {
        Pair<CalciteSchema, String> pair = SqlDdlNodes.schema(context, true, this.name);
        ((CalciteSchema)pair.left).add((String)pair.right, typeFactory -> {
            if (this.dataType != null) {
                return this.dataType.deriveType(typeFactory);
            }
            RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
            for (SqlNode def : this.attributeDefs) {
                SqlAttributeDefinition attributeDef = (SqlAttributeDefinition)def;
                SqlDataTypeSpec typeSpec = attributeDef.dataType;
                RelDataType type = typeSpec.deriveType(typeFactory);
                if (type == null) {
                    Pair<CalciteSchema, String> pair1 = SqlDdlNodes.schema(context, false, typeSpec.getTypeName());
                    type = (RelDataType)((CalciteSchema)pair1.left).getType((String)pair1.right, false).getType().apply(typeFactory);
                }
                builder.add(attributeDef.name.getSimple(), type);
            }
            return builder.build();
        });
    }

    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.name, (Object)this.attributeDefs);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        if (this.getReplace()) {
            writer.keyword("CREATE OR REPLACE");
        } else {
            writer.keyword("CREATE");
        }
        writer.keyword("TYPE");
        this.name.unparse(writer, leftPrec, rightPrec);
        writer.keyword("AS");
        if (this.attributeDefs != null) {
            SqlWriter.Frame frame = writer.startList("(", ")");
            for (SqlNode a : this.attributeDefs) {
                writer.sep(",");
                a.unparse(writer, 0, 0);
            }
            writer.endList(frame);
        } else if (this.dataType != null) {
            this.dataType.unparse(writer, leftPrec, rightPrec);
        }
    }
}

