/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.ddl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.runtime.Resources;
import org.apache.calcite.schema.ColumnStrategy;
import org.apache.calcite.schema.ModifiableTable;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.Wrapper;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.calcite.schema.impl.AbstractTableQueryable;
import org.apache.calcite.schema.impl.ViewTable;
import org.apache.calcite.schema.impl.ViewTableMacro;
import org.apache.calcite.sql.SqlCreate;
import org.apache.calcite.sql.SqlExecutableStatement;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.ddl.SqlColumnDeclaration;
import org.apache.calcite.sql.ddl.SqlDdlNodes;
import org.apache.calcite.sql.dialect.CalciteSqlDialect;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql2rel.InitializerContext;
import org.apache.calcite.sql2rel.InitializerExpressionFactory;
import org.apache.calcite.sql2rel.NullInitializerExpressionFactory;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Static;

public class SqlCreateTable
extends SqlCreate
implements SqlExecutableStatement {
    private final SqlIdentifier name;
    private final SqlNodeList columnList;
    private final SqlNode query;
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("CREATE TABLE", SqlKind.CREATE_TABLE);

    SqlCreateTable(SqlParserPos pos, boolean replace, boolean ifNotExists, SqlIdentifier name, SqlNodeList columnList, SqlNode query) {
        super(OPERATOR, pos, replace, ifNotExists);
        this.name = Objects.requireNonNull(name);
        this.columnList = columnList;
        this.query = query;
    }

    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.name, (Object)this.columnList, (Object)this.query);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("CREATE");
        writer.keyword("TABLE");
        if (this.ifNotExists) {
            writer.keyword("IF NOT EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
        if (this.columnList != null) {
            SqlWriter.Frame frame = writer.startList("(", ")");
            for (SqlNode c : this.columnList) {
                writer.sep(",");
                c.unparse(writer, 0, 0);
            }
            writer.endList(frame);
        }
        if (this.query != null) {
            writer.keyword("AS");
            writer.newlineAndIndent();
            this.query.unparse(writer, 0, 0);
        }
    }

    public void execute(CalcitePrepare.Context context) {
        ArrayList<SqlIdentifier> columnList;
        RelDataType queryRowType;
        Pair<CalciteSchema, String> pair = SqlDdlNodes.schema(context, true, this.name);
        JavaTypeFactoryImpl typeFactory = new JavaTypeFactoryImpl();
        if (this.query != null) {
            String sql = this.query.toSqlString(CalciteSqlDialect.DEFAULT).getSql();
            ViewTableMacro viewTableMacro = ViewTable.viewMacro((SchemaPlus)((CalciteSchema)pair.left).plus(), (String)sql, (List)((CalciteSchema)pair.left).path(null), (List)context.getObjectPath(), (Boolean)false);
            TranslatableTable x = viewTableMacro.apply((List)ImmutableList.of());
            queryRowType = x.getRowType((RelDataTypeFactory)typeFactory);
            if (this.columnList != null && queryRowType.getFieldCount() != this.columnList.size()) {
                throw SqlUtil.newContextException((SqlParserPos)this.columnList.getParserPosition(), (Resources.ExInst)Static.RESOURCE.columnCountMismatch());
            }
        } else {
            queryRowType = null;
        }
        if (this.columnList != null) {
            columnList = this.columnList.getList();
        } else {
            if (queryRowType == null) {
                throw SqlUtil.newContextException((SqlParserPos)this.name.getParserPosition(), (Resources.ExInst)Static.RESOURCE.createTableRequiresColumnList());
            }
            columnList = new ArrayList<SqlIdentifier>();
            for (String name : queryRowType.getFieldNames()) {
                columnList.add(new SqlIdentifier(name, SqlParserPos.ZERO));
            }
        }
        ImmutableList.Builder b = ImmutableList.builder();
        RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
        RelDataTypeFactory.FieldInfoBuilder storedBuilder = typeFactory.builder();
        for (Ord c : Ord.zip(columnList)) {
            if (c.e instanceof SqlColumnDeclaration) {
                CalciteSchema.TypeEntry typeEntry;
                SqlColumnDeclaration d = (SqlColumnDeclaration)((Object)c.e);
                RelDataType type = d.dataType.deriveType((RelDataTypeFactory)typeFactory, true);
                Pair<CalciteSchema, String> pairForType = SqlDdlNodes.schema(context, true, d.dataType.getTypeName());
                if (type == null && (typeEntry = ((CalciteSchema)pairForType.left).getType((String)pairForType.right, false)) != null) {
                    type = (RelDataType)typeEntry.getType().apply((Object)typeFactory);
                }
                builder.add(d.name.getSimple(), type);
                if (d.strategy != ColumnStrategy.VIRTUAL) {
                    storedBuilder.add(d.name.getSimple(), type);
                }
                b.add((Object)ColumnDef.of(d.expression, type, d.strategy));
                continue;
            }
            if (c.e instanceof SqlIdentifier) {
                SqlIdentifier id = (SqlIdentifier)c.e;
                if (queryRowType == null) {
                    throw SqlUtil.newContextException((SqlParserPos)id.getParserPosition(), (Resources.ExInst)Static.RESOURCE.createTableRequiresColumnTypes(id.getSimple()));
                }
                RelDataTypeField f = (RelDataTypeField)queryRowType.getFieldList().get(c.i);
                ColumnStrategy strategy = f.getType().isNullable() ? ColumnStrategy.NULLABLE : ColumnStrategy.NOT_NULLABLE;
                b.add((Object)ColumnDef.of((SqlNode)c.e, f.getType(), strategy));
                builder.add(id.getSimple(), f.getType());
                storedBuilder.add(id.getSimple(), f.getType());
                continue;
            }
            throw new AssertionError(((SqlNode)c.e).getClass());
        }
        RelDataType rowType = builder.build();
        RelDataType storedRowType = storedBuilder.build();
        ImmutableList columns = b.build();
        NullInitializerExpressionFactory ief = new NullInitializerExpressionFactory((List)columns){
            final /* synthetic */ List val$columns;
            {
                this.val$columns = list;
            }

            public ColumnStrategy generationStrategy(RelOptTable table, int iColumn) {
                return ((ColumnDef)this.val$columns.get((int)iColumn)).strategy;
            }

            public RexNode newColumnDefaultValue(RelOptTable table, int iColumn, InitializerContext context) {
                ColumnDef c = (ColumnDef)this.val$columns.get(iColumn);
                if (c.expr != null) {
                    return context.convertExpression(c.expr);
                }
                return super.newColumnDefaultValue(table, iColumn, context);
            }
        };
        if (((CalciteSchema)pair.left).plus().getTable((String)pair.right) != null) {
            if (!this.ifNotExists) {
                throw SqlUtil.newContextException((SqlParserPos)this.name.getParserPosition(), (Resources.ExInst)Static.RESOURCE.tableExists((String)pair.right));
            }
            return;
        }
        ((CalciteSchema)pair.left).add((String)pair.right, (Table)new MutableArrayTable((String)pair.right, RelDataTypeImpl.proto((RelDataType)storedRowType), RelDataTypeImpl.proto((RelDataType)rowType), (InitializerExpressionFactory)ief));
        if (this.query != null) {
            SqlDdlNodes.populate(this.name, this.query, context);
        }
    }

    static class MutableArrayTable
    extends AbstractModifiableTable
    implements Wrapper {
        final List rows = new ArrayList();
        private final RelProtoDataType protoStoredRowType;
        private final RelProtoDataType protoRowType;
        private final InitializerExpressionFactory initializerExpressionFactory;

        MutableArrayTable(String name, RelProtoDataType protoStoredRowType, RelProtoDataType protoRowType, InitializerExpressionFactory initializerExpressionFactory) {
            super(name);
            this.protoStoredRowType = Objects.requireNonNull(protoStoredRowType);
            this.protoRowType = Objects.requireNonNull(protoRowType);
            this.initializerExpressionFactory = Objects.requireNonNull(initializerExpressionFactory);
        }

        public Collection getModifiableCollection() {
            return this.rows;
        }

        public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
            return new AbstractTableQueryable<T>(queryProvider, schema, (QueryableTable)this, tableName){

                public Enumerator<T> enumerator() {
                    return Linq4j.enumerator((Collection)rows);
                }
            };
        }

        public Type getElementType() {
            return Object[].class;
        }

        public Expression getExpression(SchemaPlus schema, String tableName, Class clazz) {
            return Schemas.tableExpression((SchemaPlus)schema, (Type)this.getElementType(), (String)tableName, (Class)clazz);
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return (RelDataType)this.protoRowType.apply((Object)typeFactory);
        }

        public <C> C unwrap(Class<C> aClass) {
            if (aClass.isInstance(this.initializerExpressionFactory)) {
                return aClass.cast(this.initializerExpressionFactory);
            }
            return (C)super.unwrap(aClass);
        }
    }

    static abstract class AbstractModifiableTable
    extends AbstractTable
    implements ModifiableTable {
        AbstractModifiableTable(String tableName) {
        }

        public TableModify toModificationRel(RelOptCluster cluster, RelOptTable table, Prepare.CatalogReader catalogReader, RelNode child, TableModify.Operation operation, List<String> updateColumnList, List<RexNode> sourceExpressionList, boolean flattened) {
            return LogicalTableModify.create((RelOptTable)table, (Prepare.CatalogReader)catalogReader, (RelNode)child, (TableModify.Operation)operation, updateColumnList, sourceExpressionList, (boolean)flattened);
        }
    }

    private static class ColumnDef {
        final SqlNode expr;
        final RelDataType type;
        final ColumnStrategy strategy;

        private ColumnDef(SqlNode expr, RelDataType type, ColumnStrategy strategy) {
            this.expr = expr;
            this.type = type;
            this.strategy = Objects.requireNonNull(strategy);
            Preconditions.checkArgument((strategy == ColumnStrategy.NULLABLE || strategy == ColumnStrategy.NOT_NULLABLE || expr != null ? 1 : 0) != 0);
        }

        static ColumnDef of(SqlNode expr, RelDataType type, ColumnStrategy strategy) {
            return new ColumnDef(expr, type, strategy);
        }
    }
}

