/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.os;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.apache.calcite.adapter.os.DuTableFunction;
import org.apache.calcite.adapter.os.FilesTableFunction;
import org.apache.calcite.adapter.os.GitCommitsTableFunction;
import org.apache.calcite.adapter.os.PsTableFunction;
import org.apache.calcite.adapter.os.StdinTableFunction;
import org.apache.calcite.adapter.os.VmstatTableFunction;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.util.JsonBuilder;

public class SqlShell {
    static final String MODEL = SqlShell.model();
    private final List<String> args;
    private final InputStreamReader in;
    private final PrintWriter out;
    private final PrintWriter err;

    SqlShell(InputStreamReader in, PrintWriter out, PrintWriter err, String ... args) {
        this.args = ImmutableList.copyOf((Object[])args);
        this.in = Objects.requireNonNull(in);
        this.out = Objects.requireNonNull(out);
        this.err = Objects.requireNonNull(err);
    }

    private static String model() {
        StringBuilder b = new StringBuilder();
        b.append("{\n").append("  version: '1.0',\n").append("  defaultSchema: 'os',\n").append("   schemas: [\n").append("     {\n").append("       \"name\": \"os\",\n").append("       \"tables\": [ {\n");
        SqlShell.addView(b, "du", "select *, \"size_k\" * 1024 as \"size_b\"\nfrom table(\"du\"(true))");
        SqlShell.addView(b, "files", "select * from table(\"files\"('.'))");
        SqlShell.addView(b, "git_commits", "select * from table(\"git_commits\"(true))");
        SqlShell.addView(b, "ps", "select * from table(\"ps\"(true))");
        SqlShell.addView(b, "stdin", "select * from table(\"stdin\"(true))");
        SqlShell.addView(b, "vmstat", "select * from table(\"vmstat\"(true))");
        b.append("       } ],\n").append("       functions: [ {\n");
        SqlShell.addFunction(b, "du", DuTableFunction.class);
        SqlShell.addFunction(b, "files", FilesTableFunction.class);
        SqlShell.addFunction(b, "git_commits", GitCommitsTableFunction.class);
        SqlShell.addFunction(b, "ps", PsTableFunction.class);
        SqlShell.addFunction(b, "stdin", StdinTableFunction.class);
        SqlShell.addFunction(b, "vmstat", VmstatTableFunction.class);
        b.append("       } ]\n").append("     }\n").append("   ]\n").append("}");
        return b.toString();
    }

    public static void main(String[] args) {
        try (PrintWriter err = new PrintWriter(new OutputStreamWriter((OutputStream)System.err, StandardCharsets.UTF_8));
             InputStreamReader in = new InputStreamReader(System.in, StandardCharsets.UTF_8);
             PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8));){
            new SqlShell(in, out, err, args).run();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run() throws SQLException {
        String url = "jdbc:calcite:lex=JAVA;conformance=LENIENT;model=inline:" + MODEL;
        String help = "Usage: sqlsh [OPTION]... SQL\nExecute a SQL command\n\nOptions:\n  -o FORMAT  Print output in FORMAT; options are 'spaced' (the default), 'csv',\n             'headers', 'json', 'mysql'\n  -h --help  Print this help";
        StringBuilder b = new StringBuilder();
        Format format = Format.SPACED;
        try (Enumerator args = Linq4j.asEnumerable(this.args).enumerator();){
            while (args.moveNext()) {
                if (((String)args.current()).equals("-o")) {
                    if (args.moveNext()) {
                        String formatString = (String)args.current();
                        try {
                            format = Format.valueOf(formatString.toUpperCase(Locale.ROOT));
                            continue;
                        }
                        catch (IllegalArgumentException e) {
                            throw new RuntimeException("unknown format: " + formatString);
                        }
                    }
                    throw new RuntimeException("missing format");
                }
                if (((String)args.current()).equals("-h") || ((String)args.current()).equals("--help")) {
                    this.out.println("Usage: sqlsh [OPTION]... SQL\nExecute a SQL command\n\nOptions:\n  -o FORMAT  Print output in FORMAT; options are 'spaced' (the default), 'csv',\n             'headers', 'json', 'mysql'\n  -h --help  Print this help");
                    return;
                }
                if (b.length() > 0) {
                    b.append(' ');
                }
                b.append((String)args.current());
            }
        }
        try {
            var6_6 = null;
            try (Connection connection = DriverManager.getConnection(url);
                 Statement s = connection.createStatement();
                 Enumerator args = Linq4j.asEnumerable(this.args).enumerator();){
                ResultSet r = s.executeQuery(b.toString());
                format.output(this.out, r);
                r.close();
            }
            catch (Throwable throwable) {
                var6_6 = throwable;
                throw throwable;
            }
        }
        finally {
            this.out.flush();
        }
    }

    private static void addView(StringBuilder b, String name, String sql) {
        if (!name.equals("du")) {
            b.append("}, {\n");
        }
        b.append("         \"name\": \"").append(name).append("\",\n").append("         \"type\": \"view\",\n").append("         \"sql\": \"").append(sql.replaceAll("\"", "\\\\\"").replaceAll("\n", "")).append("\"\n");
    }

    private static void addFunction(StringBuilder b, String name, Class c) {
        if (!name.equals("du")) {
            b.append("}, {\n");
        }
        b.append("         \"name\": \"").append(name).append("\",\n").append("         \"className\": \"").append(c.getName()).append("\"\n");
    }

    static enum Format {
        SPACED{

            @Override
            protected void output(PrintWriter out, ResultSet r) throws SQLException {
                int n = r.getMetaData().getColumnCount();
                StringBuilder b = new StringBuilder();
                while (r.next()) {
                    for (int i = 0; i < n; ++i) {
                        if (i > 0) {
                            b.append(' ');
                        }
                        b.append(r.getString(i + 1));
                    }
                    out.println(b);
                    b.setLength(0);
                }
            }
        }
        ,
        HEADERS{

            @Override
            protected void output(PrintWriter out, ResultSet r) throws SQLException {
                ResultSetMetaData m = r.getMetaData();
                int n = m.getColumnCount();
                StringBuilder b = new StringBuilder();
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        b.append(' ');
                    }
                    b.append(m.getColumnLabel(i + 1));
                }
                out.println(b);
                b.setLength(0);
                SPACED.output(out, r);
            }
        }
        ,
        CSV{

            @Override
            protected void output(PrintWriter out, ResultSet r) throws SQLException {
                int i;
                ResultSetMetaData m = r.getMetaData();
                int n = m.getColumnCount();
                StringBuilder b = new StringBuilder();
                for (i = 0; i < n; ++i) {
                    if (i > 0) {
                        b.append(',');
                    }
                    this.value(b, m.getColumnLabel(i + 1));
                }
                out.print(b);
                b.setLength(0);
                while (r.next()) {
                    out.println();
                    for (i = 0; i < n; ++i) {
                        if (i > 0) {
                            b.append(',');
                        }
                        this.value(b, r.getString(i + 1));
                    }
                    out.print(b);
                    b.setLength(0);
                }
            }

            private void value(StringBuilder b, String s) {
                if (s != null) {
                    if (s.contains("\"")) {
                        b.append('\"').append(s.replaceAll("\"", "\"\"")).append('\"');
                    } else if (s.indexOf(44) >= 0 || s.indexOf(10) >= 0 || s.indexOf(13) >= 0) {
                        b.append('\"').append(s).append('\"');
                    } else {
                        b.append(s);
                    }
                }
            }
        }
        ,
        JSON{

            @Override
            protected void output(PrintWriter out, ResultSet r) throws SQLException {
                ResultSetMetaData m = r.getMetaData();
                int n = m.getColumnCount();
                LinkedHashMap<String, Integer> fieldOrdinals = new LinkedHashMap<String, Integer>();
                for (int i = 0; i < n; ++i) {
                    fieldOrdinals.put(m.getColumnLabel(i + 1), fieldOrdinals.size() + 1);
                }
                Set fields = fieldOrdinals.keySet();
                JsonBuilder json = new JsonBuilder();
                StringBuilder b = new StringBuilder();
                out.println("[");
                int i = 0;
                while (r.next()) {
                    if (i++ > 0) {
                        out.println(",");
                    }
                    json.append(b, 0, (Object)Maps.asMap(fields, columnLabel -> {
                        try {
                            int i1 = (Integer)fieldOrdinals.get(columnLabel);
                            switch (m.getColumnType(i1)) {
                                case 16: {
                                    boolean b1 = r.getBoolean(i1);
                                    return !b1 && r.wasNull() ? null : Boolean.valueOf(b1);
                                }
                                case 3: 
                                case 6: 
                                case 7: 
                                case 8: {
                                    double d = r.getDouble(i1);
                                    return d == 0.0 && r.wasNull() ? null : Double.valueOf(d);
                                }
                                case -6: 
                                case -5: 
                                case 4: 
                                case 5: {
                                    long v = r.getLong(i1);
                                    return v == 0L && r.wasNull() ? null : Long.valueOf(v);
                                }
                            }
                            return r.getString(i1);
                        }
                        catch (SQLException e) {
                            throw new RuntimeException(e);
                        }
                    }));
                    out.append(b);
                    b.setLength(0);
                }
                if (i > 0) {
                    out.println();
                }
                out.println("]");
            }
        }
        ,
        MYSQL{

            @Override
            protected void output(PrintWriter out, ResultSet r) throws SQLException {
                Object v;
                int i;
                ResultSetMetaData m = r.getMetaData();
                int n = m.getColumnCount();
                ArrayList<Object> values = new ArrayList<Object>();
                int[] lengths = new int[n];
                boolean[] rights = new boolean[n];
                for (i = 0; i < n; ++i) {
                    v = m.getColumnLabel(i + 1);
                    values.add(v);
                    lengths[i] = ((String)v).length();
                    switch (m.getColumnType(i + 1)) {
                        case -6: 
                        case -5: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: {
                            rights[i] = true;
                        }
                    }
                }
                while (r.next()) {
                    for (i = 0; i < n; ++i) {
                        v = r.getString(i + 1);
                        values.add(v);
                        if (v == null || ((String)v).length() <= lengths[i]) continue;
                        lengths[i] = ((String)v).length();
                    }
                }
                StringBuilder b = new StringBuilder("+");
                for (Object length : (Object)lengths) {
                    this.pad(b, (int)(length + 2), '-');
                    b.append('+');
                }
                String bar = b.toString();
                out.println(bar);
                b.setLength(0);
                for (int i2 = 0; i2 < n; ++i2) {
                    if (i2 == 0) {
                        b.append('|');
                    }
                    b.append(' ');
                    this.value(b, (String)values.get(i2), lengths[i2], rights[i2]);
                    b.append(" |");
                }
                out.println(b);
                b.setLength(0);
                out.print(bar);
                for (int h = n; h < values.size(); ++h) {
                    int i3 = h % n;
                    if (i3 == 0) {
                        out.println(b);
                        b.setLength(0);
                        b.append('|');
                    }
                    b.append(' ');
                    this.value(b, (String)values.get(h), lengths[i3], rights[i3]);
                    b.append(" |");
                }
                out.println(b);
                out.println(bar);
                int rowCount = values.size() / n - 1;
                if (rowCount == 1) {
                    out.println("(1 row)");
                } else {
                    out.print("(");
                    out.print(rowCount);
                    out.println(" rows)");
                }
                out.println();
            }

            private void value(StringBuilder b, String value, int length, boolean right) {
                if (value == null) {
                    this.pad(b, length, ' ');
                } else {
                    int pad = length - value.length();
                    if (pad == 0) {
                        b.append(value);
                    } else if (right) {
                        this.pad(b, pad, ' ');
                        b.append(value);
                    } else {
                        b.append(value);
                        this.pad(b, pad, ' ');
                    }
                }
            }

            private void pad(StringBuilder b, int pad, char c) {
                for (int j = 0; j < pad; ++j) {
                    b.append(c);
                }
            }
        };


        protected abstract void output(PrintWriter var1, ResultSet var2) throws SQLException;
    }
}

