/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.materialize;

import java.util.List;
import java.util.Properties;
import java.util.Random;
import net.hydromatic.tpcds.query.Query;
import org.apache.calcite.adapter.tpcds.TpcdsSchema;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.materialize.Lattice;
import org.apache.calcite.materialize.LatticeRootNode;
import org.apache.calcite.materialize.LatticeSuggester;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.prepare.CalcitePrepareImpl;
import org.apache.calcite.prepare.PlannerImpl;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.RelConversionException;
import org.apache.calcite.tools.ValidationException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class TpcdsLatticeSuggesterTest {
    private String number(String s) {
        StringBuilder b = new StringBuilder();
        int i = 0;
        for (String line : s.split("\n")) {
            b.append(++i).append(' ').append(line).append("\n");
        }
        return b.toString();
    }

    private void checkFoodMartAll(boolean evolve) throws Exception {
        Tester t = new Tester().tpcds().withEvolve(evolve);
        block3: for (Query query : Query.values()) {
            String sql = query.sql(new Random(0L)).replaceAll("as returns", "as \"returns\"").replaceAll("sum\\(returns\\)", "sum(\"returns\")").replaceAll(", returns", ", \"returns\"").replaceAll("14 days", "interval '14' day").replaceAll("substr\\(([^,]*),([^,]*),([^)]*)\\)", "substring($1 from $2 for $3)");
            if (CalcitePrepareImpl.DEBUG) {
                System.out.println("Query #" + query.id + "\n" + this.number(sql));
            }
            switch (query.id) {
                case 6: 
                case 9: {
                    continue block3;
                }
                default: {
                    if (query.id > 11) break block3;
                    t.addQuery(sql);
                }
            }
        }
        String expected = "graph(vertices: [[tpcds, CATALOG_SALES], [tpcds, CUSTOMER], [tpcds, CUSTOMER_ADDRESS], [tpcds, CUSTOMER_DEMOGRAPHICS], [tpcds, DATE_DIM], [tpcds, ITEM], [tpcds, PROMOTION], [tpcds, STORE], [tpcds, STORE_RETURNS], [tpcds, STORE_SALES], [tpcds, WEB_SALES]], edges: [Step([tpcds, CATALOG_SALES], [tpcds, CUSTOMER], CS_SHIP_CUSTOMER_SK:C_CUSTOMER_SK), Step([tpcds, CATALOG_SALES], [tpcds, DATE_DIM], CS_SOLD_DATE_SK:D_DATE_SK), Step([tpcds, STORE_RETURNS], [tpcds, CUSTOMER], SR_CUSTOMER_SK:C_CUSTOMER_SK), Step([tpcds, STORE_RETURNS], [tpcds, DATE_DIM], SR_RETURNED_DATE_SK:D_DATE_SK), Step([tpcds, STORE_RETURNS], [tpcds, STORE], SR_STORE_SK:S_STORE_SK), Step([tpcds, STORE_RETURNS], [tpcds, STORE_RETURNS], SR_STORE_SK:SR_STORE_SK), Step([tpcds, STORE_SALES], [tpcds, CUSTOMER], SS_CUSTOMER_SK:C_CUSTOMER_SK), Step([tpcds, STORE_SALES], [tpcds, CUSTOMER_DEMOGRAPHICS], SS_CDEMO_SK:CD_DEMO_SK), Step([tpcds, STORE_SALES], [tpcds, DATE_DIM], SS_SOLD_DATE_SK:D_DATE_SK), Step([tpcds, STORE_SALES], [tpcds, ITEM], SS_ITEM_SK:I_ITEM_SK), Step([tpcds, STORE_SALES], [tpcds, PROMOTION], SS_PROMO_SK:P_PROMO_SK), Step([tpcds, WEB_SALES], [tpcds, CUSTOMER], WS_BILL_CUSTOMER_SK:C_CUSTOMER_SK), Step([tpcds, WEB_SALES], [tpcds, DATE_DIM], WS_SOLD_DATE_SK:D_DATE_SK)])";
        Assert.assertThat((Object)t.suggester.space.g.toString(), (Matcher)CoreMatchers.is((Object)"graph(vertices: [[tpcds, CATALOG_SALES], [tpcds, CUSTOMER], [tpcds, CUSTOMER_ADDRESS], [tpcds, CUSTOMER_DEMOGRAPHICS], [tpcds, DATE_DIM], [tpcds, ITEM], [tpcds, PROMOTION], [tpcds, STORE], [tpcds, STORE_RETURNS], [tpcds, STORE_SALES], [tpcds, WEB_SALES]], edges: [Step([tpcds, CATALOG_SALES], [tpcds, CUSTOMER], CS_SHIP_CUSTOMER_SK:C_CUSTOMER_SK), Step([tpcds, CATALOG_SALES], [tpcds, DATE_DIM], CS_SOLD_DATE_SK:D_DATE_SK), Step([tpcds, STORE_RETURNS], [tpcds, CUSTOMER], SR_CUSTOMER_SK:C_CUSTOMER_SK), Step([tpcds, STORE_RETURNS], [tpcds, DATE_DIM], SR_RETURNED_DATE_SK:D_DATE_SK), Step([tpcds, STORE_RETURNS], [tpcds, STORE], SR_STORE_SK:S_STORE_SK), Step([tpcds, STORE_RETURNS], [tpcds, STORE_RETURNS], SR_STORE_SK:SR_STORE_SK), Step([tpcds, STORE_SALES], [tpcds, CUSTOMER], SS_CUSTOMER_SK:C_CUSTOMER_SK), Step([tpcds, STORE_SALES], [tpcds, CUSTOMER_DEMOGRAPHICS], SS_CDEMO_SK:CD_DEMO_SK), Step([tpcds, STORE_SALES], [tpcds, DATE_DIM], SS_SOLD_DATE_SK:D_DATE_SK), Step([tpcds, STORE_SALES], [tpcds, ITEM], SS_ITEM_SK:I_ITEM_SK), Step([tpcds, STORE_SALES], [tpcds, PROMOTION], SS_PROMO_SK:P_PROMO_SK), Step([tpcds, WEB_SALES], [tpcds, CUSTOMER], WS_BILL_CUSTOMER_SK:C_CUSTOMER_SK), Step([tpcds, WEB_SALES], [tpcds, DATE_DIM], WS_SOLD_DATE_SK:D_DATE_SK)])"));
        if (evolve) {
            Assert.assertThat((Object)t.suggester.space.nodeMap.size(), (Matcher)CoreMatchers.is((Object)5));
            Assert.assertThat((Object)t.suggester.latticeMap.size(), (Matcher)CoreMatchers.is((Object)3));
            Assert.assertThat((Object)t.suggester.space.pathMap.size(), (Matcher)CoreMatchers.is((Object)10));
        } else {
            Assert.assertThat((Object)t.suggester.space.nodeMap.size(), (Matcher)CoreMatchers.is((Object)5));
            Assert.assertThat((Object)t.suggester.latticeMap.size(), (Matcher)CoreMatchers.is((Object)4));
            Assert.assertThat((Object)t.suggester.space.pathMap.size(), (Matcher)CoreMatchers.is((Object)10));
        }
    }

    @Test
    public void testTpcdsAll() throws Exception {
        this.checkFoodMartAll(false);
    }

    @Test
    public void testTpcdsAllEvolve() throws Exception {
        this.checkFoodMartAll(true);
    }

    private static class Tester {
        final LatticeSuggester suggester;
        private final FrameworkConfig config;

        Tester() {
            this(Tester.config(CalciteAssert.SchemaSpec.BLANK).build());
        }

        private Tester(FrameworkConfig config) {
            this.config = config;
            this.suggester = new LatticeSuggester(config);
        }

        Tester tpcds() {
            SchemaPlus rootSchema = Frameworks.createRootSchema((boolean)true);
            double scaleFactor = 0.01;
            SchemaPlus schema = rootSchema.add("tpcds", (Schema)new TpcdsSchema(0.01));
            FrameworkConfig config = Frameworks.newConfigBuilder().parserConfig(SqlParser.Config.DEFAULT).context(Contexts.of((Object)new CalciteConnectionConfigImpl(new Properties()).set(CalciteConnectionProperty.CONFORMANCE, SqlConformanceEnum.LENIENT.name()))).defaultSchema(schema).build();
            return this.withConfig(config);
        }

        Tester withConfig(FrameworkConfig config) {
            return new Tester(config);
        }

        List<Lattice> addQuery(String q) throws SqlParseException, ValidationException, RelConversionException {
            PlannerImpl planner = new PlannerImpl(this.config);
            SqlNode node = planner.parse(q);
            SqlNode node2 = planner.validate(node);
            RelRoot root = planner.rel(node2);
            return this.suggester.addQuery(root.project());
        }

        LatticeRootNode node(String q) throws SqlParseException, ValidationException, RelConversionException {
            List<Lattice> list = this.addQuery(q);
            Assert.assertThat((Object)list.size(), (Matcher)CoreMatchers.is((Object)1));
            return list.get((int)0).rootNode;
        }

        static Frameworks.ConfigBuilder config(CalciteAssert.SchemaSpec spec) {
            SchemaPlus rootSchema = Frameworks.createRootSchema((boolean)true);
            SchemaPlus schema = CalciteAssert.addSchema((SchemaPlus)rootSchema, (CalciteAssert.SchemaSpec)spec);
            return Frameworks.newConfigBuilder().parserConfig(SqlParser.Config.DEFAULT).defaultSchema(schema);
        }

        Tester withEvolve(boolean evolve) {
            if (evolve == this.config.isEvolveLattice()) {
                return this;
            }
            Frameworks.ConfigBuilder configBuilder = Frameworks.newConfigBuilder((FrameworkConfig)this.config);
            return new Tester(configBuilder.evolveLattice(true).build());
        }
    }
}

