/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.chinook;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.calcite.chinook.ChinookAvaticaServer;
import org.junit.Test;

public class RemotePreparedStatementParametersTest {
    @Test
    public void testSimpleStringParameterShouldWorkWithCalcite() throws Exception {
        ChinookAvaticaServer server = new ChinookAvaticaServer();
        server.startWithCalcite();
        Connection connection = DriverManager.getConnection(server.getURL());
        PreparedStatement pS = connection.prepareStatement("select * from chinook.artist where name = ?");
        pS.setString(1, "AC/DC");
        ResultSet resultSet = pS.executeQuery();
        server.stop();
    }

    @Test
    public void testSeveralParametersShouldWorkWithCalcite() throws Exception {
        ChinookAvaticaServer server = new ChinookAvaticaServer();
        server.startWithCalcite();
        Connection connection = DriverManager.getConnection(server.getURL());
        PreparedStatement pS = connection.prepareStatement("select * from chinook.track where name = ? or milliseconds > ?");
        pS.setString(1, "AC/DC");
        pS.setInt(2, 10);
        ResultSet resultSet = pS.executeQuery();
        server.stop();
    }

    @Test
    public void testParametersShouldWorkWithRaw() throws Exception {
        ChinookAvaticaServer server = new ChinookAvaticaServer();
        server.startWithRaw();
        Connection connection = DriverManager.getConnection(server.getURL());
        PreparedStatement pS = connection.prepareStatement("select * from artist where name = ?");
        pS.setString(1, "AC/DC");
        ResultSet resultSet = pS.executeQuery();
        server.stop();
    }
}

