/* Generated By:JavaCC: Do not edit this line. PigletParser.java */
package org.apache.calcite.piglet.parser;

import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParserUtil;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.piglet.Ast.*;
import org.apache.calcite.util.trace.CalciteTrace;
import org.apache.calcite.util.Pair;

import com.google.common.collect.ImmutableList;

import org.slf4j.Logger;

import java.util.ArrayList;
import java.util.List;

import static org.apache.calcite.util.Static.RESOURCE;

/**
 * Parser Piglet, a Pig-like language, generated from PigletParser.jj by JavaCC.
 */
public class PigletParser implements PigletParserConstants {
  private static final Logger LOGGER = CalciteTrace.getParserTracer();

  public void setTabSize(int tabSize) {
    jj_input_stream.setTabSize(tabSize);
  }

  void debug_message1() throws ParseException {
  LOGGER.info("{} , {}", getToken(0).image, getToken(1).image);
  }

  String unquotedIdentifier() throws ParseException {
  return SqlParserUtil.strip(getToken(0).image, null, null, null,
    Casing.UNCHANGED);
  }

  final public String nonReservedKeyWord() throws ParseException {
  String kw;
    kw = commonNonReservedKeyWord();
    {if (true) return kw;}
    throw new Error("Missing return statement in function");
  }

  void e() throws ParseException {
  }

  SqlParserPos pos() throws ParseException {
  return new SqlParserPos(token.beginLine, token.beginColumn,
    token.endLine, token.endColumn);
  }

  SqlParserPos pos2(SqlParserPos p) throws ParseException {
  return p.plus(pos());
  }

  SqlParserPos pos3(Node n) throws ParseException {
  return n.pos.plus(pos());
  }

  SqlParseException convertException(Throwable ex) throws ParseException {
  if (ex instanceof SqlParseException) {
    return (SqlParseException) ex;
  }
  SqlParserPos pos = null;
  int[][] expectedTokenSequences = null;
  String[] tokenImage = null;
  if (ex instanceof ParseException) {
    ParseException pex = (ParseException) ex;
    expectedTokenSequences = pex.expectedTokenSequences;
    tokenImage = pex.tokenImage;
    if (pex.currentToken != null) {
      final Token token = pex.currentToken.next;
      pos = new SqlParserPos(token.beginLine, token.beginColumn,
          token.endLine, token.endColumn);
    }
  } else if (ex instanceof TokenMgrError) {
    TokenMgrError tme = (TokenMgrError) ex;
    expectedTokenSequences = null;
    tokenImage = null;
    // Example:
    //    Lexical error at line 3, column 24.  Encountered "#" after "a".
    final java.util.regex.Pattern pattern = java.util.regex.Pattern.compile(
        "(?s)Lexical error at line ([0-9]+), column ([0-9]+).*");
    java.util.regex.Matcher matcher = pattern.matcher(ex.getMessage());
    if (matcher.matches()) {
      int line = Integer.parseInt(matcher.group(1));
      int column = Integer.parseInt(matcher.group(2));
      pos = new SqlParserPos(line, column, line, column);
    }
  } else if (ex instanceof CalciteContextException) {
    // CalciteContextException is the standard wrapper for exceptions
    // produced by the validator, but in the parser, the standard is
    // SqlParseException; so, strip it away. In case you were wondering,
    // the CalciteContextException appears because the parser
    // occasionally calls into validator-style code such as
    // SqlSpecialOperator.reduceExpr.
    CalciteContextException ece =
        (CalciteContextException) ex;
    pos = new SqlParserPos(
        ece.getPosLine(),
        ece.getPosColumn(),
        ece.getEndPosLine(),
        ece.getEndPosColumn());
    ex = ece.getCause();
  }

  return new SqlParseException(ex.getMessage(), pos, expectedTokenSequences,
      tokenImage, ex);
  }

/*****************************************
 * Syntactical Descriptions              *
 *****************************************/

/**
 * Parses a list of statements (LOAD, DUMP, etc.) followed by
 * the end-of-file symbol.
 */
  final public Program stmtListEof() throws ParseException {
  final List<Stmt> list = new ArrayList<Stmt>();
  Stmt s;
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALL:
      case AND:
      case ASC:
      case BY:
      case DESC:
      case DESCRIBE:
      case DISTINCT:
      case DUMP:
      case FOREACH:
      case GENERATE:
      case GROUP:
      case LOAD:
      case LIMIT:
      case NOT:
      case ORDER:
      case OR:
      case VALUES:
      case IDENTIFIER:
        ;
        break;
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
      s = stmt();
      list.add(s);
    }
    jj_consume_token(0);
    SqlParserPos p = SqlParserPos.ZERO;
    for (Stmt s2 : list) {
      p = p.plus(s2.pos);
    }
    {if (true) return new Program(p, list);}
    throw new Error("Missing return statement in function");
  }

  final public Stmt stmt() throws ParseException {
  final Identifier target;
  final Stmt s;
    if (jj_2_1(2)) {
      target = simpleIdentifier();
      jj_consume_token(EQ);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LOAD:
        s = loadStmt(target);
        break;
      case VALUES:
        s = valuesStmt(target);
        break;
      case DISTINCT:
        s = distinctStmt(target);
        break;
      case LIMIT:
        s = limitStmt(target);
        break;
      case ORDER:
        s = orderStmt(target);
        break;
      case FOREACH:
        s = foreachStmt(target);
        break;
      case FILTER:
        s = filterStmt(target);
        break;
      case GROUP:
        s = groupStmt(target);
        break;
      default:
        jj_la1[1] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else if (jj_2_2(2)) {
      s = describeStmt();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DUMP:
        s = dumpStmt();
        break;
      default:
        jj_la1[2] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return s;}
    throw new Error("Missing return statement in function");
  }

  final public Assignment1 nestedStmt() throws ParseException {
  final Identifier target;
  final Assignment1 s;
    target = simpleIdentifier();
    jj_consume_token(EQ);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DISTINCT:
      s = distinctStmt(target);
      break;
    case LIMIT:
      s = limitStmt(target);
      break;
    case ORDER:
      s = orderStmt(target);
      break;
    case FILTER:
      s = filterStmt(target);
      break;
    default:
      jj_la1[3] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return s;}
    throw new Error("Missing return statement in function");
  }

  final public LoadStmt loadStmt(final Identifier target) throws ParseException {
  final Literal name;
    jj_consume_token(LOAD);
    name = stringLiteral();
    jj_consume_token(SEMICOLON);
    {if (true) return new LoadStmt(pos3(target), target, name);}
    throw new Error("Missing return statement in function");
  }

  final public ValuesStmt valuesStmt(final Identifier target) throws ParseException {
  final List<List<Node>> tupleList;
  final Schema schema;
    jj_consume_token(VALUES);
    tupleList = tupleListMaybeEmpty();
    jj_consume_token(AS);
    schema = schema();
    jj_consume_token(SEMICOLON);
    {if (true) return new ValuesStmt(pos3(target), target, schema, tupleList);}
    throw new Error("Missing return statement in function");
  }

/** Parses a tuple list.
 * The list may be empty.
 * Each tuple is a list of at least one expression. */
  final public List<List<Node>> tupleListMaybeEmpty() throws ParseException {
  final ImmutableList.Builder<List<Node>> tupleList = ImmutableList.builder();
  List<Node> tuple;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      tuple = tuple();
      tupleList.add(tuple);
      label_2:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[4] = jj_gen;
          break label_2;
        }
        jj_consume_token(COMMA);
        tuple = tuple();
        tupleList.add(tuple);
      }
      break;
    default:
      jj_la1[5] = jj_gen;
      ;
    }
    {if (true) return tupleList.build();}
    throw new Error("Missing return statement in function");
  }

  final public DescribeStmt describeStmt() throws ParseException {
  final SqlParserPos p;
  final Identifier id;
    jj_consume_token(DESCRIBE);
               p = pos();
    id = simpleIdentifier();
    jj_consume_token(SEMICOLON);
    {if (true) return new DescribeStmt(pos2(p), id);}
    throw new Error("Missing return statement in function");
  }

  final public DumpStmt dumpStmt() throws ParseException {
  final SqlParserPos p;
  final Identifier id;
    jj_consume_token(DUMP);
           p = pos();
    id = simpleIdentifier();
    jj_consume_token(SEMICOLON);
    {if (true) return new DumpStmt(pos2(p), id);}
    throw new Error("Missing return statement in function");
  }

  final public Assignment foreachStmt(final Identifier target) throws ParseException {
  final Identifier id;
  final List<Node> expList;
  final List<Stmt> nestedStmtList;
  final Schema schema = null;
    jj_consume_token(FOREACH);
    id = simpleIdentifier();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case GENERATE:
      jj_consume_token(GENERATE);
      expList = expCommaList();
      jj_consume_token(SEMICOLON);
      {if (true) return new ForeachStmt(pos3(target), target, id, expList, schema);}
      break;
    case LBRACE:
      jj_consume_token(LBRACE);
      nestedStmtList = nestedStmtList();
      jj_consume_token(GENERATE);
      expList = expCommaList();
      jj_consume_token(SEMICOLON);
      jj_consume_token(RBRACE);
      {if (true) return new ForeachNestedStmt(pos3(target), target, id, nestedStmtList,
          expList, schema);}
      break;
    default:
      jj_la1[6] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public List<Stmt> nestedStmtList() throws ParseException {
  Assignment s;
  final List<Stmt> list = new ArrayList<Stmt>();
    s = nestedStmt();
    list.add(s);
    label_3:
    while (true) {
      if (jj_2_3(2)) {
        ;
      } else {
        break label_3;
      }
      s = nestedStmt();
      list.add(s);
    }
    {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

  final public FilterStmt filterStmt(final Identifier target) throws ParseException {
  final Identifier id;
  final Node condition;
    jj_consume_token(FILTER);
    id = simpleIdentifier();
    jj_consume_token(BY);
    condition = exp();
    jj_consume_token(SEMICOLON);
    {if (true) return new FilterStmt(pos3(target), target, id, condition);}
    throw new Error("Missing return statement in function");
  }

  final public DistinctStmt distinctStmt(final Identifier target) throws ParseException {
  final Identifier id;
    jj_consume_token(DISTINCT);
    id = simpleIdentifier();
    jj_consume_token(SEMICOLON);
    {if (true) return new DistinctStmt(pos3(target), target, id);}
    throw new Error("Missing return statement in function");
  }

  final public LimitStmt limitStmt(final Identifier target) throws ParseException {
  final Identifier id;
  final NumericLiteral count;
    jj_consume_token(LIMIT);
    id = simpleIdentifier();
    count = numericLiteral();
    jj_consume_token(SEMICOLON);
    {if (true) return new LimitStmt(pos3(target), target, id, count);}
    throw new Error("Missing return statement in function");
  }

  final public OrderStmt orderStmt(final Identifier target) throws ParseException {
  final Identifier id;
  final List<Pair<Identifier, Direction>> fields;
    jj_consume_token(ORDER);
    id = simpleIdentifier();
    jj_consume_token(BY);
    fields = orderFieldCommaList();
    jj_consume_token(SEMICOLON);
    {if (true) return new OrderStmt(pos3(target), target, id, fields);}
    throw new Error("Missing return statement in function");
  }

  final public List<Pair<Identifier, Direction>> orderFieldCommaList() throws ParseException {
  final List<Pair<Identifier, Direction>> list =
      new ArrayList<Pair<Identifier, Direction>>();
  Pair<Identifier, Direction> field;
    field = orderField();
    list.add(field);
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[7] = jj_gen;
        break label_4;
      }
      jj_consume_token(COMMA);
      field = orderField();
      list.add(field);
    }
    {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

  final public Pair<Identifier, Direction> orderField() throws ParseException {
  final Identifier id;
  final Direction direction;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STAR:
      jj_consume_token(STAR);
      id = new SpecialIdentifier(pos());
      break;
    case ALL:
    case AND:
    case ASC:
    case BY:
    case DESC:
    case DESCRIBE:
    case DISTINCT:
    case DUMP:
    case FOREACH:
    case GENERATE:
    case GROUP:
    case LOAD:
    case LIMIT:
    case NOT:
    case ORDER:
    case OR:
    case VALUES:
    case IDENTIFIER:
      id = simpleIdentifier();
      break;
    default:
      jj_la1[8] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASC:
      jj_consume_token(ASC);
      direction = Direction.ASC;
      break;
    case DESC:
      jj_consume_token(DESC);
      direction = Direction.DESC;
      break;
    default:
      jj_la1[9] = jj_gen;
      direction = Direction.NOT_SPECIFIED;
    }
    {if (true) return Pair.of(id, direction);}
    throw new Error("Missing return statement in function");
  }

  final public GroupStmt groupStmt(final Identifier target) throws ParseException {
  final Identifier id;
  final List<Node> keys;
  final Node exp;
    jj_consume_token(GROUP);
    id = simpleIdentifier();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ALL:
      jj_consume_token(ALL);
      keys = null;
      break;
    case BY:
      jj_consume_token(BY);
      if (jj_2_4(3)) {
        keys = tuple();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ALL:
        case AND:
        case ASC:
        case BY:
        case DESC:
        case DESCRIBE:
        case DISTINCT:
        case DUMP:
        case FALSE:
        case FOREACH:
        case GENERATE:
        case GROUP:
        case LOAD:
        case LIMIT:
        case NOT:
        case ORDER:
        case OR:
        case TRUE:
        case VALUES:
        case UNSIGNED_INTEGER_LITERAL:
        case FLOAT_LITERAL:
        case QUOTED_STRING:
        case LPAREN:
        case LBRACE:
        case PLUS:
        case MINUS:
        case IDENTIFIER:
          exp = exp();
        keys = ImmutableList.of(exp);
          break;
        default:
          jj_la1[10] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
    default:
      jj_la1[11] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(SEMICOLON);
    {if (true) return new GroupStmt(pos3(target), target, id, keys);}
    throw new Error("Missing return statement in function");
  }

/** Parses a schema. */
  final public Schema schema() throws ParseException {
  final SqlParserPos p;
  final List<FieldSchema> fieldSchemaList;
    jj_consume_token(LPAREN);
    p = pos();
    fieldSchemaList = fieldSchemaList();
    jj_consume_token(RPAREN);
    {if (true) return new Schema(pos2(p), fieldSchemaList);}
    throw new Error("Missing return statement in function");
  }

  final public List<FieldSchema> fieldSchemaList() throws ParseException {
  final ImmutableList.Builder<FieldSchema> list = ImmutableList.builder();
  FieldSchema fieldSchema;
    fieldSchema = fieldSchema();
    list.add(fieldSchema);
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[12] = jj_gen;
        break label_5;
      }
      jj_consume_token(COMMA);
      fieldSchema = fieldSchema();
      list.add(fieldSchema);
    }
    {if (true) return list.build();}
    throw new Error("Missing return statement in function");
  }

  final public FieldSchema fieldSchema() throws ParseException {
  final Identifier identifier;
  final Type type;
    identifier = simpleIdentifier();
    jj_consume_token(COLON);
    type = type();
    {if (true) return new FieldSchema(pos3(identifier), identifier, type);}
    throw new Error("Missing return statement in function");
  }

/** Parses a Type. */
  final public Type type() throws ParseException {
  final SqlParserPos p;
  final String s;
  final Type t;
  final List<FieldSchema> fieldSchemaList;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ALL:
    case AND:
    case ASC:
    case BY:
    case DESC:
    case DESCRIBE:
    case DISTINCT:
    case DUMP:
    case FOREACH:
    case GENERATE:
    case GROUP:
    case LOAD:
    case LIMIT:
    case NOT:
    case ORDER:
    case OR:
    case VALUES:
    case IDENTIFIER:
      s = identifier();
      {if (true) return new ScalarType(pos(), s);}
      break;
    case BAG:
      jj_consume_token(BAG);
      p = pos();
      jj_consume_token(LBRACE);
      t = type();
      jj_consume_token(RBRACE);
      {if (true) return new BagType(pos2(p), t);}
      break;
    case TUPLE:
      jj_consume_token(TUPLE);
      p = pos();
      jj_consume_token(LPAREN);
      fieldSchemaList = fieldSchemaList();
      jj_consume_token(RPAREN);
      {if (true) return new TupleType(pos2(p), fieldSchemaList);}
      break;
    case MAP:
      jj_consume_token(MAP);
            p = pos();
      jj_consume_token(LBRACKET);
      jj_consume_token(RBRACKET);
      {if (true) return new MapType(pos2(p));}
      break;
    default:
      jj_la1[13] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/** Parses an expression. */
  final public Node exp() throws ParseException {
  final Node e;
    e = exp1();
    {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/** Parses an expression of precedence 1: OR. */
  final public Node exp1() throws ParseException {
  Node e;
  Node f;
    e = exp2();
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OR:
        ;
        break;
      default:
        jj_la1[14] = jj_gen;
        break label_6;
      }
      jj_consume_token(OR);
      f = exp2();
      e = new Call(pos3(e), Op.OR, e, f);
    }
    {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/** Parses an expression of precedence 2: AND. */
  final public Node exp2() throws ParseException {
  Node e;
  Node f;
    e = exp3();
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AND:
        ;
        break;
      default:
        jj_la1[15] = jj_gen;
        break label_7;
      }
      jj_consume_token(AND);
      f = exp3();
      e = new Call(pos3(e), Op.AND, e, f);
    }
    {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/** Parses an expression of precedence 3: NOT. */
  final public Node exp3() throws ParseException {
  final Node e;
  final SqlParserPos p;
    if (jj_2_5(3)) {
      jj_consume_token(NOT);
      p = pos();
      e = exp3();
      {if (true) return new Call(pos2(p), Op.NOT, e);}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALL:
      case AND:
      case ASC:
      case BY:
      case DESC:
      case DESCRIBE:
      case DISTINCT:
      case DUMP:
      case FALSE:
      case FOREACH:
      case GENERATE:
      case GROUP:
      case LOAD:
      case LIMIT:
      case NOT:
      case ORDER:
      case OR:
      case TRUE:
      case VALUES:
      case UNSIGNED_INTEGER_LITERAL:
      case FLOAT_LITERAL:
      case QUOTED_STRING:
      case LPAREN:
      case LBRACE:
      case PLUS:
      case MINUS:
      case IDENTIFIER:
        e = exp4();
      {if (true) return e;}
        break;
      default:
        jj_la1[16] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/** Parses an expression of precedence 4: relational operators (==, !=, <, <=,
 * >, >=). */
  final public Node exp4() throws ParseException {
  Node e;
  Node f;
    e = exp5();
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQEQ:
      case GT:
      case LT:
      case LE:
      case GE:
        ;
        break;
      default:
        jj_la1[17] = jj_gen;
        break label_8;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQEQ:
        jj_consume_token(EQEQ);
        f = exp5();
      e = new Call(pos3(e), Op.EQ, e, f);
        break;
      case GT:
        jj_consume_token(GT);
        f = exp5();
      e = new Call(pos3(e), Op.GT, e, f);
        break;
      case LT:
        jj_consume_token(LT);
        f = exp5();
      e = new Call(pos3(e), Op.LT, e, f);
        break;
      case GE:
        jj_consume_token(GE);
        f = exp5();
      e = new Call(pos3(e), Op.GTE, e, f);
        break;
      case LE:
        jj_consume_token(LE);
        f = exp5();
      e = new Call(pos3(e), Op.LTE, e, f);
        break;
      default:
        jj_la1[18] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/** Parses an expression of precedence 5: +, -. */
  final public Node exp5() throws ParseException {
  Node e;
  Node f;
    e = exp10();
    label_9:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
        ;
        break;
      default:
        jj_la1[19] = jj_gen;
        break label_9;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        jj_consume_token(PLUS);
        f = exp10();
      e = new Call(pos3(e), Op.PLUS, e, f);
        break;
      case MINUS:
        jj_consume_token(MINUS);
        f = exp10();
      e = new Call(pos3(e), Op.PLUS, e, f);
        break;
      default:
        jj_la1[20] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/** Parses an expression of precedence 10: . */
  final public Node exp10() throws ParseException {
  Node e;
  Node f;
    e = atom();
    label_10:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOT:
        ;
        break;
      default:
        jj_la1[21] = jj_gen;
        break label_10;
      }
      jj_consume_token(DOT);
      f = atom();
      e = new Call(pos3(e), Op.DOT, e, f);
    }
    {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/** Parses an atomic expression, effectively an expression of infinite
  * precedence. */
  final public Node atom() throws ParseException {
  final Node e;
  Node f;
  final List<Node> list;
  ImmutableList.Builder<Node> builder = null;
  final SqlParserPos p;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FALSE:
    case TRUE:
    case UNSIGNED_INTEGER_LITERAL:
    case FLOAT_LITERAL:
    case QUOTED_STRING:
    case PLUS:
    case MINUS:
      e = literal();
      break;
    case ALL:
    case AND:
    case ASC:
    case BY:
    case DESC:
    case DESCRIBE:
    case DISTINCT:
    case DUMP:
    case FOREACH:
    case GENERATE:
    case GROUP:
    case LOAD:
    case LIMIT:
    case NOT:
    case ORDER:
    case OR:
    case VALUES:
    case IDENTIFIER:
      e = simpleIdentifier();
      break;
    case LPAREN:
      jj_consume_token(LPAREN);
      p = pos();
      e = exp();
      label_11:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[22] = jj_gen;
          break label_11;
        }
        jj_consume_token(COMMA);
        f = exp();
        if (builder == null) {
          builder = ImmutableList.builder();
          builder.add(e);
        }
        builder.add(f);
      }
      jj_consume_token(RPAREN);
      if (builder == null) {
        {if (true) return e;}
      } else {
        {if (true) return new Call(pos2(p), Op.TUPLE, builder.build());}
      }
      break;
    case LBRACE:
      jj_consume_token(LBRACE);
      p = pos();
      list = expCommaListOrEmpty();
      jj_consume_token(RBRACE);
      {if (true) return new Call(pos2(p), Op.BAG, list);}
      break;
    default:
      jj_la1[23] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/** A non-empty list of expressions. */
  final public List<Node> expCommaList() throws ParseException {
  final List<Node> list = new ArrayList<Node>();
  Node e;
    e = exp();
    list.add(e);
    label_12:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[24] = jj_gen;
        break label_12;
      }
      jj_consume_token(COMMA);
      e = exp();
      list.add(e);
    }
    {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

/** A list of expressions, maybe empty. */
  final public List<Node> expCommaListOrEmpty() throws ParseException {
  final List<Node> list;
  Node e;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ALL:
    case AND:
    case ASC:
    case BY:
    case DESC:
    case DESCRIBE:
    case DISTINCT:
    case DUMP:
    case FALSE:
    case FOREACH:
    case GENERATE:
    case GROUP:
    case LOAD:
    case LIMIT:
    case NOT:
    case ORDER:
    case OR:
    case TRUE:
    case VALUES:
    case UNSIGNED_INTEGER_LITERAL:
    case FLOAT_LITERAL:
    case QUOTED_STRING:
    case LPAREN:
    case LBRACE:
    case PLUS:
    case MINUS:
    case IDENTIFIER:
      list = expCommaList();
      {if (true) return list;}
      break;
    default:
      jj_la1[25] = jj_gen;
      {if (true) return ImmutableList.<Node>of();}
    }
    throw new Error("Missing return statement in function");
  }

/** Parses a tuple. A tuple is a list of one or more expressions surrounded by
 * parentheses. */
  final public List<Node> tuple() throws ParseException {
  final List<Node> expList;
    jj_consume_token(LPAREN);
    expList = expCommaList();
    jj_consume_token(RPAREN);
    {if (true) return expList;}
    throw new Error("Missing return statement in function");
  }

/** Parses a literal expression. */
  final public Literal literal() throws ParseException {
  Literal e;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FALSE:
    case TRUE:
      e = booleanLiteral();
      break;
    case UNSIGNED_INTEGER_LITERAL:
    case FLOAT_LITERAL:
    case PLUS:
    case MINUS:
      e = numericLiteral();
      break;
    case QUOTED_STRING:
      e = stringLiteral();
      break;
    default:
      jj_la1[26] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/** Parses a boolean literal */
  final public Literal booleanLiteral() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TRUE:
      jj_consume_token(TRUE);
      {if (true) return new Literal(pos(), true);}
      break;
    case FALSE:
      jj_consume_token(FALSE);
      {if (true) return new Literal(pos(), false);}
      break;
    default:
      jj_la1[27] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/** Parses an unsigned numeric literal */
  final public NumericLiteral unsignedNumericLiteral() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNSIGNED_INTEGER_LITERAL:
      jj_consume_token(UNSIGNED_INTEGER_LITERAL);
      {if (true) return Literal.createExactNumeric(token.image, pos());}
      break;
    case FLOAT_LITERAL:
      jj_consume_token(FLOAT_LITERAL);
      assert token.image.endsWith("F");
      final String x = token.image.substring(0, token.image.length() - 1);
      {if (true) return Literal.createExactNumeric(x, pos());}
      break;
    default:
      jj_la1[28] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/** Parses a numeric literal (can be signed) */
  final public NumericLiteral numericLiteral() throws ParseException {
  NumericLiteral num;
  SqlParserPos p;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
      jj_consume_token(PLUS);
      num = unsignedNumericLiteral();
    {if (true) return num;}
      break;
    case MINUS:
      jj_consume_token(MINUS);
    p = pos();
      num = unsignedNumericLiteral();
    {if (true) return num.negate(pos2(p));}
      break;
    case UNSIGNED_INTEGER_LITERAL:
    case FLOAT_LITERAL:
      num = unsignedNumericLiteral();
    {if (true) return num;}
      break;
    default:
      jj_la1[29] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/** Parses a string literal. */
  final public Literal stringLiteral() throws ParseException {
  String s;
    jj_consume_token(QUOTED_STRING);
    s = SqlParserUtil.parseString(token.image);
    {if (true) return new Literal(pos(), s);}
    throw new Error("Missing return statement in function");
  }

/** Parses a simple identifier as a string. */
  final public String identifier() throws ParseException {
  String id;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      jj_consume_token(IDENTIFIER);
      id = unquotedIdentifier();
      break;
    case ALL:
    case AND:
    case ASC:
    case BY:
    case DESC:
    case DESCRIBE:
    case DISTINCT:
    case DUMP:
    case FOREACH:
    case GENERATE:
    case GROUP:
    case LOAD:
    case LIMIT:
    case NOT:
    case ORDER:
    case OR:
    case VALUES:
      id = nonReservedKeyWord();
      break;
    default:
      jj_la1[30] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return id;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a simple identifier as an Identifier.
 */
  final public Identifier simpleIdentifier() throws ParseException {
  String s;
    s = identifier();
    {if (true) return new Identifier(pos(), s);}
    throw new Error("Missing return statement in function");
  }

/** Parses a non-reserved keyword for use as an identifier.
 *
 * <p>Reserved: BAG, TUPLE, MAP, TRUE, FALSE
 */
  final public String commonNonReservedKeyWord() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ALL:
      jj_consume_token(ALL);
      break;
    case AND:
      jj_consume_token(AND);
      break;
    case ASC:
      jj_consume_token(ASC);
      break;
    case BY:
      jj_consume_token(BY);
      break;
    case DESC:
      jj_consume_token(DESC);
      break;
    case DESCRIBE:
      jj_consume_token(DESCRIBE);
      break;
    case DISTINCT:
      jj_consume_token(DISTINCT);
      break;
    case DUMP:
      jj_consume_token(DUMP);
      break;
    case FOREACH:
      jj_consume_token(FOREACH);
      break;
    case GENERATE:
      jj_consume_token(GENERATE);
      break;
    case GROUP:
      jj_consume_token(GROUP);
      break;
    case LIMIT:
      jj_consume_token(LIMIT);
      break;
    case LOAD:
      jj_consume_token(LOAD);
      break;
    case NOT:
      jj_consume_token(NOT);
      break;
    case OR:
      jj_consume_token(OR);
      break;
    case ORDER:
      jj_consume_token(ORDER);
      break;
    case VALUES:
      jj_consume_token(VALUES);
      break;
    default:
      jj_la1[31] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return unquotedIdentifier();}
    throw new Error("Missing return statement in function");
  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  final private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  final private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  final private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  final private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  final private boolean jj_3R_27() {
    if (jj_3R_31()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_32()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_43() {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  final private boolean jj_3R_34() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_43()) {
    jj_scanpos = xsp;
    if (jj_3R_44()) return true;
    }
    return false;
  }

  final private boolean jj_3R_62() {
    if (jj_scan_token(MINUS)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  final private boolean jj_3R_28() {
    if (jj_3R_33()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_34()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_30() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(1)) {
    jj_scanpos = xsp;
    if (jj_scan_token(2)) {
    jj_scanpos = xsp;
    if (jj_scan_token(3)) {
    jj_scanpos = xsp;
    if (jj_scan_token(6)) {
    jj_scanpos = xsp;
    if (jj_scan_token(7)) {
    jj_scanpos = xsp;
    if (jj_scan_token(8)) {
    jj_scanpos = xsp;
    if (jj_scan_token(9)) {
    jj_scanpos = xsp;
    if (jj_scan_token(10)) {
    jj_scanpos = xsp;
    if (jj_scan_token(13)) {
    jj_scanpos = xsp;
    if (jj_scan_token(14)) {
    jj_scanpos = xsp;
    if (jj_scan_token(15)) {
    jj_scanpos = xsp;
    if (jj_scan_token(17)) {
    jj_scanpos = xsp;
    if (jj_scan_token(16)) {
    jj_scanpos = xsp;
    if (jj_scan_token(19)) {
    jj_scanpos = xsp;
    if (jj_scan_token(21)) {
    jj_scanpos = xsp;
    if (jj_scan_token(20)) {
    jj_scanpos = xsp;
    if (jj_scan_token(24)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_24() {
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  final private boolean jj_3R_61() {
    if (jj_scan_token(PLUS)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  final private boolean jj_3R_57() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_61()) {
    jj_scanpos = xsp;
    if (jj_3R_62()) {
    jj_scanpos = xsp;
    if (jj_3R_63()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3_4() {
    if (jj_3R_16()) return true;
    return false;
  }

  final private boolean jj_3R_26() {
    if (jj_3R_30()) return true;
    return false;
  }

  final private boolean jj_3R_23() {
    if (jj_3R_27()) return true;
    return false;
  }

  final private boolean jj_3R_19() {
    if (jj_3R_23()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_24()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_39() {
    if (jj_scan_token(LE)) return true;
    return false;
  }

  final private boolean jj_3R_66() {
    if (jj_scan_token(FLOAT_LITERAL)) return true;
    return false;
  }

  final private boolean jj_3R_38() {
    if (jj_scan_token(GE)) return true;
    return false;
  }

  final private boolean jj_3R_65() {
    if (jj_scan_token(UNSIGNED_INTEGER_LITERAL)) return true;
    return false;
  }

  final private boolean jj_3R_37() {
    if (jj_scan_token(LT)) return true;
    return false;
  }

  final private boolean jj_3R_64() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_65()) {
    jj_scanpos = xsp;
    if (jj_3R_66()) return true;
    }
    return false;
  }

  final private boolean jj_3R_48() {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_50()) return true;
    return false;
  }

  final private boolean jj_3R_36() {
    if (jj_scan_token(GT)) return true;
    return false;
  }

  final private boolean jj_3R_29() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_35()) {
    jj_scanpos = xsp;
    if (jj_3R_36()) {
    jj_scanpos = xsp;
    if (jj_3R_37()) {
    jj_scanpos = xsp;
    if (jj_3R_38()) {
    jj_scanpos = xsp;
    if (jj_3R_39()) return true;
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_35() {
    if (jj_scan_token(EQEQ)) return true;
    return false;
  }

  final private boolean jj_3_3() {
    if (jj_3R_15()) return true;
    return false;
  }

  final private boolean jj_3R_60() {
    if (jj_scan_token(FALSE)) return true;
    return false;
  }

  final private boolean jj_3R_25() {
    if (jj_3R_28()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_29()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_59() {
    if (jj_scan_token(TRUE)) return true;
    return false;
  }

  final private boolean jj_3R_56() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_59()) {
    jj_scanpos = xsp;
    if (jj_3R_60()) return true;
    }
    return false;
  }

  final private boolean jj_3R_47() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_23()) return true;
    return false;
  }

  final private boolean jj_3R_20() {
    if (jj_3R_25()) return true;
    return false;
  }

  final private boolean jj_3R_13() {
    if (jj_3R_18()) return true;
    return false;
  }

  final private boolean jj_3R_46() {
    if (jj_3R_13()) return true;
    return false;
  }

  final private boolean jj_3R_53() {
    if (jj_3R_58()) return true;
    return false;
  }

  final private boolean jj_3R_45() {
    if (jj_3R_49()) return true;
    return false;
  }

  final private boolean jj_3R_52() {
    if (jj_3R_57()) return true;
    return false;
  }

  final private boolean jj_3R_15() {
    if (jj_3R_13()) return true;
    if (jj_scan_token(EQ)) return true;
    return false;
  }

  final private boolean jj_3R_51() {
    if (jj_3R_56()) return true;
    return false;
  }

  final private boolean jj_3R_41() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_45()) {
    jj_scanpos = xsp;
    if (jj_3R_46()) {
    jj_scanpos = xsp;
    if (jj_3R_47()) {
    jj_scanpos = xsp;
    if (jj_3R_48()) return true;
    }
    }
    }
    return false;
  }

  final private boolean jj_3_5() {
    if (jj_scan_token(NOT)) return true;
    if (jj_3R_17()) return true;
    return false;
  }

  final private boolean jj_3R_49() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_51()) {
    jj_scanpos = xsp;
    if (jj_3R_52()) {
    jj_scanpos = xsp;
    if (jj_3R_53()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_17() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_5()) {
    jj_scanpos = xsp;
    if (jj_3R_20()) return true;
    }
    return false;
  }

  final private boolean jj_3R_22() {
    if (jj_3R_26()) return true;
    return false;
  }

  final private boolean jj_3R_21() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  final private boolean jj_3_2() {
    if (jj_3R_14()) return true;
    return false;
  }

  final private boolean jj_3R_18() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_21()) {
    jj_scanpos = xsp;
    if (jj_3R_22()) return true;
    }
    return false;
  }

  final private boolean jj_3R_16() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_19()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_40() {
    if (jj_scan_token(AND)) return true;
    return false;
  }

  final private boolean jj_3R_42() {
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  final private boolean jj_3R_31() {
    if (jj_3R_17()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_40()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_33() {
    if (jj_3R_41()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_42()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_58() {
    if (jj_scan_token(QUOTED_STRING)) return true;
    return false;
  }

  final private boolean jj_3R_55() {
    return false;
  }

  final private boolean jj_3R_14() {
    if (jj_scan_token(DESCRIBE)) return true;
    if (jj_3R_13()) return true;
    return false;
  }

  final private boolean jj_3R_54() {
    if (jj_3R_19()) return true;
    return false;
  }

  final private boolean jj_3_1() {
    if (jj_3R_13()) return true;
    if (jj_scan_token(EQ)) return true;
    return false;
  }

  final private boolean jj_3R_50() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_54()) {
    jj_scanpos = xsp;
    if (jj_3R_55()) return true;
    }
    return false;
  }

  final private boolean jj_3R_32() {
    if (jj_scan_token(OR)) return true;
    return false;
  }

  final private boolean jj_3R_63() {
    if (jj_3R_64()) return true;
    return false;
  }

  final private boolean jj_3R_44() {
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  public PigletParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[32];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static {
      jj_la1_0();
      jj_la1_1();
      jj_la1_2();
   }
   private static void jj_la1_0() {
      jj_la1_0 = new int[] {0x13be7ce,0x113b200,0x400,0x121200,0x0,0x0,0x4000,0x0,0x13be7ce,0x88,0x77befce,0x42,0x0,0x1bfe7ee,0x200000,0x4,0x77befce,0x0,0x0,0x0,0x0,0x0,0x0,0x77befce,0x0,0x77befce,0x6400800,0x400800,0x6000000,0x6000000,0x13be7ce,0x13be7ce,};
   }
   private static void jj_la1_1() {
      jj_la1_1 = new int[] {0x0,0x0,0x0,0x0,0x4000,0x40,0x100,0x4000,0x4000000,0x0,0x3000142,0x0,0x4000,0x0,0x0,0x0,0x3000142,0x670000,0x670000,0x3000000,0x3000000,0x2000,0x4000,0x3000142,0x4000,0x3000142,0x3000002,0x0,0x0,0x3000000,0x0,0x0,};
   }
   private static void jj_la1_2() {
      jj_la1_2 = new int[] {0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x20000,0x0,0x0,0x20000,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x20000,0x0,0x0,0x0,0x0,0x20000,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[5];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  public PigletParser(java.io.InputStream stream) {
     this(stream, null);
  }
  public PigletParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new PigletParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 32; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 32; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public PigletParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new PigletParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 32; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 32; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public PigletParser(PigletParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 32; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(PigletParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 32; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration e = jj_expentries.elements(); e.hasMoreElements();) {
        int[] oldentry = (int[])(e.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[85];
    for (int i = 0; i < 85; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 32; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 85; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

  final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 5; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
