/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.piglet;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.piglet.Ast;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.PigRelBuilder;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.Pair;

public class Handler {
    private final PigRelBuilder builder;
    private final Map<String, RelNode> map = new HashMap<String, RelNode>();

    public Handler(PigRelBuilder builder) {
        this.builder = builder;
    }

    public Handler handle(Ast.Node node) {
        switch (node.op) {
            case LOAD: {
                Ast.LoadStmt load = (Ast.LoadStmt)node;
                this.builder.scan(new String[]{(String)load.name.value});
                this.register(load.target.value);
                return this;
            }
            case VALUES: {
                Ast.ValuesStmt values = (Ast.ValuesStmt)node;
                RelDataType rowType = this.toType(values.schema);
                this.builder.values(this.tuples(values, rowType), rowType);
                this.register(values.target.value);
                return this;
            }
            case FOREACH: {
                Ast.ForeachStmt foreach = (Ast.ForeachStmt)node;
                this.builder.clear();
                RelNode input = this.map.get(foreach.source.value);
                this.builder.push(input);
                ArrayList<RexNode> rexNodes = new ArrayList<RexNode>();
                for (Ast.Node exp : foreach.expList) {
                    rexNodes.add(this.toRex(exp));
                }
                this.builder.project(rexNodes);
                this.register(foreach.target.value);
                return this;
            }
            case FOREACH_NESTED: {
                Ast.ForeachNestedStmt foreachNested = (Ast.ForeachNestedStmt)node;
                this.builder.clear();
                RelNode input = this.map.get(foreachNested.source.value);
                this.builder.push(input);
                System.out.println(input.getRowType());
                for (RelDataTypeField field : input.getRowType().getFieldList()) {
                    switch (field.getType().getSqlTypeName()) {
                        case ARRAY: {
                            System.out.println(field);
                        }
                    }
                }
                for (Ast.Stmt stmt : foreachNested.nestedStmtList) {
                    this.handle(stmt);
                }
                ArrayList<RexNode> rexNodes = new ArrayList<RexNode>();
                for (Ast.Node exp : foreachNested.expList) {
                    rexNodes.add(this.toRex(exp));
                }
                this.builder.project(rexNodes);
                this.register(foreachNested.target.value);
                return this;
            }
            case FILTER: {
                Ast.FilterStmt filter = (Ast.FilterStmt)node;
                this.builder.clear();
                RelNode input = this.map.get(filter.source.value);
                this.builder.push(input);
                RexNode rexNode = this.toRex(filter.condition);
                this.builder.filter(new RexNode[]{rexNode});
                this.register(filter.target.value);
                return this;
            }
            case DISTINCT: {
                Ast.DistinctStmt distinct = (Ast.DistinctStmt)node;
                this.builder.clear();
                RelNode input = this.map.get(distinct.source.value);
                this.builder.push(input);
                this.builder.distinct(null, -1);
                this.register(distinct.target.value);
                return this;
            }
            case ORDER: {
                Ast.OrderStmt order = (Ast.OrderStmt)node;
                this.builder.clear();
                RelNode input = this.map.get(order.source.value);
                this.builder.push(input);
                ArrayList<RexNode> nodes = new ArrayList<RexNode>();
                for (Pair<Ast.Identifier, Ast.Direction> field : order.fields) {
                    this.toSortRex(nodes, field);
                }
                this.builder.sort(nodes);
                this.register(order.target.value);
                return this;
            }
            case LIMIT: {
                Ast.LimitStmt limit = (Ast.LimitStmt)node;
                this.builder.clear();
                RelNode input = this.map.get(limit.source.value);
                int count = ((Number)limit.count.value).intValue();
                this.builder.push(input);
                this.builder.limit(0, count);
                this.register(limit.target.value);
                return this;
            }
            case GROUP: {
                Ast.GroupStmt group = (Ast.GroupStmt)node;
                this.builder.clear();
                RelNode input = this.map.get(group.source.value);
                this.builder.push(input).as(group.source.value);
                ArrayList<RelBuilder.GroupKey> groupKeys = new ArrayList<RelBuilder.GroupKey>();
                ArrayList<RexNode> keys = new ArrayList<RexNode>();
                if (group.keys != null) {
                    for (Ast.Node key : group.keys) {
                        keys.add(this.toRex(key));
                    }
                }
                groupKeys.add(this.builder.groupKey(keys));
                this.builder.group(PigRelBuilder.GroupOption.COLLECTED, null, -1, groupKeys);
                this.register(group.target.value);
                return this;
            }
            case PROGRAM: {
                Ast.Program program = (Ast.Program)node;
                for (Ast.Stmt stmt : program.stmtList) {
                    this.handle(stmt);
                }
                return this;
            }
            case DUMP: {
                Ast.DumpStmt dump = (Ast.DumpStmt)node;
                RelNode relNode = this.map.get(dump.relation.value);
                this.dump(relNode);
                return this;
            }
        }
        throw new AssertionError((Object)("unknown operation " + (Object)((Object)node.op)));
    }

    protected void dump(RelNode rel) {
    }

    private ImmutableList<ImmutableList<RexLiteral>> tuples(Ast.ValuesStmt valuesStmt, RelDataType rowType) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (List<Ast.Node> nodeList : valuesStmt.tupleList) {
            listBuilder.add(this.tuple(nodeList, rowType));
        }
        return listBuilder.build();
    }

    private ImmutableList<RexLiteral> tuple(List<Ast.Node> nodeList, RelDataType rowType) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (Pair pair : Pair.zip(nodeList, (List)rowType.getFieldList())) {
            Ast.Node node = (Ast.Node)pair.left;
            RelDataType type = ((RelDataTypeField)pair.right).getType();
            listBuilder.add((Object)this.item(node, type));
        }
        return listBuilder.build();
    }

    private ImmutableList<RexLiteral> bag(List<Ast.Node> nodeList, RelDataType type) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (Ast.Node node : nodeList) {
            listBuilder.add((Object)this.item(node, type.getComponentType()));
        }
        return listBuilder.build();
    }

    private RexLiteral item(Ast.Node node, RelDataType type) {
        RexBuilder rexBuilder = this.builder.getRexBuilder();
        switch (node.op) {
            case LITERAL: {
                Ast.Literal literal = (Ast.Literal)node;
                return (RexLiteral)rexBuilder.makeLiteral(literal.value, type, false);
            }
            case TUPLE: {
                Ast.Call tuple = (Ast.Call)node;
                ImmutableList<RexLiteral> list = this.tuple((List<Ast.Node>)tuple.operands, type);
                return (RexLiteral)rexBuilder.makeLiteral(list, type, false);
            }
            case BAG: {
                Ast.Call bag = (Ast.Call)node;
                ImmutableList<RexLiteral> list2 = this.bag((List<Ast.Node>)bag.operands, type);
                return (RexLiteral)rexBuilder.makeLiteral(list2, type, false);
            }
        }
        throw new IllegalArgumentException("not a literal: " + node);
    }

    private RelDataType toType(Ast.Schema schema) {
        RelDataTypeFactory.FieldInfoBuilder typeBuilder = this.builder.getTypeFactory().builder();
        for (Ast.FieldSchema fieldSchema : schema.fieldSchemaList) {
            typeBuilder.add(fieldSchema.id.value, this.toType(fieldSchema.type));
        }
        return typeBuilder.build();
    }

    private RelDataType toType(Ast.Type type) {
        switch (type.op) {
            case SCALAR_TYPE: {
                return this.toType((Ast.ScalarType)type);
            }
            case BAG_TYPE: {
                return this.toType((Ast.BagType)type);
            }
            case MAP_TYPE: {
                return this.toType((Ast.MapType)type);
            }
            case TUPLE_TYPE: {
                return this.toType((Ast.TupleType)type);
            }
        }
        throw new AssertionError((Object)("unknown type " + type));
    }

    private RelDataType toType(Ast.ScalarType type) {
        RelDataTypeFactory typeFactory = this.builder.getTypeFactory();
        switch (type.name) {
            case "boolean": {
                return typeFactory.createSqlType(SqlTypeName.BOOLEAN);
            }
            case "int": {
                return typeFactory.createSqlType(SqlTypeName.INTEGER);
            }
            case "float": {
                return typeFactory.createSqlType(SqlTypeName.REAL);
            }
        }
        return typeFactory.createSqlType(SqlTypeName.VARCHAR);
    }

    private RelDataType toType(Ast.BagType type) {
        RelDataTypeFactory typeFactory = this.builder.getTypeFactory();
        RelDataType t = this.toType(type.componentType);
        return typeFactory.createMultisetType(t, -1L);
    }

    private RelDataType toType(Ast.MapType type) {
        RelDataTypeFactory typeFactory = this.builder.getTypeFactory();
        RelDataType k = this.toType(type.keyType);
        RelDataType v = this.toType(type.valueType);
        return typeFactory.createMapType(k, v);
    }

    private RelDataType toType(Ast.TupleType type) {
        RelDataTypeFactory typeFactory = this.builder.getTypeFactory();
        RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
        for (Ast.FieldSchema fieldSchema : type.fieldSchemaList) {
            builder.add(fieldSchema.id.value, this.toType(fieldSchema.type));
        }
        return builder.build();
    }

    private void toSortRex(List<RexNode> nodes, Pair<Ast.Identifier, Ast.Direction> pair) {
        if (((Ast.Identifier)pair.left).isStar()) {
            for (RexNode node : this.builder.fields()) {
                switch ((Ast.Direction)((Object)pair.right)) {
                    case DESC: {
                        node = this.builder.desc(node);
                    }
                }
                nodes.add(node);
            }
        } else {
            RexNode node = this.toRex((Ast.Node)pair.left);
            switch ((Ast.Direction)((Object)pair.right)) {
                case DESC: {
                    node = this.builder.desc(node);
                }
            }
            nodes.add(node);
        }
    }

    private RexNode toRex(Ast.Node exp) {
        switch (exp.op) {
            case LITERAL: {
                return this.builder.literal(((Ast.Literal)exp).value);
            }
            case IDENTIFIER: {
                String value = ((Ast.Identifier)exp).value;
                if (value.matches("^\\$[0-9]+")) {
                    int i = Integer.valueOf(value.substring(1));
                    return this.builder.field(i);
                }
                return this.builder.field(value);
            }
            case DOT: {
                Ast.Call call = (Ast.Call)exp;
                RexNode left = this.toRex((Ast.Node)call.operands.get(0));
                Ast.Identifier right = (Ast.Identifier)call.operands.get(1);
                return this.builder.dot(left, right.value);
            }
            case EQ: 
            case NE: 
            case GT: 
            case GTE: 
            case LT: 
            case LTE: 
            case AND: 
            case OR: 
            case NOT: 
            case PLUS: 
            case MINUS: {
                Ast.Call call = (Ast.Call)exp;
                return this.builder.call(Handler.op(exp.op), this.toRex((Iterable<Ast.Node>)call.operands));
            }
        }
        throw new AssertionError((Object)("unknown op " + (Object)((Object)exp.op)));
    }

    private static SqlOperator op(Ast.Op op) {
        switch (op) {
            case EQ: {
                return SqlStdOperatorTable.EQUALS;
            }
            case NE: {
                return SqlStdOperatorTable.NOT_EQUALS;
            }
            case GT: {
                return SqlStdOperatorTable.GREATER_THAN;
            }
            case GTE: {
                return SqlStdOperatorTable.GREATER_THAN_OR_EQUAL;
            }
            case LT: {
                return SqlStdOperatorTable.LESS_THAN;
            }
            case LTE: {
                return SqlStdOperatorTable.LESS_THAN_OR_EQUAL;
            }
            case AND: {
                return SqlStdOperatorTable.AND;
            }
            case OR: {
                return SqlStdOperatorTable.OR;
            }
            case NOT: {
                return SqlStdOperatorTable.NOT;
            }
            case PLUS: {
                return SqlStdOperatorTable.PLUS;
            }
            case MINUS: {
                return SqlStdOperatorTable.MINUS;
            }
        }
        throw new AssertionError((Object)("unknown: " + (Object)((Object)op)));
    }

    private ImmutableList<RexNode> toRex(Iterable<Ast.Node> operands) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Ast.Node operand : operands) {
            builder.add((Object)this.toRex(operand));
        }
        return builder.build();
    }

    private void register(String name) {
        this.map.put(name, this.builder.peek());
    }
}

