/* Generated By:JavaCC: Do not edit this line. PigletParser.java */
package org.apache.calcite.piglet.parser;

import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParserUtil;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.piglet.Ast.*;
import org.apache.calcite.util.trace.CalciteTrace;
import org.apache.calcite.util.Pair;

import com.google.common.collect.ImmutableList;

import org.slf4j.Logger;

import java.util.ArrayList;
import java.util.List;

import static org.apache.calcite.util.Static.RESOURCE;

/**
 * Parser Piglet, a Pig-like language, generated from PigletParser.jj by JavaCC.
 */
public class PigletParser implements PigletParserConstants {
  private static final Logger LOGGER = CalciteTrace.getParserTracer();

  public void setTabSize(int tabSize) {
    jj_input_stream.setTabSize(tabSize);
  }

  void debug_message1() throws ParseException {
  LOGGER.info("{} , {}", getToken(0).image, getToken(1).image);
  }

  String unquotedIdentifier() throws ParseException {
  return SqlParserUtil.strip(getToken(0).image, null, null, null,
    Casing.UNCHANGED);
  }

  final public String nonReservedKeyWord() throws ParseException {
  String kw;
    kw = commonNonReservedKeyWord();
    {if (true) return kw;}
    throw new Error("Missing return statement in function");
  }

  void e() throws ParseException {
  }

  SqlParserPos pos() throws ParseException {
  return new SqlParserPos(token.beginLine, token.beginColumn,
    token.endLine, token.endColumn);
  }

  SqlParserPos pos2(SqlParserPos p) throws ParseException {
  return p.plus(pos());
  }

  SqlParserPos pos3(Node n) throws ParseException {
  return n.pos.plus(pos());
  }

  SqlParseException convertException(Throwable ex) throws ParseException {
  if (ex instanceof SqlParseException) {
    return (SqlParseException) ex;
  }
  SqlParserPos pos = null;
  int[][] expectedTokenSequences = null;
  String[] tokenImage = null;
  if (ex instanceof ParseException) {
    ParseException pex = (ParseException) ex;
    expectedTokenSequences = pex.expectedTokenSequences;
    tokenImage = pex.tokenImage;
    if (pex.currentToken != null) {
      final Token token = pex.currentToken.next;
      pos = new SqlParserPos(token.beginLine, token.beginColumn,
          token.endLine, token.endColumn);
    }
  } else if (ex instanceof TokenMgrError) {
    TokenMgrError tme = (TokenMgrError) ex;
    expectedTokenSequences = null;
    tokenImage = null;
    // Example:
    //    Lexical error at line 3, column 24.  Encountered "#" after "a".
    final java.util.regex.Pattern pattern = java.util.regex.Pattern.compile(
        "(?s)Lexical error at line ([0-9]+), column ([0-9]+).*");
    java.util.regex.Matcher matcher = pattern.matcher(ex.getMessage());
    if (matcher.matches()) {
      int line = Integer.parseInt(matcher.group(1));
      int column = Integer.parseInt(matcher.group(2));
      pos = new SqlParserPos(line, column, line, column);
    }
  } else if (ex instanceof CalciteContextException) {
    // CalciteContextException is the standard wrapper for exceptions
    // produced by the validator, but in the parser, the standard is
    // SqlParseException; so, strip it away. In case you were wondering,
    // the CalciteContextException appears because the parser
    // occasionally calls into validator-style code such as
    // SqlSpecialOperator.reduceExpr.
    CalciteContextException ece =
        (CalciteContextException) ex;
    pos = new SqlParserPos(
        ece.getPosLine(),
        ece.getPosColumn(),
        ece.getEndPosLine(),
        ece.getEndPosColumn());
    ex = ece.getCause();
  }

  return new SqlParseException(ex.getMessage(), pos, expectedTokenSequences,
      tokenImage, ex);
  }

/*****************************************
 * Syntactical Descriptions              *
 *****************************************/

/**
 * Parses a list of statements (LOAD, DUMP, etc.) followed by
 * the end-of-file symbol.
 */
  final public Program stmtListEof() throws ParseException {
  final List<Stmt> list = new ArrayList<Stmt>();
  Stmt s;
    label_1:
    while (true) {
      if (jj_2_1(2)) {
        ;
      } else {
        break label_1;
      }
      s = stmt();
      list.add(s);
    }
    jj_consume_token(0);
    SqlParserPos p = SqlParserPos.ZERO;
    for (Stmt s2 : list) {
      p = p.plus(s2.pos);
    }
    {if (true) return new Program(p, list);}
    throw new Error("Missing return statement in function");
  }

  final public Stmt stmt() throws ParseException {
  final Identifier target;
  final Stmt s;
    if (jj_2_10(2)) {
      target = simpleIdentifier();
      jj_consume_token(EQ);
      if (jj_2_2(2)) {
        s = loadStmt(target);
      } else if (jj_2_3(2)) {
        s = valuesStmt(target);
      } else if (jj_2_4(2)) {
        s = distinctStmt(target);
      } else if (jj_2_5(2)) {
        s = limitStmt(target);
      } else if (jj_2_6(2)) {
        s = orderStmt(target);
      } else if (jj_2_7(2)) {
        s = foreachStmt(target);
      } else if (jj_2_8(2)) {
        s = filterStmt(target);
      } else if (jj_2_9(2)) {
        s = groupStmt(target);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else if (jj_2_11(2)) {
      s = describeStmt();
    } else if (jj_2_12(2)) {
      s = dumpStmt();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return s;}
    throw new Error("Missing return statement in function");
  }

  final public Assignment1 nestedStmt() throws ParseException {
  final Identifier target;
  final Assignment1 s;
    target = simpleIdentifier();
    jj_consume_token(EQ);
    if (jj_2_13(2)) {
      s = distinctStmt(target);
    } else if (jj_2_14(2)) {
      s = limitStmt(target);
    } else if (jj_2_15(2)) {
      s = orderStmt(target);
    } else if (jj_2_16(2)) {
      s = filterStmt(target);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return s;}
    throw new Error("Missing return statement in function");
  }

  final public LoadStmt loadStmt(final Identifier target) throws ParseException {
  final Literal name;
    jj_consume_token(LOAD);
    name = stringLiteral();
    jj_consume_token(SEMICOLON);
    {if (true) return new LoadStmt(pos3(target), target, name);}
    throw new Error("Missing return statement in function");
  }

  final public ValuesStmt valuesStmt(final Identifier target) throws ParseException {
  final List<List<Node>> tupleList;
  final Schema schema;
    jj_consume_token(VALUES);
    tupleList = tupleListMaybeEmpty();
    jj_consume_token(AS);
    schema = schema();
    jj_consume_token(SEMICOLON);
    {if (true) return new ValuesStmt(pos3(target), target, schema, tupleList);}
    throw new Error("Missing return statement in function");
  }

/** Parses a tuple list.
 * The list may be empty.
 * Each tuple is a list of at least one expression. */
  final public List<List<Node>> tupleListMaybeEmpty() throws ParseException {
  final ImmutableList.Builder<List<Node>> tupleList = ImmutableList.builder();
  List<Node> tuple;
    if (jj_2_18(2)) {
      tuple = tuple();
      tupleList.add(tuple);
      label_2:
      while (true) {
        if (jj_2_17(2)) {
          ;
        } else {
          break label_2;
        }
        jj_consume_token(COMMA);
        tuple = tuple();
        tupleList.add(tuple);
      }
    } else {
      ;
    }
    {if (true) return tupleList.build();}
    throw new Error("Missing return statement in function");
  }

  final public DescribeStmt describeStmt() throws ParseException {
  final SqlParserPos p;
  final Identifier id;
    jj_consume_token(DESCRIBE);
               p = pos();
    id = simpleIdentifier();
    jj_consume_token(SEMICOLON);
    {if (true) return new DescribeStmt(pos2(p), id);}
    throw new Error("Missing return statement in function");
  }

  final public DumpStmt dumpStmt() throws ParseException {
  final SqlParserPos p;
  final Identifier id;
    jj_consume_token(DUMP);
           p = pos();
    id = simpleIdentifier();
    jj_consume_token(SEMICOLON);
    {if (true) return new DumpStmt(pos2(p), id);}
    throw new Error("Missing return statement in function");
  }

  final public Assignment foreachStmt(final Identifier target) throws ParseException {
  final Identifier id;
  final List<Node> expList;
  final List<Stmt> nestedStmtList;
  final Schema schema = null;
    jj_consume_token(FOREACH);
    id = simpleIdentifier();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case GENERATE:
      jj_consume_token(GENERATE);
      expList = expCommaList();
      jj_consume_token(SEMICOLON);
      {if (true) return new ForeachStmt(pos3(target), target, id, expList, schema);}
      break;
    default:
      jj_la1[0] = jj_gen;
      if (jj_2_19(2)) {
        jj_consume_token(LBRACE);
        nestedStmtList = nestedStmtList();
        jj_consume_token(GENERATE);
        expList = expCommaList();
        jj_consume_token(SEMICOLON);
        jj_consume_token(RBRACE);
      {if (true) return new ForeachNestedStmt(pos3(target), target, id, nestedStmtList,
          expList, schema);}
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public List<Stmt> nestedStmtList() throws ParseException {
  Assignment s;
  final List<Stmt> list = new ArrayList<Stmt>();
    s = nestedStmt();
    list.add(s);
    label_3:
    while (true) {
      if (jj_2_20(2)) {
        ;
      } else {
        break label_3;
      }
      s = nestedStmt();
      list.add(s);
    }
    {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

  final public FilterStmt filterStmt(final Identifier target) throws ParseException {
  final Identifier id;
  final Node condition;
    jj_consume_token(FILTER);
    id = simpleIdentifier();
    jj_consume_token(BY);
    condition = exp();
    jj_consume_token(SEMICOLON);
    {if (true) return new FilterStmt(pos3(target), target, id, condition);}
    throw new Error("Missing return statement in function");
  }

  final public DistinctStmt distinctStmt(final Identifier target) throws ParseException {
  final Identifier id;
    jj_consume_token(DISTINCT);
    id = simpleIdentifier();
    jj_consume_token(SEMICOLON);
    {if (true) return new DistinctStmt(pos3(target), target, id);}
    throw new Error("Missing return statement in function");
  }

  final public LimitStmt limitStmt(final Identifier target) throws ParseException {
  final Identifier id;
  final NumericLiteral count;
    jj_consume_token(LIMIT);
    id = simpleIdentifier();
    count = numericLiteral();
    jj_consume_token(SEMICOLON);
    {if (true) return new LimitStmt(pos3(target), target, id, count);}
    throw new Error("Missing return statement in function");
  }

  final public OrderStmt orderStmt(final Identifier target) throws ParseException {
  final Identifier id;
  final List<Pair<Identifier, Direction>> fields;
    jj_consume_token(ORDER);
    id = simpleIdentifier();
    jj_consume_token(BY);
    fields = orderFieldCommaList();
    jj_consume_token(SEMICOLON);
    {if (true) return new OrderStmt(pos3(target), target, id, fields);}
    throw new Error("Missing return statement in function");
  }

  final public List<Pair<Identifier, Direction>> orderFieldCommaList() throws ParseException {
  final List<Pair<Identifier, Direction>> list =
      new ArrayList<Pair<Identifier, Direction>>();
  Pair<Identifier, Direction> field;
    field = orderField();
    list.add(field);
    label_4:
    while (true) {
      if (jj_2_21(2)) {
        ;
      } else {
        break label_4;
      }
      jj_consume_token(COMMA);
      field = orderField();
      list.add(field);
    }
    {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

  final public Pair<Identifier, Direction> orderField() throws ParseException {
  final Identifier id;
  final Direction direction;
    if (jj_2_22(2)) {
      jj_consume_token(STAR);
      id = new SpecialIdentifier(pos());
    } else if (jj_2_23(2)) {
      id = simpleIdentifier();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    if (jj_2_24(2)) {
      jj_consume_token(ASC);
      direction = Direction.ASC;
    } else if (jj_2_25(2)) {
      jj_consume_token(DESC);
      direction = Direction.DESC;
    } else {
      direction = Direction.NOT_SPECIFIED;
    }
    {if (true) return Pair.of(id, direction);}
    throw new Error("Missing return statement in function");
  }

  final public GroupStmt groupStmt(final Identifier target) throws ParseException {
  final Identifier id;
  final List<Node> keys;
  final Node exp;
    jj_consume_token(GROUP);
    id = simpleIdentifier();
    if (jj_2_28(2)) {
      jj_consume_token(ALL);
      keys = null;
    } else if (jj_2_29(2)) {
      jj_consume_token(BY);
      if (jj_2_26(2)) {
        keys = tuple();
      } else if (jj_2_27(2)) {
        exp = exp();
        keys = ImmutableList.of(exp);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(SEMICOLON);
    {if (true) return new GroupStmt(pos3(target), target, id, keys);}
    throw new Error("Missing return statement in function");
  }

/** Parses a schema. */
  final public Schema schema() throws ParseException {
  final SqlParserPos p;
  final List<FieldSchema> fieldSchemaList;
    jj_consume_token(LPAREN);
    p = pos();
    fieldSchemaList = fieldSchemaList();
    jj_consume_token(RPAREN);
    {if (true) return new Schema(pos2(p), fieldSchemaList);}
    throw new Error("Missing return statement in function");
  }

  final public List<FieldSchema> fieldSchemaList() throws ParseException {
  final ImmutableList.Builder<FieldSchema> list = ImmutableList.builder();
  FieldSchema fieldSchema;
    fieldSchema = fieldSchema();
    list.add(fieldSchema);
    label_5:
    while (true) {
      if (jj_2_30(2)) {
        ;
      } else {
        break label_5;
      }
      jj_consume_token(COMMA);
      fieldSchema = fieldSchema();
      list.add(fieldSchema);
    }
    {if (true) return list.build();}
    throw new Error("Missing return statement in function");
  }

  final public FieldSchema fieldSchema() throws ParseException {
  final Identifier identifier;
  final Type type;
    identifier = simpleIdentifier();
    jj_consume_token(COLON);
    type = type();
    {if (true) return new FieldSchema(pos3(identifier), identifier, type);}
    throw new Error("Missing return statement in function");
  }

/** Parses a Type. */
  final public Type type() throws ParseException {
  final SqlParserPos p;
  final String s;
  final Type t;
  final List<FieldSchema> fieldSchemaList;
    if (jj_2_31(2)) {
      s = identifier();
      {if (true) return new ScalarType(pos(), s);}
    } else if (jj_2_32(2)) {
      jj_consume_token(BAG);
      p = pos();
      jj_consume_token(LBRACE);
      t = type();
      jj_consume_token(RBRACE);
      {if (true) return new BagType(pos2(p), t);}
    } else if (jj_2_33(2)) {
      jj_consume_token(TUPLE);
      p = pos();
      jj_consume_token(LPAREN);
      fieldSchemaList = fieldSchemaList();
      jj_consume_token(RPAREN);
      {if (true) return new TupleType(pos2(p), fieldSchemaList);}
    } else if (jj_2_34(2)) {
      jj_consume_token(MAP);
            p = pos();
      jj_consume_token(LBRACKET);
      jj_consume_token(RBRACKET);
      {if (true) return new MapType(pos2(p));}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/** Parses an expression. */
  final public Node exp() throws ParseException {
  final Node e;
    e = exp1();
    {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/** Parses an expression of precedence 1: OR. */
  final public Node exp1() throws ParseException {
  Node e;
  Node f;
    e = exp2();
    label_6:
    while (true) {
      if (jj_2_35(2)) {
        ;
      } else {
        break label_6;
      }
      jj_consume_token(OR);
      f = exp2();
      e = new Call(pos3(e), Op.OR, e, f);
    }
    {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/** Parses an expression of precedence 2: AND. */
  final public Node exp2() throws ParseException {
  Node e;
  Node f;
    e = exp3();
    label_7:
    while (true) {
      if (jj_2_36(2)) {
        ;
      } else {
        break label_7;
      }
      jj_consume_token(AND);
      f = exp3();
      e = new Call(pos3(e), Op.AND, e, f);
    }
    {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/** Parses an expression of precedence 3: NOT. */
  final public Node exp3() throws ParseException {
  final Node e;
  final SqlParserPos p;
    if (jj_2_37(2)) {
      jj_consume_token(NOT);
      p = pos();
      e = exp3();
      {if (true) return new Call(pos2(p), Op.NOT, e);}
    } else if (jj_2_38(2)) {
      e = exp4();
      {if (true) return e;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/** Parses an expression of precedence 4: relational operators (==, !=, <, <=,
 * >, >=). */
  final public Node exp4() throws ParseException {
  Node e;
  Node f;
    e = exp5();
    label_8:
    while (true) {
      if (jj_2_39(2)) {
        ;
      } else {
        break label_8;
      }
      if (jj_2_40(2)) {
        jj_consume_token(EQEQ);
        f = exp5();
      e = new Call(pos3(e), Op.EQ, e, f);
      } else if (jj_2_41(2)) {
        jj_consume_token(GT);
        f = exp5();
      e = new Call(pos3(e), Op.GT, e, f);
      } else if (jj_2_42(2)) {
        jj_consume_token(LT);
        f = exp5();
      e = new Call(pos3(e), Op.LT, e, f);
      } else if (jj_2_43(2)) {
        jj_consume_token(GE);
        f = exp5();
      e = new Call(pos3(e), Op.GTE, e, f);
      } else if (jj_2_44(2)) {
        jj_consume_token(LE);
        f = exp5();
      e = new Call(pos3(e), Op.LTE, e, f);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/** Parses an expression of precedence 5: +, -. */
  final public Node exp5() throws ParseException {
  Node e;
  Node f;
    e = exp10();
    label_9:
    while (true) {
      if (jj_2_45(2)) {
        ;
      } else {
        break label_9;
      }
      if (jj_2_46(2)) {
        jj_consume_token(PLUS);
        f = exp10();
      e = new Call(pos3(e), Op.PLUS, e, f);
      } else if (jj_2_47(2)) {
        jj_consume_token(MINUS);
        f = exp10();
      e = new Call(pos3(e), Op.PLUS, e, f);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/** Parses an expression of precedence 10: . */
  final public Node exp10() throws ParseException {
  Node e;
  Node f;
    e = atom();
    label_10:
    while (true) {
      if (jj_2_48(2)) {
        ;
      } else {
        break label_10;
      }
      jj_consume_token(DOT);
      f = atom();
      e = new Call(pos3(e), Op.DOT, e, f);
    }
    {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/** Parses an atomic expression, effectively an expression of infinite
  * precedence. */
  final public Node atom() throws ParseException {
  final Node e;
  Node f;
  final List<Node> list;
  ImmutableList.Builder<Node> builder = null;
  final SqlParserPos p;
    if (jj_2_50(2)) {
      e = literal();
    } else if (jj_2_51(2)) {
      e = simpleIdentifier();
    } else if (jj_2_52(2)) {
      jj_consume_token(LPAREN);
      p = pos();
      e = exp();
      label_11:
      while (true) {
        if (jj_2_49(2)) {
          ;
        } else {
          break label_11;
        }
        jj_consume_token(COMMA);
        f = exp();
        if (builder == null) {
          builder = ImmutableList.builder();
          builder.add(e);
        }
        builder.add(f);
      }
      jj_consume_token(RPAREN);
      if (builder == null) {
        {if (true) return e;}
      } else {
        {if (true) return new Call(pos2(p), Op.TUPLE, builder.build());}
      }
    } else if (jj_2_53(2)) {
      jj_consume_token(LBRACE);
      p = pos();
      list = expCommaListOrEmpty();
      jj_consume_token(RBRACE);
      {if (true) return new Call(pos2(p), Op.BAG, list);}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/** A non-empty list of expressions. */
  final public List<Node> expCommaList() throws ParseException {
  final List<Node> list = new ArrayList<Node>();
  Node e;
    e = exp();
    list.add(e);
    label_12:
    while (true) {
      if (jj_2_54(2)) {
        ;
      } else {
        break label_12;
      }
      jj_consume_token(COMMA);
      e = exp();
      list.add(e);
    }
    {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

/** A list of expressions, maybe empty. */
  final public List<Node> expCommaListOrEmpty() throws ParseException {
  final List<Node> list;
  Node e;
    if (jj_2_55(2)) {
      list = expCommaList();
      {if (true) return list;}
    } else {
      {if (true) return ImmutableList.<Node>of();}
    }
    throw new Error("Missing return statement in function");
  }

/** Parses a tuple. A tuple is a list of one or more expressions surrounded by
 * parentheses. */
  final public List<Node> tuple() throws ParseException {
  final List<Node> expList;
    jj_consume_token(LPAREN);
    expList = expCommaList();
    jj_consume_token(RPAREN);
    {if (true) return expList;}
    throw new Error("Missing return statement in function");
  }

/** Parses a literal expression. */
  final public Literal literal() throws ParseException {
  Literal e;
    if (jj_2_56(2)) {
      e = booleanLiteral();
    } else if (jj_2_57(2)) {
      e = numericLiteral();
    } else if (jj_2_58(2)) {
      e = stringLiteral();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/** Parses a boolean literal */
  final public Literal booleanLiteral() throws ParseException {
    if (jj_2_59(2)) {
      jj_consume_token(TRUE);
      {if (true) return new Literal(pos(), true);}
    } else if (jj_2_60(2)) {
      jj_consume_token(FALSE);
      {if (true) return new Literal(pos(), false);}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/** Parses an unsigned numeric literal */
  final public NumericLiteral unsignedNumericLiteral() throws ParseException {
    if (jj_2_61(2)) {
      jj_consume_token(UNSIGNED_INTEGER_LITERAL);
      {if (true) return Literal.createExactNumeric(token.image, pos());}
    } else if (jj_2_62(2)) {
      jj_consume_token(FLOAT_LITERAL);
      assert token.image.endsWith("F");
      final String x = token.image.substring(0, token.image.length() - 1);
      {if (true) return Literal.createExactNumeric(x, pos());}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/** Parses a numeric literal (can be signed) */
  final public NumericLiteral numericLiteral() throws ParseException {
  NumericLiteral num;
  SqlParserPos p;
    if (jj_2_63(2)) {
      jj_consume_token(PLUS);
      num = unsignedNumericLiteral();
    {if (true) return num;}
    } else if (jj_2_64(2)) {
      jj_consume_token(MINUS);
    p = pos();
      num = unsignedNumericLiteral();
    {if (true) return num.negate(pos2(p));}
    } else if (jj_2_65(2)) {
      num = unsignedNumericLiteral();
    {if (true) return num;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/** Parses a string literal. */
  final public Literal stringLiteral() throws ParseException {
  String s;
    jj_consume_token(QUOTED_STRING);
    s = SqlParserUtil.parseString(token.image);
    {if (true) return new Literal(pos(), s);}
    throw new Error("Missing return statement in function");
  }

/** Parses a simple identifier as a string. */
  final public String identifier() throws ParseException {
  String id;
    if (jj_2_66(2)) {
      jj_consume_token(IDENTIFIER);
      id = unquotedIdentifier();
    } else if (jj_2_67(2)) {
      id = nonReservedKeyWord();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return id;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a simple identifier as an Identifier.
 */
  final public Identifier simpleIdentifier() throws ParseException {
  String s;
    s = identifier();
    {if (true) return new Identifier(pos(), s);}
    throw new Error("Missing return statement in function");
  }

/** Parses a non-reserved keyword for use as an identifier.
 *
 * <p>Reserved: BAG, TUPLE, MAP, TRUE, FALSE
 */
  final public String commonNonReservedKeyWord() throws ParseException {
    if (jj_2_68(2)) {
      jj_consume_token(ALL);
    } else if (jj_2_69(2)) {
      jj_consume_token(AND);
    } else if (jj_2_70(2)) {
      jj_consume_token(ASC);
    } else if (jj_2_71(2)) {
      jj_consume_token(BY);
    } else if (jj_2_72(2)) {
      jj_consume_token(DESC);
    } else if (jj_2_73(2)) {
      jj_consume_token(DESCRIBE);
    } else if (jj_2_74(2)) {
      jj_consume_token(DISTINCT);
    } else if (jj_2_75(2)) {
      jj_consume_token(DUMP);
    } else if (jj_2_76(2)) {
      jj_consume_token(FOREACH);
    } else if (jj_2_77(2)) {
      jj_consume_token(GENERATE);
    } else if (jj_2_78(2)) {
      jj_consume_token(GROUP);
    } else if (jj_2_79(2)) {
      jj_consume_token(LIMIT);
    } else if (jj_2_80(2)) {
      jj_consume_token(LOAD);
    } else if (jj_2_81(2)) {
      jj_consume_token(NOT);
    } else if (jj_2_82(2)) {
      jj_consume_token(OR);
    } else if (jj_2_83(2)) {
      jj_consume_token(ORDER);
    } else if (jj_2_84(2)) {
      jj_consume_token(VALUES);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return unquotedIdentifier();}
    throw new Error("Missing return statement in function");
  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  final private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  final private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  final private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  final private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  final private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  final private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  final private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  final private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  final private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  final private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  final private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  final private boolean jj_2_13(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_13(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  final private boolean jj_2_14(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_14(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  final private boolean jj_2_15(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_15(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  final private boolean jj_2_16(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_16(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  final private boolean jj_2_17(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_17(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  final private boolean jj_2_18(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_18(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  final private boolean jj_2_19(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_19(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  final private boolean jj_2_20(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_20(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  final private boolean jj_2_21(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_21(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  final private boolean jj_2_22(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_22(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  final private boolean jj_2_23(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_23(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  final private boolean jj_2_24(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_24(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  final private boolean jj_2_25(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_25(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  final private boolean jj_2_26(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_26(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  final private boolean jj_2_27(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_27(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  final private boolean jj_2_28(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_28(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(27, xla); }
  }

  final private boolean jj_2_29(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_29(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(28, xla); }
  }

  final private boolean jj_2_30(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_30(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(29, xla); }
  }

  final private boolean jj_2_31(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_31(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(30, xla); }
  }

  final private boolean jj_2_32(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_32(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(31, xla); }
  }

  final private boolean jj_2_33(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_33(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(32, xla); }
  }

  final private boolean jj_2_34(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_34(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(33, xla); }
  }

  final private boolean jj_2_35(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_35(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(34, xla); }
  }

  final private boolean jj_2_36(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_36(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(35, xla); }
  }

  final private boolean jj_2_37(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_37(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(36, xla); }
  }

  final private boolean jj_2_38(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_38(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(37, xla); }
  }

  final private boolean jj_2_39(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_39(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(38, xla); }
  }

  final private boolean jj_2_40(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_40(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(39, xla); }
  }

  final private boolean jj_2_41(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_41(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(40, xla); }
  }

  final private boolean jj_2_42(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_42(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(41, xla); }
  }

  final private boolean jj_2_43(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_43(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(42, xla); }
  }

  final private boolean jj_2_44(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_44(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(43, xla); }
  }

  final private boolean jj_2_45(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_45(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(44, xla); }
  }

  final private boolean jj_2_46(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_46(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(45, xla); }
  }

  final private boolean jj_2_47(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_47(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(46, xla); }
  }

  final private boolean jj_2_48(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_48(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(47, xla); }
  }

  final private boolean jj_2_49(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_49(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(48, xla); }
  }

  final private boolean jj_2_50(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_50(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(49, xla); }
  }

  final private boolean jj_2_51(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_51(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(50, xla); }
  }

  final private boolean jj_2_52(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_52(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(51, xla); }
  }

  final private boolean jj_2_53(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_53(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(52, xla); }
  }

  final private boolean jj_2_54(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_54(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(53, xla); }
  }

  final private boolean jj_2_55(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_55(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(54, xla); }
  }

  final private boolean jj_2_56(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_56(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(55, xla); }
  }

  final private boolean jj_2_57(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_57(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(56, xla); }
  }

  final private boolean jj_2_58(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_58(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(57, xla); }
  }

  final private boolean jj_2_59(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_59(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(58, xla); }
  }

  final private boolean jj_2_60(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_60(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(59, xla); }
  }

  final private boolean jj_2_61(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_61(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(60, xla); }
  }

  final private boolean jj_2_62(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_62(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(61, xla); }
  }

  final private boolean jj_2_63(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_63(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(62, xla); }
  }

  final private boolean jj_2_64(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_64(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(63, xla); }
  }

  final private boolean jj_2_65(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_65(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(64, xla); }
  }

  final private boolean jj_2_66(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_66(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(65, xla); }
  }

  final private boolean jj_2_67(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_67(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(66, xla); }
  }

  final private boolean jj_2_68(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_68(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(67, xla); }
  }

  final private boolean jj_2_69(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_69(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(68, xla); }
  }

  final private boolean jj_2_70(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_70(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(69, xla); }
  }

  final private boolean jj_2_71(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_71(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(70, xla); }
  }

  final private boolean jj_2_72(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_72(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(71, xla); }
  }

  final private boolean jj_2_73(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_73(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(72, xla); }
  }

  final private boolean jj_2_74(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_74(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(73, xla); }
  }

  final private boolean jj_2_75(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_75(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(74, xla); }
  }

  final private boolean jj_2_76(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_76(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(75, xla); }
  }

  final private boolean jj_2_77(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_77(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(76, xla); }
  }

  final private boolean jj_2_78(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_78(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(77, xla); }
  }

  final private boolean jj_2_79(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_79(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(78, xla); }
  }

  final private boolean jj_2_80(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_80(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(79, xla); }
  }

  final private boolean jj_2_81(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_81(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(80, xla); }
  }

  final private boolean jj_2_82(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_82(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(81, xla); }
  }

  final private boolean jj_2_83(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_83(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(82, xla); }
  }

  final private boolean jj_2_84(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_84(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(83, xla); }
  }

  final private boolean jj_3_82() {
    if (jj_scan_token(OR)) return true;
    return false;
  }

  final private boolean jj_3_55() {
    if (jj_3R_40()) return true;
    return false;
  }

  final private boolean jj_3_81() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  final private boolean jj_3_80() {
    if (jj_scan_token(LOAD)) return true;
    return false;
  }

  final private boolean jj_3R_39() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_55()) {
    jj_scanpos = xsp;
    if (jj_3R_48()) return true;
    }
    return false;
  }

  final private boolean jj_3_79() {
    if (jj_scan_token(LIMIT)) return true;
    return false;
  }

  final private boolean jj_3_35() {
    if (jj_scan_token(OR)) return true;
    if (jj_3R_32()) return true;
    return false;
  }

  final private boolean jj_3_78() {
    if (jj_scan_token(GROUP)) return true;
    return false;
  }

  final private boolean jj_3_77() {
    if (jj_scan_token(GENERATE)) return true;
    return false;
  }

  final private boolean jj_3R_17() {
    if (jj_scan_token(LIMIT)) return true;
    if (jj_3R_22()) return true;
    return false;
  }

  final private boolean jj_3_76() {
    if (jj_scan_token(FOREACH)) return true;
    return false;
  }

  final private boolean jj_3R_47() {
    if (jj_3R_32()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_35()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3_75() {
    if (jj_scan_token(DUMP)) return true;
    return false;
  }

  final private boolean jj_3_74() {
    if (jj_scan_token(DISTINCT)) return true;
    return false;
  }

  final private boolean jj_3_73() {
    if (jj_scan_token(DESCRIBE)) return true;
    return false;
  }

  final private boolean jj_3_72() {
    if (jj_scan_token(DESC)) return true;
    return false;
  }

  final private boolean jj_3_71() {
    if (jj_scan_token(BY)) return true;
    return false;
  }

  final private boolean jj_3_70() {
    if (jj_scan_token(ASC)) return true;
    return false;
  }

  final private boolean jj_3_69() {
    if (jj_scan_token(AND)) return true;
    return false;
  }

  final private boolean jj_3_68() {
    if (jj_scan_token(ALL)) return true;
    return false;
  }

  final private boolean jj_3_1() {
    if (jj_3R_13()) return true;
    return false;
  }

  final private boolean jj_3_54() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_29()) return true;
    return false;
  }

  final private boolean jj_3R_49() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_68()) {
    jj_scanpos = xsp;
    if (jj_3_69()) {
    jj_scanpos = xsp;
    if (jj_3_70()) {
    jj_scanpos = xsp;
    if (jj_3_71()) {
    jj_scanpos = xsp;
    if (jj_3_72()) {
    jj_scanpos = xsp;
    if (jj_3_73()) {
    jj_scanpos = xsp;
    if (jj_3_74()) {
    jj_scanpos = xsp;
    if (jj_3_75()) {
    jj_scanpos = xsp;
    if (jj_3_76()) {
    jj_scanpos = xsp;
    if (jj_3_77()) {
    jj_scanpos = xsp;
    if (jj_3_78()) {
    jj_scanpos = xsp;
    if (jj_3_79()) {
    jj_scanpos = xsp;
    if (jj_3_80()) {
    jj_scanpos = xsp;
    if (jj_3_81()) {
    jj_scanpos = xsp;
    if (jj_3_82()) {
    jj_scanpos = xsp;
    if (jj_3_83()) {
    jj_scanpos = xsp;
    if (jj_3_84()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_16() {
    if (jj_scan_token(DISTINCT)) return true;
    if (jj_3R_22()) return true;
    return false;
  }

  final private boolean jj_3R_29() {
    if (jj_3R_47()) return true;
    return false;
  }

  final private boolean jj_3R_40() {
    if (jj_3R_29()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_54()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_20() {
    if (jj_scan_token(FILTER)) return true;
    if (jj_3R_22()) return true;
    return false;
  }

  final private boolean jj_3_34() {
    if (jj_scan_token(MAP)) return true;
    if (jj_scan_token(LBRACKET)) return true;
    return false;
  }

  final private boolean jj_3_33() {
    if (jj_scan_token(TUPLE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3_53() {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_39()) return true;
    return false;
  }

  final private boolean jj_3_20() {
    if (jj_3R_27()) return true;
    return false;
  }

  final private boolean jj_3_32() {
    if (jj_scan_token(BAG)) return true;
    if (jj_scan_token(LBRACE)) return true;
    return false;
  }

  final private boolean jj_3R_26() {
    if (jj_3R_27()) return true;
    return false;
  }

  final private boolean jj_3_31() {
    if (jj_3R_31()) return true;
    return false;
  }

  final private boolean jj_3_49() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_29()) return true;
    return false;
  }

  final private boolean jj_3_19() {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_26()) return true;
    return false;
  }

  final private boolean jj_3_52() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_29()) return true;
    return false;
  }

  final private boolean jj_3R_22() {
    if (jj_3R_31()) return true;
    return false;
  }

  final private boolean jj_3_51() {
    if (jj_3R_22()) return true;
    return false;
  }

  final private boolean jj_3_50() {
    if (jj_3R_38()) return true;
    return false;
  }

  final private boolean jj_3R_30() {
    if (jj_3R_22()) return true;
    return false;
  }

  final private boolean jj_3R_37() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_50()) {
    jj_scanpos = xsp;
    if (jj_3_51()) {
    jj_scanpos = xsp;
    if (jj_3_52()) {
    jj_scanpos = xsp;
    if (jj_3_53()) return true;
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_19() {
    if (jj_scan_token(FOREACH)) return true;
    if (jj_3R_22()) return true;
    return false;
  }

  final private boolean jj_3_67() {
    if (jj_3R_45()) return true;
    return false;
  }

  final private boolean jj_3_30() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_30()) return true;
    return false;
  }

  final private boolean jj_3_66() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  final private boolean jj_3R_31() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_66()) {
    jj_scanpos = xsp;
    if (jj_3_67()) return true;
    }
    return false;
  }

  final private boolean jj_3R_24() {
    if (jj_scan_token(DUMP)) return true;
    if (jj_3R_22()) return true;
    return false;
  }

  final private boolean jj_3_48() {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_37()) return true;
    return false;
  }

  final private boolean jj_3R_36() {
    if (jj_3R_37()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_48()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_23() {
    if (jj_scan_token(DESCRIBE)) return true;
    if (jj_3R_22()) return true;
    return false;
  }

  final private boolean jj_3R_43() {
    if (jj_scan_token(QUOTED_STRING)) return true;
    return false;
  }

  final private boolean jj_3_17() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_25()) return true;
    return false;
  }

  final private boolean jj_3_47() {
    if (jj_scan_token(MINUS)) return true;
    if (jj_3R_36()) return true;
    return false;
  }

  final private boolean jj_3_65() {
    if (jj_3R_44()) return true;
    return false;
  }

  final private boolean jj_3_45() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_46()) {
    jj_scanpos = xsp;
    if (jj_3_47()) return true;
    }
    return false;
  }

  final private boolean jj_3_46() {
    if (jj_scan_token(PLUS)) return true;
    if (jj_3R_36()) return true;
    return false;
  }

  final private boolean jj_3_18() {
    if (jj_3R_25()) return true;
    return false;
  }

  final private boolean jj_3R_35() {
    if (jj_3R_36()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_45()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3_64() {
    if (jj_scan_token(MINUS)) return true;
    if (jj_3R_44()) return true;
    return false;
  }

  final private boolean jj_3R_46() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_18()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_45() {
    if (jj_3R_49()) return true;
    return false;
  }

  final private boolean jj_3_27() {
    if (jj_3R_29()) return true;
    return false;
  }

  final private boolean jj_3_26() {
    if (jj_3R_25()) return true;
    return false;
  }

  final private boolean jj_3R_42() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_63()) {
    jj_scanpos = xsp;
    if (jj_3_64()) {
    jj_scanpos = xsp;
    if (jj_3_65()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3_63() {
    if (jj_scan_token(PLUS)) return true;
    if (jj_3R_44()) return true;
    return false;
  }

  final private boolean jj_3_29() {
    if (jj_scan_token(BY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_26()) {
    jj_scanpos = xsp;
    if (jj_3_27()) return true;
    }
    return false;
  }

  final private boolean jj_3_28() {
    if (jj_scan_token(ALL)) return true;
    return false;
  }

  final private boolean jj_3_44() {
    if (jj_scan_token(LE)) return true;
    if (jj_3R_35()) return true;
    return false;
  }

  final private boolean jj_3R_21() {
    if (jj_scan_token(GROUP)) return true;
    if (jj_3R_22()) return true;
    return false;
  }

  final private boolean jj_3R_15() {
    if (jj_scan_token(VALUES)) return true;
    if (jj_3R_46()) return true;
    if (jj_scan_token(AS)) return true;
    return false;
  }

  final private boolean jj_3_43() {
    if (jj_scan_token(GE)) return true;
    if (jj_3R_35()) return true;
    return false;
  }

  final private boolean jj_3_62() {
    if (jj_scan_token(FLOAT_LITERAL)) return true;
    return false;
  }

  final private boolean jj_3_42() {
    if (jj_scan_token(LT)) return true;
    if (jj_3R_35()) return true;
    return false;
  }

  final private boolean jj_3_61() {
    if (jj_scan_token(UNSIGNED_INTEGER_LITERAL)) return true;
    return false;
  }

  final private boolean jj_3R_44() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_61()) {
    jj_scanpos = xsp;
    if (jj_3_62()) return true;
    }
    return false;
  }

  final private boolean jj_3_41() {
    if (jj_scan_token(GT)) return true;
    if (jj_3R_35()) return true;
    return false;
  }

  final private boolean jj_3R_14() {
    if (jj_scan_token(LOAD)) return true;
    if (jj_3R_43()) return true;
    return false;
  }

  final private boolean jj_3_39() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_40()) {
    jj_scanpos = xsp;
    if (jj_3_41()) {
    jj_scanpos = xsp;
    if (jj_3_42()) {
    jj_scanpos = xsp;
    if (jj_3_43()) {
    jj_scanpos = xsp;
    if (jj_3_44()) return true;
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3_40() {
    if (jj_scan_token(EQEQ)) return true;
    if (jj_3R_35()) return true;
    return false;
  }

  final private boolean jj_3_25() {
    if (jj_scan_token(DESC)) return true;
    return false;
  }

  final private boolean jj_3R_34() {
    if (jj_3R_35()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_39()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3_60() {
    if (jj_scan_token(FALSE)) return true;
    return false;
  }

  final private boolean jj_3_24() {
    if (jj_scan_token(ASC)) return true;
    return false;
  }

  final private boolean jj_3_16() {
    if (jj_3R_20()) return true;
    return false;
  }

  final private boolean jj_3_59() {
    if (jj_scan_token(TRUE)) return true;
    return false;
  }

  final private boolean jj_3_15() {
    if (jj_3R_18()) return true;
    return false;
  }

  final private boolean jj_3_23() {
    if (jj_3R_22()) return true;
    return false;
  }

  final private boolean jj_3R_41() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_59()) {
    jj_scanpos = xsp;
    if (jj_3_60()) return true;
    }
    return false;
  }

  final private boolean jj_3_14() {
    if (jj_3R_17()) return true;
    return false;
  }

  final private boolean jj_3_13() {
    if (jj_3R_16()) return true;
    return false;
  }

  final private boolean jj_3_22() {
    if (jj_scan_token(STAR)) return true;
    return false;
  }

  final private boolean jj_3_38() {
    if (jj_3R_34()) return true;
    return false;
  }

  final private boolean jj_3R_28() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_22()) {
    jj_scanpos = xsp;
    if (jj_3_23()) return true;
    }
    return false;
  }

  final private boolean jj_3R_27() {
    if (jj_3R_22()) return true;
    if (jj_scan_token(EQ)) return true;
    return false;
  }

  final private boolean jj_3_58() {
    if (jj_3R_43()) return true;
    return false;
  }

  final private boolean jj_3_57() {
    if (jj_3R_42()) return true;
    return false;
  }

  final private boolean jj_3_37() {
    if (jj_scan_token(NOT)) return true;
    if (jj_3R_33()) return true;
    return false;
  }

  final private boolean jj_3_56() {
    if (jj_3R_41()) return true;
    return false;
  }

  final private boolean jj_3R_33() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_37()) {
    jj_scanpos = xsp;
    if (jj_3_38()) return true;
    }
    return false;
  }

  final private boolean jj_3R_38() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_56()) {
    jj_scanpos = xsp;
    if (jj_3_57()) {
    jj_scanpos = xsp;
    if (jj_3_58()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3_12() {
    if (jj_3R_24()) return true;
    return false;
  }

  final private boolean jj_3_21() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_28()) return true;
    return false;
  }

  final private boolean jj_3_11() {
    if (jj_3R_23()) return true;
    return false;
  }

  final private boolean jj_3_9() {
    if (jj_3R_21()) return true;
    return false;
  }

  final private boolean jj_3_8() {
    if (jj_3R_20()) return true;
    return false;
  }

  final private boolean jj_3_7() {
    if (jj_3R_19()) return true;
    return false;
  }

  final private boolean jj_3_6() {
    if (jj_3R_18()) return true;
    return false;
  }

  final private boolean jj_3R_25() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_40()) return true;
    return false;
  }

  final private boolean jj_3_5() {
    if (jj_3R_17()) return true;
    return false;
  }

  final private boolean jj_3_36() {
    if (jj_scan_token(AND)) return true;
    if (jj_3R_33()) return true;
    return false;
  }

  final private boolean jj_3_4() {
    if (jj_3R_16()) return true;
    return false;
  }

  final private boolean jj_3R_32() {
    if (jj_3R_33()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_36()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3_3() {
    if (jj_3R_15()) return true;
    return false;
  }

  final private boolean jj_3_2() {
    if (jj_3R_14()) return true;
    return false;
  }

  final private boolean jj_3R_18() {
    if (jj_scan_token(ORDER)) return true;
    if (jj_3R_22()) return true;
    return false;
  }

  final private boolean jj_3R_48() {
    return false;
  }

  final private boolean jj_3_10() {
    if (jj_3R_22()) return true;
    if (jj_scan_token(EQ)) return true;
    return false;
  }

  final private boolean jj_3_84() {
    if (jj_scan_token(VALUES)) return true;
    return false;
  }

  final private boolean jj_3R_13() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_10()) {
    jj_scanpos = xsp;
    if (jj_3_11()) {
    jj_scanpos = xsp;
    if (jj_3_12()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3_83() {
    if (jj_scan_token(ORDER)) return true;
    return false;
  }

  public PigletParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[1];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static {
      jj_la1_0();
      jj_la1_1();
      jj_la1_2();
   }
   private static void jj_la1_0() {
      jj_la1_0 = new int[] {0x4000,};
   }
   private static void jj_la1_1() {
      jj_la1_1 = new int[] {0x0,};
   }
   private static void jj_la1_2() {
      jj_la1_2 = new int[] {0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[84];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  public PigletParser(java.io.InputStream stream) {
     this(stream, null);
  }
  public PigletParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new PigletParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 1; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 1; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public PigletParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new PigletParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 1; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 1; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public PigletParser(PigletParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 1; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(PigletParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 1; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration e = jj_expentries.elements(); e.hasMoreElements();) {
        int[] oldentry = (int[])(e.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[85];
    for (int i = 0; i < 85; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 1; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 85; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

  final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 84; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
            case 12: jj_3_13(); break;
            case 13: jj_3_14(); break;
            case 14: jj_3_15(); break;
            case 15: jj_3_16(); break;
            case 16: jj_3_17(); break;
            case 17: jj_3_18(); break;
            case 18: jj_3_19(); break;
            case 19: jj_3_20(); break;
            case 20: jj_3_21(); break;
            case 21: jj_3_22(); break;
            case 22: jj_3_23(); break;
            case 23: jj_3_24(); break;
            case 24: jj_3_25(); break;
            case 25: jj_3_26(); break;
            case 26: jj_3_27(); break;
            case 27: jj_3_28(); break;
            case 28: jj_3_29(); break;
            case 29: jj_3_30(); break;
            case 30: jj_3_31(); break;
            case 31: jj_3_32(); break;
            case 32: jj_3_33(); break;
            case 33: jj_3_34(); break;
            case 34: jj_3_35(); break;
            case 35: jj_3_36(); break;
            case 36: jj_3_37(); break;
            case 37: jj_3_38(); break;
            case 38: jj_3_39(); break;
            case 39: jj_3_40(); break;
            case 40: jj_3_41(); break;
            case 41: jj_3_42(); break;
            case 42: jj_3_43(); break;
            case 43: jj_3_44(); break;
            case 44: jj_3_45(); break;
            case 45: jj_3_46(); break;
            case 46: jj_3_47(); break;
            case 47: jj_3_48(); break;
            case 48: jj_3_49(); break;
            case 49: jj_3_50(); break;
            case 50: jj_3_51(); break;
            case 51: jj_3_52(); break;
            case 52: jj_3_53(); break;
            case 53: jj_3_54(); break;
            case 54: jj_3_55(); break;
            case 55: jj_3_56(); break;
            case 56: jj_3_57(); break;
            case 57: jj_3_58(); break;
            case 58: jj_3_59(); break;
            case 59: jj_3_60(); break;
            case 60: jj_3_61(); break;
            case 61: jj_3_62(); break;
            case 62: jj_3_63(); break;
            case 63: jj_3_64(); break;
            case 64: jj_3_65(); break;
            case 65: jj_3_66(); break;
            case 66: jj_3_67(); break;
            case 67: jj_3_68(); break;
            case 68: jj_3_69(); break;
            case 69: jj_3_70(); break;
            case 70: jj_3_71(); break;
            case 71: jj_3_72(); break;
            case 72: jj_3_73(); break;
            case 73: jj_3_74(); break;
            case 74: jj_3_75(); break;
            case 75: jj_3_76(); break;
            case 76: jj_3_77(); break;
            case 77: jj_3_78(); break;
            case 78: jj_3_79(); break;
            case 79: jj_3_80(); break;
            case 80: jj_3_81(); break;
            case 81: jj_3_82(); break;
            case 82: jj_3_83(); break;
            case 83: jj_3_84(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
