/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.pig;

import org.apache.calcite.adapter.pig.PigDataType;
import org.apache.calcite.adapter.pig.PigRel;
import org.apache.calcite.adapter.pig.PigTableScan;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.AbstractTable;

public class PigTable
extends AbstractTable
implements TranslatableTable {
    private final String filePath;
    private final String[] fieldNames;

    public PigTable(String filePath, String[] fieldNames) {
        this.filePath = filePath;
        this.fieldNames = fieldNames;
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
        for (String fieldName : this.fieldNames) {
            RelDataType relDataType = typeFactory.createSqlType(PigDataType.valueOf((byte)55).getSqlType());
            RelDataType nullableRelDataType = typeFactory.createTypeWithNullability(relDataType, true);
            builder.add(fieldName, nullableRelDataType);
        }
        return builder.build();
    }

    public String getFilePath() {
        return this.filePath;
    }

    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        RelOptCluster cluster = context.getCluster();
        return new PigTableScan(cluster, cluster.traitSetOf((RelTrait)PigRel.CONVENTION), relOptTable);
    }
}

