/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.pig;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.adapter.pig.PigAggregate;
import org.apache.calcite.adapter.pig.PigFilter;
import org.apache.calcite.adapter.pig.PigJoin;
import org.apache.calcite.adapter.pig.PigProject;
import org.apache.calcite.adapter.pig.PigRel;
import org.apache.calcite.adapter.pig.PigTableScan;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.util.ImmutableBitSet;

public class PigRules {
    public static final List<ConverterRule> ALL_PIG_OPT_RULES = ImmutableList.of((Object)((Object)PigFilterRule.access$000()), (Object)((Object)PigTableScanRule.access$100()), (Object)((Object)PigProjectRule.access$200()), (Object)((Object)PigAggregateRule.access$300()), (Object)((Object)PigJoinRule.access$400()));

    private PigRules() {
    }

    private static class PigJoinRule
    extends ConverterRule {
        private static final PigJoinRule INSTANCE = new PigJoinRule();

        private PigJoinRule() {
            super(LogicalJoin.class, (RelTrait)Convention.NONE, (RelTrait)PigRel.CONVENTION, "PigJoinRule");
        }

        public RelNode convert(RelNode rel) {
            LogicalJoin join = (LogicalJoin)rel;
            RelTraitSet traitSet = join.getTraitSet().replace((RelTrait)PigRel.CONVENTION);
            return new PigJoin(join.getCluster(), traitSet, join.getLeft(), join.getRight(), join.getCondition(), join.getJoinType());
        }

        static /* synthetic */ PigJoinRule access$400() {
            return INSTANCE;
        }
    }

    private static class PigAggregateRule
    extends ConverterRule {
        private static final PigAggregateRule INSTANCE = new PigAggregateRule();

        private PigAggregateRule() {
            super(LogicalAggregate.class, (RelTrait)Convention.NONE, (RelTrait)PigRel.CONVENTION, "PigAggregateRule");
        }

        public RelNode convert(RelNode rel) {
            LogicalAggregate agg = (LogicalAggregate)rel;
            RelTraitSet traitSet = agg.getTraitSet().replace((RelTrait)PigRel.CONVENTION);
            return new PigAggregate(agg.getCluster(), traitSet, agg.getInput(), agg.getGroupSet(), (List<ImmutableBitSet>)agg.getGroupSets(), agg.getAggCallList());
        }

        static /* synthetic */ PigAggregateRule access$300() {
            return INSTANCE;
        }
    }

    private static class PigProjectRule
    extends ConverterRule {
        private static final PigProjectRule INSTANCE = new PigProjectRule();

        private PigProjectRule() {
            super(LogicalProject.class, (RelTrait)Convention.NONE, (RelTrait)PigRel.CONVENTION, "PigProjectRule");
        }

        public RelNode convert(RelNode rel) {
            LogicalProject project = (LogicalProject)rel;
            RelTraitSet traitSet = project.getTraitSet().replace((RelTrait)PigRel.CONVENTION);
            return new PigProject(project.getCluster(), traitSet, project.getInput(), project.getProjects(), project.getRowType());
        }

        static /* synthetic */ PigProjectRule access$200() {
            return INSTANCE;
        }
    }

    private static class PigTableScanRule
    extends ConverterRule {
        private static final PigTableScanRule INSTANCE = new PigTableScanRule();

        private PigTableScanRule() {
            super(LogicalTableScan.class, (RelTrait)Convention.NONE, (RelTrait)PigRel.CONVENTION, "PigTableScanRule");
        }

        public RelNode convert(RelNode rel) {
            LogicalTableScan scan = (LogicalTableScan)rel;
            RelTraitSet traitSet = scan.getTraitSet().replace((RelTrait)PigRel.CONVENTION);
            return new PigTableScan(rel.getCluster(), traitSet, scan.getTable());
        }

        static /* synthetic */ PigTableScanRule access$100() {
            return INSTANCE;
        }
    }

    private static class PigFilterRule
    extends ConverterRule {
        private static final PigFilterRule INSTANCE = new PigFilterRule();

        private PigFilterRule() {
            super(LogicalFilter.class, (RelTrait)Convention.NONE, (RelTrait)PigRel.CONVENTION, "PigFilterRule");
        }

        public RelNode convert(RelNode rel) {
            LogicalFilter filter = (LogicalFilter)rel;
            RelTraitSet traitSet = filter.getTraitSet().replace((RelTrait)PigRel.CONVENTION);
            return new PigFilter(rel.getCluster(), traitSet, PigFilterRule.convert((RelNode)filter.getInput(), (RelTrait)PigRel.CONVENTION), filter.getCondition());
        }

        static /* synthetic */ PigFilterRule access$000() {
            return INSTANCE;
        }
    }
}

