/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.pig;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import org.apache.calcite.adapter.pig.PigAggregate;
import org.apache.calcite.adapter.pig.PigFilter;
import org.apache.calcite.adapter.pig.PigJoin;
import org.apache.calcite.adapter.pig.PigRel;
import org.apache.calcite.adapter.pig.PigTableScan;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableBitSet;

public class PigRelFactories {
    public static final Context ALL_PIG_REL_FACTORIES = Contexts.of((Object[])new Object[]{PigTableScanFactory.INSTANCE, PigFilterFactory.INSTANCE, PigAggregateFactory.INSTANCE, PigJoinFactory.INSTANCE});

    private PigRelFactories() {
    }

    public static class PigJoinFactory
    implements RelFactories.JoinFactory {
        public static final PigJoinFactory INSTANCE = new PigJoinFactory();

        public RelNode createJoin(RelNode left, RelNode right, RexNode condition, Set<CorrelationId> variablesSet, JoinRelType joinType, boolean semiJoinDone) {
            return new PigJoin(left.getCluster(), left.getTraitSet(), left, right, condition, joinType);
        }

        public RelNode createJoin(RelNode left, RelNode right, RexNode condition, JoinRelType joinType, Set<String> variablesStopped, boolean semiJoinDone) {
            return new PigJoin(left.getCluster(), left.getTraitSet(), left, right, condition, joinType);
        }
    }

    public static class PigAggregateFactory
    implements RelFactories.AggregateFactory {
        public static final PigAggregateFactory INSTANCE = new PigAggregateFactory();

        public RelNode createAggregate(RelNode input, ImmutableBitSet groupSet, ImmutableList<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
            return new PigAggregate(input.getCluster(), input.getTraitSet(), input, groupSet, (List<ImmutableBitSet>)groupSets, aggCalls);
        }
    }

    public static class PigFilterFactory
    implements RelFactories.FilterFactory {
        public static final PigFilterFactory INSTANCE = new PigFilterFactory();

        public RelNode createFilter(RelNode input, RexNode condition) {
            return new PigFilter(input.getCluster(), input.getTraitSet().replace((RelTrait)PigRel.CONVENTION), input, condition);
        }
    }

    public static class PigTableScanFactory
    implements RelFactories.TableScanFactory {
        public static final PigTableScanFactory INSTANCE = new PigTableScanFactory();

        public RelNode createScan(RelOptCluster cluster, RelOptTable table) {
            return new PigTableScan(cluster, cluster.traitSetOf((RelTrait)PigRel.CONVENTION), table);
        }
    }
}

