/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.mongodb;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoDatabase;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.adapter.mongodb.MongoTable;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;

public class MongoSchema
extends AbstractSchema {
    final MongoDatabase mongoDb;

    MongoSchema(String host, String database, List<MongoCredential> credentialsList, MongoClientOptions options) {
        try {
            MongoClient mongo = new MongoClient(new ServerAddress(host), credentialsList, options);
            this.mongoDb = mongo.getDatabase(database);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    MongoSchema(MongoDatabase mongoDb) {
        this.mongoDb = Objects.requireNonNull(mongoDb, "mongoDb");
    }

    protected Map<String, Table> getTableMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String collectionName : this.mongoDb.listCollectionNames()) {
            builder.put((Object)collectionName, (Object)new MongoTable(collectionName));
        }
        return builder.build();
    }
}

