/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.Consumer;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.util.Util;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;

public class MongoAssertions {
    private MongoAssertions() {
    }

    public static Consumer<ResultSet> checkResultUnordered(String ... lines) {
        return resultSet -> {
            try {
                ImmutableList expectedList = Ordering.natural().immutableSortedCopy(Arrays.asList(lines));
                ArrayList<String> actualList = new ArrayList<String>();
                CalciteAssert.toStringList((ResultSet)resultSet, actualList);
                for (int i = 0; i < actualList.size(); ++i) {
                    String s = (String)actualList.get(i);
                    actualList.set(i, s.replaceAll("\\.0;", ";").replaceAll("\\.0$", ""));
                }
                Collections.sort(actualList);
                Assert.assertThat((Object)Ordering.natural().immutableSortedCopy(actualList), (Matcher)CoreMatchers.equalTo((Object)expectedList));
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static boolean useMongo() {
        return Util.getBooleanProperty((String)"calcite.integrationTest") && Util.getBooleanProperty((String)"calcite.test.mongodb", (boolean)true);
    }

    public static boolean useFongo() {
        return !MongoAssertions.useMongo();
    }

    public static void assumeRealMongoInstance() {
        Assume.assumeTrue((String)"Expect mongo instance", (boolean)MongoAssertions.useMongo());
    }
}

