/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.mongodb;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.calcite.adapter.java.AbstractQueryableTable;
import org.apache.calcite.adapter.mongodb.MongoEnumerator;
import org.apache.calcite.adapter.mongodb.MongoRel;
import org.apache.calcite.adapter.mongodb.MongoSchema;
import org.apache.calcite.adapter.mongodb.MongoTableScan;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.AbstractTableQueryable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Util;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoTable
extends AbstractQueryableTable
implements TranslatableTable {
    private final String collectionName;

    MongoTable(String collectionName) {
        super(Object[].class);
        this.collectionName = collectionName;
    }

    public String toString() {
        return "MongoTable {" + this.collectionName + "}";
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        RelDataType mapType = typeFactory.createMapType(typeFactory.createSqlType(SqlTypeName.VARCHAR), typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.ANY), true));
        return typeFactory.builder().add("_MAP", mapType).build();
    }

    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        return new MongoQueryable(queryProvider, schema, this, tableName);
    }

    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        RelOptCluster cluster = context.getCluster();
        return new MongoTableScan(cluster, cluster.traitSetOf((RelTrait)MongoRel.CONVENTION), relOptTable, this, null);
    }

    private Enumerable<Object> find(MongoDatabase mongoDb, String filterJson, String projectJson, List<Map.Entry<String, Class>> fields) {
        final MongoCollection collection = mongoDb.getCollection(this.collectionName);
        BsonDocument filter = filterJson == null ? null : BsonDocument.parse((String)filterJson);
        BsonDocument project = projectJson == null ? null : BsonDocument.parse((String)projectJson);
        Function1<Document, Object> getter = MongoEnumerator.getter(fields);
        return new AbstractEnumerable<Object>((Bson)filter, (Bson)project, getter){
            final /* synthetic */ Bson val$filter;
            final /* synthetic */ Bson val$project;
            final /* synthetic */ Function1 val$getter;
            {
                this.val$filter = bson;
                this.val$project = bson2;
                this.val$getter = function1;
            }

            public Enumerator<Object> enumerator() {
                FindIterable cursor = collection.find(this.val$filter).projection(this.val$project);
                return new MongoEnumerator((Iterator<Document>)cursor.iterator(), (Function1<Document, Object>)this.val$getter);
            }
        };
    }

    private Enumerable<Object> aggregate(final MongoDatabase mongoDb, List<Map.Entry<String, Class>> fields, final List<String> operations) {
        final ArrayList<BsonDocument> list = new ArrayList<BsonDocument>();
        for (String operation : operations) {
            list.add(BsonDocument.parse((String)operation));
        }
        final Function1<Document, Object> getter = MongoEnumerator.getter(fields);
        return new AbstractEnumerable<Object>(){

            public Enumerator<Object> enumerator() {
                MongoCursor resultIterator;
                try {
                    resultIterator = mongoDb.getCollection(MongoTable.this.collectionName).aggregate(list).iterator();
                }
                catch (Exception e) {
                    throw new RuntimeException("While running MongoDB query " + Util.toString((Iterable)operations, (String)"[", (String)",\n", (String)"]"), e);
                }
                return new MongoEnumerator((Iterator<Document>)resultIterator, (Function1<Document, Object>)getter);
            }
        };
    }

    private static Integer parseIntString(String valueString) {
        return Integer.parseInt(valueString.replaceAll("[^0-9]", ""));
    }

    public static class MongoQueryable<T>
    extends AbstractTableQueryable<T> {
        MongoQueryable(QueryProvider queryProvider, SchemaPlus schema, MongoTable table, String tableName) {
            super(queryProvider, schema, (QueryableTable)table, tableName);
        }

        public Enumerator<T> enumerator() {
            Enumerable enumerable = this.getTable().find(this.getMongoDb(), null, null, null);
            return enumerable.enumerator();
        }

        private MongoDatabase getMongoDb() {
            return ((MongoSchema)((Object)this.schema.unwrap(MongoSchema.class))).mongoDb;
        }

        private MongoTable getTable() {
            return (MongoTable)this.table;
        }

        public Enumerable<Object> aggregate(List<Map.Entry<String, Class>> fields, List<String> operations) {
            return this.getTable().aggregate(this.getMongoDb(), fields, operations);
        }

        public Enumerable<Object> find(String filterJson, String projectJson, List<Map.Entry<String, Class>> fields) {
            return this.getTable().find(this.getMongoDb(), filterJson, projectJson, fields);
        }
    }
}

