/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.mongodb;

import com.github.fakemongo.Fongo;
import com.mongodb.MongoClient;
import com.mongodb.client.MongoDatabase;
import java.util.Objects;
import org.apache.calcite.test.MongoAssertions;
import org.junit.rules.ExternalResource;

class MongoDatabasePolicy
extends ExternalResource {
    private static final String DB_NAME = "test";
    private final MongoDatabase database;
    private final MongoClient client;

    private MongoDatabasePolicy(MongoClient client) {
        this.client = Objects.requireNonNull(client, "client");
        this.database = client.getDatabase(DB_NAME);
    }

    static MongoDatabasePolicy create() {
        MongoClient client;
        if (MongoAssertions.useMongo()) {
            client = new MongoClient();
        } else if (MongoAssertions.useFongo()) {
            client = new Fongo(MongoDatabasePolicy.class.getSimpleName()).getMongo();
        } else {
            throw new UnsupportedOperationException("I can only connect to Mongo or Fongo instances");
        }
        return new MongoDatabasePolicy(client);
    }

    MongoDatabase database() {
        return this.database;
    }

    protected void after() {
        this.client.close();
    }
}

