/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.geode.simple;

import java.util.Iterator;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.SelectResults;

public abstract class GeodeSimpleEnumerator<E>
implements Enumerator<E> {
    private Iterator results;
    private E current;
    private ClientCache clientCache;

    public GeodeSimpleEnumerator(ClientCache clientCache, String regionName) {
        this.clientCache = clientCache;
        QueryService queryService = clientCache.getQueryService();
        String oql = "select * from /" + regionName.trim();
        try {
            this.results = ((SelectResults)queryService.newQuery(oql).execute()).iterator();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.results = null;
        }
    }

    public E current() {
        return this.current;
    }

    public boolean moveNext() {
        if (this.results.hasNext()) {
            this.current = this.convert(this.results.next());
            return true;
        }
        this.current = null;
        return false;
    }

    public void reset() {
        throw new UnsupportedOperationException();
    }

    public void close() {
    }

    public abstract E convert(Object var1);
}

