/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.geode.rel;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.calcite.adapter.geode.rel.GeodeSchema;
import org.apache.calcite.adapter.geode.util.GeodeUtils;
import org.apache.calcite.model.ModelHandler;
import org.apache.calcite.runtime.GeoFunctions;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaFactory;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.geode.cache.GemFireCache;

public class GeodeSchemaFactory
implements SchemaFactory {
    public static final String LOCATOR_HOST = "locatorHost";
    public static final String LOCATOR_PORT = "locatorPort";
    public static final String REGIONS = "regions";
    public static final String PDX_SERIALIZABLE_PACKAGE_PATH = "pdxSerializablePackagePath";
    public static final String ALLOW_SPATIAL_FUNCTIONS = "spatialFunction";
    public static final String COMMA_DELIMITER = ",";

    public synchronized Schema create(SchemaPlus parentSchema, String name, Map<String, Object> operand) {
        Map<String, Object> map = operand;
        String locatorHost = (String)map.get(LOCATOR_HOST);
        int locatorPort = Integer.valueOf((String)map.get(LOCATOR_PORT));
        String[] regionNames = ((String)map.get(REGIONS)).split(COMMA_DELIMITER);
        String pbxSerializablePackagePath = (String)map.get(PDX_SERIALIZABLE_PACKAGE_PATH);
        boolean allowSpatialFunctions = true;
        if (map.containsKey(ALLOW_SPATIAL_FUNCTIONS)) {
            allowSpatialFunctions = Boolean.valueOf((String)map.get(ALLOW_SPATIAL_FUNCTIONS));
        }
        if (allowSpatialFunctions) {
            ModelHandler.addFunctions((SchemaPlus)parentSchema, null, (List)ImmutableList.of(), (String)GeoFunctions.class.getName(), (String)"*", (boolean)true);
        }
        return new GeodeSchema((GemFireCache)GeodeUtils.createClientCache(locatorHost, locatorPort, pbxSerializablePackagePath, true), Arrays.asList(regionNames));
    }
}

