/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.geode.rel;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.adapter.geode.rel.GeodeRel;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;

public class GeodeSort
extends Sort
implements GeodeRel {
    public static final String ASC = "ASC";
    public static final String DESC = "DESC";

    GeodeSort(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RelCollation collation, RexNode fetch) {
        super(cluster, traitSet, input, collation, null, fetch);
        assert (this.getConvention() == GeodeRel.CONVENTION);
        assert (this.getConvention() == input.getConvention());
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        RelOptCost cost = super.computeSelfCost(planner, mq);
        if (this.fetch != null) {
            return cost.multiplyBy(0.05);
        }
        return cost;
    }

    public Sort copy(RelTraitSet traitSet, RelNode input, RelCollation newCollation, RexNode offset, RexNode fetch) {
        return new GeodeSort(this.getCluster(), traitSet, input, this.collation, fetch);
    }

    @Override
    public void implement(GeodeRel.GeodeImplementContext geodeImplementContext) {
        geodeImplementContext.visitChild(this.getInput());
        List sortCollations = this.collation.getFieldCollations();
        if (!sortCollations.isEmpty()) {
            ArrayList<String> orderByFields = new ArrayList<String>();
            for (RelFieldCollation fieldCollation : sortCollations) {
                String name = this.fieldName(fieldCollation.getFieldIndex());
                orderByFields.add(name + " " + this.direction(fieldCollation.getDirection()));
            }
            geodeImplementContext.addOrderByFields(orderByFields);
        }
        if (this.fetch != null) {
            geodeImplementContext.setLimit((Long)((RexLiteral)this.fetch).getValueAs(Long.class));
        }
    }

    private String fieldName(int index) {
        return ((RelDataTypeField)this.getRowType().getFieldList().get(index)).getName();
    }

    private String direction(RelFieldCollation.Direction relDirection) {
        if (relDirection == RelFieldCollation.Direction.DESCENDING) {
            return DESC;
        }
        return ASC;
    }
}

