/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.geode.rel;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.distributed.AbstractLauncher;
import org.apache.geode.distributed.ServerLauncher;
import org.junit.rules.ExternalResource;

public class GeodeEmbeddedPolicy
extends ExternalResource {
    private final ServerLauncher launcher;

    private GeodeEmbeddedPolicy(ServerLauncher launcher) {
        Objects.requireNonNull(launcher, "launcher");
        Preconditions.checkState((!launcher.isRunning() ? 1 : 0) != 0, (Object)"Launcher process is already running");
        this.launcher = launcher;
    }

    protected void before() {
        this.requireStatus(AbstractLauncher.Status.NOT_RESPONDING);
        this.launcher.start();
    }

    protected void after() {
        if (this.launcher.status().getStatus() == AbstractLauncher.Status.ONLINE) {
            CacheFactory.getAnyInstance().close();
        }
        Path pidFile = Paths.get(this.launcher.getWorkingDirectory(), new String[0]).resolve("vf.gf.server.pid");
        this.launcher.stop();
        if (Files.exists(pidFile, new LinkOption[0])) {
            try {
                Files.delete(pidFile);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    GeodeEmbeddedPolicy share() {
        return new RefCountPolicy(this);
    }

    Cache cache() {
        this.requireStatus(AbstractLauncher.Status.ONLINE);
        return CacheFactory.getAnyInstance();
    }

    private void requireStatus(AbstractLauncher.Status expected) {
        AbstractLauncher.Status current = this.launcher.status().getStatus();
        Preconditions.checkState((current == expected ? 1 : 0) != 0, (String)"Expected state %s but got %s", (Object[])new Object[]{expected, current});
    }

    static GeodeEmbeddedPolicy create() {
        ServerLauncher launcher = new ServerLauncher.Builder().setMemberName("fake-geode").set("log-file", "").set("log-level", "severe").set("bind-address", "127.0.0.1").setServerPort(Integer.valueOf(0)).setPdxPersistent(false).setPdxReadSerialized(true).build();
        return new GeodeEmbeddedPolicy(launcher);
    }

    private static class RefCountPolicy
    extends GeodeEmbeddedPolicy {
        private final AtomicInteger refCount;
        private final GeodeEmbeddedPolicy policy;

        RefCountPolicy(GeodeEmbeddedPolicy policy) {
            super(Objects.requireNonNull(policy, "policy").launcher);
            this.policy = policy;
            this.refCount = new AtomicInteger();
        }

        @Override
        GeodeEmbeddedPolicy share() {
            return this;
        }

        @Override
        public synchronized void before() {
            if (this.refCount.getAndIncrement() == 0) {
                this.policy.before();
            }
        }

        @Override
        protected void after() {
            if (this.refCount.decrementAndGet() == 0) {
                this.policy.after();
            }
        }
    }
}

