/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.geode.rel;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.geode.cache.Region;
import org.apache.geode.pdx.PdxInstance;
import org.apache.geode.pdx.PdxInstanceFactory;

class JsonLoader {
    private static final String ROOT_PACKATE = "org.apache.calcite.adapter.geode";
    private final String rootPackage;
    private final Region region;
    private final ObjectMapper mapper;

    JsonLoader(Region<?, ?> region) {
        this.region = Objects.requireNonNull(region, "region");
        this.rootPackage = ROOT_PACKATE;
        this.mapper = new ObjectMapper();
    }

    private void load(Reader reader) throws IOException {
        Objects.requireNonNull(reader, "reader");
        try (BufferedReader br = new BufferedReader(reader);){
            String line;
            ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
            while ((line = br.readLine()) != null) {
                Map jsonMap = (Map)this.mapper.readValue(line, Map.class);
                mapList.add(jsonMap);
            }
            this.loadMapList(mapList);
        }
    }

    void loadMapList(List<Map<String, Object>> mapList) {
        int key = 0;
        for (Map<String, Object> jsonMap : mapList) {
            PdxInstance pdxInstance = this.mapToPdx(this.rootPackage, jsonMap);
            this.region.put((Object)key++, (Object)pdxInstance);
        }
    }

    void loadClasspathResource(String location) throws IOException {
        Objects.requireNonNull(location, "location");
        InputStream is = this.getClass().getResourceAsStream(location);
        if (is == null) {
            throw new IllegalArgumentException("Resource " + location + " not found in the classpath");
        }
        this.load(new InputStreamReader(is, StandardCharsets.UTF_8));
    }

    private PdxInstance mapToPdx(String packageName, Map<String, Object> map) {
        PdxInstanceFactory pdxBuilder = this.region.getRegionService().createPdxInstanceFactory(packageName);
        for (String name : map.keySet()) {
            Object value = map.get(name);
            if (value instanceof Map) {
                pdxBuilder.writeObject(name, (Object)this.mapToPdx(packageName + "." + name, (Map)value));
                continue;
            }
            pdxBuilder.writeObject(name, value);
        }
        return pdxBuilder.create();
    }
}

