/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.geode.simple;

import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.geode.simple.GeodeSimpleEnumerator;
import org.apache.calcite.adapter.geode.util.GeodeUtils;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.geode.cache.client.ClientCache;

public class GeodeSimpleScannableTable
extends AbstractTable
implements ScannableTable {
    private final RelDataType relDataType;
    private String regionName;
    private ClientCache clientCache;

    public GeodeSimpleScannableTable(String regionName, RelDataType relDataType, ClientCache clientCache) {
        this.regionName = regionName;
        this.clientCache = clientCache;
        this.relDataType = relDataType;
    }

    public String toString() {
        return "GeodeSimpleScannableTable";
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return this.relDataType;
    }

    public Enumerable<Object[]> scan(DataContext root) {
        return new AbstractEnumerable<Object[]>(){

            public Enumerator<Object[]> enumerator() {
                return new GeodeSimpleEnumerator<Object[]>(GeodeSimpleScannableTable.this.clientCache, GeodeSimpleScannableTable.this.regionName){

                    @Override
                    public Object[] convert(Object obj) {
                        Object values = GeodeUtils.convertToRowValues(GeodeSimpleScannableTable.this.relDataType.getFieldList(), obj);
                        if (values instanceof Object[]) {
                            return (Object[])values;
                        }
                        return new Object[]{values};
                    }
                };
            }
        };
    }
}

