/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.geode.rel;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.adapter.geode.rel.GeodeTable;
import org.apache.calcite.adapter.geode.util.GeodeUtils;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.Region;

public class GeodeSchema
extends AbstractSchema {
    final GemFireCache cache;
    private final List<String> regionNames;
    private ImmutableMap<String, Table> tableMap;

    GeodeSchema(String locatorHost, int locatorPort, Iterable<String> regionNames, String pdxAutoSerializerPackageExp) {
        this((GemFireCache)GeodeUtils.createClientCache(locatorHost, locatorPort, pdxAutoSerializerPackageExp, true), regionNames);
    }

    GeodeSchema(GemFireCache cache, Iterable<String> regionNames) {
        this.cache = Objects.requireNonNull(cache, "clientCache");
        this.regionNames = ImmutableList.copyOf(Objects.requireNonNull(regionNames, "regionNames"));
    }

    protected Map<String, Table> getTableMap() {
        if (this.tableMap == null) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (String regionName : this.regionNames) {
                Region region = GeodeUtils.createRegion(this.cache, regionName);
                GeodeTable table = new GeodeTable(region);
                builder.put((Object)regionName, (Object)table);
            }
            this.tableMap = builder.build();
        }
        return this.tableMap;
    }
}

