/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.geode.rel;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.geode.rel.GeodeRel;
import org.apache.calcite.adapter.geode.rel.GeodeRules;
import org.apache.calcite.adapter.geode.rel.GeodeTable;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterImpl;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.Pair;

public class GeodeToEnumerableConverter
extends ConverterImpl
implements EnumerableRel {
    private static final Method GEODE_QUERY_METHOD = Types.lookupMethod(GeodeTable.GeodeQueryable.class, (String)"query", (Class[])new Class[]{List.class, List.class, List.class, List.class, List.class, List.class, Long.class});

    protected GeodeToEnumerableConverter(RelOptCluster cluster, RelTraitSet traitSet, RelNode input) {
        super(cluster, (RelTraitDef)ConventionTraitDef.INSTANCE, traitSet, input);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new GeodeToEnumerableConverter(this.getCluster(), traitSet, (RelNode)GeodeToEnumerableConverter.sole(inputs));
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.1);
    }

    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        GeodeRel.GeodeImplementContext geodeImplementContext = new GeodeRel.GeodeImplementContext();
        ((GeodeRel)this.getInput()).implement(geodeImplementContext);
        final RelDataType rowType = this.getRowType();
        final PhysType physType = PhysTypeImpl.of((JavaTypeFactory)implementor.getTypeFactory(), (RelDataType)rowType, (JavaRowFormat)pref.prefer(JavaRowFormat.ARRAY));
        AbstractList<Class> physFieldClasses = new AbstractList<Class>(){

            @Override
            public Class get(int index) {
                return physType.fieldClass(index);
            }

            @Override
            public int size() {
                return rowType.getFieldCount();
            }
        };
        BlockBuilder blockBuilder = new BlockBuilder().append((Expression)Expressions.call((Expression)geodeImplementContext.table.getExpression(GeodeTable.GeodeQueryable.class), (Method)GEODE_QUERY_METHOD, (Expression[])new Expression[]{GeodeToEnumerableConverter.constantArrayList(Pair.zip(GeodeRules.geodeFieldNames(rowType), (List)physFieldClasses), Pair.class), GeodeToEnumerableConverter.constantArrayList(GeodeToEnumerableConverter.toListMapPairs(geodeImplementContext.selectFields), Pair.class), GeodeToEnumerableConverter.constantArrayList(GeodeToEnumerableConverter.toListMapPairs(geodeImplementContext.oqlAggregateFunctions), Pair.class), GeodeToEnumerableConverter.constantArrayList(geodeImplementContext.groupByFields, String.class), GeodeToEnumerableConverter.constantArrayList(geodeImplementContext.whereClause, String.class), GeodeToEnumerableConverter.constantArrayList(geodeImplementContext.orderByFields, String.class), Expressions.constant((Object)geodeImplementContext.limitValue)}));
        return implementor.result(physType, blockBuilder.toBlock());
    }

    private static List<Map.Entry<String, String>> toListMapPairs(Map<String, String> map) {
        ArrayList<Map.Entry<String, String>> selectList = new ArrayList<Map.Entry<String, String>>();
        for (Map.Entry entry : Pair.zip(map.keySet(), map.values())) {
            selectList.add(entry);
        }
        return selectList;
    }

    private static <T> MethodCallExpression constantArrayList(List<T> values, Class clazz) {
        return Expressions.call((Method)BuiltInMethod.ARRAYS_AS_LIST.method, (Expression[])new Expression[]{Expressions.newArrayInit((Type)clazz, GeodeToEnumerableConverter.constantList(values))});
    }

    private static <T> List<Expression> constantList(List<T> values) {
        return Lists.transform(values, Expressions::constant);
    }
}

