/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.geode.simple;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleJdbcExample {
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)SimpleJdbcExample.class.getName());

    private SimpleJdbcExample() {
    }

    public static void main(String[] args) throws Exception {
        Properties info = new Properties();
        String model = "inline:{\n  version: '1.0',\n  schemas: [\n     {\n       type: 'custom',\n       name: 'TEST',\n       factory: 'org.apache.calcite.adapter.geode.simple.GeodeSimpleSchemaFactory',\n       operand: {\n         locatorHost: 'localhost',\n         locatorPort: '10334',\n         regions: 'BookMaster',\n         pdxSerializablePackagePath: 'org.apache.calcite.adapter.geode.domain.*'\n       }\n     }\n  ]\n}";
        info.put("model", "inline:{\n  version: '1.0',\n  schemas: [\n     {\n       type: 'custom',\n       name: 'TEST',\n       factory: 'org.apache.calcite.adapter.geode.simple.GeodeSimpleSchemaFactory',\n       operand: {\n         locatorHost: 'localhost',\n         locatorPort: '10334',\n         regions: 'BookMaster',\n         pdxSerializablePackagePath: 'org.apache.calcite.adapter.geode.domain.*'\n       }\n     }\n  ]\n}");
        Class.forName("org.apache.calcite.jdbc.Driver");
        Connection connection = DriverManager.getConnection("jdbc:calcite:", info);
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT * FROM \"TEST\".\"BookMaster\"");
        StringBuilder buf = new StringBuilder();
        while (resultSet.next()) {
            int columnCount = resultSet.getMetaData().getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                buf.append(i > 1 ? "; " : "").append(resultSet.getMetaData().getColumnLabel(i)).append("=").append(resultSet.getObject(i));
            }
            LOGGER.info("Entry: " + buf.toString());
            buf.setLength(0);
        }
        resultSet.close();
        statement.close();
        connection.close();
    }
}

