/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.geode.rel;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.apache.calcite.adapter.geode.rel.GeodeAggregate;
import org.apache.calcite.adapter.geode.rel.GeodeFilter;
import org.apache.calcite.adapter.geode.rel.GeodeProject;
import org.apache.calcite.adapter.geode.rel.GeodeRel;
import org.apache.calcite.adapter.geode.rel.GeodeSort;
import org.apache.calcite.adapter.geode.rel.GeodeTableScan;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.ImmutableBitSet;

public class GeodeRules {
    static final RelOptRule[] RULES = new RelOptRule[]{GeodeSortLimitRule.access$000(), GeodeFilterRule.access$100(), GeodeProjectRule.access$200(), GeodeAggregateRule.access$300()};

    private GeodeRules() {
    }

    static String isItem(RexCall call) {
        if (call.getOperator() != SqlStdOperatorTable.ITEM) {
            return null;
        }
        RexNode op0 = (RexNode)call.getOperands().get(0);
        RexNode op1 = (RexNode)call.getOperands().get(1);
        if (op0 instanceof RexInputRef && ((RexInputRef)op0).getIndex() == 0 && op1 instanceof RexLiteral && ((RexLiteral)op1).getValue2() instanceof String) {
            return (String)((RexLiteral)op1).getValue2();
        }
        return null;
    }

    static List<String> geodeFieldNames(final RelDataType rowType) {
        AbstractList<String> fieldNames = new AbstractList<String>(){

            @Override
            public String get(int index) {
                return ((RelDataTypeField)rowType.getFieldList().get(index)).getName();
            }

            @Override
            public int size() {
                return rowType.getFieldCount();
            }
        };
        return SqlValidatorUtil.uniquify((List)fieldNames, (boolean)true);
    }

    static abstract class GeodeConverterRule
    extends ConverterRule {
        protected final Convention out = GeodeRel.CONVENTION;

        GeodeConverterRule(Class<? extends RelNode> clazz, String description) {
            super(clazz, (RelTrait)Convention.NONE, (RelTrait)GeodeRel.CONVENTION, description);
        }
    }

    private static class GeodeFilterRule
    extends RelOptRule {
        private static final GeodeFilterRule INSTANCE = new GeodeFilterRule();

        private GeodeFilterRule() {
            super(GeodeFilterRule.operand(LogicalFilter.class, (RelOptRuleOperand)GeodeFilterRule.operand(GeodeTableScan.class, (RelOptRuleOperandChildren)GeodeFilterRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), "GeodeFilterRule");
        }

        public boolean matches(RelOptRuleCall call) {
            LogicalFilter filter = (LogicalFilter)call.rel(0);
            RexNode condition = filter.getCondition();
            List<String> fieldNames = GeodeRules.geodeFieldNames(filter.getInput().getRowType());
            List disjunctions = RelOptUtil.disjunctions((RexNode)condition);
            if (disjunctions.size() != 1) {
                return true;
            }
            condition = (RexNode)disjunctions.get(0);
            for (RexNode predicate : RelOptUtil.conjunctions((RexNode)condition)) {
                if (this.isEqualityOnKey(predicate, fieldNames)) continue;
                return false;
            }
            return true;
        }

        private boolean isEqualityOnKey(RexNode node, List<String> fieldNames) {
            RexNode right;
            RexCall call = (RexCall)node;
            RexNode left = (RexNode)call.operands.get(0);
            if (this.checkConditionContainsInputRefOrLiterals(left, right = (RexNode)call.operands.get(1), fieldNames)) {
                return true;
            }
            return this.checkConditionContainsInputRefOrLiterals(right, left, fieldNames);
        }

        private boolean checkConditionContainsInputRefOrLiterals(RexNode left, RexNode right, List<String> fieldNames) {
            if (left.isA(SqlKind.CAST)) {
                left = (RexNode)((RexCall)left).getOperands().get(0);
            }
            if (right.isA(SqlKind.CAST)) {
                right = (RexNode)((RexCall)right).getOperands().get(0);
            }
            if (left.isA(SqlKind.INPUT_REF) && right.isA(SqlKind.LITERAL)) {
                RexInputRef left1 = (RexInputRef)left;
                String name = fieldNames.get(left1.getIndex());
                return name != null;
            }
            if (left.isA(SqlKind.INPUT_REF) && right.isA(SqlKind.INPUT_REF)) {
                RexInputRef left1 = (RexInputRef)left;
                String leftName = fieldNames.get(left1.getIndex());
                RexInputRef right1 = (RexInputRef)right;
                String rightName = fieldNames.get(right1.getIndex());
                return leftName != null && rightName != null;
            }
            if (left.isA(SqlKind.OTHER_FUNCTION) && right.isA(SqlKind.LITERAL)) {
                return ((RexCall)left).getOperator() == SqlStdOperatorTable.ITEM;
            }
            return false;
        }

        public void onMatch(RelOptRuleCall call) {
            LogicalFilter filter = (LogicalFilter)call.rel(0);
            GeodeTableScan scan = (GeodeTableScan)call.rel(1);
            if (filter.getTraitSet().contains((RelTrait)Convention.NONE)) {
                RelNode converted = this.convert(filter, scan);
                call.transformTo(converted);
            }
        }

        private RelNode convert(LogicalFilter filter, GeodeTableScan scan) {
            RelTraitSet traitSet = filter.getTraitSet().replace((RelTrait)GeodeRel.CONVENTION);
            return new GeodeFilter(filter.getCluster(), traitSet, GeodeFilterRule.convert((RelNode)filter.getInput(), (RelTrait)GeodeRel.CONVENTION), filter.getCondition());
        }

        static /* synthetic */ GeodeFilterRule access$100() {
            return INSTANCE;
        }
    }

    private static class GeodeSortLimitRule
    extends RelOptRule {
        private static final GeodeSortLimitRule INSTANCE = new GeodeSortLimitRule(sort -> sort.offset == null);

        GeodeSortLimitRule(Predicate<Sort> predicate) {
            super(GeodeSortLimitRule.operandJ(Sort.class, null, predicate, (RelOptRuleOperandChildren)GeodeSortLimitRule.any()), "GeodeSortLimitRule");
        }

        public void onMatch(RelOptRuleCall call) {
            Sort sort = (Sort)call.rel(0);
            RelTraitSet traitSet = sort.getTraitSet().replace((RelTrait)GeodeRel.CONVENTION).replace((RelTrait)sort.getCollation());
            GeodeSort geodeSort = new GeodeSort(sort.getCluster(), traitSet, GeodeSortLimitRule.convert((RelNode)sort.getInput(), (RelTraitSet)traitSet.replace((RelTrait)RelCollations.EMPTY)), sort.getCollation(), sort.fetch);
            call.transformTo((RelNode)geodeSort);
        }

        static /* synthetic */ GeodeSortLimitRule access$000() {
            return INSTANCE;
        }
    }

    private static class GeodeAggregateRule
    extends GeodeConverterRule {
        private static final GeodeAggregateRule INSTANCE = new GeodeAggregateRule();

        GeodeAggregateRule() {
            super(LogicalAggregate.class, "GeodeAggregateRule");
        }

        public RelNode convert(RelNode rel) {
            LogicalAggregate aggregate = (LogicalAggregate)rel;
            RelTraitSet traitSet = aggregate.getTraitSet().replace((RelTrait)this.out);
            return new GeodeAggregate(aggregate.getCluster(), traitSet, GeodeAggregateRule.convert((RelNode)aggregate.getInput(), (RelTraitSet)traitSet.simplify()), aggregate.indicator, aggregate.getGroupSet(), (List<ImmutableBitSet>)aggregate.getGroupSets(), aggregate.getAggCallList());
        }

        static /* synthetic */ GeodeAggregateRule access$300() {
            return INSTANCE;
        }
    }

    private static class GeodeProjectRule
    extends GeodeConverterRule {
        private static final GeodeProjectRule INSTANCE = new GeodeProjectRule();

        private GeodeProjectRule() {
            super(LogicalProject.class, "GeodeProjectRule");
        }

        public boolean matches(RelOptRuleCall call) {
            LogicalProject project = (LogicalProject)call.rel(0);
            for (RexNode e : project.getProjects()) {
                if (e.getType().getSqlTypeName() != SqlTypeName.GEOMETRY) continue;
                return false;
            }
            return true;
        }

        public RelNode convert(RelNode rel) {
            LogicalProject project = (LogicalProject)rel;
            RelTraitSet traitSet = project.getTraitSet().replace((RelTrait)this.out);
            return new GeodeProject(project.getCluster(), traitSet, GeodeProjectRule.convert((RelNode)project.getInput(), (RelTrait)this.out), project.getProjects(), project.getRowType());
        }

        static /* synthetic */ GeodeProjectRule access$200() {
            return INSTANCE;
        }
    }

    static class RexToGeodeTranslator
    extends RexVisitorImpl<String> {
        private final List<String> inFields;

        protected RexToGeodeTranslator(List<String> inFields) {
            super(true);
            this.inFields = inFields;
        }

        public String visitInputRef(RexInputRef inputRef) {
            return this.inFields.get(inputRef.getIndex());
        }

        public String visitCall(RexCall call) {
            RexNode op1;
            List<String> strings = this.visitList((List<RexNode>)call.operands);
            if (call.getOperator() == SqlStdOperatorTable.ITEM && (op1 = (RexNode)call.getOperands().get(1)) instanceof RexLiteral) {
                if (op1.getType().getSqlTypeName() == SqlTypeName.INTEGER) {
                    return this.stripQuotes(strings.get(0)) + "[" + ((RexLiteral)op1).getValue2() + "]";
                }
                if (op1.getType().getSqlTypeName() == SqlTypeName.CHAR) {
                    return this.stripQuotes(strings.get(0)) + "." + ((RexLiteral)op1).getValue2();
                }
            }
            return (String)super.visitCall(call);
        }

        private String stripQuotes(String s) {
            return s.startsWith("'") && s.endsWith("'") ? s.substring(1, s.length() - 1) : s;
        }

        List<String> visitList(List<RexNode> list) {
            ArrayList<String> strings = new ArrayList<String>();
            for (RexNode node : list) {
                strings.add((String)node.accept((RexVisitor)this));
            }
            return strings;
        }
    }
}

