/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.geode.rel;

import java.util.LinkedHashMap;
import java.util.List;
import org.apache.calcite.adapter.geode.rel.GeodeRel;
import org.apache.calcite.adapter.geode.rel.GeodeRules;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.util.Pair;

public class GeodeProject
extends Project
implements GeodeRel {
    GeodeProject(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, List<? extends RexNode> projects, RelDataType rowType) {
        super(cluster, traitSet, input, projects, rowType);
        assert (this.getConvention() == GeodeRel.CONVENTION);
        assert (this.getConvention() == input.getConvention());
    }

    public Project copy(RelTraitSet traitSet, RelNode input, List<RexNode> projects, RelDataType rowType) {
        return new GeodeProject(this.getCluster(), traitSet, input, projects, rowType);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.1);
    }

    @Override
    public void implement(GeodeRel.GeodeImplementContext geodeImplementContext) {
        geodeImplementContext.visitChild(this.getInput());
        GeodeRules.RexToGeodeTranslator translator = new GeodeRules.RexToGeodeTranslator(GeodeRules.geodeFieldNames(this.getInput().getRowType()));
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        for (Pair pair : this.getNamedProjects()) {
            String name = (String)pair.right;
            String originalName = (String)((RexNode)pair.left).accept((RexVisitor)translator);
            fields.put(originalName, name);
        }
        geodeImplementContext.addSelectFields(fields);
    }
}

