/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.geode.rel;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.calcite.adapter.geode.rel.AbstractGeodeTest;
import org.apache.calcite.adapter.geode.rel.GeodeAssertions;
import org.apache.calcite.adapter.geode.rel.GeodeSchema;
import org.apache.calcite.adapter.geode.rel.JsonLoader;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.test.CalciteAssert;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.Region;
import org.junit.BeforeClass;
import org.junit.Test;

public class GeodeAllDataTypesTest
extends AbstractGeodeTest {
    @BeforeClass
    public static void setUp() {
        Cache cache = POLICY.cache();
        Region region = cache.createRegionFactory().create("allDataTypesRegion");
        List<Map<String, Object>> mapList = GeodeAllDataTypesTest.createMapList();
        new JsonLoader(region).loadMapList(mapList);
    }

    private static List<Map<String, Object>> createMapList() {
        return ImmutableList.of((Object)ImmutableMap.builder().put((Object)"booleanValue", (Object)true).put((Object)"dateValue", (Object)Date.valueOf("2018-02-03")).put((Object)"timeValue", (Object)Time.valueOf("02:22:23")).put((Object)"timestampValue", (Object)Timestamp.valueOf("2018-02-03 02:22:33")).put((Object)"stringValue", (Object)"abc").put((Object)"floatValue", (Object)1.5678).build(), (Object)ImmutableMap.builder().put((Object)"booleanValue", (Object)false).put((Object)"dateValue", (Object)Date.valueOf("2018-02-04")).put((Object)"timeValue", (Object)Time.valueOf("03:22:23")).put((Object)"timestampValue", (Object)Timestamp.valueOf("2018-02-04 04:22:33")).put((Object)"stringValue", (Object)"def").put((Object)"floatValue", (Object)3.5678).build(), (Object)ImmutableMap.builder().put((Object)"booleanValue", (Object)true).put((Object)"dateValue", (Object)Date.valueOf("2018-02-05")).put((Object)"timeValue", (Object)Time.valueOf("04:22:23")).put((Object)"timestampValue", (Object)Timestamp.valueOf("2018-02-05 04:22:33")).put((Object)"stringValue", (Object)"ghi").put((Object)"floatValue", (Object)8.9267).build());
    }

    private CalciteAssert.ConnectionFactory newConnectionFactory() {
        return new CalciteAssert.ConnectionFactory(){

            public Connection createConnection() throws SQLException {
                Connection connection = DriverManager.getConnection("jdbc:calcite:lex=JAVA");
                SchemaPlus root = connection.unwrap(CalciteConnection.class).getRootSchema();
                root.add("geode", (Schema)new GeodeSchema((GemFireCache)AbstractGeodeTest.POLICY.cache(), Collections.singleton("allDataTypesRegion")));
                return connection;
            }
        };
    }

    private CalciteAssert.AssertThat calciteAssert() {
        return CalciteAssert.that().with(this.newConnectionFactory());
    }

    @Test
    public void testSqlSingleBooleanWhereFilter() {
        this.calciteAssert().query("SELECT booleanValue as booleanValue FROM geode.allDataTypesRegion WHERE booleanValue = true").returnsCount(2).queryContains(GeodeAssertions.query("SELECT booleanValue AS booleanValue FROM /allDataTypesRegion WHERE booleanValue = true"));
    }

    @Test
    public void testSqlMultipleBooleanWhereFilter() {
        this.calciteAssert().query("SELECT booleanValue as booleanValue FROM geode.allDataTypesRegion WHERE booleanValue = true OR booleanValue = false").returnsCount(3).queryContains(GeodeAssertions.query("SELECT booleanValue AS booleanValue FROM /allDataTypesRegion WHERE booleanValue IN SET(true, false)"));
    }

    @Test
    public void testSqlWhereWithMultipleOrForLiteralFields() {
        this.calciteAssert().query("SELECT stringValue FROM geode.allDataTypesRegion WHERE (stringValue = 'abc' OR stringValue = 'def') OR (floatValue = 1.5678 OR floatValue = null) OR (booleanValue = true OR booleanValue = false OR booleanValue = null)").returnsCount(3).queryContains(GeodeAssertions.query("SELECT stringValue AS stringValue FROM /allDataTypesRegion WHERE stringValue IN SET('abc', 'def') OR floatValue IN SET(1.5678, null) OR booleanValue IN SET(true, false, null)"));
    }

    @Test
    public void testSqlSingleDateWhereFilter() {
        this.calciteAssert().query("SELECT dateValue\nFROM geode.allDataTypesRegion\nWHERE dateValue = DATE '2018-02-03'").returnsCount(1).queryContains(GeodeAssertions.query("SELECT dateValue AS dateValue FROM /allDataTypesRegion WHERE dateValue = DATE '2018-02-03'"));
        this.calciteAssert().query("SELECT dateValue\nFROM geode.allDataTypesRegion\nWHERE dateValue > DATE '2018-02-03'").returnsCount(2).queryContains(GeodeAssertions.query("SELECT dateValue AS dateValue FROM /allDataTypesRegion WHERE dateValue > DATE '2018-02-03'"));
        this.calciteAssert().query("SELECT dateValue\nFROM geode.allDataTypesRegion\nWHERE dateValue < DATE '2018-02-03'").returnsCount(0).queryContains(GeodeAssertions.query("SELECT dateValue AS dateValue FROM /allDataTypesRegion WHERE dateValue < DATE '2018-02-03'"));
    }

    @Test
    public void testSqlMultipleDateWhereFilter() {
        this.calciteAssert().query("SELECT dateValue\nFROM geode.allDataTypesRegion\nWHERE dateValue = DATE '2018-02-03'\n  OR dateValue = DATE '2018-02-04'").returnsCount(2).queryContains(GeodeAssertions.query("SELECT dateValue AS dateValue FROM /allDataTypesRegion WHERE dateValue IN SET(DATE '2018-02-03', DATE '2018-02-04')"));
    }

    @Test
    public void testSqlSingleTimeWhereFilter() {
        this.calciteAssert().query("SELECT timeValue\nFROM geode.allDataTypesRegion\nWHERE timeValue = TIME '02:22:23'").returnsCount(1).queryContains(GeodeAssertions.query("SELECT timeValue AS timeValue FROM /allDataTypesRegion WHERE timeValue = TIME '02:22:23'"));
        this.calciteAssert().query("SELECT timeValue\nFROM geode.allDataTypesRegion\nWHERE timeValue > TIME '02:22:23'").returnsCount(2).queryContains(GeodeAssertions.query("SELECT timeValue AS timeValue FROM /allDataTypesRegion WHERE timeValue > TIME '02:22:23'"));
        this.calciteAssert().query("SELECT timeValue\nFROM geode.allDataTypesRegion\nWHERE timeValue < TIME '02:22:23'").returnsCount(0).queryContains(GeodeAssertions.query("SELECT timeValue AS timeValue FROM /allDataTypesRegion WHERE timeValue < TIME '02:22:23'"));
    }

    @Test
    public void testSqlMultipleTimeWhereFilter() {
        this.calciteAssert().query("SELECT timeValue\nFROM geode.allDataTypesRegion\nWHERE timeValue = TIME '02:22:23'\n  OR timeValue = TIME '03:22:23'").returnsCount(2).queryContains(GeodeAssertions.query("SELECT timeValue AS timeValue FROM /allDataTypesRegion WHERE timeValue IN SET(TIME '02:22:23', TIME '03:22:23')"));
    }

    @Test
    public void testSqlSingleTimestampWhereFilter() {
        this.calciteAssert().query("SELECT timestampValue\nFROM geode.allDataTypesRegion\nWHERE timestampValue = TIMESTAMP '2018-02-03 02:22:33'").returnsCount(1).queryContains(GeodeAssertions.query("SELECT timestampValue AS timestampValue FROM /allDataTypesRegion WHERE timestampValue = TIMESTAMP '2018-02-03 02:22:33'"));
        this.calciteAssert().query("SELECT timestampValue\nFROM geode.allDataTypesRegion\nWHERE timestampValue > TIMESTAMP '2018-02-03 02:22:33'").returnsCount(2).queryContains(GeodeAssertions.query("SELECT timestampValue AS timestampValue FROM /allDataTypesRegion WHERE timestampValue > TIMESTAMP '2018-02-03 02:22:33'"));
        this.calciteAssert().query("SELECT timestampValue\nFROM geode.allDataTypesRegion\nWHERE timestampValue < TIMESTAMP '2018-02-03 02:22:33'").returnsCount(0).queryContains(GeodeAssertions.query("SELECT timestampValue AS timestampValue FROM /allDataTypesRegion WHERE timestampValue < TIMESTAMP '2018-02-03 02:22:33'"));
    }

    @Test
    public void testSqlMultipleTimestampWhereFilter() {
        this.calciteAssert().query("SELECT timestampValue\nFROM geode.allDataTypesRegion\nWHERE timestampValue = TIMESTAMP '2018-02-03 02:22:33'\n  OR timestampValue = TIMESTAMP '2018-02-05 04:22:33'").returnsCount(2).queryContains(GeodeAssertions.query("SELECT timestampValue AS timestampValue FROM /allDataTypesRegion WHERE timestampValue IN SET(TIMESTAMP '2018-02-03 02:22:33', TIMESTAMP '2018-02-05 04:22:33')"));
    }

    @Test
    public void testSqlWhereWithMultipleOrForAllFields() {
        this.calciteAssert().query("SELECT stringValue FROM geode.allDataTypesRegion WHERE (stringValue = 'abc' OR stringValue = 'def') OR (floatValue = 1.5678 OR floatValue = null) OR (dateValue = DATE '2018-02-05' OR dateValue = DATE '2018-02-06' ) OR (timeValue = TIME '03:22:23' OR timeValue = TIME '07:22:23') OR (timestampValue = TIMESTAMP '2018-02-05 04:22:33' OR timestampValue = TIMESTAMP '2017-02-05 04:22:33') OR (booleanValue = true OR booleanValue = false OR booleanValue = null)").returnsCount(3).queryContains(GeodeAssertions.query("SELECT stringValue AS stringValue FROM /allDataTypesRegion WHERE stringValue IN SET('abc', 'def') OR floatValue IN SET(1.5678, null) OR dateValue IN SET(DATE '2018-02-05', DATE '2018-02-06') OR timeValue IN SET(TIME '03:22:23', TIME '07:22:23') OR timestampValue IN SET(TIMESTAMP '2018-02-05 04:22:33', TIMESTAMP '2017-02-05 04:22:33') OR booleanValue IN SET(true, false, null)"));
    }
}

