/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.csv;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.csv.CsvEnumerator;
import org.apache.calcite.adapter.csv.CsvTable;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.FilterableTable;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.util.Source;

public class CsvFilterableTable
extends CsvTable
implements FilterableTable {
    public CsvFilterableTable(Source source, RelProtoDataType protoRowType) {
        super(source, protoRowType);
    }

    public String toString() {
        return "CsvFilterableTable";
    }

    public Enumerable<Object[]> scan(DataContext root, List<RexNode> filters) {
        final String[] filterValues = new String[this.fieldTypes.size()];
        filters.removeIf(filter -> this.addFilter((RexNode)filter, filterValues));
        final int[] fields = CsvEnumerator.identityList(this.fieldTypes.size());
        final AtomicBoolean cancelFlag = (AtomicBoolean)DataContext.Variable.CANCEL_FLAG.get(root);
        return new AbstractEnumerable<Object[]>(){

            public Enumerator<Object[]> enumerator() {
                return new CsvEnumerator<Object[]>(CsvFilterableTable.this.source, cancelFlag, false, filterValues, new CsvEnumerator.ArrayRowConverter(CsvFilterableTable.this.fieldTypes, fields));
            }
        };
    }

    private boolean addFilter(RexNode filter, Object[] filterValues) {
        if (filter.isA(SqlKind.EQUALS)) {
            int index;
            RexCall call = (RexCall)filter;
            RexNode left = (RexNode)call.getOperands().get(0);
            if (left.isA(SqlKind.CAST)) {
                left = (RexNode)((RexCall)left).operands.get(0);
            }
            RexNode right = (RexNode)call.getOperands().get(1);
            if (left instanceof RexInputRef && right instanceof RexLiteral && filterValues[index = ((RexInputRef)left).getIndex()] == null) {
                filterValues[index] = ((RexLiteral)right).getValue2().toString();
                return true;
            }
        }
        return false;
    }
}

