/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.elasticsearch;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableMap;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.PatternSyntaxException;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchSchema;
import org.apache.calcite.adapter.elasticsearch.EmbeddedElasticsearchPolicy;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.impl.ViewTable;
import org.apache.calcite.schema.impl.ViewTableMacro;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.test.ElasticsearchChecker;
import org.apache.calcite.util.TestUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class Projection2Test {
    @ClassRule
    public static final EmbeddedElasticsearchPolicy NODE = EmbeddedElasticsearchPolicy.create();
    private static final String NAME = "nested";

    @BeforeClass
    public static void setupInstance() throws Exception {
        ImmutableMap mappings = ImmutableMap.of((Object)"a", (Object)"long", (Object)"b.a", (Object)"long", (Object)"b.b", (Object)"long", (Object)"b.c.a", (Object)"keyword");
        NODE.createIndex(NAME, (Map<String, String>)mappings);
        String doc = "{'a': 1, 'b':{'a': 2, 'b':'3', 'c':{'a': 'foo'}}}".replace('\'', '\"');
        NODE.insertDocument(NAME, (ObjectNode)NODE.mapper().readTree(doc));
    }

    private CalciteAssert.ConnectionFactory newConnectionFactory() {
        return new CalciteAssert.ConnectionFactory(){

            public Connection createConnection() throws SQLException {
                Connection connection = DriverManager.getConnection("jdbc:calcite:");
                SchemaPlus root = connection.unwrap(CalciteConnection.class).getRootSchema();
                root.add("elastic", (Schema)new ElasticsearchSchema(NODE.restClient(), NODE.mapper(), Projection2Test.NAME));
                String viewSql = String.format(Locale.ROOT, "select _MAP['a'] AS \"a\",  _MAP['b.a']  AS \"b.a\",  _MAP['b.b'] AS \"b.b\",  _MAP['b.c.a'] AS \"b.c.a\",  _MAP['_id'] AS \"id\"  from \"elastic\".\"%s\"", Projection2Test.NAME);
                ViewTableMacro macro = ViewTable.viewMacro((SchemaPlus)root, (String)viewSql, Collections.singletonList("elastic"), Arrays.asList("elastic", "view"), (Boolean)false);
                root.add("VIEW", (Function)macro);
                return connection;
            }
        };
    }

    @Test
    public void projection() {
        CalciteAssert.that().with(this.newConnectionFactory()).query("select \"a\", \"b.a\", \"b.b\", \"b.c.a\" from view").returns("a=1; b.a=2; b.b=3; b.c.a=foo\n");
    }

    @Test
    public void projection2() {
        String sql = String.format(Locale.ROOT, "select _MAP['a'], _MAP['b.a'], _MAP['b.b'], _MAP['b.c.a'], _MAP['missing'], _MAP['b.missing'] from \"elastic\".\"%s\"", NAME);
        CalciteAssert.that().with(this.newConnectionFactory()).query(sql).returns("EXPR$0=1; EXPR$1=2; EXPR$2=3; EXPR$3=foo; EXPR$4=null; EXPR$5=null\n");
    }

    @Test
    public void projection3() {
        CalciteAssert.that().with(this.newConnectionFactory()).query(String.format(Locale.ROOT, "select * from \"elastic\".\"%s\"", NAME)).returns("_MAP={a=1, b={a=2, b=3, c={a=foo}}}\n");
        CalciteAssert.that().with(this.newConnectionFactory()).query(String.format(Locale.ROOT, "select *, _MAP['a'] from \"elastic\".\"%s\"", NAME)).returns("_MAP={a=1, b={a=2, b=3, c={a=foo}}}; EXPR$1=1\n");
    }

    @Test
    public void projectionWithIdField() {
        CalciteAssert.AssertThat factory = CalciteAssert.that().with(this.newConnectionFactory());
        factory.query("select \"id\" from view").returns(Projection2Test.regexMatch("id=\\p{Graph}+"));
        factory.query("select \"id\", \"id\" from view").returns(Projection2Test.regexMatch("id=\\p{Graph}+; id=\\p{Graph}+"));
        factory.query("select \"id\", \"a\" from view").returns(Projection2Test.regexMatch("id=\\p{Graph}+; a=1"));
        factory.query("select \"a\", \"id\" from view").returns(Projection2Test.regexMatch("a=1; id=\\p{Graph}+"));
        String sql1 = String.format(Locale.ROOT, "select _MAP['_id']  from \"elastic\".\"%s\"", NAME);
        factory.query(sql1).returns(Projection2Test.regexMatch("EXPR$0=\\p{Graph}+"));
        String sql2 = String.format(Locale.ROOT, "select _MAP['_id'], _MAP['a']  from \"elastic\".\"%s\"", NAME);
        factory.query(sql2).returns(Projection2Test.regexMatch("EXPR$0=\\p{Graph}+; EXPR$1=1"));
        String sql3 = String.format(Locale.ROOT, "select _MAP['_id'], _MAP['_id']  from \"elastic\".\"%s\"", NAME);
        factory.query(sql3).returns(Projection2Test.regexMatch("EXPR$0=\\p{Graph}+; EXPR$1=\\p{Graph}+"));
        String sql4 = String.format(Locale.ROOT, "select _MAP['_id'] as \"_id\"  from \"elastic\".\"%s\"", NAME);
        factory.query(sql4).returns(Projection2Test.regexMatch("_id=\\p{Graph}+"));
        factory.query(String.format(Locale.ROOT, "select * from \"elastic\".\"%s\"", NAME)).returns(Projection2Test.regexMatch("_MAP={a=1, b={a=2, b=3, c={a=foo}}}"));
        factory.query(String.format(Locale.ROOT, "select *, _MAP['_id'] from \"elastic\".\"%s\"", NAME)).returns(Projection2Test.regexMatch("_MAP={a=1, b={a=2, b=3, c={a=foo}}}; EXPR$1=\\p{Graph}+"));
    }

    @Test
    public void simpleProjectionNoScripting() {
        CalciteAssert.that().with(this.newConnectionFactory()).query(String.format(Locale.ROOT, "select _MAP['_id'], _MAP['a'], _MAP['b.a'] from  \"elastic\".\"%s\" where _MAP['b.a'] = 2", NAME)).queryContains(ElasticsearchChecker.elasticsearchChecker("'query.constant_score.filter.term.b.a':2", "_source:['a', 'b.a']", "size:5196")).returns(Projection2Test.regexMatch("EXPR$0=\\p{Graph}+; EXPR$1=1; EXPR$2=2"));
    }

    private static Consumer<ResultSet> regexMatch(String ... lines) {
        return rset -> {
            try {
                int columnCount = rset.getMetaData().getColumnCount();
                StringBuilder actual = new StringBuilder();
                int processedRows = 0;
                boolean fail = false;
                while (rset.next()) {
                    if (processedRows >= lines.length) {
                        fail = true;
                    }
                    for (int i = 1; i <= columnCount; ++i) {
                        String name = rset.getMetaData().getColumnName(i);
                        String value = rset.getString(i);
                        actual.append(name).append('=').append(value);
                        if (i < columnCount) {
                            actual.append("; ");
                        }
                        if (fail) continue;
                        String keyValue = lines[processedRows].split("; ")[i - 1];
                        String[] parts = keyValue.split("=", 2);
                        String expectedName = parts[0];
                        String expectedValue = parts[1];
                        boolean valueMatches = expectedValue.equals(value);
                        if (!valueMatches) {
                            try {
                                valueMatches = value != null && value.matches(expectedValue);
                            }
                            catch (PatternSyntaxException patternSyntaxException) {
                                // empty catch block
                            }
                        }
                        fail = !name.equals(expectedName) || !valueMatches;
                    }
                    ++processedRows;
                }
                if (fail &= processedRows == lines.length) {
                    Assert.assertEquals((Object)String.join((CharSequence)"\n", Arrays.asList(lines)), (Object)actual.toString());
                    Assert.fail((String)"Should have failed on previous line, but for some reason didn't");
                }
            }
            catch (SQLException e) {
                throw TestUtil.rethrow((Throwable)e);
            }
        };
    }
}

