/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.elasticsearch;

import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.apache.calcite.util.TestUtil;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.node.InternalSettingsPreparer;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeValidationException;
import org.elasticsearch.painless.PainlessPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.transport.Netty4Plugin;

class EmbeddedElasticsearchNode
implements AutoCloseable {
    private final Node node;
    private volatile boolean isStarted;

    private EmbeddedElasticsearchNode(Node node) {
        this.node = Objects.requireNonNull(node, "node");
    }

    private static EmbeddedElasticsearchNode create(Settings settings) {
        LocalNode node = new LocalNode(settings, Arrays.asList(Netty4Plugin.class, PainlessPlugin.class));
        return new EmbeddedElasticsearchNode(node);
    }

    public static synchronized EmbeddedElasticsearchNode create() {
        File data = Files.createTempDir();
        data.deleteOnExit();
        File home = Files.createTempDir();
        home.deleteOnExit();
        Settings settings = Settings.builder().put("node.name", "fake-elastic").put("path.home", home.getAbsolutePath()).put("path.data", data.getAbsolutePath()).put("http.type", "netty4").put("transport.tcp.port", 0).put("http.port", 0).put("network.host", "localhost").build();
        return EmbeddedElasticsearchNode.create(settings);
    }

    public void start() {
        Preconditions.checkState((!this.isStarted ? 1 : 0) != 0, (Object)"already started");
        try {
            this.node.start();
            this.isStarted = true;
        }
        catch (NodeValidationException e) {
            throw TestUtil.rethrow((Throwable)e);
        }
    }

    public TransportAddress httpAddress() {
        Preconditions.checkState((boolean)this.isStarted, (Object)"node is not started");
        NodesInfoResponse response = (NodesInfoResponse)this.client().admin().cluster().prepareNodesInfo(new String[0]).execute().actionGet();
        if (response.getNodes().size() != 1) {
            throw new IllegalStateException("Expected single node but got " + response.getNodes().size());
        }
        NodeInfo node = (NodeInfo)response.getNodes().get(0);
        return node.getHttp().address().boundAddresses()[0];
    }

    public Client client() {
        Preconditions.checkState((boolean)this.isStarted, (Object)"node is not started");
        return this.node.client();
    }

    @Override
    public void close() throws Exception {
        this.node.close();
        for (String name : Arrays.asList("path.data", "path.home")) {
            File file;
            if (this.node.settings().get(name) == null || !(file = new File(this.node.settings().get(name))).exists()) continue;
            file.delete();
        }
    }

    private static class LocalNode
    extends Node {
        private LocalNode(Settings settings, Collection<Class<? extends Plugin>> classpathPlugins) {
            super(InternalSettingsPreparer.prepareEnvironment((Settings)settings, Collections.emptyMap(), null, () -> "default_node_name"), classpathPlugins, false);
        }
    }
}

