/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.elasticsearch;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableMap;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchSchema;
import org.apache.calcite.adapter.elasticsearch.EmbeddedElasticsearchPolicy;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.impl.ViewTable;
import org.apache.calcite.schema.impl.ViewTableMacro;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.test.ElasticsearchChecker;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class AggregationTest {
    @ClassRule
    public static final EmbeddedElasticsearchPolicy NODE = EmbeddedElasticsearchPolicy.create();
    private static final String NAME = "aggs";

    @BeforeClass
    public static void setupInstance() throws Exception {
        ImmutableMap mappings = ImmutableMap.builder().put((Object)"cat1", (Object)"keyword").put((Object)"cat2", (Object)"keyword").put((Object)"cat3", (Object)"keyword").put((Object)"cat4", (Object)"date").put((Object)"cat5", (Object)"integer").put((Object)"val1", (Object)"long").put((Object)"val2", (Object)"long").build();
        NODE.createIndex(NAME, (Map<String, String>)mappings);
        String doc1 = "{cat1:'a', cat2:'g', val1:1, cat4:'2018-01-01', cat5:1}";
        String doc2 = "{cat2:'g', cat3:'y', val2:5, cat4:'2019-12-12'}";
        String doc3 = "{cat1:'b', cat2:'h', cat3:'z', cat5:2, val1:7, val2:42}";
        ObjectMapper mapper = new ObjectMapper().enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES}).enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_SINGLE_QUOTES});
        ArrayList<ObjectNode> docs = new ArrayList<ObjectNode>();
        for (String text : Arrays.asList(doc1, doc2, doc3)) {
            docs.add((ObjectNode)mapper.readTree(text));
        }
        NODE.insertBulk(NAME, docs);
    }

    private CalciteAssert.ConnectionFactory newConnectionFactory() {
        return new CalciteAssert.ConnectionFactory(){

            public Connection createConnection() throws SQLException {
                Connection connection = DriverManager.getConnection("jdbc:calcite:lex=JAVA");
                SchemaPlus root = connection.unwrap(CalciteConnection.class).getRootSchema();
                root.add("elastic", (Schema)new ElasticsearchSchema(NODE.restClient(), NODE.mapper(), AggregationTest.NAME));
                String viewSql = String.format(Locale.ROOT, "select _MAP['cat1'] AS \"cat1\",  _MAP['cat2']  AS \"cat2\",  _MAP['cat3'] AS \"cat3\",  _MAP['cat4'] AS \"cat4\",  _MAP['cat5'] AS \"cat5\",  _MAP['val1'] AS \"val1\",  _MAP['val2'] AS \"val2\"  from \"elastic\".\"%s\"", AggregationTest.NAME);
                ViewTableMacro macro = ViewTable.viewMacro((SchemaPlus)root, (String)viewSql, Collections.singletonList("elastic"), Arrays.asList("elastic", "view"), (Boolean)false);
                root.add("view", (Function)macro);
                return connection;
            }
        };
    }

    @Test
    public void countStar() {
        CalciteAssert.that().with(this.newConnectionFactory()).query("select count(*) from view").queryContains(ElasticsearchChecker.elasticsearchChecker("_source:false, size:0")).returns("EXPR$0=3\n");
        CalciteAssert.that().with(this.newConnectionFactory()).query("select count(*) from view where cat1 = 'a'").returns("EXPR$0=1\n");
        CalciteAssert.that().with(this.newConnectionFactory()).query("select count(*) from view where cat1 in ('a', 'b')").returns("EXPR$0=2\n");
    }

    @Test
    public void all() {
        CalciteAssert.that().with(this.newConnectionFactory()).query("select count(*), sum(val1), sum(val2) from view").queryContains(ElasticsearchChecker.elasticsearchChecker("_source:false, size:0", "aggregations:{'EXPR$0.value_count.field': '_id'", "'EXPR$1.sum.field': 'val1'", "'EXPR$2.sum.field': 'val2'}")).returns("EXPR$0=3; EXPR$1=8.0; EXPR$2=47.0\n");
        CalciteAssert.that().with(this.newConnectionFactory()).query("select min(val1), max(val2), count(*) from view").queryContains(ElasticsearchChecker.elasticsearchChecker("_source:false, size:0", "aggregations:{'EXPR$0.min.field': 'val1'", "'EXPR$1.max.field': 'val2'", "'EXPR$2.value_count.field': '_id'}")).returns("EXPR$0=1.0; EXPR$1=42.0; EXPR$2=3\n");
    }

    @Test
    public void cat1() {
        CalciteAssert.that().with(this.newConnectionFactory()).query("select cat1, sum(val1), sum(val2) from view group by cat1").returnsUnordered(new String[]{"cat1=null; EXPR$1=0.0; EXPR$2=5.0", "cat1=a; EXPR$1=1.0; EXPR$2=0.0", "cat1=b; EXPR$1=7.0; EXPR$2=42.0"});
        CalciteAssert.that().with(this.newConnectionFactory()).query("select cat1, count(*) from view group by cat1").returnsUnordered(new String[]{"cat1=null; EXPR$1=1", "cat1=a; EXPR$1=1", "cat1=b; EXPR$1=1"});
        CalciteAssert.that().with(this.newConnectionFactory()).query("select count(*), cat1 from view group by cat1").returnsUnordered(new String[]{"EXPR$0=1; cat1=a", "EXPR$0=1; cat1=b", "EXPR$0=1; cat1=null"});
        CalciteAssert.that().with(this.newConnectionFactory()).query("select cat1, count(*), sum(val1), sum(val2) from view group by cat1").returnsUnordered(new String[]{"cat1=a; EXPR$1=1; EXPR$2=1.0; EXPR$3=0.0", "cat1=b; EXPR$1=1; EXPR$2=7.0; EXPR$3=42.0", "cat1=null; EXPR$1=1; EXPR$2=0.0; EXPR$3=5.0"});
    }

    @Test
    public void cat2() {
        CalciteAssert.that().with(this.newConnectionFactory()).query("select cat2, min(val1), max(val1), min(val2), max(val2) from view group by cat2").returnsUnordered(new String[]{"cat2=g; EXPR$1=1.0; EXPR$2=1.0; EXPR$3=5.0; EXPR$4=5.0", "cat2=h; EXPR$1=7.0; EXPR$2=7.0; EXPR$3=42.0; EXPR$4=42.0"});
        CalciteAssert.that().with(this.newConnectionFactory()).query("select cat2, sum(val1), sum(val2) from view group by cat2").returnsUnordered(new String[]{"cat2=g; EXPR$1=1.0; EXPR$2=5.0", "cat2=h; EXPR$1=7.0; EXPR$2=42.0"});
        CalciteAssert.that().with(this.newConnectionFactory()).query("select cat2, count(*) from view group by cat2").returnsUnordered(new String[]{"cat2=g; EXPR$1=2", "cat2=h; EXPR$1=1"});
    }

    @Test
    public void cat1Cat2() {
        CalciteAssert.that().with(this.newConnectionFactory()).query("select cat1, cat2, sum(val1), sum(val2) from view group by cat1, cat2").returnsUnordered(new String[]{"cat1=a; cat2=g; EXPR$2=1.0; EXPR$3=0.0", "cat1=null; cat2=g; EXPR$2=0.0; EXPR$3=5.0", "cat1=b; cat2=h; EXPR$2=7.0; EXPR$3=42.0"});
        CalciteAssert.that().with(this.newConnectionFactory()).query("select cat1, cat2, count(*) from view group by cat1, cat2").returnsUnordered(new String[]{"cat1=a; cat2=g; EXPR$2=1", "cat1=null; cat2=g; EXPR$2=1", "cat1=b; cat2=h; EXPR$2=1"});
    }

    @Test
    public void cat1Cat3() {
        CalciteAssert.that().with(this.newConnectionFactory()).query("select cat1, cat3, sum(val1), sum(val2) from view group by cat1, cat3").returnsUnordered(new String[]{"cat1=a; cat3=null; EXPR$2=1.0; EXPR$3=0.0", "cat1=null; cat3=y; EXPR$2=0.0; EXPR$3=5.0", "cat1=b; cat3=z; EXPR$2=7.0; EXPR$3=42.0"});
    }

    @Test
    public void anyValue() {
        CalciteAssert.that().with(this.newConnectionFactory()).query("select cat1, any_value(cat2) from view group by cat1").returnsUnordered(new String[]{"cat1=a; EXPR$1=g", "cat1=null; EXPR$1=g", "cat1=b; EXPR$1=h"});
        CalciteAssert.that().with(this.newConnectionFactory()).query("select cat2, any_value(cat1) from view group by cat2").returnsUnordered(new String[]{"cat2=g; EXPR$1=a", "cat2=h; EXPR$1=b"});
        CalciteAssert.that().with(this.newConnectionFactory()).query("select cat2, any_value(cat3) from view group by cat2").returnsUnordered(new String[]{"cat2=g; EXPR$1=y", "cat2=h; EXPR$1=z"});
    }

    @Test
    public void anyValueWithOtherAgg() {
        CalciteAssert.that().with(this.newConnectionFactory()).query("select cat1, any_value(cat2), max(val1) from view group by cat1").returnsUnordered(new String[]{"cat1=a; EXPR$1=g; EXPR$2=1.0", "cat1=null; EXPR$1=g; EXPR$2=null", "cat1=b; EXPR$1=h; EXPR$2=7.0"});
        CalciteAssert.that().with(this.newConnectionFactory()).query("select max(val1), cat1, any_value(cat2) from view group by cat1").returnsUnordered(new String[]{"EXPR$0=1.0; cat1=a; EXPR$2=g", "EXPR$0=null; cat1=null; EXPR$2=g", "EXPR$0=7.0; cat1=b; EXPR$2=h"});
        CalciteAssert.that().with(this.newConnectionFactory()).query("select any_value(cat2), cat1, max(val1) from view group by cat1").returnsUnordered(new String[]{"EXPR$0=g; cat1=a; EXPR$2=1.0", "EXPR$0=g; cat1=null; EXPR$2=null", "EXPR$0=h; cat1=b; EXPR$2=7.0"});
    }

    @Test
    public void cat1Cat2Cat3() {
        CalciteAssert.that().with(this.newConnectionFactory()).query("select cat1, cat2, cat3, count(*), sum(val1), sum(val2) from view group by cat1, cat2, cat3").returnsUnordered(new String[]{"cat1=a; cat2=g; cat3=null; EXPR$3=1; EXPR$4=1.0; EXPR$5=0.0", "cat1=b; cat2=h; cat3=z; EXPR$3=1; EXPR$4=7.0; EXPR$5=42.0", "cat1=null; cat2=g; cat3=y; EXPR$3=1; EXPR$4=0.0; EXPR$5=5.0"});
    }

    @Test
    public void dateCat() {
        CalciteAssert.that().with(this.newConnectionFactory()).query("select cat4, sum(val1) from view group by cat4").returnsUnordered(new String[]{"cat4=1514764800000; EXPR$1=1.0", "cat4=1576108800000; EXPR$1=0.0", "cat4=null; EXPR$1=7.0"});
    }

    @Test
    public void integerCat() {
        CalciteAssert.that().with(this.newConnectionFactory()).query("select cat5, sum(val1) from view group by cat5").returnsUnordered(new String[]{"cat5=1; EXPR$1=1.0", "cat5=null; EXPR$1=0.0", "cat5=2; EXPR$1=7.0"});
    }

    @Test
    public void approximateCountDistinct() {
        CalciteAssert.that().with(this.newConnectionFactory()).query("select approx_count_distinct(cat1) from view").returnsUnordered(new String[]{"EXPR$0=2"});
        CalciteAssert.that().with(this.newConnectionFactory()).query("select approx_count_distinct(cat2) from view").returnsUnordered(new String[]{"EXPR$0=2"});
        CalciteAssert.that().with(this.newConnectionFactory()).query("select cat1, approx_count_distinct(val1) from view group by cat1").returnsUnordered(new String[]{"cat1=a; EXPR$1=1", "cat1=b; EXPR$1=1", "cat1=null; EXPR$1=0"});
        CalciteAssert.that().with(this.newConnectionFactory()).query("select cat1, approx_count_distinct(val2) from view group by cat1").returnsUnordered(new String[]{"cat1=a; EXPR$1=0", "cat1=b; EXPR$1=1", "cat1=null; EXPR$1=1"});
    }
}

