/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.elasticsearch;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Map;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchJson;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ElasticsearchJsonTest {
    private ObjectMapper mapper;

    @Before
    public void setUp() throws Exception {
        this.mapper = new ObjectMapper().configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true).configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
    }

    @Test
    public void aggEmpty() throws Exception {
        String json = "{}";
        ElasticsearchJson.Aggregations a = (ElasticsearchJson.Aggregations)this.mapper.readValue(json, ElasticsearchJson.Aggregations.class);
        Assert.assertNotNull((Object)a);
        Assert.assertThat((Object)a.asList().size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)a.asMap().size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void aggSingle1() throws Exception {
        String json = "{agg1: {value: '111'}}";
        ElasticsearchJson.Aggregations a = (ElasticsearchJson.Aggregations)this.mapper.readValue(json, ElasticsearchJson.Aggregations.class);
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((long)1L, (long)a.asList().size());
        Assert.assertEquals((long)1L, (long)a.asMap().size());
        Assert.assertEquals((Object)"agg1", (Object)((ElasticsearchJson.Aggregation)a.asList().get(0)).getName());
        Assert.assertEquals((Object)"agg1", a.asMap().keySet().iterator().next());
        Assert.assertEquals((Object)"111", (Object)((ElasticsearchJson.MultiValue)a.asList().get(0)).value());
        ArrayList rows = new ArrayList();
        ElasticsearchJson.visitValueNodes((ElasticsearchJson.Aggregations)a, rows::add);
        Assert.assertThat((Object)rows.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat(((Map)rows.get(0)).get("agg1"), (Matcher)CoreMatchers.is((Object)"111"));
    }

    @Test
    public void aggMultiValues() throws Exception {
        String json = "{ agg1: {min: 0, max: 2, avg: 2.33}}";
        ElasticsearchJson.Aggregations a = (ElasticsearchJson.Aggregations)this.mapper.readValue(json, ElasticsearchJson.Aggregations.class);
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((long)1L, (long)a.asList().size());
        Assert.assertEquals((long)1L, (long)a.asMap().size());
        Assert.assertEquals((Object)"agg1", (Object)((ElasticsearchJson.Aggregation)a.asList().get(0)).getName());
        Map values = ((ElasticsearchJson.MultiValue)a.get("agg1")).values();
        Assert.assertThat(values.keySet(), (Matcher)CoreMatchers.hasItems((Object[])new String[]{"min", "max", "avg"}));
    }

    @Test
    public void aggSingle2() throws Exception {
        String json = "{ agg1: {value: 'foo'}, agg2: {value: 42}}";
        ElasticsearchJson.Aggregations a = (ElasticsearchJson.Aggregations)this.mapper.readValue(json, ElasticsearchJson.Aggregations.class);
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((long)2L, (long)a.asList().size());
        Assert.assertEquals((long)2L, (long)a.asMap().size());
        Assert.assertThat(a.asMap().keySet(), (Matcher)CoreMatchers.hasItems((Object[])new String[]{"agg1", "agg2"}));
    }

    @Test
    public void aggBuckets1() throws Exception {
        String json = "{ groupby: {buckets: [{key:'k1', doc_count:0, myagg:{value: 1.1}}, {key:'k2', myagg:{value: 2.2}}] }}";
        ElasticsearchJson.Aggregations a = (ElasticsearchJson.Aggregations)this.mapper.readValue(json, ElasticsearchJson.Aggregations.class);
        Assert.assertThat(a.asMap().keySet(), (Matcher)IsCollectionContaining.hasItem((Object)"groupby"));
        Assert.assertThat((Object)a.get("groupby"), (Matcher)CoreMatchers.instanceOf(ElasticsearchJson.MultiBucketsAggregation.class));
        ElasticsearchJson.MultiBucketsAggregation multi = (ElasticsearchJson.MultiBucketsAggregation)a.get("groupby");
        Assert.assertThat((Object)multi.buckets().size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)multi.getName(), (Matcher)CoreMatchers.is((Object)"groupby"));
        Assert.assertThat((Object)((ElasticsearchJson.Bucket)multi.buckets().get(0)).key(), (Matcher)CoreMatchers.is((Object)"k1"));
        Assert.assertThat((Object)((ElasticsearchJson.Bucket)multi.buckets().get(0)).keyAsString(), (Matcher)CoreMatchers.is((Object)"k1"));
        Assert.assertThat((Object)((ElasticsearchJson.Bucket)multi.buckets().get(1)).key(), (Matcher)CoreMatchers.is((Object)"k2"));
        Assert.assertThat((Object)((ElasticsearchJson.Bucket)multi.buckets().get(1)).keyAsString(), (Matcher)CoreMatchers.is((Object)"k2"));
    }

    @Test
    public void aggManyAggregations() throws Exception {
        String json = "{groupby:{buckets:[{key:'k1', a1:{value:1}, a2:{value:2}},{key:'k2', a1:{value:3}, a2:{value:4}}]}}";
        ElasticsearchJson.Aggregations a = (ElasticsearchJson.Aggregations)this.mapper.readValue(json, ElasticsearchJson.Aggregations.class);
        ElasticsearchJson.MultiBucketsAggregation multi = (ElasticsearchJson.MultiBucketsAggregation)a.get("groupby");
        Assert.assertThat((Object)((ElasticsearchJson.Bucket)multi.buckets().get(0)).getAggregations().asMap().size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((ElasticsearchJson.Bucket)multi.buckets().get(0)).getName(), (Matcher)CoreMatchers.is((Object)"groupby"));
        Assert.assertThat((Object)((ElasticsearchJson.Bucket)multi.buckets().get(0)).key(), (Matcher)CoreMatchers.is((Object)"k1"));
        Assert.assertThat(((ElasticsearchJson.Bucket)multi.buckets().get(0)).getAggregations().asMap().keySet(), (Matcher)CoreMatchers.hasItems((Object[])new String[]{"a1", "a2"}));
        Assert.assertThat((Object)((ElasticsearchJson.Bucket)multi.buckets().get(1)).getAggregations().asMap().size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((ElasticsearchJson.Bucket)multi.buckets().get(1)).getName(), (Matcher)CoreMatchers.is((Object)"groupby"));
        Assert.assertThat((Object)((ElasticsearchJson.Bucket)multi.buckets().get(1)).key(), (Matcher)CoreMatchers.is((Object)"k2"));
        Assert.assertThat(((ElasticsearchJson.Bucket)multi.buckets().get(1)).getAggregations().asMap().keySet(), (Matcher)CoreMatchers.hasItems((Object[])new String[]{"a1", "a2"}));
        ArrayList rows = new ArrayList();
        ElasticsearchJson.visitValueNodes((ElasticsearchJson.Aggregations)a, rows::add);
        Assert.assertThat((Object)rows.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat(((Map)rows.get(0)).get("groupby"), (Matcher)CoreMatchers.is((Object)"k1"));
        Assert.assertThat(((Map)rows.get(0)).get("a1"), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat(((Map)rows.get(0)).get("a2"), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void aggMultiBuckets() throws Exception {
        String json = "{col1: {buckets: [{col2: {doc_count:1, buckets:[{key:'k3', max:{value:41}}]}, key:'k1'},{col2: {buckets:[{key:'k4', max:{value:42}}], doc_count:1}, key:'k2'}]}}";
        ElasticsearchJson.Aggregations a = (ElasticsearchJson.Aggregations)this.mapper.readValue(json, ElasticsearchJson.Aggregations.class);
        Assert.assertNotNull((Object)a);
        Assert.assertThat(a.asMap().keySet(), (Matcher)IsCollectionContaining.hasItem((Object)"col1"));
        Assert.assertThat((Object)a.get("col1"), (Matcher)CoreMatchers.instanceOf(ElasticsearchJson.MultiBucketsAggregation.class));
        ElasticsearchJson.MultiBucketsAggregation m = (ElasticsearchJson.MultiBucketsAggregation)a.get("col1");
        Assert.assertThat((Object)m.getName(), (Matcher)CoreMatchers.is((Object)"col1"));
        Assert.assertThat((Object)m.buckets().size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((ElasticsearchJson.Bucket)m.buckets().get(0)).key(), (Matcher)CoreMatchers.is((Object)"k1"));
        Assert.assertThat((Object)((ElasticsearchJson.Bucket)m.buckets().get(0)).getName(), (Matcher)CoreMatchers.is((Object)"col1"));
        Assert.assertThat(((ElasticsearchJson.Bucket)m.buckets().get(0)).getAggregations().asMap().keySet(), (Matcher)IsCollectionContaining.hasItem((Object)"col2"));
        Assert.assertThat((Object)((ElasticsearchJson.Bucket)m.buckets().get(1)).key(), (Matcher)CoreMatchers.is((Object)"k2"));
        ArrayList rows = new ArrayList();
        ElasticsearchJson.visitValueNodes((ElasticsearchJson.Aggregations)a, rows::add);
        Assert.assertThat((Object)rows.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat(((Map)rows.get(0)).keySet(), (Matcher)CoreMatchers.hasItems((Object[])new String[]{"col1", "col2", "max"}));
        Assert.assertThat(((Map)rows.get(0)).get("col1"), (Matcher)CoreMatchers.is((Object)"k1"));
        Assert.assertThat(((Map)rows.get(0)).get("col2"), (Matcher)CoreMatchers.is((Object)"k3"));
        Assert.assertThat(((Map)rows.get(0)).get("max"), (Matcher)CoreMatchers.is((Object)41));
        Assert.assertThat(((Map)rows.get(1)).keySet(), (Matcher)CoreMatchers.hasItems((Object[])new String[]{"col1", "col2", "max"}));
        Assert.assertThat(((Map)rows.get(1)).get("col1"), (Matcher)CoreMatchers.is((Object)"k2"));
        Assert.assertThat(((Map)rows.get(1)).get("col2"), (Matcher)CoreMatchers.is((Object)"k4"));
        Assert.assertThat(((Map)rows.get(1)).get("max"), (Matcher)CoreMatchers.is((Object)42));
    }
}

