/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.elasticsearch;

import java.util.Locale;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchVersion;
import org.junit.Assert;
import org.junit.Test;

public class ElasticsearchVersionTest {
    @Test
    public void versions() {
        Assert.assertEquals((Object)ElasticsearchVersion.fromString((String)"2.3.4"), (Object)ElasticsearchVersion.ES2);
        Assert.assertEquals((Object)ElasticsearchVersion.fromString((String)"2.0.0"), (Object)ElasticsearchVersion.ES2);
        Assert.assertEquals((Object)ElasticsearchVersion.fromString((String)"5.6.1"), (Object)ElasticsearchVersion.ES5);
        Assert.assertEquals((Object)ElasticsearchVersion.fromString((String)"6.0.1"), (Object)ElasticsearchVersion.ES6);
        Assert.assertEquals((Object)ElasticsearchVersion.fromString((String)"7.0.1"), (Object)ElasticsearchVersion.ES7);
        Assert.assertEquals((Object)ElasticsearchVersion.fromString((String)"111.0.1"), (Object)ElasticsearchVersion.UNKNOWN);
        Assert.assertEquals((Object)ElasticsearchVersion.fromString((String)"2020.12.12"), (Object)ElasticsearchVersion.UNKNOWN);
        ElasticsearchVersionTest.assertFails("");
        ElasticsearchVersionTest.assertFails(".");
        ElasticsearchVersionTest.assertFails(".1.2");
        ElasticsearchVersionTest.assertFails("1.2");
        ElasticsearchVersionTest.assertFails("0");
        ElasticsearchVersionTest.assertFails("b");
        ElasticsearchVersionTest.assertFails("a.b");
        ElasticsearchVersionTest.assertFails("aa");
        ElasticsearchVersionTest.assertFails("a.b.c");
        ElasticsearchVersionTest.assertFails("2.2");
        ElasticsearchVersionTest.assertFails("a.2");
        ElasticsearchVersionTest.assertFails("2.2.0a");
        ElasticsearchVersionTest.assertFails("2a.2.0");
    }

    private static void assertFails(String version) {
        try {
            ElasticsearchVersion.fromString((String)version);
            Assert.fail((String)String.format(Locale.ROOT, "Should fail for version %s", version));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

