/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.elasticsearch;

import java.util.Locale;
import java.util.Objects;

enum ElasticsearchVersion {
    ES2,
    ES5,
    ES6,
    ES7,
    UNKNOWN;


    static ElasticsearchVersion fromString(String version) {
        Objects.requireNonNull(version, "version");
        if (!version.matches("\\d+\\.\\d+\\.\\d+")) {
            String message = String.format(Locale.ROOT, "Wrong version format. Expected ${digit}.${digit}.${digit} but got %s", version);
            throw new IllegalArgumentException(message);
        }
        int major = Integer.parseInt(version.substring(0, version.indexOf(".")));
        if (major == 2) {
            return ES2;
        }
        if (major == 5) {
            return ES5;
        }
        if (major == 6) {
            return ES6;
        }
        if (major == 7) {
            return ES7;
        }
        return UNKNOWN;
    }
}

