/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.elasticsearch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchEnumerators;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchJson;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchRel;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchTableScan;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchTransport;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchVersion;
import org.apache.calcite.adapter.elasticsearch.Scrolling;
import org.apache.calcite.adapter.java.AbstractQueryableTable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.AbstractTableQueryable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchTable
extends AbstractQueryableTable
implements TranslatableTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchTable.class);
    private static final String AGGREGATIONS = "aggregations";
    private final ElasticsearchVersion version;
    private final String indexName;
    private final String typeName;
    final ObjectMapper mapper;
    final ElasticsearchTransport transport;

    ElasticsearchTable(ElasticsearchTransport transport) {
        super(Object[].class);
        this.transport = Objects.requireNonNull(transport, "transport");
        this.version = transport.version;
        this.indexName = transport.indexName;
        this.typeName = transport.typeName;
        this.mapper = transport.mapper();
    }

    String scriptedFieldPrefix() {
        return this.version == ElasticsearchVersion.ES2 ? "_source" : "params._source";
    }

    private Enumerable<Object> find(List<String> ops, List<Map.Entry<String, Class>> fields, List<Map.Entry<String, RelFieldCollation.Direction>> sort, List<String> groupBy, List<Map.Entry<String, String>> aggregations, Map<String, String> mappings, Long offset, Long fetch) throws IOException {
        Iterable iter;
        if (!aggregations.isEmpty() || !groupBy.isEmpty()) {
            return this.aggregate(ops, fields, sort, groupBy, aggregations, mappings, offset, fetch);
        }
        ObjectNode query = this.mapper.createObjectNode();
        for (String op : ops) {
            query.setAll((ObjectNode)this.mapper.readTree(op));
        }
        if (!sort.isEmpty()) {
            ArrayNode sortNode = query.withArray("sort");
            sort.forEach(e -> sortNode.add((JsonNode)this.mapper.createObjectNode().put((String)e.getKey(), ((RelFieldCollation.Direction)e.getValue()).isDescending() ? "desc" : "asc")));
        }
        if (offset != null) {
            query.put("from", offset);
        }
        if (fetch != null) {
            query.put("size", fetch);
        }
        Function1<ElasticsearchJson.SearchHit, Object> getter = ElasticsearchEnumerators.getter(fields, (Map<String, String>)ImmutableMap.copyOf(mappings));
        if (offset == null) {
            iter = () -> new Scrolling(this.transport).query(query);
        } else {
            ElasticsearchJson.Result search = this.transport.search().apply(query);
            iter = () -> search.searchHits().hits().iterator();
        }
        return Linq4j.asEnumerable(iter).select(getter);
    }

    private Enumerable<Object> aggregate(List<String> ops, List<Map.Entry<String, Class>> fields, List<Map.Entry<String, RelFieldCollation.Direction>> sort, List<String> groupBy, List<Map.Entry<String, String>> aggregations, Map<String, String> mapping, Long offset, Long fetch) throws IOException {
        if (!groupBy.isEmpty() && offset != null) {
            String message = "Currently ES doesn't support generic pagination with aggregations. You can still use LIMIT keyword (without OFFSET). For more details see https://github.com/elastic/elasticsearch/issues/4915";
            throw new IllegalStateException(message);
        }
        ObjectNode query = this.mapper.createObjectNode();
        for (String op : ops) {
            query.setAll((ObjectNode)this.mapper.readTree(op));
        }
        query.put("_source", false);
        query.put("size", 0);
        query.remove("script_fields");
        Predicate<Map.Entry> isCountStar = e -> ((String)e.getValue()).contains("\"_id\"");
        Set countAll = aggregations.stream().filter(isCountStar).map(Map.Entry::getKey).collect(Collectors.toSet());
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        LinkedHashSet<String> orderedGroupBy = new LinkedHashSet<String>();
        orderedGroupBy.addAll(sort.stream().map(Map.Entry::getKey).collect(Collectors.toList()));
        orderedGroupBy.addAll(groupBy);
        ObjectNode parent = query.with(AGGREGATIONS);
        for (String string : orderedGroupBy) {
            String aggName = "g_" + string;
            fieldMap.put(aggName, string);
            ObjectNode section = parent.with(aggName);
            ObjectNode terms = section.with("terms");
            terms.put("field", string);
            this.transport.mapping.missingValueFor(string).ifPresent(m -> terms.set("missing", m));
            if (fetch != null) {
                terms.put("size", fetch);
            }
            sort.stream().filter(e -> ((String)e.getKey()).equals(name)).findAny().ifPresent(s -> terms.with("order").put("_key", ((RelFieldCollation.Direction)s.getValue()).isDescending() ? "desc" : "asc"));
            parent = section.with(AGGREGATIONS);
        }
        if (!groupBy.isEmpty() || !aggregations.stream().allMatch(isCountStar)) {
            for (Map.Entry entry : aggregations) {
                JsonNode value = this.mapper.readTree((String)entry.getValue());
                parent.set((String)entry.getKey(), value);
            }
        }
        Consumer<JsonNode> emptyAggRemover = new Consumer<JsonNode>(){

            @Override
            public void accept(JsonNode node) {
                if (!node.has(ElasticsearchTable.AGGREGATIONS)) {
                    node.elements().forEachRemaining(this);
                    return;
                }
                JsonNode agg = node.get(ElasticsearchTable.AGGREGATIONS);
                if (agg.size() == 0) {
                    ((ObjectNode)node).remove(ElasticsearchTable.AGGREGATIONS);
                } else {
                    this.accept(agg);
                }
            }
        };
        emptyAggRemover.accept((JsonNode)query);
        ElasticsearchJson.Result result = this.transport.search(Collections.emptyMap()).apply(query);
        ArrayList result2 = new ArrayList();
        if (result.aggregations() != null) {
            ElasticsearchJson.visitValueNodes(result.aggregations(), m -> {
                LinkedHashMap newMap = new LinkedHashMap();
                for (String key : m.keySet()) {
                    newMap.put(fieldMap.getOrDefault(key, key), m.get(key));
                }
                result2.add(newMap);
            });
        } else {
            result2.add(new LinkedHashMap());
        }
        long total = result.searchHits().total();
        if (groupBy.isEmpty()) {
            for (String expr : countAll) {
                result2.forEach(m -> m.put(expr, total));
            }
        }
        Function1<ElasticsearchJson.SearchHit, Object> getter = ElasticsearchEnumerators.getter(fields, (Map<String, String>)ImmutableMap.copyOf(mapping));
        ElasticsearchJson.SearchHits hits = new ElasticsearchJson.SearchHits(total, result2.stream().map(r -> new ElasticsearchJson.SearchHit("_id", (Map<String, Object>)r, null)).collect(Collectors.toList()));
        return Linq4j.asEnumerable(hits.hits()).select(getter);
    }

    public RelDataType getRowType(RelDataTypeFactory relDataTypeFactory) {
        RelDataType mapType = relDataTypeFactory.createMapType(relDataTypeFactory.createSqlType(SqlTypeName.VARCHAR), relDataTypeFactory.createTypeWithNullability(relDataTypeFactory.createSqlType(SqlTypeName.ANY), true));
        return relDataTypeFactory.builder().add("_MAP", mapType).build();
    }

    public String toString() {
        return "ElasticsearchTable{" + this.indexName + "/" + this.typeName + "}";
    }

    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        return new ElasticsearchQueryable(queryProvider, schema, this, tableName);
    }

    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        RelOptCluster cluster = context.getCluster();
        return new ElasticsearchTableScan(cluster, cluster.traitSetOf((RelTrait)ElasticsearchRel.CONVENTION), relOptTable, this, null);
    }

    public static class ElasticsearchQueryable<T>
    extends AbstractTableQueryable<T> {
        ElasticsearchQueryable(QueryProvider queryProvider, SchemaPlus schema, ElasticsearchTable table, String tableName) {
            super(queryProvider, schema, (QueryableTable)table, tableName);
        }

        public Enumerator<T> enumerator() {
            return null;
        }

        private ElasticsearchTable getTable() {
            return (ElasticsearchTable)this.table;
        }

        public Enumerable<Object> find(List<String> ops, List<Map.Entry<String, Class>> fields, List<Map.Entry<String, RelFieldCollation.Direction>> sort, List<String> groupBy, List<Map.Entry<String, String>> aggregations, Map<String, String> mappings, Long offset, Long fetch) {
            try {
                return this.getTable().find(ops, fields, sort, groupBy, aggregations, mappings, offset, fetch);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to query " + this.getTable().indexName, e);
            }
        }
    }
}

