/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.elasticsearch;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchSchema;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaFactory;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.http.HttpHost;
import org.elasticsearch.client.RestClient;

public class ElasticsearchSchemaFactory
implements SchemaFactory {
    public Schema create(SchemaPlus parentSchema, String name, Map<String, Object> operand) {
        Map<String, Object> map = operand;
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        try {
            Map coordinates = (Map)mapper.readValue((String)map.get("coordinates"), (TypeReference)new TypeReference<Map<String, Integer>>(){});
            RestClient client = ElasticsearchSchemaFactory.connect(coordinates);
            Map userConfig = (Map)mapper.readValue((String)map.get("userConfig"), (TypeReference)new TypeReference<Map<String, String>>(){});
            String index = (String)map.get("index");
            Preconditions.checkArgument((index != null ? 1 : 0) != 0, (Object)"index is missing in configuration");
            return new ElasticsearchSchema(client, new ObjectMapper(), index);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot parse values from json", e);
        }
    }

    private static RestClient connect(Map<String, Integer> coordinates) {
        Objects.requireNonNull(coordinates, "coordinates");
        Preconditions.checkArgument((!coordinates.isEmpty() ? 1 : 0) != 0, (Object)"no ES coordinates specified");
        LinkedHashSet<HttpHost> set = new LinkedHashSet<HttpHost>();
        for (Map.Entry<String, Integer> entry : coordinates.entrySet()) {
            set.add(new HttpHost(entry.getKey(), entry.getValue().intValue()));
        }
        return RestClient.builder((HttpHost[])set.toArray(new HttpHost[0])).build();
    }
}

