/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.elasticsearch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchTable;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchTransport;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.http.Header;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;

public class ElasticsearchSchema
extends AbstractSchema {
    private final String index;
    private final RestClient client;
    private final ObjectMapper mapper;
    private final Map<String, Table> tableMap;
    private final int fetchSize;

    public ElasticsearchSchema(RestClient client, ObjectMapper mapper, String index) {
        this(client, mapper, index, null);
    }

    public ElasticsearchSchema(RestClient client, ObjectMapper mapper, String index, String type) {
        this(client, mapper, index, type, 5196);
    }

    @VisibleForTesting
    ElasticsearchSchema(RestClient client, ObjectMapper mapper, String index, String type, int fetchSize) {
        this.client = Objects.requireNonNull(client, "client");
        this.mapper = Objects.requireNonNull(mapper, "mapper");
        this.index = Objects.requireNonNull(index, "index");
        Preconditions.checkArgument((fetchSize > 0 ? 1 : 0) != 0, (String)"invalid fetch size. Expected %s > 0", (Object[])new Object[]{fetchSize});
        this.fetchSize = fetchSize;
        if (type == null) {
            try {
                this.tableMap = this.createTables(this.listTypesFromElastic());
            }
            catch (IOException e) {
                throw new UncheckedIOException("Couldn't get types for " + index, e);
            }
        } else {
            this.tableMap = this.createTables(Collections.singleton(type));
        }
    }

    protected Map<String, Table> getTableMap() {
        return this.tableMap;
    }

    private Map<String, Table> createTables(Iterable<String> types) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String type : types) {
            ElasticsearchTransport transport = new ElasticsearchTransport(this.client, this.mapper, this.index, type, this.fetchSize);
            builder.put((Object)type, (Object)new ElasticsearchTable(transport));
        }
        return builder.build();
    }

    private Set<String> listTypesFromElastic() throws IOException {
        String endpoint = "/" + this.index + "/_mapping";
        Response response = this.client.performRequest("GET", endpoint, new Header[0]);
        try (InputStream is = response.getEntity().getContent();){
            JsonNode root = this.mapper.readTree(is);
            if (!root.isObject() || root.size() != 1) {
                String message = String.format(Locale.ROOT, "Invalid response for %s/%s Expected object of size 1 got %s (of size %d)", response.getHost(), response.getRequestLine(), root.getNodeType(), root.size());
                throw new IllegalStateException(message);
            }
            JsonNode mappings = ((JsonNode)root.iterator().next()).get("mappings");
            if (mappings == null || mappings.size() == 0) {
                String message = String.format(Locale.ROOT, "Index %s does not have any types", this.index);
                throw new IllegalStateException(message);
            }
            HashSet types = Sets.newHashSet((Iterator)mappings.fieldNames());
            types.remove("_default_");
            HashSet hashSet = types;
            return hashSet;
        }
    }

    public String getIndex() {
        return this.index;
    }
}

