/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.elasticsearch;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchAggregate;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchFilter;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchProject;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchRel;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchSort;
import org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.ImmutableBitSet;

class ElasticsearchRules {
    static final RelOptRule[] RULES = new RelOptRule[]{ElasticsearchSortRule.access$000(), ElasticsearchFilterRule.access$100(), ElasticsearchProjectRule.access$200(), ElasticsearchAggregateRule.INSTANCE};

    private ElasticsearchRules() {
    }

    static String isItem(RexCall call) {
        if (call.getOperator() != SqlStdOperatorTable.ITEM) {
            return null;
        }
        RexNode op0 = (RexNode)call.getOperands().get(0);
        RexNode op1 = (RexNode)call.getOperands().get(1);
        if (op0 instanceof RexInputRef && ((RexInputRef)op0).getIndex() == 0 && op1 instanceof RexLiteral && ((RexLiteral)op1).getValue2() instanceof String) {
            return (String)((RexLiteral)op1).getValue2();
        }
        return null;
    }

    static List<String> elasticsearchFieldNames(final RelDataType rowType) {
        return SqlValidatorUtil.uniquify((List)new AbstractList<String>(){

            @Override
            public String get(int index) {
                String name = ((RelDataTypeField)rowType.getFieldList().get(index)).getName();
                return name.startsWith("$") ? "_" + name.substring(2) : name;
            }

            @Override
            public int size() {
                return rowType.getFieldCount();
            }
        }, (SqlValidatorUtil.Suggester)SqlValidatorUtil.EXPR_SUGGESTER, (boolean)true);
    }

    static String quote(String s) {
        return "\"" + s + "\"";
    }

    static String stripQuotes(String s) {
        return s.startsWith("\"") && s.endsWith("\"") ? s.substring(1, s.length() - 1) : s;
    }

    private static class ElasticsearchProjectRule
    extends ElasticsearchConverterRule {
        private static final ElasticsearchProjectRule INSTANCE = new ElasticsearchProjectRule();

        private ElasticsearchProjectRule() {
            super(LogicalProject.class, (RelTrait)Convention.NONE, ElasticsearchRel.CONVENTION, "ElasticsearchProjectRule");
        }

        public RelNode convert(RelNode relNode) {
            LogicalProject project = (LogicalProject)relNode;
            RelTraitSet traitSet = project.getTraitSet().replace((RelTrait)this.out);
            return new ElasticsearchProject(project.getCluster(), traitSet, ElasticsearchProjectRule.convert((RelNode)project.getInput(), (RelTrait)this.out), project.getProjects(), project.getRowType());
        }

        static /* synthetic */ ElasticsearchProjectRule access$200() {
            return INSTANCE;
        }
    }

    private static class ElasticsearchAggregateRule
    extends ElasticsearchConverterRule {
        static final RelOptRule INSTANCE = new ElasticsearchAggregateRule();

        private ElasticsearchAggregateRule() {
            super(LogicalAggregate.class, (RelTrait)Convention.NONE, ElasticsearchRel.CONVENTION, "ElasticsearchAggregateRule");
        }

        public RelNode convert(RelNode rel) {
            LogicalAggregate agg = (LogicalAggregate)rel;
            RelTraitSet traitSet = agg.getTraitSet().replace((RelTrait)this.out);
            try {
                return new ElasticsearchAggregate(rel.getCluster(), traitSet, ElasticsearchAggregateRule.convert((RelNode)agg.getInput(), (RelTraitSet)traitSet.simplify()), agg.indicator, agg.getGroupSet(), (List<ImmutableBitSet>)agg.getGroupSets(), agg.getAggCallList());
            }
            catch (InvalidRelException e) {
                return null;
            }
        }
    }

    private static class ElasticsearchFilterRule
    extends ElasticsearchConverterRule {
        private static final ElasticsearchFilterRule INSTANCE = new ElasticsearchFilterRule();

        private ElasticsearchFilterRule() {
            super(LogicalFilter.class, (RelTrait)Convention.NONE, ElasticsearchRel.CONVENTION, "ElasticsearchFilterRule");
        }

        public RelNode convert(RelNode relNode) {
            LogicalFilter filter = (LogicalFilter)relNode;
            RelTraitSet traitSet = filter.getTraitSet().replace((RelTrait)this.out);
            return new ElasticsearchFilter(relNode.getCluster(), traitSet, ElasticsearchFilterRule.convert((RelNode)filter.getInput(), (RelTrait)this.out), filter.getCondition());
        }

        static /* synthetic */ ElasticsearchFilterRule access$100() {
            return INSTANCE;
        }
    }

    private static class ElasticsearchSortRule
    extends ElasticsearchConverterRule {
        private static final ElasticsearchSortRule INSTANCE = new ElasticsearchSortRule();

        private ElasticsearchSortRule() {
            super(Sort.class, (RelTrait)Convention.NONE, ElasticsearchRel.CONVENTION, "ElasticsearchSortRule");
        }

        public RelNode convert(RelNode relNode) {
            Sort sort = (Sort)relNode;
            RelTraitSet traitSet = sort.getTraitSet().replace((RelTrait)this.out).replace((RelTrait)sort.getCollation());
            return new ElasticsearchSort(relNode.getCluster(), traitSet, ElasticsearchSortRule.convert((RelNode)sort.getInput(), (RelTraitSet)traitSet.replace((RelTrait)RelCollations.EMPTY)), sort.getCollation(), sort.offset, sort.fetch);
        }

        static /* synthetic */ ElasticsearchSortRule access$000() {
            return INSTANCE;
        }
    }

    static abstract class ElasticsearchConverterRule
    extends ConverterRule {
        final Convention out;

        ElasticsearchConverterRule(Class<? extends RelNode> clazz, RelTrait in, Convention out, String description) {
            super(clazz, in, (RelTrait)out, description);
            this.out = out;
        }
    }

    static class RexToElasticsearchTranslator
    extends RexVisitorImpl<String> {
        private final JavaTypeFactory typeFactory;
        private final List<String> inFields;

        RexToElasticsearchTranslator(JavaTypeFactory typeFactory, List<String> inFields) {
            super(true);
            this.typeFactory = typeFactory;
            this.inFields = inFields;
        }

        public String visitLiteral(RexLiteral literal) {
            if (literal.getValue() == null) {
                return "null";
            }
            return "\"literal\":\"" + RexToLixTranslator.translateLiteral((RexLiteral)literal, (RelDataType)literal.getType(), (JavaTypeFactory)this.typeFactory, (RexImpTable.NullAs)RexImpTable.NullAs.NOT_POSSIBLE) + "\"";
        }

        public String visitInputRef(RexInputRef inputRef) {
            return ElasticsearchRules.quote(this.inFields.get(inputRef.getIndex()));
        }

        public String visitCall(RexCall call) {
            RexNode op1;
            String name = ElasticsearchRules.isItem(call);
            if (name != null) {
                return "\"" + name + "\"";
            }
            List<String> strings = this.visitList((List<RexNode>)call.operands);
            if (call.getKind() == SqlKind.CAST) {
                return strings.get(0).startsWith("$") ? strings.get(0).substring(1) : strings.get(0);
            }
            if (call.getOperator() == SqlStdOperatorTable.ITEM && (op1 = (RexNode)call.getOperands().get(1)) instanceof RexLiteral && op1.getType().getSqlTypeName() == SqlTypeName.INTEGER) {
                return ElasticsearchRules.stripQuotes(strings.get(0)) + "[" + ((RexLiteral)op1).getValue2() + "]";
            }
            throw new IllegalArgumentException("Translation of " + call + " is not supported by ElasticsearchProject");
        }

        List<String> visitList(List<RexNode> list) {
            ArrayList<String> strings = new ArrayList<String>();
            for (RexNode node : list) {
                strings.add((String)node.accept((RexVisitor)this));
            }
            return strings;
        }
    }
}

