/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.elasticsearch;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchRel;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.util.ImmutableBitSet;

public class ElasticsearchAggregate
extends Aggregate
implements ElasticsearchRel {
    private static final Set<SqlKind> SUPPORTED_AGGREGATIONS = EnumSet.of(SqlKind.COUNT, new SqlKind[]{SqlKind.MAX, SqlKind.MIN, SqlKind.AVG, SqlKind.SUM, SqlKind.ANY_VALUE});

    ElasticsearchAggregate(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, boolean indicator, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) throws InvalidRelException {
        super(cluster, traitSet, input, indicator, groupSet, groupSets, aggCalls);
        if (this.getConvention() != input.getConvention()) {
            String message = String.format(Locale.ROOT, "%s != %s", this.getConvention(), input.getConvention());
            throw new AssertionError((Object)message);
        }
        assert (this.getConvention() == input.getConvention());
        assert (this.getConvention() == ElasticsearchRel.CONVENTION);
        assert (this.groupSets.size() == 1) : "Grouping sets not supported";
        for (AggregateCall aggCall : aggCalls) {
            if (aggCall.isDistinct()) {
                throw new InvalidRelException("distinct aggregation not supported");
            }
            SqlKind kind = aggCall.getAggregation().getKind();
            if (SUPPORTED_AGGREGATIONS.contains(kind)) continue;
            String message = String.format(Locale.ROOT, "Aggregation %s not supported (use one of %s)", kind, SUPPORTED_AGGREGATIONS);
            throw new InvalidRelException(message);
        }
        if (this.getGroupType() != Aggregate.Group.SIMPLE) {
            String message = String.format(Locale.ROOT, "Only %s grouping is supported. Yours is %s", Aggregate.Group.SIMPLE, this.getGroupType());
            throw new InvalidRelException(message);
        }
    }

    public Aggregate copy(RelTraitSet traitSet, RelNode input, boolean indicator, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        try {
            return new ElasticsearchAggregate(this.getCluster(), traitSet, input, indicator, groupSet, groupSets, aggCalls);
        }
        catch (InvalidRelException e) {
            throw new AssertionError((Object)e);
        }
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.1);
    }

    @Override
    public void implement(ElasticsearchRel.Implementor implementor) {
        implementor.visitChild(0, this.getInput());
        List<String> inputFields = this.fieldNames(this.getInput().getRowType());
        Iterator iterator = this.groupSet.iterator();
        while (iterator.hasNext()) {
            int group = (Integer)iterator.next();
            implementor.addGroupBy(inputFields.get(group));
        }
        for (AggregateCall aggCall : this.aggCalls) {
            ArrayList<String> names = new ArrayList<String>();
            Iterator iterator2 = aggCall.getArgList().iterator();
            while (iterator2.hasNext()) {
                int i = (Integer)iterator2.next();
                names.add(inputFields.get(i));
            }
            String name = names.isEmpty() ? "_id" : (String)names.get(0);
            String size = aggCall.getAggregation().getKind() == SqlKind.ANY_VALUE ? ", \"size\": 1" : "";
            String op = String.format(Locale.ROOT, "{\"%s\":{\"field\": \"%s\" %s}}", this.toElasticAggregate(aggCall), name, size);
            implementor.addAggregation(aggCall.getName(), op);
        }
    }

    private String toElasticAggregate(AggregateCall call) {
        SqlKind kind = call.getAggregation().getKind();
        switch (kind) {
            case COUNT: {
                return call.isApproximate() ? "cardinality" : "value_count";
            }
            case SUM: {
                return "sum";
            }
            case MIN: {
                return "min";
            }
            case MAX: {
                return "max";
            }
            case AVG: {
                return "avg";
            }
            case ANY_VALUE: {
                return "terms";
            }
        }
        throw new IllegalArgumentException("Unknown aggregation kind " + kind + " for " + call);
    }

    private List<String> fieldNames(RelDataType relDataType) {
        ArrayList<String> names = new ArrayList<String>();
        for (RelDataTypeField rdtf : relDataType.getFieldList()) {
            names.add(rdtf.getName());
        }
        return names;
    }
}

