/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.druid;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.List;
import java.util.Set;
import org.apache.calcite.adapter.druid.DruidJsonFilter;
import org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.calcite.adapter.druid.DruidSchema;
import org.apache.calcite.adapter.druid.DruidTable;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class DruidQueryFilterTest {
    private DruidQuery druidQuery;

    @Before
    public void testSetup() {
        this.druidQuery = (DruidQuery)Mockito.mock(DruidQuery.class);
        CalciteConnectionConfig connectionConfigMock = (CalciteConnectionConfig)Mockito.mock(CalciteConnectionConfig.class);
        Mockito.when((Object)connectionConfigMock.timeZone()).thenReturn((Object)"UTC");
        Mockito.when((Object)this.druidQuery.getConnectionConfig()).thenReturn((Object)connectionConfigMock);
        Mockito.when((Object)this.druidQuery.getDruidTable()).thenReturn((Object)new DruidTable((DruidSchema)Mockito.mock(DruidSchema.class), "dataSource", null, (Set)ImmutableSet.of(), "timestamp", null, null, null));
    }

    @Test
    public void testInFilter() throws IOException {
        Fixture f = new Fixture();
        ImmutableList listRexNodes = ImmutableList.of((Object)f.rexBuilder.makeInputRef(f.varcharRowType, 0), (Object)f.rexBuilder.makeExactLiteral(BigDecimal.valueOf(1L)), (Object)f.rexBuilder.makeExactLiteral(BigDecimal.valueOf(5L)), (Object)f.rexBuilder.makeLiteral("value1"));
        RexNode inRexNode = f.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IN, (List)listRexNodes);
        DruidJsonFilter returnValue = DruidJsonFilter.toDruidFilters((RexNode)inRexNode, (RelDataType)f.varcharRowType, (DruidQuery)this.druidQuery);
        Assert.assertNotNull((String)"Filter is null", (Object)returnValue);
        JsonFactory jsonFactory = new JsonFactory();
        StringWriter sw = new StringWriter();
        JsonGenerator jsonGenerator = jsonFactory.createGenerator((Writer)sw);
        returnValue.write(jsonGenerator);
        jsonGenerator.close();
        Assert.assertThat((Object)sw.toString(), (Matcher)Is.is((Object)"{\"type\":\"in\",\"dimension\":\"dimensionName\",\"values\":[\"1\",\"5\",\"value1\"]}"));
    }

    @Test
    public void testBetweenFilterStringCase() throws IOException {
        Fixture f = new Fixture();
        ImmutableList listRexNodes = ImmutableList.of((Object)f.rexBuilder.makeLiteral(false), (Object)f.rexBuilder.makeInputRef(f.varcharRowType, 0), (Object)f.rexBuilder.makeLiteral("lower-bound"), (Object)f.rexBuilder.makeLiteral("upper-bound"));
        RelDataType relDataType = f.typeFactory.createSqlType(SqlTypeName.BOOLEAN);
        RexNode betweenRexNode = f.rexBuilder.makeCall(relDataType, (SqlOperator)SqlStdOperatorTable.BETWEEN, (List)listRexNodes);
        DruidJsonFilter returnValue = DruidJsonFilter.toDruidFilters((RexNode)betweenRexNode, (RelDataType)f.varcharRowType, (DruidQuery)this.druidQuery);
        Assert.assertNotNull((String)"Filter is null", (Object)returnValue);
        JsonFactory jsonFactory = new JsonFactory();
        StringWriter sw = new StringWriter();
        JsonGenerator jsonGenerator = jsonFactory.createGenerator((Writer)sw);
        returnValue.write(jsonGenerator);
        jsonGenerator.close();
        Assert.assertThat((Object)sw.toString(), (Matcher)Is.is((Object)"{\"type\":\"bound\",\"dimension\":\"dimensionName\",\"lower\":\"lower-bound\",\"lowerStrict\":false,\"upper\":\"upper-bound\",\"upperStrict\":false,\"ordering\":\"lexicographic\"}"));
    }

    static class Fixture {
        final JavaTypeFactoryImpl typeFactory = new JavaTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        final RexBuilder rexBuilder = new RexBuilder((RelDataTypeFactory)this.typeFactory);
        final DruidTable druidTable = new DruidTable((DruidSchema)Mockito.mock(DruidSchema.class), "dataSource", null, (Set)ImmutableSet.of(), "timestamp", null, null, null);
        final RelDataType varcharType = this.typeFactory.createSqlType(SqlTypeName.VARCHAR);
        final RelDataType varcharRowType = this.typeFactory.builder().add("dimensionName", this.varcharType).build();

        Fixture() {
        }
    }
}

