/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import java.net.URL;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.function.Consumer;
import org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.calcite.adapter.druid.DruidSchema;
import org.apache.calcite.avatica.ConnectionProperty;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.prepare.CalcitePrepareImpl;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.Util;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class DruidAdapterIT {
    public static final URL FOODMART = DruidAdapterIT.class.getResource("/druid-foodmart-model.json");
    public static final URL WIKI = DruidAdapterIT.class.getResource("/druid-wiki-model.json");
    public static final URL WIKI_AUTO = DruidAdapterIT.class.getResource("/druid-wiki-no-columns-model.json");
    public static final URL WIKI_AUTO2 = DruidAdapterIT.class.getResource("/druid-wiki-no-tables-model.json");
    public static final boolean ENABLED = Util.getBooleanProperty((String)"calcite.test.druid", (boolean)true);
    private static final String VARCHAR_TYPE = "VARCHAR";
    private static final String FOODMART_TABLE = "\"foodmart\"";

    protected boolean enabled() {
        return ENABLED;
    }

    private static Consumer<List> druidChecker(String ... lines) {
        return list -> {
            Assert.assertThat((Object)list.size(), (Matcher)CoreMatchers.is((Object)1));
            DruidQuery.QuerySpec querySpec = (DruidQuery.QuerySpec)list.get(0);
            for (String line : lines) {
                String s = line.replace('\'', '\"');
                Assert.assertThat((Object)querySpec.getQueryString(null, -1), (Matcher)CoreMatchers.containsString((String)s));
            }
        };
    }

    private CalciteAssert.AssertQuery foodmartApprox(String sql) {
        return this.approxQuery(FOODMART, sql);
    }

    private CalciteAssert.AssertQuery wikiApprox(String sql) {
        return this.approxQuery(WIKI, sql);
    }

    private CalciteAssert.AssertQuery approxQuery(URL url, String sql) {
        return CalciteAssert.that().enable(this.enabled()).withModel(url).with((ConnectionProperty)CalciteConnectionProperty.APPROXIMATE_DISTINCT_COUNT, (Object)true).with((ConnectionProperty)CalciteConnectionProperty.APPROXIMATE_TOP_N, (Object)true).with((ConnectionProperty)CalciteConnectionProperty.APPROXIMATE_DECIMAL, (Object)true).query(sql);
    }

    private CalciteAssert.AssertQuery sql(String sql, URL url) {
        return CalciteAssert.that().enable(this.enabled()).withModel(url).query(sql);
    }

    private CalciteAssert.AssertQuery sql(String sql) {
        return this.sql(sql, FOODMART);
    }

    @Test
    public void testSelectDistinctWiki() {
        String explain = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[wiki, wiki]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[=($13, 'Jeremy Corbyn')], groups=[{5}], aggs=[[]])\n";
        this.checkSelectDistinctWiki(WIKI, "wiki").explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[wiki, wiki]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[=($13, 'Jeremy Corbyn')], groups=[{5}], aggs=[[]])\n");
    }

    @Test
    public void testSelectDistinctWikiNoColumns() {
        String explain = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[wiki, wiki]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[=($17, 'Jeremy Corbyn')], groups=[{7}], aggs=[[]])\n";
        this.checkSelectDistinctWiki(WIKI_AUTO, "wiki").explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[wiki, wiki]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[=($17, 'Jeremy Corbyn')], groups=[{7}], aggs=[[]])\n");
    }

    @Test
    public void testSelectDistinctWikiNoTables() {
        String sql = "select distinct \"countryName\"\nfrom \"wikiticker\"\nwhere \"page\" = 'Jeremy Corbyn'";
        String explain = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[wiki, wikiticker]], intervals=[[1900-01-01T00:00:00.000Z/3000-01-01T00:00:00.000Z]], filter=[=($17, 'Jeremy Corbyn')], groups=[{7}], aggs=[[]])\n";
        String druidQuery = "{'queryType':'groupBy','dataSource':'wikiticker','granularity':'all','dimensions':[{'type':'default','dimension':'countryName','outputName':'countryName','outputType':'STRING'}],'limitSpec':{'type':'default'},'filter':{'type':'selector','dimension':'page','value':'Jeremy Corbyn'},'aggregations':[],'intervals':['1900-01-01T00:00:00.000Z/3000-01-01T00:00:00.000Z']}";
        this.sql("select distinct \"countryName\"\nfrom \"wikiticker\"\nwhere \"page\" = 'Jeremy Corbyn'", WIKI_AUTO2).returnsUnordered(new String[]{"countryName=United Kingdom", "countryName=null"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[wiki, wikiticker]], intervals=[[1900-01-01T00:00:00.000Z/3000-01-01T00:00:00.000Z]], filter=[=($17, 'Jeremy Corbyn')], groups=[{7}], aggs=[[]])\n").queryContains(DruidAdapterIT.druidChecker("{'queryType':'groupBy','dataSource':'wikiticker','granularity':'all','dimensions':[{'type':'default','dimension':'countryName','outputName':'countryName','outputType':'STRING'}],'limitSpec':{'type':'default'},'filter':{'type':'selector','dimension':'page','value':'Jeremy Corbyn'},'aggregations':[],'intervals':['1900-01-01T00:00:00.000Z/3000-01-01T00:00:00.000Z']}"));
        this.sql("select count(*) as c from \"foodmart\"", WIKI_AUTO2).returnsUnordered(new String[]{"C=86829"});
    }

    @Test
    public void testSelectTimestampColumnNoTables1() {
        String sql = "select sum(\"added\")\nfrom \"wikiticker\"\ngroup by floor(\"__time\" to DAY)";
        String explain = "PLAN=EnumerableInterpreter\n  BindableProject(EXPR$0=[$1])\n    DruidQuery(table=[[wiki, wikiticker]], intervals=[[1900-01-01T00:00:00.000Z/3000-01-01T00:00:00.000Z]], projects=[[FLOOR($0, FLAG(DAY)), $1]], groups=[{0}], aggs=[[SUM($1)]])\n";
        String druidQuery = "{'queryType':'timeseries','dataSource':'wikiticker','descending':false,'granularity':{'type':'period','period':'P1D','timeZone':'UTC'},'aggregations':[{'type':'longSum','name':'EXPR$0','fieldName':'added'}],'intervals':['1900-01-01T00:00:00.000Z/3000-01-01T00:00:00.000Z'],'context':{'skipEmptyBuckets':true}}";
        this.sql("select sum(\"added\")\nfrom \"wikiticker\"\ngroup by floor(\"__time\" to DAY)", WIKI_AUTO2).explainContains("PLAN=EnumerableInterpreter\n  BindableProject(EXPR$0=[$1])\n    DruidQuery(table=[[wiki, wikiticker]], intervals=[[1900-01-01T00:00:00.000Z/3000-01-01T00:00:00.000Z]], projects=[[FLOOR($0, FLAG(DAY)), $1]], groups=[{0}], aggs=[[SUM($1)]])\n").queryContains(DruidAdapterIT.druidChecker("{'queryType':'timeseries','dataSource':'wikiticker','descending':false,'granularity':{'type':'period','period':'P1D','timeZone':'UTC'},'aggregations':[{'type':'longSum','name':'EXPR$0','fieldName':'added'}],'intervals':['1900-01-01T00:00:00.000Z/3000-01-01T00:00:00.000Z'],'context':{'skipEmptyBuckets':true}}"));
    }

    @Test
    public void testSelectTimestampColumnNoTables2() {
        String sql = "select cast(\"__time\" as timestamp) as \"__time\"\nfrom \"wikiticker\"\nlimit 1\n";
        String explain = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[wiki, wikiticker]], intervals=[[1900-01-01T00:00:00.000Z/3000-01-01T00:00:00.000Z]], projects=[[CAST($0):TIMESTAMP(0) NOT NULL]], fetch=[1])";
        String druidQuery = "{'queryType':'scan','dataSource':'wikiticker','intervals':['1900-01-01T00:00:00.000Z/3000-01-01T00:00:00.000Z'],'columns':['__time'],'granularity':'all','resultFormat':'compactedList','limit':1}";
        this.sql("select cast(\"__time\" as timestamp) as \"__time\"\nfrom \"wikiticker\"\nlimit 1\n", WIKI_AUTO2).returnsUnordered(new String[]{"__time=2015-09-12 00:46:58"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[wiki, wikiticker]], intervals=[[1900-01-01T00:00:00.000Z/3000-01-01T00:00:00.000Z]], projects=[[CAST($0):TIMESTAMP(0) NOT NULL]], fetch=[1])");
    }

    @Test
    public void testSelectTimestampColumnNoTables3() {
        String sql = "select cast(floor(\"__time\" to DAY) as timestamp) as \"day\", sum(\"added\")\nfrom \"wikiticker\"\ngroup by floor(\"__time\" to DAY)";
        String explain = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[wiki, wikiticker]], intervals=[[1900-01-01T00:00:00.000Z/3000-01-01T00:00:00.000Z]], projects=[[FLOOR($0, FLAG(DAY)), $1]], groups=[{0}], aggs=[[SUM($1)]], post_projects=[[CAST($0):TIMESTAMP(0) NOT NULL, $1]])";
        String druidQuery = "{'queryType':'timeseries','dataSource':'wikiticker','descending':false,'granularity':{'type':'period','period':'P1D','timeZone':'UTC'},'aggregations':[{'type':'longSum','name':'EXPR$1','fieldName':'added'}],'intervals':['1900-01-01T00:00:00.000Z/3000-01-01T00:00:00.000Z'],'context':{'skipEmptyBuckets':true}}";
        this.sql("select cast(floor(\"__time\" to DAY) as timestamp) as \"day\", sum(\"added\")\nfrom \"wikiticker\"\ngroup by floor(\"__time\" to DAY)", WIKI_AUTO2).returnsUnordered(new String[]{"day=2015-09-12 00:00:00; EXPR$1=9385573"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[wiki, wikiticker]], intervals=[[1900-01-01T00:00:00.000Z/3000-01-01T00:00:00.000Z]], projects=[[FLOOR($0, FLAG(DAY)), $1]], groups=[{0}], aggs=[[SUM($1)]], post_projects=[[CAST($0):TIMESTAMP(0) NOT NULL, $1]])").queryContains(DruidAdapterIT.druidChecker("{'queryType':'timeseries','dataSource':'wikiticker','descending':false,'granularity':{'type':'period','period':'P1D','timeZone':'UTC'},'aggregations':[{'type':'longSum','name':'EXPR$1','fieldName':'added'}],'intervals':['1900-01-01T00:00:00.000Z/3000-01-01T00:00:00.000Z'],'context':{'skipEmptyBuckets':true}}"));
    }

    @Test
    public void testSelectTimestampColumnNoTables4() {
        String sql = "select sum(\"added\") as \"s\", \"page\", cast(floor(\"__time\" to DAY) as timestamp) as \"day\"\nfrom \"wikiticker\"\ngroup by \"page\", floor(\"__time\" to DAY)\norder by \"s\" desc";
        String explain = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[wiki, wikiticker]], intervals=[[1900-01-01T00:00:00.000Z/3000-01-01T00:00:00.000Z]], projects=[[$17, FLOOR($0, FLAG(DAY)), $1]], groups=[{0, 1}], aggs=[[SUM($2)]], post_projects=[[$2, $0, CAST($1):TIMESTAMP(0) NOT NULL]], sort0=[0], dir0=[DESC])";
        this.sql("select sum(\"added\") as \"s\", \"page\", cast(floor(\"__time\" to DAY) as timestamp) as \"day\"\nfrom \"wikiticker\"\ngroup by \"page\", floor(\"__time\" to DAY)\norder by \"s\" desc", WIKI_AUTO2).limit(1).returnsUnordered(new String[]{"s=199818; page=User:QuackGuru/Electronic cigarettes 1; day=2015-09-12 00:00:00"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[wiki, wikiticker]], intervals=[[1900-01-01T00:00:00.000Z/3000-01-01T00:00:00.000Z]], projects=[[$17, FLOOR($0, FLAG(DAY)), $1]], groups=[{0, 1}], aggs=[[SUM($2)]], post_projects=[[$2, $0, CAST($1):TIMESTAMP(0) NOT NULL]], sort0=[0], dir0=[DESC])").queryContains(DruidAdapterIT.druidChecker("'queryType':'groupBy'", "'limitSpec':{'type':'default','columns':[{'dimension':'s','direction':'descending','dimensionOrder':'numeric'}]}"));
    }

    @Test
    public void testSkipEmptyBuckets() {
        String sql = "select cast(floor(\"__time\" to SECOND) as timestamp) as \"second\", sum(\"added\")\nfrom \"wikiticker\"\nwhere \"page\" = 'Jeremy Corbyn'\ngroup by floor(\"__time\" to SECOND)";
        String druidQuery = "{'queryType':'timeseries','dataSource':'wikiticker','descending':false,'granularity':{'type':'period','period':'PT1S','timeZone':'UTC'},'filter':{'type':'selector','dimension':'page','value':'Jeremy Corbyn'},'aggregations':[{'type':'longSum','name':'EXPR$1','fieldName':'added'}],'intervals':['1900-01-01T00:00:00.000Z/3000-01-01T00:00:00.000Z'],'context':{'skipEmptyBuckets':true}}";
        this.sql("select cast(floor(\"__time\" to SECOND) as timestamp) as \"second\", sum(\"added\")\nfrom \"wikiticker\"\nwhere \"page\" = 'Jeremy Corbyn'\ngroup by floor(\"__time\" to SECOND)", WIKI_AUTO2).limit(1).returnsUnordered(new String[]{"second=2015-09-12 01:20:19; EXPR$1=1075"}).queryContains(DruidAdapterIT.druidChecker("{'queryType':'timeseries','dataSource':'wikiticker','descending':false,'granularity':{'type':'period','period':'PT1S','timeZone':'UTC'},'filter':{'type':'selector','dimension':'page','value':'Jeremy Corbyn'},'aggregations':[{'type':'longSum','name':'EXPR$1','fieldName':'added'}],'intervals':['1900-01-01T00:00:00.000Z/3000-01-01T00:00:00.000Z'],'context':{'skipEmptyBuckets':true}}"));
    }

    private CalciteAssert.AssertQuery checkSelectDistinctWiki(URL url, String tableName) {
        String sql = "select distinct \"countryName\"\nfrom \"" + tableName + "\"\nwhere \"page\" = 'Jeremy Corbyn'";
        String druidQuery = "{'queryType':'groupBy','dataSource':'wikiticker','granularity':'all','dimensions':[{'type':'default','dimension':'countryName','outputName':'countryName','outputType':'STRING'}],'limitSpec':{'type':'default'},'filter':{'type':'selector','dimension':'page','value':'Jeremy Corbyn'},'aggregations':[],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z']}";
        return this.sql(sql, url).returnsUnordered(new String[]{"countryName=United Kingdom", "countryName=null"}).queryContains(DruidAdapterIT.druidChecker("{'queryType':'groupBy','dataSource':'wikiticker','granularity':'all','dimensions':[{'type':'default','dimension':'countryName','outputName':'countryName','outputType':'STRING'}],'limitSpec':{'type':'default'},'filter':{'type':'selector','dimension':'page','value':'Jeremy Corbyn'},'aggregations':[],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z']}"));
    }

    @Test
    public void testFilterTime() {
        String sql = "select cast(\"__time\" as timestamp) as \"__time\"\nfrom \"wikiticker\"\nwhere \"__time\" < '2015-10-12 00:00:00 UTC'";
        String explain = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[wiki, wikiticker]], intervals=[[1900-01-01T00:00:00.000Z/2015-10-12T00:00:00.000Z]], projects=[[CAST($0):TIMESTAMP(0) NOT NULL]])";
        String druidQuery = "{'queryType':'scan','dataSource':'wikiticker','intervals':['1900-01-01T00:00:00.000Z/2015-10-12T00:00:00.000Z'],'virtualColumns':[{'type':'expression','name':'vc','expression':";
        this.sql("select cast(\"__time\" as timestamp) as \"__time\"\nfrom \"wikiticker\"\nwhere \"__time\" < '2015-10-12 00:00:00 UTC'", WIKI_AUTO2).limit(2).returnsUnordered(new String[]{"__time=2015-09-12 00:46:58", "__time=2015-09-12 00:47:00"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[wiki, wikiticker]], intervals=[[1900-01-01T00:00:00.000Z/2015-10-12T00:00:00.000Z]], projects=[[CAST($0):TIMESTAMP(0) NOT NULL]])").queryContains(DruidAdapterIT.druidChecker("{'queryType':'scan','dataSource':'wikiticker','intervals':['1900-01-01T00:00:00.000Z/2015-10-12T00:00:00.000Z'],'virtualColumns':[{'type':'expression','name':'vc','expression':"));
    }

    @Test
    public void testFilterTimeDistinct() {
        String sql = "select CAST(\"c1\" AS timestamp) as \"time\" from\n(select distinct \"__time\" as \"c1\"\nfrom \"wikiticker\"\nwhere \"__time\" < '2015-10-12 00:00:00 UTC')";
        String explain = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[wiki, wikiticker]], intervals=[[1900-01-01T00:00:00.000Z/3000-01-01T00:00:00.000Z]], projects=[[$0]], groups=[{0}], aggs=[[]], filter=[<($0, 2015-10-12 00:00:00)], projects=[[CAST($0):TIMESTAMP(0) NOT NULL]])\n";
        String subDruidQuery = "{'queryType':'groupBy','dataSource':'wikiticker','granularity':'all','dimensions':[{'type':'extraction','dimension':'__time','outputName':'extract','extractionFn':{'type':'timeFormat'";
        this.sql("select CAST(\"c1\" AS timestamp) as \"time\" from\n(select distinct \"__time\" as \"c1\"\nfrom \"wikiticker\"\nwhere \"__time\" < '2015-10-12 00:00:00 UTC')", WIKI_AUTO2).limit(2).returnsUnordered(new String[]{"time=2015-09-12 00:46:58", "time=2015-09-12 00:47:00"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[wiki, wikiticker]], intervals=[[1900-01-01T00:00:00.000Z/3000-01-01T00:00:00.000Z]], projects=[[$0]], groups=[{0}], aggs=[[]], filter=[<($0, 2015-10-12 00:00:00)], projects=[[CAST($0):TIMESTAMP(0) NOT NULL]])\n").queryContains(DruidAdapterIT.druidChecker("{'queryType':'groupBy','dataSource':'wikiticker','granularity':'all','dimensions':[{'type':'extraction','dimension':'__time','outputName':'extract','extractionFn':{'type':'timeFormat'"));
    }

    @Test
    public void testMetadataColumns() throws Exception {
        this.sql("values 1").withConnection(c -> {
            try {
                DatabaseMetaData metaData = c.getMetaData();
                ResultSet r = metaData.getColumns(null, null, "foodmart", null);
                ArrayListMultimap map = ArrayListMultimap.create();
                while (r.next()) {
                    map.put((Object)r.getString("TYPE_NAME"), (Object)true);
                }
                if (CalcitePrepareImpl.DEBUG) {
                    System.out.println(map);
                }
                Assert.assertThat((Object)map.keySet().size(), (Matcher)CoreMatchers.is((Object)4));
                Assert.assertThat((Object)map.values().size(), (Matcher)CoreMatchers.is((Object)92));
                Assert.assertThat((Object)map.get((Object)"TIMESTAMP_WITH_LOCAL_TIME_ZONE(0) NOT NULL").size(), (Matcher)CoreMatchers.is((Object)1));
                Assert.assertThat((Object)map.get((Object)"DOUBLE").size(), (Matcher)CoreMatchers.is((Object)2));
                Assert.assertThat((Object)map.get((Object)"BIGINT").size(), (Matcher)CoreMatchers.is((Object)1));
                Assert.assertThat((Object)map.get((Object)VARCHAR_TYPE).size(), (Matcher)CoreMatchers.is((Object)88));
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Test
    public void testSelectDistinct() {
        String explain = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], groups=[{30}], aggs=[[]])";
        String sql = "select distinct \"state_province\" from \"foodmart\"";
        String druidQuery = "{'queryType':'groupBy','dataSource':'foodmart','granularity':'all','dimensions':[{'type':'default','dimension':'state_province','outputName':'state_province','outputType':'STRING'}],'limitSpec':{'type':'default'},'aggregations':[],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z']}";
        this.sql("select distinct \"state_province\" from \"foodmart\"").returnsUnordered(new String[]{"state_province=CA", "state_province=OR", "state_province=WA"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], groups=[{30}], aggs=[[]])").queryContains(DruidAdapterIT.druidChecker("{'queryType':'groupBy','dataSource':'foodmart','granularity':'all','dimensions':[{'type':'default','dimension':'state_province','outputName':'state_province','outputType':'STRING'}],'limitSpec':{'type':'default'},'aggregations':[],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z']}"));
    }

    @Test
    public void testSelectGroupBySum() {
        String explain = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$30, CAST($89):INTEGER]], groups=[{0}], aggs=[[SUM($1)]])";
        String sql = "select \"state_province\", sum(cast(\"unit_sales\" as integer)) as u\nfrom \"foodmart\"\ngroup by \"state_province\"";
        this.sql("select \"state_province\", sum(cast(\"unit_sales\" as integer)) as u\nfrom \"foodmart\"\ngroup by \"state_province\"").returnsUnordered(new String[]{"state_province=CA; U=74748", "state_province=OR; U=67659", "state_province=WA; U=124366"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$30, CAST($89):INTEGER]], groups=[{0}], aggs=[[SUM($1)]])");
    }

    @Test
    public void testGroupbyMetric() {
        String sql = "select  \"store_sales\" ,\"product_id\" from \"foodmart\" where \"product_id\" = 1020group by \"store_sales\" ,\"product_id\" ";
        String plan = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[=($1, 1020)], projects=[[$90, $1]], groups=[{0, 1}], aggs=[[]])";
        String druidQuery = "{'queryType':'groupBy','dataSource':'foodmart','granularity':'all','dimensions':[{'type':'default','dimension':'store_sales',\"outputName\":\"store_sales\",'outputType':'DOUBLE'},{'type':'default','dimension':'product_id','outputName':'product_id','outputType':'STRING'}],'limitSpec':{'type':'default'},'filter':{'type':'bound','dimension':'product_id','lower':'1020','lowerStrict':false,'upper':'1020','upperStrict':false,'ordering':'numeric'},'aggregations':[],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z']}";
        this.sql("select  \"store_sales\" ,\"product_id\" from \"foodmart\" where \"product_id\" = 1020group by \"store_sales\" ,\"product_id\" ").explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[=($1, 1020)], projects=[[$90, $1]], groups=[{0, 1}], aggs=[[]])").queryContains(DruidAdapterIT.druidChecker("{'queryType':'groupBy','dataSource':'foodmart','granularity':'all','dimensions':[{'type':'default','dimension':'store_sales',\"outputName\":\"store_sales\",'outputType':'DOUBLE'},{'type':'default','dimension':'product_id','outputName':'product_id','outputType':'STRING'}],'limitSpec':{'type':'default'},'filter':{'type':'bound','dimension':'product_id','lower':'1020','lowerStrict':false,'upper':'1020','upperStrict':false,'ordering':'numeric'},'aggregations':[],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z']}")).returnsUnordered(new String[]{"store_sales=0.51; product_id=1020", "store_sales=1.02; product_id=1020", "store_sales=1.53; product_id=1020", "store_sales=2.04; product_id=1020", "store_sales=2.55; product_id=1020"});
    }

    @Test
    public void testPushSimpleGroupBy() {
        String sql = "select \"product_id\" from \"foodmart\" where \"product_id\" = 1020 group by \"product_id\"";
        String druidQuery = "{'queryType':'groupBy','dataSource':'foodmart','granularity':'all','dimensions':[{'type':'default','dimension':'product_id','outputName':'product_id','outputType':'STRING'}],'limitSpec':{'type':'default'},'filter':{'type':'bound','dimension':'product_id','lower':'1020','lowerStrict':false,'upper':'1020','upperStrict':false,'ordering':'numeric'},'aggregations':[],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z']}";
        this.sql("select \"product_id\" from \"foodmart\" where \"product_id\" = 1020 group by \"product_id\"").returnsUnordered(new String[]{"product_id=1020"}).queryContains(DruidAdapterIT.druidChecker("{'queryType':'groupBy','dataSource':'foodmart','granularity':'all','dimensions':[{'type':'default','dimension':'product_id','outputName':'product_id','outputType':'STRING'}],'limitSpec':{'type':'default'},'filter':{'type':'bound','dimension':'product_id','lower':'1020','lowerStrict':false,'upper':'1020','upperStrict':false,'ordering':'numeric'},'aggregations':[],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z']}"));
    }

    @Test
    public void testComplexPushGroupBy() {
        String innerQuery = "select \"product_id\" as \"id\" from \"foodmart\" where \"product_id\" = 1020";
        String sql = "select \"id\" from (select \"product_id\" as \"id\" from \"foodmart\" where \"product_id\" = 1020) group by \"id\"";
        String druidQuery = "{'queryType':'groupBy','dataSource':'foodmart','granularity':'all','dimensions':[{'type':'default','dimension':'product_id','outputName':'product_id','outputType':'STRING'}],'limitSpec':{'type':'default'},'filter':{'type':'bound','dimension':'product_id','lower':'1020','lowerStrict':false,'upper':'1020','upperStrict':false,'ordering':'numeric'},'aggregations':[],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z']}";
        this.sql("select \"id\" from (select \"product_id\" as \"id\" from \"foodmart\" where \"product_id\" = 1020) group by \"id\"").returnsUnordered(new String[]{"id=1020"}).queryContains(DruidAdapterIT.druidChecker("{'queryType':'groupBy','dataSource':'foodmart','granularity':'all','dimensions':[{'type':'default','dimension':'product_id','outputName':'product_id','outputType':'STRING'}],'limitSpec':{'type':'default'},'filter':{'type':'bound','dimension':'product_id','lower':'1020','lowerStrict':false,'upper':'1020','upperStrict':false,'ordering':'numeric'},'aggregations':[],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z']}"));
    }

    @Test
    public void testSelectCount() {
        String sql = "select count(*) as c from \"foodmart\"";
        this.sql("select count(*) as c from \"foodmart\"").returns(input -> {
            try {
                Assert.assertThat((Object)input.next(), (Matcher)CoreMatchers.is((Object)true));
                Assert.assertThat((Object)input.getInt(1), (Matcher)CoreMatchers.is((Object)86829));
                Assert.assertThat((Object)input.getLong(1), (Matcher)CoreMatchers.is((Object)86829L));
                Assert.assertThat((Object)input.getString(1), (Matcher)CoreMatchers.is((Object)"86829"));
                Assert.assertThat((Object)input.wasNull(), (Matcher)CoreMatchers.is((Object)false));
                Assert.assertThat((Object)input.next(), (Matcher)CoreMatchers.is((Object)false));
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Test
    public void testSort() {
        String explain = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$39, $30]], groups=[{0, 1}], aggs=[[]], sort0=[1], sort1=[0], dir0=[ASC], dir1=[DESC])";
        String sql = "select distinct \"gender\", \"state_province\"\nfrom \"foodmart\" order by 2, 1 desc";
        this.sql("select distinct \"gender\", \"state_province\"\nfrom \"foodmart\" order by 2, 1 desc").returnsOrdered(new String[]{"gender=M; state_province=CA", "gender=F; state_province=CA", "gender=M; state_province=OR", "gender=F; state_province=OR", "gender=M; state_province=WA", "gender=F; state_province=WA"}).queryContains(DruidAdapterIT.druidChecker("{'queryType':'groupBy','dataSource':'foodmart','granularity':'all','dimensions':[{'type':'default','dimension':'gender','outputName':'gender','outputType':'STRING'},{'type':'default','dimension':'state_province','outputName':'state_province','outputType':'STRING'}],'limitSpec':{'type':'default','columns':[{'dimension':'state_province','direction':'ascending','dimensionOrder':'lexicographic'},{'dimension':'gender','direction':'descending','dimensionOrder':'lexicographic'}]},'aggregations':[],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z']}")).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$39, $30]], groups=[{0, 1}], aggs=[[]], sort0=[1], sort1=[0], dir0=[ASC], dir1=[DESC])");
    }

    @Test
    public void testSortLimit() {
        String explain = "PLAN=EnumerableInterpreter\n  BindableSort(sort0=[$1], sort1=[$0], dir0=[ASC], dir1=[DESC], offset=[2], fetch=[3])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$39, $30]], groups=[{0, 1}], aggs=[[]], sort0=[1], sort1=[0], dir0=[ASC], dir1=[DESC])";
        String sql = "select distinct \"gender\", \"state_province\"\nfrom \"foodmart\"\norder by 2, 1 desc offset 2 rows fetch next 3 rows only";
        this.sql("select distinct \"gender\", \"state_province\"\nfrom \"foodmart\"\norder by 2, 1 desc offset 2 rows fetch next 3 rows only").returnsOrdered(new String[]{"gender=M; state_province=OR", "gender=F; state_province=OR", "gender=M; state_province=WA"}).explainContains("PLAN=EnumerableInterpreter\n  BindableSort(sort0=[$1], sort1=[$0], dir0=[ASC], dir1=[DESC], offset=[2], fetch=[3])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$39, $30]], groups=[{0, 1}], aggs=[[]], sort0=[1], sort1=[0], dir0=[ASC], dir1=[DESC])");
    }

    @Test
    public void testOffsetLimit() {
        String sql = "select \"state_province\", \"product_name\"\nfrom \"foodmart\"\noffset 2 fetch next 3 rows only";
        String druidQuery = "{'queryType':'scan','dataSource':'foodmart','intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'columns':['state_province','product_name'],'resultFormat':'compactedList'}";
        this.sql("select \"state_province\", \"product_name\"\nfrom \"foodmart\"\noffset 2 fetch next 3 rows only").runs().queryContains(DruidAdapterIT.druidChecker("{'queryType':'scan','dataSource':'foodmart','intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'columns':['state_province','product_name'],'resultFormat':'compactedList'}"));
    }

    @Test
    public void testLimit() {
        String sql = "select \"gender\", \"state_province\"\nfrom \"foodmart\" fetch next 3 rows only";
        String druidQuery = "{'queryType':'scan','dataSource':'foodmart','intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'columns':['gender','state_province'],'resultFormat':'compactedList','limit':3";
        this.sql("select \"gender\", \"state_province\"\nfrom \"foodmart\" fetch next 3 rows only").runs().queryContains(DruidAdapterIT.druidChecker("{'queryType':'scan','dataSource':'foodmart','intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'columns':['gender','state_province'],'resultFormat':'compactedList','limit':3"));
    }

    @Test
    public void testDistinctLimit() {
        String sql = "select distinct \"gender\", \"state_province\"\nfrom \"foodmart\" fetch next 3 rows only";
        String druidQuery = "{'queryType':'groupBy','dataSource':'foodmart','granularity':'all','dimensions':[{'type':'default','dimension':'gender','outputName':'gender','outputType':'STRING'},{'type':'default','dimension':'state_province','outputName':'state_province','outputType':'STRING'}],'limitSpec':{'type':'default','limit':3,'columns':[]},'aggregations':[],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z']}";
        String explain = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$39, $30]], groups=[{0, 1}], aggs=[[]], fetch=[3])";
        this.sql("select distinct \"gender\", \"state_province\"\nfrom \"foodmart\" fetch next 3 rows only").runs().explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$39, $30]], groups=[{0, 1}], aggs=[[]], fetch=[3])").queryContains(DruidAdapterIT.druidChecker("{'queryType':'groupBy','dataSource':'foodmart','granularity':'all','dimensions':[{'type':'default','dimension':'gender','outputName':'gender','outputType':'STRING'},{'type':'default','dimension':'state_province','outputName':'state_province','outputType':'STRING'}],'limitSpec':{'type':'default','limit':3,'columns':[]},'aggregations':[],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z']}")).returnsUnordered(new String[]{"gender=F; state_province=CA", "gender=F; state_province=OR", "gender=F; state_province=WA"});
    }

    @Test
    public void testGroupBySortLimit() {
        String sql = "select \"brand_name\", \"gender\", sum(\"unit_sales\") as s\nfrom \"foodmart\"\ngroup by \"brand_name\", \"gender\"\norder by s desc limit 3";
        String druidQuery = "{'queryType':'groupBy','dataSource':'foodmart','granularity':'all','dimensions':[{'type':'default','dimension':'brand_name','outputName':'brand_name','outputType':'STRING'},{'type':'default','dimension':'gender','outputName':'gender','outputType':'STRING'}],'limitSpec':{'type':'default','limit':3,'columns':[{'dimension':'S','direction':'descending','dimensionOrder':'numeric'}]},'aggregations':[{'type':'longSum','name':'S','fieldName':'unit_sales'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z']}";
        String explain = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$2, $39, $89]], groups=[{0, 1}], aggs=[[SUM($2)]], sort0=[2], dir0=[DESC], fetch=[3])";
        this.sql("select \"brand_name\", \"gender\", sum(\"unit_sales\") as s\nfrom \"foodmart\"\ngroup by \"brand_name\", \"gender\"\norder by s desc limit 3").runs().returnsOrdered(new String[]{"brand_name=Hermanos; gender=M; S=4286", "brand_name=Hermanos; gender=F; S=4183", "brand_name=Tell Tale; gender=F; S=4033"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$2, $39, $89]], groups=[{0, 1}], aggs=[[SUM($2)]], sort0=[2], dir0=[DESC], fetch=[3])").queryContains(DruidAdapterIT.druidChecker("{'queryType':'groupBy','dataSource':'foodmart','granularity':'all','dimensions':[{'type':'default','dimension':'brand_name','outputName':'brand_name','outputType':'STRING'},{'type':'default','dimension':'gender','outputName':'gender','outputType':'STRING'}],'limitSpec':{'type':'default','limit':3,'columns':[{'dimension':'S','direction':'descending','dimensionOrder':'numeric'}]},'aggregations':[{'type':'longSum','name':'S','fieldName':'unit_sales'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z']}"));
    }

    @Test
    public void testGroupBySingleSortLimit() {
        this.checkGroupBySingleSortLimit(false);
    }

    @Test
    public void testGroupBySingleSortLimitApprox() {
        this.checkGroupBySingleSortLimit(true);
    }

    private void checkGroupBySingleSortLimit(boolean approx) {
        String sql = "select \"brand_name\", sum(\"unit_sales\") as s\nfrom \"foodmart\"\ngroup by \"brand_name\"\norder by s desc limit 3";
        String approxDruid = "{'queryType':'topN','dataSource':'foodmart','granularity':'all','dimension':{'type':'default','dimension':'brand_name','outputName':'brand_name','outputType':'STRING'},'metric':'S','aggregations':[{'type':'longSum','name':'S','fieldName':'unit_sales'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'threshold':3}";
        String exactDruid = "{'queryType':'groupBy','dataSource':'foodmart','granularity':'all','dimensions':[{'type':'default','dimension':'brand_name','outputName':'brand_name','outputType':'STRING'}],'limitSpec':{'type':'default','limit':3,'columns':[{'dimension':'S','direction':'descending','dimensionOrder':'numeric'}]},'aggregations':[{'type':'longSum','name':'S','fieldName':'unit_sales'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z']}";
        String druidQuery = approx ? "{'queryType':'topN','dataSource':'foodmart','granularity':'all','dimension':{'type':'default','dimension':'brand_name','outputName':'brand_name','outputType':'STRING'},'metric':'S','aggregations':[{'type':'longSum','name':'S','fieldName':'unit_sales'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'threshold':3}" : "{'queryType':'groupBy','dataSource':'foodmart','granularity':'all','dimensions':[{'type':'default','dimension':'brand_name','outputName':'brand_name','outputType':'STRING'}],'limitSpec':{'type':'default','limit':3,'columns':[{'dimension':'S','direction':'descending','dimensionOrder':'numeric'}]},'aggregations':[{'type':'longSum','name':'S','fieldName':'unit_sales'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z']}";
        String explain = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$2, $89]], groups=[{0}], aggs=[[SUM($1)]], sort0=[1], dir0=[DESC], fetch=[3])";
        CalciteAssert.that().enable(this.enabled()).withModel(FOODMART).with((ConnectionProperty)CalciteConnectionProperty.APPROXIMATE_TOP_N, (Object)approx).query("select \"brand_name\", sum(\"unit_sales\") as s\nfrom \"foodmart\"\ngroup by \"brand_name\"\norder by s desc limit 3").runs().returnsOrdered(new String[]{"brand_name=Hermanos; S=8469", "brand_name=Tell Tale; S=7877", "brand_name=Ebony; S=7438"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$2, $89]], groups=[{0}], aggs=[[SUM($1)]], sort0=[1], dir0=[DESC], fetch=[3])").queryContains(DruidAdapterIT.druidChecker(druidQuery));
    }

    @Test
    public void testGroupByDaySortDescLimit() {
        String sql = "select \"brand_name\", cast(floor(\"timestamp\" to DAY) as timestamp) as d, sum(\"unit_sales\") as s\nfrom \"foodmart\"\ngroup by \"brand_name\", floor(\"timestamp\" to DAY)\norder by s desc limit 30";
        String explain = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$2, FLOOR($0, FLAG(DAY)), $89]], groups=[{0, 1}], aggs=[[SUM($2)]], post_projects=[[$0, CAST($1):TIMESTAMP(0) NOT NULL, $2]], sort0=[2], dir0=[DESC], fetch=[30])";
        this.sql("select \"brand_name\", cast(floor(\"timestamp\" to DAY) as timestamp) as d, sum(\"unit_sales\") as s\nfrom \"foodmart\"\ngroup by \"brand_name\", floor(\"timestamp\" to DAY)\norder by s desc limit 30").runs().returnsStartingWith(new String[]{"brand_name=Ebony; D=1997-07-27 00:00:00; S=135", "brand_name=Tri-State; D=1997-05-09 00:00:00; S=120", "brand_name=Hermanos; D=1997-05-09 00:00:00; S=115"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$2, FLOOR($0, FLAG(DAY)), $89]], groups=[{0, 1}], aggs=[[SUM($2)]], post_projects=[[$0, CAST($1):TIMESTAMP(0) NOT NULL, $2]], sort0=[2], dir0=[DESC], fetch=[30])").queryContains(DruidAdapterIT.druidChecker("'queryType':'groupBy'", "'granularity':'all'", "'limitSpec':{'type':'default','limit':30,'columns':[{'dimension':'S','direction':'descending','dimensionOrder':'numeric'}]}"));
    }

    @Test
    public void testGroupByDaySortLimit() {
        String sql = "select \"brand_name\", cast(floor(\"timestamp\" to DAY) as timestamp) as d, sum(\"unit_sales\") as s\nfrom \"foodmart\"\ngroup by \"brand_name\", floor(\"timestamp\" to DAY)\norder by s desc limit 30";
        String druidQueryPart1 = "{'queryType':'groupBy','dataSource':'foodmart'";
        String druidQueryPart2 = "'limitSpec':{'type':'default','limit':30,'columns':[{'dimension':'S','direction':'descending','dimensionOrder':'numeric'}]},'aggregations':[{'type':'longSum','name':'S','fieldName':'unit_sales'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z']}";
        String explain = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$2, FLOOR($0, FLAG(DAY)), $89]], groups=[{0, 1}], aggs=[[SUM($2)]], post_projects=[[$0, CAST($1):TIMESTAMP(0) NOT NULL, $2]], sort0=[2], dir0=[DESC], fetch=[30])";
        this.sql("select \"brand_name\", cast(floor(\"timestamp\" to DAY) as timestamp) as d, sum(\"unit_sales\") as s\nfrom \"foodmart\"\ngroup by \"brand_name\", floor(\"timestamp\" to DAY)\norder by s desc limit 30").runs().returnsStartingWith(new String[]{"brand_name=Ebony; D=1997-07-27 00:00:00; S=135", "brand_name=Tri-State; D=1997-05-09 00:00:00; S=120", "brand_name=Hermanos; D=1997-05-09 00:00:00; S=115"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$2, FLOOR($0, FLAG(DAY)), $89]], groups=[{0, 1}], aggs=[[SUM($2)]], post_projects=[[$0, CAST($1):TIMESTAMP(0) NOT NULL, $2]], sort0=[2], dir0=[DESC], fetch=[30])").queryContains(DruidAdapterIT.druidChecker("{'queryType':'groupBy','dataSource':'foodmart'", "'limitSpec':{'type':'default','limit':30,'columns':[{'dimension':'S','direction':'descending','dimensionOrder':'numeric'}]},'aggregations':[{'type':'longSum','name':'S','fieldName':'unit_sales'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z']}"));
    }

    @Test
    public void testGroupByDaySortDimension() {
        String sql = "select \"brand_name\", cast(floor(\"timestamp\" to DAY) as timestamp) as d, sum(\"unit_sales\") as s\nfrom \"foodmart\"\ngroup by \"brand_name\", floor(\"timestamp\" to DAY)\norder by \"brand_name\"";
        String subDruidQuery = "{'queryType':'groupBy','dataSource':'foodmart','granularity':'all','dimensions':[{'type':'default','dimension':'brand_name','outputName':'brand_name','outputType':'STRING'},{'type':'extraction','dimension':'__time','outputName':'floor_day','extractionFn':{'type':'timeFormat'";
        String explain = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$2, FLOOR($0, FLAG(DAY)), $89]], groups=[{0, 1}], aggs=[[SUM($2)]], post_projects=[[$0, CAST($1):TIMESTAMP(0) NOT NULL, $2]], sort0=[0], dir0=[ASC])";
        this.sql("select \"brand_name\", cast(floor(\"timestamp\" to DAY) as timestamp) as d, sum(\"unit_sales\") as s\nfrom \"foodmart\"\ngroup by \"brand_name\", floor(\"timestamp\" to DAY)\norder by \"brand_name\"").runs().returnsStartingWith(new String[]{"brand_name=ADJ; D=1997-01-11 00:00:00; S=2", "brand_name=ADJ; D=1997-01-12 00:00:00; S=3", "brand_name=ADJ; D=1997-01-17 00:00:00; S=3"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$2, FLOOR($0, FLAG(DAY)), $89]], groups=[{0, 1}], aggs=[[SUM($2)]], post_projects=[[$0, CAST($1):TIMESTAMP(0) NOT NULL, $2]], sort0=[0], dir0=[ASC])").queryContains(DruidAdapterIT.druidChecker("{'queryType':'groupBy','dataSource':'foodmart','granularity':'all','dimensions':[{'type':'default','dimension':'brand_name','outputName':'brand_name','outputType':'STRING'},{'type':'extraction','dimension':'__time','outputName':'floor_day','extractionFn':{'type':'timeFormat'"));
    }

    @Test
    public void testFilterSortDesc() {
        String sql = "select \"product_name\" from \"foodmart\"\nwhere \"product_id\" BETWEEN '1500' AND '1502'\norder by \"state_province\" desc, \"product_id\"";
        String druidQuery = "{'queryType':'scan','dataSource':'foodmart','intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'filter':{'type':'and','fields':[{'type':'bound','dimension':'product_id','lower':'1500','lowerStrict':false,'ordering':'lexicographic'},{'type':'bound','dimension':'product_id','upper':'1502','upperStrict':false,'ordering':'lexicographic'}]},'columns':['product_name','state_province','product_id'],'resultFormat':'compactedList'";
        this.sql("select \"product_name\" from \"foodmart\"\nwhere \"product_id\" BETWEEN '1500' AND '1502'\norder by \"state_province\" desc, \"product_id\"").limit(4).returns(resultSet -> {
            try {
                for (int i = 0; i < 4; ++i) {
                    Assert.assertTrue((boolean)resultSet.next());
                    Assert.assertThat((Object)resultSet.getString("product_name"), (Matcher)CoreMatchers.is((Object)"Fort West Dried Apricots"));
                }
                Assert.assertFalse((boolean)resultSet.next());
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }).queryContains(DruidAdapterIT.druidChecker("{'queryType':'scan','dataSource':'foodmart','intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'filter':{'type':'and','fields':[{'type':'bound','dimension':'product_id','lower':'1500','lowerStrict':false,'ordering':'lexicographic'},{'type':'bound','dimension':'product_id','upper':'1502','upperStrict':false,'ordering':'lexicographic'}]},'columns':['product_name','state_province','product_id'],'resultFormat':'compactedList'"));
    }

    @Test
    public void testFilterSortDescNumeric() {
        String sql = "select \"product_name\" from \"foodmart\"\nwhere \"product_id\" BETWEEN 1500 AND 1502\norder by \"state_province\" desc, \"product_id\"";
        String druidQuery = "{'queryType':'scan','dataSource':'foodmart','intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'filter':{'type':'and','fields':[{'type':'bound','dimension':'product_id','lower':'1500','lowerStrict':false,'ordering':'numeric'},{'type':'bound','dimension':'product_id','upper':'1502','upperStrict':false,'ordering':'numeric'}]},'columns':['product_name','state_province','product_id'],'resultFormat':'compactedList'";
        this.sql("select \"product_name\" from \"foodmart\"\nwhere \"product_id\" BETWEEN 1500 AND 1502\norder by \"state_province\" desc, \"product_id\"").limit(4).returns(resultSet -> {
            try {
                for (int i = 0; i < 4; ++i) {
                    Assert.assertTrue((boolean)resultSet.next());
                    Assert.assertThat((Object)resultSet.getString("product_name"), (Matcher)CoreMatchers.is((Object)"Fort West Dried Apricots"));
                }
                Assert.assertFalse((boolean)resultSet.next());
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }).queryContains(DruidAdapterIT.druidChecker("{'queryType':'scan','dataSource':'foodmart','intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'filter':{'type':'and','fields':[{'type':'bound','dimension':'product_id','lower':'1500','lowerStrict':false,'ordering':'numeric'},{'type':'bound','dimension':'product_id','upper':'1502','upperStrict':false,'ordering':'numeric'}]},'columns':['product_name','state_province','product_id'],'resultFormat':'compactedList'"));
    }

    @Test
    public void testFilterOutEverything() {
        String sql = "select \"product_name\" from \"foodmart\"\nwhere \"product_id\" = -1";
        String druidQuery = "{'queryType':'scan','dataSource':'foodmart','intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'filter':{'type':'bound','dimension':'product_id','lower':'-1','lowerStrict':false,'upper':'-1','upperStrict':false,'ordering':'numeric'},'columns':['product_name'],'resultFormat':'compactedList'}";
        this.sql("select \"product_name\" from \"foodmart\"\nwhere \"product_id\" = -1").limit(4).returnsUnordered(new String[0]).queryContains(DruidAdapterIT.druidChecker("{'queryType':'scan','dataSource':'foodmart','intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'filter':{'type':'bound','dimension':'product_id','lower':'-1','lowerStrict':false,'upper':'-1','upperStrict':false,'ordering':'numeric'},'columns':['product_name'],'resultFormat':'compactedList'}"));
    }

    @Test
    public void testNonPushableFilterSortDesc() {
        String sql = "select \"product_name\" from \"foodmart\"\nwhere cast(\"product_id\" as integer) - 1500 BETWEEN 0 AND 2\norder by \"state_province\" desc, \"product_id\"";
        String druidQuery = "{'queryType':'scan','dataSource':'foodmart','intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],";
        String druidFilter = "\"filter\":{\"type\":\"and\",\"fields\":[{\"type\":\"expression\",\"expression\":\"((CAST(\\\"product_id\\\"";
        String druidQuery2 = "'columns':['product_name','state_province','product_id'],'resultFormat':'compactedList'}";
        this.sql("select \"product_name\" from \"foodmart\"\nwhere cast(\"product_id\" as integer) - 1500 BETWEEN 0 AND 2\norder by \"state_province\" desc, \"product_id\"").limit(4).returns(resultSet -> {
            try {
                for (int i = 0; i < 4; ++i) {
                    Assert.assertTrue((boolean)resultSet.next());
                    Assert.assertThat((Object)resultSet.getString("product_name"), (Matcher)CoreMatchers.is((Object)"Fort West Dried Apricots"));
                }
                Assert.assertFalse((boolean)resultSet.next());
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }).queryContains(DruidAdapterIT.druidChecker("{'queryType':'scan','dataSource':'foodmart','intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],", "\"filter\":{\"type\":\"and\",\"fields\":[{\"type\":\"expression\",\"expression\":\"((CAST(\\\"product_id\\\"", "'columns':['product_name','state_province','product_id'],'resultFormat':'compactedList'}"));
    }

    @Test
    public void testUnionPlan() {
        String sql = "select distinct \"gender\" from \"foodmart\"\nunion all\nselect distinct \"marital_status\" from \"foodmart\"";
        String explain = "PLAN=EnumerableInterpreter\n  BindableUnion(all=[true])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], groups=[{39}], aggs=[[]])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], groups=[{37}], aggs=[[]])";
        this.sql("select distinct \"gender\" from \"foodmart\"\nunion all\nselect distinct \"marital_status\" from \"foodmart\"").explainContains("PLAN=EnumerableInterpreter\n  BindableUnion(all=[true])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], groups=[{39}], aggs=[[]])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], groups=[{37}], aggs=[[]])").returnsUnordered(new String[]{"gender=F", "gender=M", "gender=M", "gender=S"});
    }

    @Test
    public void testFilterUnionPlan() {
        String sql = "select * from (\n  select distinct \"gender\" from \"foodmart\"\n  union all\n  select distinct \"marital_status\" from \"foodmart\")\nwhere \"gender\" = 'M'";
        String explain = "PLAN=EnumerableInterpreter\n  BindableFilter(condition=[=($0, 'M')])\n    BindableUnion(all=[true])\n      DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], groups=[{39}], aggs=[[]])\n      DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], groups=[{37}], aggs=[[]])";
        this.sql("select * from (\n  select distinct \"gender\" from \"foodmart\"\n  union all\n  select distinct \"marital_status\" from \"foodmart\")\nwhere \"gender\" = 'M'").explainContains("PLAN=EnumerableInterpreter\n  BindableFilter(condition=[=($0, 'M')])\n    BindableUnion(all=[true])\n      DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], groups=[{39}], aggs=[[]])\n      DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], groups=[{37}], aggs=[[]])").returnsUnordered(new String[]{"gender=M", "gender=M"});
    }

    @Test
    public void testCountGroupByEmpty() {
        String druidQuery = "{'queryType':'timeseries','dataSource':'foodmart','descending':false,'granularity':'all','aggregations':[{'type':'count','name':'EXPR$0'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'context':{'skipEmptyBuckets':false}}";
        String explain = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[0]], groups=[{}], aggs=[[COUNT()]])";
        String sql = "select count(*) from \"foodmart\"";
        this.sql("select count(*) from \"foodmart\"").returns("EXPR$0=86829\n").queryContains(DruidAdapterIT.druidChecker("{'queryType':'timeseries','dataSource':'foodmart','descending':false,'granularity':'all','aggregations':[{'type':'count','name':'EXPR$0'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'context':{'skipEmptyBuckets':false}}")).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[0]], groups=[{}], aggs=[[COUNT()]])");
    }

    @Test
    public void testGroupByOneColumnNotProjected() {
        String sql = "select count(*) as c from \"foodmart\"\ngroup by \"state_province\" order by 1";
        this.sql("select count(*) as c from \"foodmart\"\ngroup by \"state_province\" order by 1").returnsOrdered(new String[]{"C=21610", "C=24441", "C=40778"});
    }

    @Test
    public void testGroupByTimeAndOneColumnNotProjectedWithLimit() {
        String sql = "select count(*) as \"c\", cast(floor(\"timestamp\" to MONTH) as timestamp) as \"month\"\nfrom \"foodmart\"\ngroup by floor(\"timestamp\" to MONTH), \"state_province\"\norder by \"c\" desc limit 3";
        this.sql("select count(*) as \"c\", cast(floor(\"timestamp\" to MONTH) as timestamp) as \"month\"\nfrom \"foodmart\"\ngroup by floor(\"timestamp\" to MONTH), \"state_province\"\norder by \"c\" desc limit 3").returnsOrdered(new String[]{"c=4070; month=1997-12-01 00:00:00", "c=4033; month=1997-11-01 00:00:00", "c=3511; month=1997-07-01 00:00:00"}).queryContains(DruidAdapterIT.druidChecker("'queryType':'groupBy'"));
    }

    @Test
    public void testGroupByTimeAndOneMetricNotProjected() {
        String sql = "select count(*) as \"c\", cast(floor(\"timestamp\" to MONTH) as timestamp) as \"month\", floor(\"store_sales\") as sales\nfrom \"foodmart\"\ngroup by floor(\"timestamp\" to MONTH), \"state_province\", floor(\"store_sales\")\norder by \"c\" desc limit 3";
        this.sql("select count(*) as \"c\", cast(floor(\"timestamp\" to MONTH) as timestamp) as \"month\", floor(\"store_sales\") as sales\nfrom \"foodmart\"\ngroup by floor(\"timestamp\" to MONTH), \"state_province\", floor(\"store_sales\")\norder by \"c\" desc limit 3").returnsOrdered(new String[]{"c=494; month=1997-11-01 00:00:00; SALES=5.0", "c=475; month=1997-12-01 00:00:00; SALES=5.0", "c=468; month=1997-03-01 00:00:00; SALES=5.0"}).queryContains(DruidAdapterIT.druidChecker("'queryType':'groupBy'"));
    }

    @Test
    public void testGroupByTimeAndOneColumnNotProjected() {
        String sql = "select count(*) as \"c\",\n  cast(floor(\"timestamp\" to MONTH) as timestamp) as \"month\"\nfrom \"foodmart\"\ngroup by floor(\"timestamp\" to MONTH), \"state_province\"\nhaving count(*) > 3500";
        this.sql("select count(*) as \"c\",\n  cast(floor(\"timestamp\" to MONTH) as timestamp) as \"month\"\nfrom \"foodmart\"\ngroup by floor(\"timestamp\" to MONTH), \"state_province\"\nhaving count(*) > 3500").returnsUnordered(new String[]{"c=3511; month=1997-07-01 00:00:00", "c=4033; month=1997-11-01 00:00:00", "c=4070; month=1997-12-01 00:00:00"}).queryContains(DruidAdapterIT.druidChecker("'queryType':'groupBy'"));
    }

    @Test
    public void testOrderByOneColumnNotProjected() {
        String sql = "select count(*) as c from \"foodmart\"\ngroup by \"state_province\" order by \"state_province\"";
        this.sql("select count(*) as c from \"foodmart\"\ngroup by \"state_province\" order by \"state_province\"").returnsOrdered(new String[]{"C=24441", "C=21610", "C=40778"});
    }

    @Test
    public void testGroupByOneColumn() {
        String sql = "select \"state_province\", count(*) as c\nfrom \"foodmart\"\ngroup by \"state_province\"\norder by \"state_province\"";
        String explain = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$30]], groups=[{0}], aggs=[[COUNT()]], sort0=[0], dir0=[ASC])";
        this.sql("select \"state_province\", count(*) as c\nfrom \"foodmart\"\ngroup by \"state_province\"\norder by \"state_province\"").limit(2).returnsOrdered(new String[]{"state_province=CA; C=24441", "state_province=OR; C=21610"}).explainContains(explain);
    }

    @Test
    public void testGroupByOneColumnReversed() {
        String sql = "select count(*) as c, \"state_province\"\nfrom \"foodmart\"\ngroup by \"state_province\"\norder by \"state_province\"";
        this.sql("select count(*) as c, \"state_province\"\nfrom \"foodmart\"\ngroup by \"state_province\"\norder by \"state_province\"").limit(2).returnsOrdered(new String[]{"C=24441; state_province=CA", "C=21610; state_province=OR"});
    }

    @Test
    public void testGroupByAvgSumCount() {
        String sql = "select \"state_province\",\n avg(\"unit_sales\") as a,\n sum(\"unit_sales\") as s,\n count(\"store_sqft\") as c,\n count(*) as c0\nfrom \"foodmart\"\ngroup by \"state_province\"\norder by 1";
        this.sql("select \"state_province\",\n avg(\"unit_sales\") as a,\n sum(\"unit_sales\") as s,\n count(\"store_sqft\") as c,\n count(*) as c0\nfrom \"foodmart\"\ngroup by \"state_province\"\norder by 1").limit(2).returnsUnordered(new String[]{"state_province=CA; A=3; S=74748; C=16347; C0=24441", "state_province=OR; A=3; S=67659; C=21610; C0=21610"}).explainContains("PLAN=EnumerableInterpreter\n  BindableProject(state_province=[$0], A=[CAST(/(CASE(=($2, 0), null, $1), $2)):BIGINT], S=[CASE(=($2, 0), null, $1)], C=[$3], C0=[$4])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$30, $89, $71]], groups=[{0}], aggs=[[$SUM0($1), COUNT($1), COUNT($2), COUNT()]], sort0=[0], dir0=[ASC])").queryContains(DruidAdapterIT.druidChecker("{'queryType':'groupBy','dataSource':'foodmart','granularity':'all','dimensions':[{'type':'default','dimension':'state_province','outputName':'state_province','outputType':'STRING'}],'limitSpec':{'type':'default','columns':[{'dimension':'state_province','direction':'ascending','dimensionOrder':'lexicographic'}]},'aggregations':[{'type':'longSum','name':'$f1','fieldName':'unit_sales'},{'type':'filtered','filter':{'type':'not','field':{'type':'selector','dimension':'unit_sales','value':null}},'aggregator':{'type':'count','name':'$f2','fieldName':'unit_sales'}},{'type':'filtered','filter':{'type':'not','field':{'type':'selector','dimension':'store_sqft','value':null}},'aggregator':{'type':'count','name':'C','fieldName':'store_sqft'}},{'type':'count','name':'C0'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z']}"));
    }

    @Test
    public void testGroupByMonthGranularity() {
        String sql = "select sum(\"unit_sales\") as s,\n count(\"store_sqft\") as c\nfrom \"foodmart\"\ngroup by floor(\"timestamp\" to MONTH) order by s";
        String druidQuery = "{'queryType':'groupBy','dataSource':'foodmart'";
        this.sql("select sum(\"unit_sales\") as s,\n count(\"store_sqft\") as c\nfrom \"foodmart\"\ngroup by floor(\"timestamp\" to MONTH) order by s").limit(3).explainContains("PLAN=EnumerableInterpreter\n  BindableProject(S=[$1], C=[$2])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[FLOOR($0, FLAG(MONTH)), $89, $71]], groups=[{0}], aggs=[[SUM($1), COUNT($2)]], sort0=[1], dir0=[ASC])").returnsOrdered(new String[]{"S=19958; C=5606", "S=20179; C=5523", "S=20388; C=5591"}).queryContains(DruidAdapterIT.druidChecker(druidQuery));
    }

    @Test
    public void testGroupByMonthGranularitySort() {
        String sql = "select sum(\"unit_sales\") as s,\n count(\"store_sqft\") as c\nfrom \"foodmart\"\ngroup by floor(\"timestamp\" to MONTH)\norder by floor(\"timestamp\" to MONTH) ASC";
        String explain = "PLAN=EnumerableInterpreter\n  BindableProject(S=[$1], C=[$2], EXPR$2=[$0])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[FLOOR($0, FLAG(MONTH)), $89, $71]], groups=[{0}], aggs=[[SUM($1), COUNT($2)]], sort0=[0], dir0=[ASC])";
        this.sql("select sum(\"unit_sales\") as s,\n count(\"store_sqft\") as c\nfrom \"foodmart\"\ngroup by floor(\"timestamp\" to MONTH)\norder by floor(\"timestamp\" to MONTH) ASC").explainContains("PLAN=EnumerableInterpreter\n  BindableProject(S=[$1], C=[$2], EXPR$2=[$0])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[FLOOR($0, FLAG(MONTH)), $89, $71]], groups=[{0}], aggs=[[SUM($1), COUNT($2)]], sort0=[0], dir0=[ASC])").returnsOrdered(new String[]{"S=21628; C=5957", "S=20957; C=5842", "S=23706; C=6528", "S=20179; C=5523", "S=21081; C=5793", "S=21350; C=5863", "S=23763; C=6762", "S=21697; C=5915", "S=20388; C=5591", "S=19958; C=5606", "S=25270; C=7026", "S=26796; C=7338"});
    }

    @Test
    public void testGroupByMonthGranularitySortLimit() {
        String sql = "select cast(floor(\"timestamp\" to MONTH) as timestamp) as m,\n sum(\"unit_sales\") as s,\n count(\"store_sqft\") as c\nfrom \"foodmart\"\ngroup by floor(\"timestamp\" to MONTH)\norder by floor(\"timestamp\" to MONTH) limit 3";
        String explain = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[FLOOR($0, FLAG(MONTH)), $89, $71]], groups=[{0}], aggs=[[SUM($1), COUNT($2)]], post_projects=[[CAST($0):TIMESTAMP(0) NOT NULL, $1, $2, $0]], sort0=[3], dir0=[ASC], fetch=[3])";
        this.sql("select cast(floor(\"timestamp\" to MONTH) as timestamp) as m,\n sum(\"unit_sales\") as s,\n count(\"store_sqft\") as c\nfrom \"foodmart\"\ngroup by floor(\"timestamp\" to MONTH)\norder by floor(\"timestamp\" to MONTH) limit 3").returnsOrdered(new String[]{"M=1997-01-01 00:00:00; S=21628; C=5957", "M=1997-02-01 00:00:00; S=20957; C=5842", "M=1997-03-01 00:00:00; S=23706; C=6528"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[FLOOR($0, FLAG(MONTH)), $89, $71]], groups=[{0}], aggs=[[SUM($1), COUNT($2)]], post_projects=[[CAST($0):TIMESTAMP(0) NOT NULL, $1, $2, $0]], sort0=[3], dir0=[ASC], fetch=[3])");
    }

    @Test
    public void testGroupByDayGranularity() {
        String sql = "select sum(\"unit_sales\") as s,\n count(\"store_sqft\") as c\nfrom \"foodmart\"\ngroup by floor(\"timestamp\" to DAY) order by c desc";
        String druidQuery = "{'queryType':'groupBy','dataSource':'foodmart'";
        this.sql("select sum(\"unit_sales\") as s,\n count(\"store_sqft\") as c\nfrom \"foodmart\"\ngroup by floor(\"timestamp\" to DAY) order by c desc").limit(3).queryContains(DruidAdapterIT.druidChecker(druidQuery)).returnsOrdered(new String[]{"S=3850; C=1230", "S=3342; C=1071", "S=3219; C=1024"});
    }

    @Test
    public void testGroupByMonthGranularityFiltered() {
        String sql = "select sum(\"unit_sales\") as s,\n count(\"store_sqft\") as c\nfrom \"foodmart\"\nwhere \"timestamp\" >= '1996-01-01 00:00:00 UTC' and  \"timestamp\" < '1998-01-01 00:00:00 UTC'\ngroup by floor(\"timestamp\" to MONTH) order by s asc";
        String druidQuery = "{'queryType':'groupBy','dataSource':'foodmart'";
        this.sql("select sum(\"unit_sales\") as s,\n count(\"store_sqft\") as c\nfrom \"foodmart\"\nwhere \"timestamp\" >= '1996-01-01 00:00:00 UTC' and  \"timestamp\" < '1998-01-01 00:00:00 UTC'\ngroup by floor(\"timestamp\" to MONTH) order by s asc").limit(3).returnsOrdered(new String[]{"S=19958; C=5606", "S=20179; C=5523", "S=20388; C=5591"}).queryContains(DruidAdapterIT.druidChecker(druidQuery));
    }

    @Test
    public void testTopNMonthGranularity() {
        String sql = "select sum(\"unit_sales\") as s,\nmax(\"unit_sales\") as m,\n\"state_province\" as p\nfrom \"foodmart\"\ngroup by \"state_province\", floor(\"timestamp\" to MONTH)\norder by s desc limit 3";
        String explain = "PLAN=EnumerableCalc(expr#0..3=[{inputs}], S=[$t2], M=[$t3], P=[$t0])\n  EnumerableInterpreter\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$30, FLOOR($0, FLAG(MONTH)), $89]], groups=[{0, 1}], aggs=[[SUM($2), MAX($2)]], sort0=[2], dir0=[DESC], fetch=[3])";
        String druidQueryPart1 = "{'queryType':'groupBy','dataSource':'foodmart','granularity':'all','dimensions':[{'type':'default','dimension':'state_province',\"outputName\":\"state_province\",\"outputType\":\"STRING\"},{'type':'extraction','dimension':'__time','outputName':'floor_month','extractionFn':{'type':'timeFormat','format'";
        String druidQueryPart2 = "'limitSpec':{'type':'default','limit':3,'columns':[{'dimension':'S','direction':'descending','dimensionOrder':'numeric'}]},'aggregations':[{'type':'longSum','name':'S','fieldName':'unit_sales'},{'type':'longMax','name':'M','fieldName':'unit_sales'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z']}";
        this.sql("select sum(\"unit_sales\") as s,\nmax(\"unit_sales\") as m,\n\"state_province\" as p\nfrom \"foodmart\"\ngroup by \"state_province\", floor(\"timestamp\" to MONTH)\norder by s desc limit 3").returnsUnordered(new String[]{"S=12399; M=6; P=WA", "S=12297; M=7; P=WA", "S=10640; M=6; P=WA"}).explainContains("PLAN=EnumerableCalc(expr#0..3=[{inputs}], S=[$t2], M=[$t3], P=[$t0])\n  EnumerableInterpreter\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$30, FLOOR($0, FLAG(MONTH)), $89]], groups=[{0, 1}], aggs=[[SUM($2), MAX($2)]], sort0=[2], dir0=[DESC], fetch=[3])").queryContains(DruidAdapterIT.druidChecker("{'queryType':'groupBy','dataSource':'foodmart','granularity':'all','dimensions':[{'type':'default','dimension':'state_province',\"outputName\":\"state_province\",\"outputType\":\"STRING\"},{'type':'extraction','dimension':'__time','outputName':'floor_month','extractionFn':{'type':'timeFormat','format'", "'limitSpec':{'type':'default','limit':3,'columns':[{'dimension':'S','direction':'descending','dimensionOrder':'numeric'}]},'aggregations':[{'type':'longSum','name':'S','fieldName':'unit_sales'},{'type':'longMax','name':'M','fieldName':'unit_sales'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z']}"));
    }

    @Test
    public void testTopNDayGranularityFiltered() {
        String sql = "select sum(\"unit_sales\") as s,\nmax(\"unit_sales\") as m,\n\"state_province\" as p\nfrom \"foodmart\"\nwhere \"timestamp\" >= '1997-01-01 00:00:00 UTC' and  \"timestamp\" < '1997-09-01 00:00:00 UTC'\ngroup by \"state_province\", floor(\"timestamp\" to DAY)\norder by s desc limit 6";
        String explain = "PLAN=EnumerableInterpreter\n  BindableProject(S=[$2], M=[$3], P=[$0])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1997-01-01T00:00:00.000Z/1997-09-01T00:00:00.000Z]], projects=[[$30, FLOOR($0, FLAG(DAY)), $89]], groups=[{0, 1}], aggs=[[SUM($2), MAX($2)]], sort0=[2], dir0=[DESC], fetch=[6])";
        String druidQueryType = "{'queryType':'groupBy','dataSource':'foodmart','granularity':'all','dimensions'";
        String limitSpec = "'limitSpec':{'type':'default','limit':6,'columns':[{'dimension':'S','direction':'descending','dimensionOrder':'numeric'}]}";
        this.sql("select sum(\"unit_sales\") as s,\nmax(\"unit_sales\") as m,\n\"state_province\" as p\nfrom \"foodmart\"\nwhere \"timestamp\" >= '1997-01-01 00:00:00 UTC' and  \"timestamp\" < '1997-09-01 00:00:00 UTC'\ngroup by \"state_province\", floor(\"timestamp\" to DAY)\norder by s desc limit 6").returnsOrdered(new String[]{"S=2527; M=5; P=OR", "S=2525; M=6; P=OR", "S=2238; M=6; P=OR", "S=1715; M=5; P=OR", "S=1691; M=5; P=OR", "S=1629; M=5; P=WA"}).explainContains("PLAN=EnumerableInterpreter\n  BindableProject(S=[$2], M=[$3], P=[$0])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1997-01-01T00:00:00.000Z/1997-09-01T00:00:00.000Z]], projects=[[$30, FLOOR($0, FLAG(DAY)), $89]], groups=[{0, 1}], aggs=[[SUM($2), MAX($2)]], sort0=[2], dir0=[DESC], fetch=[6])").queryContains(DruidAdapterIT.druidChecker("{'queryType':'groupBy','dataSource':'foodmart','granularity':'all','dimensions'", "'limitSpec':{'type':'default','limit':6,'columns':[{'dimension':'S','direction':'descending','dimensionOrder':'numeric'}]}"));
    }

    @Test
    public void testGroupByHaving() {
        String sql = "select \"state_province\" as s, count(*) as c\nfrom \"foodmart\"\ngroup by \"state_province\" having count(*) > 23000 order by 1";
        String explain = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$30]], groups=[{0}], aggs=[[COUNT()]], filter=[>($1, 23000)], sort0=[0], dir0=[ASC])";
        this.sql("select \"state_province\" as s, count(*) as c\nfrom \"foodmart\"\ngroup by \"state_province\" having count(*) > 23000 order by 1").returnsOrdered(new String[]{"S=CA; C=24441", "S=WA; C=40778"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$30]], groups=[{0}], aggs=[[COUNT()]], filter=[>($1, 23000)], sort0=[0], dir0=[ASC])");
    }

    @Test
    public void testGroupComposite() {
        String sql = "select count(*) as c, \"state_province\", \"city\"\nfrom \"foodmart\"\ngroup by \"state_province\", \"city\"\norder by c desc limit 2";
        String explain = "BindableProject(C=[$2], state_province=[$0], city=[$1])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$30, $29]], groups=[{0, 1}], aggs=[[COUNT()]], sort0=[2], dir0=[DESC], fetch=[2])";
        this.sql("select count(*) as c, \"state_province\", \"city\"\nfrom \"foodmart\"\ngroup by \"state_province\", \"city\"\norder by c desc limit 2").returnsOrdered(new String[]{"C=7394; state_province=WA; city=Spokane", "C=3958; state_province=WA; city=Olympia"}).explainContains("BindableProject(C=[$2], state_province=[$0], city=[$1])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$30, $29]], groups=[{0, 1}], aggs=[[COUNT()]], sort0=[2], dir0=[DESC], fetch=[2])");
    }

    @Test
    public void testDistinctCount() {
        String sql = "select \"state_province\",\n floor(count(distinct \"city\")) as cdc\nfrom \"foodmart\"\ngroup by \"state_province\"\norder by 2 desc limit 2";
        String explain = "PLAN=EnumerableInterpreter\n  BindableSort(sort0=[$1], dir0=[DESC], fetch=[2])\n    BindableProject(state_province=[$0], CDC=[FLOOR($1)])\n      BindableAggregate(group=[{1}], agg#0=[COUNT($0)])\n        DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], groups=[{29, 30}], aggs=[[]])";
        String druidQuery = "{'queryType':'groupBy','dataSource':'foodmart','granularity':'all','dimensions':[{'type':'default','dimension':'city','outputName':'city','outputType':'STRING'},{'type':'default','dimension':'state_province','outputName':'state_province','outputType':'STRING'}],'limitSpec':{'type':'default'},'aggregations':[],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z']}";
        this.sql("select \"state_province\",\n floor(count(distinct \"city\")) as cdc\nfrom \"foodmart\"\ngroup by \"state_province\"\norder by 2 desc limit 2").explainContains("PLAN=EnumerableInterpreter\n  BindableSort(sort0=[$1], dir0=[DESC], fetch=[2])\n    BindableProject(state_province=[$0], CDC=[FLOOR($1)])\n      BindableAggregate(group=[{1}], agg#0=[COUNT($0)])\n        DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], groups=[{29, 30}], aggs=[[]])").queryContains(DruidAdapterIT.druidChecker("{'queryType':'groupBy','dataSource':'foodmart','granularity':'all','dimensions':[{'type':'default','dimension':'city','outputName':'city','outputType':'STRING'},{'type':'default','dimension':'state_province','outputName':'state_province','outputType':'STRING'}],'limitSpec':{'type':'default'},'aggregations':[],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z']}")).returnsUnordered(new String[]{"state_province=CA; CDC=45", "state_province=WA; CDC=22"});
    }

    @Test
    public void testProject() {
        String sql = "select \"product_name\", 0 as zero\nfrom \"foodmart\"\norder by \"product_name\"";
        String explain = "PLAN=EnumerableInterpreter\n  BindableSort(sort0=[$0], dir0=[ASC])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$3, 0]])";
        this.sql("select \"product_name\", 0 as zero\nfrom \"foodmart\"\norder by \"product_name\"").limit(2).returnsUnordered(new String[]{"product_name=ADJ Rosy Sunglasses; ZERO=0", "product_name=ADJ Rosy Sunglasses; ZERO=0"}).explainContains("PLAN=EnumerableInterpreter\n  BindableSort(sort0=[$0], dir0=[ASC])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$3, 0]])");
    }

    @Test
    public void testFilterDistinct() {
        String sql = "select distinct \"state_province\", \"city\",\n  \"product_name\"\nfrom \"foodmart\"\nwhere \"product_name\" = 'High Top Dried Mushrooms'\nand \"quarter\" in ('Q2', 'Q3')\nand \"state_province\" = 'WA'";
        String druidQuery1 = "{'queryType':'groupBy','dataSource':'foodmart','granularity':'all'";
        String druidQuery2 = "'filter':{'type':'and','fields':[{'type':'selector','dimension':'product_name','value':'High Top Dried Mushrooms'},{'type':'or','fields':[{'type':'selector','dimension':'quarter','value':'Q2'},{'type':'selector','dimension':'quarter','value':'Q3'}]},{'type':'selector','dimension':'state_province','value':'WA'}]},'aggregations':[],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z']}";
        String explain = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[AND(=($3, 'High Top Dried Mushrooms'), OR(=($87, 'Q2'), =($87, 'Q3')), =($30, 'WA'))], projects=[[$30, $29, $3]], groups=[{0, 1, 2}], aggs=[[]])\n";
        this.sql("select distinct \"state_province\", \"city\",\n  \"product_name\"\nfrom \"foodmart\"\nwhere \"product_name\" = 'High Top Dried Mushrooms'\nand \"quarter\" in ('Q2', 'Q3')\nand \"state_province\" = 'WA'").queryContains(DruidAdapterIT.druidChecker("{'queryType':'groupBy','dataSource':'foodmart','granularity':'all'", "'filter':{'type':'and','fields':[{'type':'selector','dimension':'product_name','value':'High Top Dried Mushrooms'},{'type':'or','fields':[{'type':'selector','dimension':'quarter','value':'Q2'},{'type':'selector','dimension':'quarter','value':'Q3'}]},{'type':'selector','dimension':'state_province','value':'WA'}]},'aggregations':[],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z']}")).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[AND(=($3, 'High Top Dried Mushrooms'), OR(=($87, 'Q2'), =($87, 'Q3')), =($30, 'WA'))], projects=[[$30, $29, $3]], groups=[{0, 1, 2}], aggs=[[]])\n").returnsUnordered(new String[]{"state_province=WA; city=Bremerton; product_name=High Top Dried Mushrooms", "state_province=WA; city=Everett; product_name=High Top Dried Mushrooms", "state_province=WA; city=Kirkland; product_name=High Top Dried Mushrooms", "state_province=WA; city=Lynnwood; product_name=High Top Dried Mushrooms", "state_province=WA; city=Olympia; product_name=High Top Dried Mushrooms", "state_province=WA; city=Port Orchard; product_name=High Top Dried Mushrooms", "state_province=WA; city=Puyallup; product_name=High Top Dried Mushrooms", "state_province=WA; city=Spokane; product_name=High Top Dried Mushrooms", "state_province=WA; city=Tacoma; product_name=High Top Dried Mushrooms", "state_province=WA; city=Yakima; product_name=High Top Dried Mushrooms"});
    }

    @Test
    public void testFilter() {
        String sql = "select \"state_province\", \"city\",\n  \"product_name\"\nfrom \"foodmart\"\nwhere \"product_name\" = 'High Top Dried Mushrooms'\nand \"quarter\" in ('Q2', 'Q3')\nand \"state_province\" = 'WA'";
        String druidQuery = "{'queryType':'scan','dataSource':'foodmart','intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'filter':{'type':'and','fields':[{'type':'selector','dimension':'product_name','value':'High Top Dried Mushrooms'},{'type':'or','fields':[{'type':'selector','dimension':'quarter','value':'Q2'},{'type':'selector','dimension':'quarter','value':'Q3'}]},{'type':'selector','dimension':'state_province','value':'WA'}]},'columns':['state_province','city','product_name'],'resultFormat':'compactedList'}";
        String explain = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[AND(=($3, 'High Top Dried Mushrooms'), OR(=($87, 'Q2'), =($87, 'Q3')), =($30, 'WA'))], projects=[[$30, $29, $3]])\n";
        this.sql("select \"state_province\", \"city\",\n  \"product_name\"\nfrom \"foodmart\"\nwhere \"product_name\" = 'High Top Dried Mushrooms'\nand \"quarter\" in ('Q2', 'Q3')\nand \"state_province\" = 'WA'").queryContains(DruidAdapterIT.druidChecker("{'queryType':'scan','dataSource':'foodmart','intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'filter':{'type':'and','fields':[{'type':'selector','dimension':'product_name','value':'High Top Dried Mushrooms'},{'type':'or','fields':[{'type':'selector','dimension':'quarter','value':'Q2'},{'type':'selector','dimension':'quarter','value':'Q3'}]},{'type':'selector','dimension':'state_province','value':'WA'}]},'columns':['state_province','city','product_name'],'resultFormat':'compactedList'}")).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[AND(=($3, 'High Top Dried Mushrooms'), OR(=($87, 'Q2'), =($87, 'Q3')), =($30, 'WA'))], projects=[[$30, $29, $3]])\n").returnsUnordered(new String[]{"state_province=WA; city=Bremerton; product_name=High Top Dried Mushrooms", "state_province=WA; city=Everett; product_name=High Top Dried Mushrooms", "state_province=WA; city=Kirkland; product_name=High Top Dried Mushrooms", "state_province=WA; city=Lynnwood; product_name=High Top Dried Mushrooms", "state_province=WA; city=Olympia; product_name=High Top Dried Mushrooms", "state_province=WA; city=Port Orchard; product_name=High Top Dried Mushrooms", "state_province=WA; city=Puyallup; product_name=High Top Dried Mushrooms", "state_province=WA; city=Puyallup; product_name=High Top Dried Mushrooms", "state_province=WA; city=Spokane; product_name=High Top Dried Mushrooms", "state_province=WA; city=Spokane; product_name=High Top Dried Mushrooms", "state_province=WA; city=Spokane; product_name=High Top Dried Mushrooms", "state_province=WA; city=Tacoma; product_name=High Top Dried Mushrooms", "state_province=WA; city=Yakima; product_name=High Top Dried Mushrooms", "state_province=WA; city=Yakima; product_name=High Top Dried Mushrooms", "state_province=WA; city=Yakima; product_name=High Top Dried Mushrooms"});
    }

    @Test
    public void testFilterTimestamp() {
        String sql = "select count(*) as c\nfrom \"foodmart\"\nwhere extract(year from \"timestamp\") = 1997\nand extract(month from \"timestamp\") in (4, 6)\n";
        String explain = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1997-04-01T00:00:00.000Z/1997-05-01T00:00:00.000Z, 1997-06-01T00:00:00.000Z/1997-07-01T00:00:00.000Z]], projects=[[0]], groups=[{}], aggs=[[COUNT()]])";
        this.sql(sql).returnsUnordered(new String[]{"C=13500"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1997-04-01T00:00:00.000Z/1997-05-01T00:00:00.000Z, 1997-06-01T00:00:00.000Z/1997-07-01T00:00:00.000Z]], projects=[[0]], groups=[{}], aggs=[[COUNT()]])");
    }

    @Test
    public void testFilterSwapped() {
        String sql = "select \"state_province\"\nfrom \"foodmart\"\nwhere 'High Top Dried Mushrooms' = \"product_name\"";
        String explain = "EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[=('High Top Dried Mushrooms', $3)], projects=[[$30]])";
        String druidQuery = "'filter':{'type':'selector','dimension':'product_name','value':'High Top Dried Mushrooms'}";
        this.sql(sql).explainContains("EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[=('High Top Dried Mushrooms', $3)], projects=[[$30]])").queryContains(DruidAdapterIT.druidChecker("'filter':{'type':'selector','dimension':'product_name','value':'High Top Dried Mushrooms'}"));
    }

    @Test
    public void testWhereGroupBy() {
        String sql = "select \"wikiticker\".\"countryName\" as \"c0\",\n sum(\"wikiticker\".\"count\") as \"m1\",\n sum(\"wikiticker\".\"deleted\") as \"m2\",\n sum(\"wikiticker\".\"delta\") as \"m3\"\nfrom \"wiki\" as \"wikiticker\"\nwhere (\"wikiticker\".\"countryName\" in ('Colombia', 'France',\n 'Germany', 'India', 'Italy', 'Russia', 'United Kingdom',\n 'United States') or \"wikiticker\".\"countryName\" is null)\ngroup by \"wikiticker\".\"countryName\"";
        String druidQuery = "{'type':'selector','dimension':'countryName','value':null}";
        this.sql(sql, WIKI).queryContains(DruidAdapterIT.druidChecker(druidQuery)).returnsCount(9);
    }

    @Test
    public void testGroupByMetricAndExtractTime() {
        String sql = "SELECT count(*), cast(floor(\"timestamp\" to DAY) as timestamp), \"store_sales\" FROM \"foodmart\"\nGROUP BY \"store_sales\", floor(\"timestamp\" to DAY)\n ORDER BY \"store_sales\" DESC\nLIMIT 10\n";
        this.sql("SELECT count(*), cast(floor(\"timestamp\" to DAY) as timestamp), \"store_sales\" FROM \"foodmart\"\nGROUP BY \"store_sales\", floor(\"timestamp\" to DAY)\n ORDER BY \"store_sales\" DESC\nLIMIT 10\n").queryContains(DruidAdapterIT.druidChecker("{\"queryType\":\"groupBy\""));
    }

    @Test
    public void testFilterOnDouble() {
        String sql = "select \"product_id\" from \"foodmart\"\nwhere cast(\"product_id\" as double) < 0.41024 and \"product_id\" < 12223";
        this.sql(sql).queryContains(DruidAdapterIT.druidChecker("'type':'bound','dimension':'product_id','upper':'0.41024'", "'upper':'12223'"));
    }

    @Test
    public void testPushAggregateOnTime() {
        String sql = "select \"product_id\", cast(\"timestamp\" as timestamp) as \"time\" from \"foodmart\" where \"product_id\" = 1016 and \"timestamp\" < '1997-01-03 00:00:00 UTC' and \"timestamp\" > '1990-01-01 00:00:00 UTC' group by \"timestamp\", \"product_id\" ";
        String druidQuery = "{'queryType':'groupBy','dataSource':'foodmart','granularity':'all','dimensions':[{'type':'extraction','dimension':'__time','outputName':'extract','extractionFn':{'type':'timeFormat','format':'yyyy-MM-dd";
        this.sql(sql).returnsUnordered(new String[]{"product_id=1016; time=1997-01-02 00:00:00"}).queryContains(DruidAdapterIT.druidChecker(druidQuery));
    }

    @Test
    public void testPushAggregateOnTimeWithExtractYear() {
        String sql = "select EXTRACT( year from \"timestamp\") as \"year\",\"product_id\" from \"foodmart\" where \"product_id\" = 1016 and \"timestamp\" < cast('1999-01-02' as timestamp) and \"timestamp\" > cast('1997-01-01' as timestamp) group by  EXTRACT( year from \"timestamp\"), \"product_id\" ";
        this.sql(sql).queryContains(DruidAdapterIT.druidChecker(",'granularity':'all'", "{'type':'extraction','dimension':'__time','outputName':'extract_year','extractionFn':{'type':'timeFormat','format':'yyyy','timeZone':'UTC','locale':'en-US'}}")).returnsUnordered(new String[]{"year=1997; product_id=1016"});
    }

    @Test
    public void testPushAggregateOnTimeWithExtractMonth() {
        String sql = "select EXTRACT( month from \"timestamp\") as \"month\",\"product_id\" from \"foodmart\" where \"product_id\" = 1016 and \"timestamp\" < cast('1997-06-02' as timestamp) and \"timestamp\" > cast('1997-01-01' as timestamp) group by  EXTRACT( month from \"timestamp\"), \"product_id\" ";
        this.sql(sql).queryContains(DruidAdapterIT.druidChecker(",'granularity':'all'", "{'type':'extraction','dimension':'__time','outputName':'extract_month','extractionFn':{'type':'timeFormat','format':'M','timeZone':'UTC','locale':'en-US'}}")).returnsUnordered(new String[]{"month=1; product_id=1016", "month=2; product_id=1016", "month=3; product_id=1016", "month=4; product_id=1016", "month=5; product_id=1016"});
    }

    @Test
    public void testPushAggregateOnTimeWithExtractDay() {
        String sql = "select EXTRACT( day from \"timestamp\") as \"day\",\"product_id\" from \"foodmart\" where \"product_id\" = 1016 and \"timestamp\" < cast('1997-01-20' as timestamp) and \"timestamp\" > cast('1997-01-01' as timestamp) group by  EXTRACT( day from \"timestamp\"), \"product_id\" ";
        this.sql(sql).queryContains(DruidAdapterIT.druidChecker(",'granularity':'all'", "{'type':'extraction','dimension':'__time','outputName':'extract_day','extractionFn':{'type':'timeFormat','format':'d','timeZone':'UTC','locale':'en-US'}}")).returnsUnordered(new String[]{"day=2; product_id=1016", "day=10; product_id=1016", "day=13; product_id=1016", "day=16; product_id=1016"});
    }

    @Test
    public void testPushAggregateOnTimeWithExtractHourOfDay() {
        String sql = "select EXTRACT( hour from \"timestamp\") as \"hourOfDay\",\"product_id\"  from \"foodmart\" where \"product_id\" = 1016 and \"timestamp\" < cast('1997-06-02' as timestamp) and \"timestamp\" > cast('1997-01-01' as timestamp) group by  EXTRACT( hour from \"timestamp\"), \"product_id\" ";
        this.sql(sql).queryContains(DruidAdapterIT.druidChecker("'queryType':'groupBy'")).returnsUnordered(new String[]{"hourOfDay=0; product_id=1016"});
    }

    @Test
    public void testPushAggregateOnTimeWithExtractYearMonthDay() {
        String sql = "select EXTRACT( day from \"timestamp\") as \"day\", EXTRACT( month from \"timestamp\") as \"month\",  EXTRACT( year from \"timestamp\") as \"year\",\"product_id\"  from \"foodmart\" where \"product_id\" = 1016 and \"timestamp\" < cast('1997-01-20' as timestamp) and \"timestamp\" > cast('1997-01-01' as timestamp) group by  EXTRACT( day from \"timestamp\"), EXTRACT( month from \"timestamp\"), EXTRACT( year from \"timestamp\"), \"product_id\" ";
        this.sql(sql).queryContains(DruidAdapterIT.druidChecker(",'granularity':'all'", "{'type':'extraction','dimension':'__time','outputName':'extract_day','extractionFn':{'type':'timeFormat','format':'d','timeZone':'UTC','locale':'en-US'}}", "{'type':'extraction','dimension':'__time','outputName':'extract_month','extractionFn':{'type':'timeFormat','format':'M','timeZone':'UTC','locale':'en-US'}}", "{'type':'extraction','dimension':'__time','outputName':'extract_year','extractionFn':{'type':'timeFormat','format':'yyyy','timeZone':'UTC','locale':'en-US'}}")).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1997-01-01T00:00:00.001Z/1997-01-20T00:00:00.000Z]], filter=[=($1, 1016)], projects=[[EXTRACT(FLAG(DAY), $0), EXTRACT(FLAG(MONTH), $0), EXTRACT(FLAG(YEAR), $0), $1]], groups=[{0, 1, 2, 3}], aggs=[[]])\n").returnsUnordered(new String[]{"day=2; month=1; year=1997; product_id=1016", "day=10; month=1; year=1997; product_id=1016", "day=13; month=1; year=1997; product_id=1016", "day=16; month=1; year=1997; product_id=1016"});
    }

    @Test
    public void testPushAggregateOnTimeWithExtractYearMonthDayWithOutRenaming() {
        String sql = "select EXTRACT( day from \"timestamp\"), EXTRACT( month from \"timestamp\"), EXTRACT( year from \"timestamp\"),\"product_id\"  from \"foodmart\" where \"product_id\" = 1016 and \"timestamp\" < cast('1997-01-20' as timestamp) and \"timestamp\" > cast('1997-01-01' as timestamp) group by  EXTRACT( day from \"timestamp\"), EXTRACT( month from \"timestamp\"), EXTRACT( year from \"timestamp\"), \"product_id\" ";
        this.sql(sql).queryContains(DruidAdapterIT.druidChecker(",'granularity':'all'", "{'type':'extraction','dimension':'__time','outputName':'extract_day','extractionFn':{'type':'timeFormat','format':'d','timeZone':'UTC','locale':'en-US'}}", "{'type':'extraction','dimension':'__time','outputName':'extract_month','extractionFn':{'type':'timeFormat','format':'M','timeZone':'UTC','locale':'en-US'}}", "{'type':'extraction','dimension':'__time','outputName':'extract_year','extractionFn':{'type':'timeFormat','format':'yyyy','timeZone':'UTC','locale':'en-US'}}")).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1997-01-01T00:00:00.001Z/1997-01-20T00:00:00.000Z]], filter=[=($1, 1016)], projects=[[EXTRACT(FLAG(DAY), $0), EXTRACT(FLAG(MONTH), $0), EXTRACT(FLAG(YEAR), $0), $1]], groups=[{0, 1, 2, 3}], aggs=[[]])\n").returnsUnordered(new String[]{"EXPR$0=2; EXPR$1=1; EXPR$2=1997; product_id=1016", "EXPR$0=10; EXPR$1=1; EXPR$2=1997; product_id=1016", "EXPR$0=13; EXPR$1=1; EXPR$2=1997; product_id=1016", "EXPR$0=16; EXPR$1=1; EXPR$2=1997; product_id=1016"});
    }

    @Test
    public void testPushAggregateOnTimeWithExtractWithOutRenaming() {
        String sql = "select EXTRACT( day from \"timestamp\"), \"product_id\" as \"dayOfMonth\" from \"foodmart\" where \"product_id\" = 1016 and \"timestamp\" < cast('1997-01-20' as timestamp) and \"timestamp\" > cast('1997-01-01' as timestamp) group by  EXTRACT( day from \"timestamp\"), EXTRACT( day from \"timestamp\"), \"product_id\" ";
        this.sql(sql).queryContains(DruidAdapterIT.druidChecker(",'granularity':'all'", "{'type':'extraction','dimension':'__time','outputName':'extract_day','extractionFn':{'type':'timeFormat','format':'d','timeZone':'UTC','locale':'en-US'}}")).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1997-01-01T00:00:00.001Z/1997-01-20T00:00:00.000Z]], filter=[=($1, 1016)], projects=[[EXTRACT(FLAG(DAY), $0), $1]], groups=[{0, 1}], aggs=[[]])\n").returnsUnordered(new String[]{"EXPR$0=2; dayOfMonth=1016", "EXPR$0=10; dayOfMonth=1016", "EXPR$0=13; dayOfMonth=1016", "EXPR$0=16; dayOfMonth=1016"});
    }

    @Test
    public void testPushComplexFilter() {
        String sql = "select sum(\"store_sales\") from \"foodmart\" where EXTRACT( year from \"timestamp\") = 1997 and \"cases_per_pallet\" >= 8 and \"cases_per_pallet\" <= 10 and \"units_per_case\" < 15 ";
        String druidQuery = "{'queryType':'timeseries','dataSource':'foodmart','descending':false,'granularity':'all','filter':{'type':'and','fields':[{'type':'bound','dimension':'cases_per_pallet','lower':'8','lowerStrict':false,'ordering':'numeric'},{'type':'bound','dimension':'cases_per_pallet','upper':'10','upperStrict':false,'ordering':'numeric'},{'type':'bound','dimension':'units_per_case','upper':'15','upperStrict':true,'ordering':'numeric'}]},'aggregations':[{'type':'doubleSum','name':'EXPR$0','fieldName':'store_sales'}],'intervals':['1997-01-01T00:00:00.000Z/1998-01-01T00:00:00.000Z'],'context':{'skipEmptyBuckets':false}}";
        this.sql(sql).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1997-01-01T00:00:00.000Z/1998-01-01T00:00:00.000Z]], filter=[AND(>=(CAST($11):BIGINT, 8), <=(CAST($11):BIGINT, 10), <(CAST($10):BIGINT, 15))], groups=[{}], aggs=[[SUM($90)]])\n").returnsUnordered(new String[]{"EXPR$0=75364.1"}).queryContains(DruidAdapterIT.druidChecker(druidQuery));
    }

    @Test
    public void testPushOfFilterExtractionOnDayAndMonth() {
        String sql = "SELECT \"product_id\" , EXTRACT(day from \"timestamp\"), EXTRACT(month from \"timestamp\") from \"foodmart\" WHERE  EXTRACT(day from \"timestamp\") >= 30 AND EXTRACT(month from \"timestamp\") = 11 AND  \"product_id\" >= 1549 group by \"product_id\", EXTRACT(day from \"timestamp\"), EXTRACT(month from \"timestamp\")";
        this.sql(sql).returnsUnordered(new String[]{"product_id=1549; EXPR$1=30; EXPR$2=11", "product_id=1553; EXPR$1=30; EXPR$2=11"});
    }

    @Test
    public void testPushOfFilterExtractionOnDayAndMonthAndYear() {
        String sql = "SELECT \"product_id\" , EXTRACT(day from \"timestamp\"), EXTRACT(month from \"timestamp\") , EXTRACT(year from \"timestamp\") from \"foodmart\" WHERE  EXTRACT(day from \"timestamp\") >= 30 AND EXTRACT(month from \"timestamp\") = 11 AND  \"product_id\" >= 1549 AND EXTRACT(year from \"timestamp\") = 1997group by \"product_id\", EXTRACT(day from \"timestamp\"), EXTRACT(month from \"timestamp\"), EXTRACT(year from \"timestamp\")";
        this.sql(sql).returnsUnordered(new String[]{"product_id=1549; EXPR$1=30; EXPR$2=11; EXPR$3=1997", "product_id=1553; EXPR$1=30; EXPR$2=11; EXPR$3=1997"}).queryContains(DruidAdapterIT.druidChecker("{'queryType':'groupBy','dataSource':'foodmart','granularity':'all'"));
    }

    @Test
    public void testFilterExtractionOnMonthWithBetween() {
        String sqlQuery = "SELECT \"product_id\", EXTRACT(month from \"timestamp\") FROM \"foodmart\" WHERE EXTRACT(month from \"timestamp\") BETWEEN 10 AND 11 AND  \"product_id\" >= 1558 GROUP BY \"product_id\", EXTRACT(month from \"timestamp\")";
        String druidQuery = "{'queryType':'groupBy','dataSource':'foodmart'";
        this.sql(sqlQuery).returnsUnordered(new String[]{"product_id=1558; EXPR$1=10", "product_id=1558; EXPR$1=11", "product_id=1559; EXPR$1=11"}).queryContains(DruidAdapterIT.druidChecker(druidQuery));
    }

    @Test
    public void testFilterExtractionOnMonthWithIn() {
        String sqlQuery = "SELECT \"product_id\", EXTRACT(month from \"timestamp\") FROM \"foodmart\" WHERE EXTRACT(month from \"timestamp\") IN (10, 11) AND  \"product_id\" >= 1558 GROUP BY \"product_id\", EXTRACT(month from \"timestamp\")";
        this.sql(sqlQuery).returnsUnordered(new String[]{"product_id=1558; EXPR$1=10", "product_id=1558; EXPR$1=11", "product_id=1559; EXPR$1=11"}).queryContains(DruidAdapterIT.druidChecker("{'queryType':'groupBy','dataSource':'foodmart','granularity':'all','dimensions':[{'type':'default','dimension':'product_id','outputName':'product_id','outputType':'STRING'},{'type':'extraction','dimension':'__time','outputName':'extract_month','extractionFn':{'type':'timeFormat','format':'M','timeZone':'UTC','locale':'en-US'}}],'limitSpec':{'type':'default'},'filter':{'type':'and','fields':[{'type':'bound','dimension':'product_id','lower':'1558','lowerStrict':false,'ordering':'numeric'},{'type':'or','fields':[{'type':'bound','dimension':'__time','lower':'10','lowerStrict':false,'upper':'10','upperStrict':false,'ordering':'numeric','extractionFn':{'type':'timeFormat','format':'M','timeZone':'UTC','locale':'en-US'}},{'type':'bound','dimension':'__time','lower':'11','lowerStrict':false,'upper':'11','upperStrict':false,'ordering':'numeric','extractionFn':{'type':'timeFormat','format':'M','timeZone':'UTC','locale':'en-US'}}]}]},'aggregations':[],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z']}"));
    }

    @Test
    public void testPushOfOrderByWithMonthExtract() {
        String sqlQuery = "SELECT  extract(month from \"timestamp\") as m , \"product_id\", SUM(\"unit_sales\") as s FROM \"foodmart\" WHERE \"product_id\" >= 1558 GROUP BY extract(month from \"timestamp\"), \"product_id\" order by m, s, \"product_id\"";
        this.sql(sqlQuery).queryContains(DruidAdapterIT.druidChecker("{'queryType':'groupBy','dataSource':'foodmart','granularity':'all','dimensions':[{'type':'extraction','dimension':'__time','outputName':'extract_month','extractionFn':{'type':'timeFormat','format':'M','timeZone':'UTC','locale':'en-US'}},{'type':'default','dimension':'product_id','outputName':'product_id','outputType':'STRING'}],'limitSpec':{'type':'default','columns':[{'dimension':'extract_month','direction':'ascending','dimensionOrder':'numeric'},{'dimension':'S','direction':'ascending','dimensionOrder':'numeric'},{'dimension':'product_id','direction':'ascending','dimensionOrder':'lexicographic'}]},'filter':{'type':'bound','dimension':'product_id','lower':'1558','lowerStrict':false,'ordering':'numeric'},'aggregations':[{'type':'longSum','name':'S','fieldName':'unit_sales'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z']}")).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[>=(CAST($1):BIGINT, 1558)], projects=[[EXTRACT(FLAG(MONTH), $0), $1, $89]], groups=[{0, 1}], aggs=[[SUM($2)]], sort0=[0], sort1=[2], sort2=[1], dir0=[ASC], dir1=[ASC], dir2=[ASC])");
    }

    @Test
    public void testGroupByFloorTimeWithoutLimit() {
        String sql = "select cast(floor(\"timestamp\" to MONTH) as timestamp) as \"month\"\nfrom \"foodmart\"\ngroup by floor(\"timestamp\" to MONTH)\norder by \"month\" DESC";
        this.sql("select cast(floor(\"timestamp\" to MONTH) as timestamp) as \"month\"\nfrom \"foodmart\"\ngroup by floor(\"timestamp\" to MONTH)\norder by \"month\" DESC").queryContains(DruidAdapterIT.druidChecker("'queryType':'timeseries'", "'descending':true")).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[FLOOR($0, FLAG(MONTH))]], groups=[{0}], aggs=[[]], post_projects=[[CAST($0):TIMESTAMP(0) NOT NULL]], sort0=[0], dir0=[DESC])");
    }

    @Test
    public void testGroupByFloorTimeWithLimit() {
        String sql = "select cast(floor(\"timestamp\" to MONTH) as timestamp) as \"floorOfMonth\"\nfrom \"foodmart\"\ngroup by floor(\"timestamp\" to MONTH)\norder by \"floorOfMonth\" DESC LIMIT 3";
        String explain = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[FLOOR($0, FLAG(MONTH))]], groups=[{0}], aggs=[[]], post_projects=[[CAST($0):TIMESTAMP(0) NOT NULL]], sort0=[0], dir0=[DESC], fetch=[3])";
        this.sql("select cast(floor(\"timestamp\" to MONTH) as timestamp) as \"floorOfMonth\"\nfrom \"foodmart\"\ngroup by floor(\"timestamp\" to MONTH)\norder by \"floorOfMonth\" DESC LIMIT 3").explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[FLOOR($0, FLAG(MONTH))]], groups=[{0}], aggs=[[]], post_projects=[[CAST($0):TIMESTAMP(0) NOT NULL]], sort0=[0], dir0=[DESC], fetch=[3])").returnsOrdered(new String[]{"floorOfMonth=1997-12-01 00:00:00", "floorOfMonth=1997-11-01 00:00:00", "floorOfMonth=1997-10-01 00:00:00"}).queryContains(DruidAdapterIT.druidChecker("'queryType':'groupBy'", "'direction':'descending'"));
    }

    @Test
    public void testPushofOrderByYearWithYearMonthExtract() {
        String sqlQuery = "SELECT year(\"timestamp\") as y, extract(month from \"timestamp\") as m , \"product_id\", SUM(\"unit_sales\") as s FROM \"foodmart\" WHERE \"product_id\" >= 1558 GROUP BY year(\"timestamp\"), extract(month from \"timestamp\"), \"product_id\" order by y DESC, m ASC, s DESC, \"product_id\" LIMIT 3";
        String expectedPlan = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[>=(CAST($1):BIGINT, 1558)], projects=[[EXTRACT(FLAG(YEAR), $0), EXTRACT(FLAG(MONTH), $0), $1, $89]], groups=[{0, 1, 2}], aggs=[[SUM($3)]], sort0=[0], sort1=[1], sort2=[3], sort3=[2], dir0=[DESC], dir1=[ASC], dir2=[DESC], dir3=[ASC], fetch=[3])";
        String expectedDruidQuery = "{'queryType':'groupBy','dataSource':'foodmart','granularity':'all','dimensions':[{'type':'extraction','dimension':'__time','outputName':'extract_year','extractionFn':{'type':'timeFormat','format':'yyyy','timeZone':'UTC','locale':'en-US'}},{'type':'extraction','dimension':'__time','outputName':'extract_month','extractionFn':{'type':'timeFormat','format':'M','timeZone':'UTC','locale':'en-US'}},{'type':'default','dimension':'product_id','outputName':'product_id','outputType':'STRING'}],'limitSpec':{'type':'default','limit':3,'columns':[{'dimension':'extract_year','direction':'descending','dimensionOrder':'numeric'},{'dimension':'extract_month','direction':'ascending','dimensionOrder':'numeric'},{'dimension':'S','direction':'descending','dimensionOrder':'numeric'},{'dimension':'product_id','direction':'ascending','dimensionOrder':'lexicographic'}]},'filter':{'type':'bound','dimension':'product_id','lower':'1558','lowerStrict':false,'ordering':'numeric'},'aggregations':[{'type':'longSum','name':'S','fieldName':'unit_sales'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z']}";
        this.sql(sqlQuery).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[>=(CAST($1):BIGINT, 1558)], projects=[[EXTRACT(FLAG(YEAR), $0), EXTRACT(FLAG(MONTH), $0), $1, $89]], groups=[{0, 1, 2}], aggs=[[SUM($3)]], sort0=[0], sort1=[1], sort2=[3], sort3=[2], dir0=[DESC], dir1=[ASC], dir2=[DESC], dir3=[ASC], fetch=[3])").queryContains(DruidAdapterIT.druidChecker("{'queryType':'groupBy','dataSource':'foodmart','granularity':'all','dimensions':[{'type':'extraction','dimension':'__time','outputName':'extract_year','extractionFn':{'type':'timeFormat','format':'yyyy','timeZone':'UTC','locale':'en-US'}},{'type':'extraction','dimension':'__time','outputName':'extract_month','extractionFn':{'type':'timeFormat','format':'M','timeZone':'UTC','locale':'en-US'}},{'type':'default','dimension':'product_id','outputName':'product_id','outputType':'STRING'}],'limitSpec':{'type':'default','limit':3,'columns':[{'dimension':'extract_year','direction':'descending','dimensionOrder':'numeric'},{'dimension':'extract_month','direction':'ascending','dimensionOrder':'numeric'},{'dimension':'S','direction':'descending','dimensionOrder':'numeric'},{'dimension':'product_id','direction':'ascending','dimensionOrder':'lexicographic'}]},'filter':{'type':'bound','dimension':'product_id','lower':'1558','lowerStrict':false,'ordering':'numeric'},'aggregations':[{'type':'longSum','name':'S','fieldName':'unit_sales'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z']}")).returnsOrdered(new String[]{"Y=1997; M=1; product_id=1558; S=6", "Y=1997; M=1; product_id=1559; S=6", "Y=1997; M=2; product_id=1558; S=24"});
    }

    @Test
    public void testPushofOrderByMetricWithYearMonthExtract() {
        String sqlQuery = "SELECT year(\"timestamp\") as y, extract(month from \"timestamp\") as m , \"product_id\", SUM(\"unit_sales\") as s FROM \"foodmart\" WHERE \"product_id\" >= 1558 GROUP BY year(\"timestamp\"), extract(month from \"timestamp\"), \"product_id\" order by s DESC, m DESC, \"product_id\" LIMIT 3";
        String expectedPlan = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[>=(CAST($1):BIGINT, 1558)], projects=[[EXTRACT(FLAG(YEAR), $0), EXTRACT(FLAG(MONTH), $0), $1, $89]], groups=[{0, 1, 2}], aggs=[[SUM($3)]], sort0=[3], sort1=[1], sort2=[2], dir0=[DESC], dir1=[DESC], dir2=[ASC], fetch=[3])";
        String expectedDruidQueryType = "'queryType':'groupBy'";
        this.sql(sqlQuery).returnsOrdered(new String[]{"Y=1997; M=12; product_id=1558; S=30", "Y=1997; M=3; product_id=1558; S=29", "Y=1997; M=5; product_id=1558; S=27"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[>=(CAST($1):BIGINT, 1558)], projects=[[EXTRACT(FLAG(YEAR), $0), EXTRACT(FLAG(MONTH), $0), $1, $89]], groups=[{0, 1, 2}], aggs=[[SUM($3)]], sort0=[3], sort1=[1], sort2=[2], dir0=[DESC], dir1=[DESC], dir2=[ASC], fetch=[3])").queryContains(DruidAdapterIT.druidChecker("'queryType':'groupBy'"));
    }

    @Test
    public void testGroupByTimeSortOverMetrics() {
        String sqlQuery = "SELECT count(*) as c , SUM(\"unit_sales\") as s, cast(floor(\"timestamp\" to month) as timestamp) FROM \"foodmart\" group by floor(\"timestamp\" to month) order by s DESC";
        this.sql("SELECT count(*) as c , SUM(\"unit_sales\") as s, cast(floor(\"timestamp\" to month) as timestamp) FROM \"foodmart\" group by floor(\"timestamp\" to month) order by s DESC").returnsOrdered(new String[]{"C=8716; S=26796; EXPR$2=1997-12-01 00:00:00", "C=8231; S=25270; EXPR$2=1997-11-01 00:00:00", "C=7752; S=23763; EXPR$2=1997-07-01 00:00:00", "C=7710; S=23706; EXPR$2=1997-03-01 00:00:00", "C=7038; S=21697; EXPR$2=1997-08-01 00:00:00", "C=7033; S=21628; EXPR$2=1997-01-01 00:00:00", "C=6912; S=21350; EXPR$2=1997-06-01 00:00:00", "C=6865; S=21081; EXPR$2=1997-05-01 00:00:00", "C=6844; S=20957; EXPR$2=1997-02-01 00:00:00", "C=6662; S=20388; EXPR$2=1997-09-01 00:00:00", "C=6588; S=20179; EXPR$2=1997-04-01 00:00:00", "C=6478; S=19958; EXPR$2=1997-10-01 00:00:00"}).queryContains(DruidAdapterIT.druidChecker("'queryType':'groupBy'")).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[FLOOR($0, FLAG(MONTH)), $89]], groups=[{0}], aggs=[[COUNT(), SUM($1)]], post_projects=[[$1, $2, CAST($0):TIMESTAMP(0) NOT NULL]], sort0=[1], dir0=[DESC])");
    }

    @Test
    public void testNumericOrderingOfOrderByOperatorFullTime() {
        String sqlQuery = "SELECT cast(\"timestamp\" as timestamp) as \"timestamp\", count(*) as c, SUM(\"unit_sales\") as s FROM \"foodmart\" group by \"timestamp\" order by \"timestamp\" DESC, c DESC, s LIMIT 5";
        String druidSubQuery = "'limitSpec':{'type':'default','limit':5,'columns':[{'dimension':'extract','direction':'descending','dimensionOrder':'lexicographic'},{'dimension':'C','direction':'descending','dimensionOrder':'numeric'},{'dimension':'S','direction':'ascending','dimensionOrder':'numeric'}]},'aggregations':[{'type':'count','name':'C'},{'type':'longSum','name':'S','fieldName':'unit_sales'}]";
        this.sql("SELECT cast(\"timestamp\" as timestamp) as \"timestamp\", count(*) as c, SUM(\"unit_sales\") as s FROM \"foodmart\" group by \"timestamp\" order by \"timestamp\" DESC, c DESC, s LIMIT 5").returnsOrdered(new String[]{"timestamp=1997-12-30 00:00:00; C=22; S=36\ntimestamp=1997-12-29 00:00:00; C=321; S=982\ntimestamp=1997-12-28 00:00:00; C=480; S=1496\ntimestamp=1997-12-27 00:00:00; C=363; S=1156\ntimestamp=1997-12-26 00:00:00; C=144; S=420"}).queryContains(DruidAdapterIT.druidChecker("'limitSpec':{'type':'default','limit':5,'columns':[{'dimension':'extract','direction':'descending','dimensionOrder':'lexicographic'},{'dimension':'C','direction':'descending','dimensionOrder':'numeric'},{'dimension':'S','direction':'ascending','dimensionOrder':'numeric'}]},'aggregations':[{'type':'count','name':'C'},{'type':'longSum','name':'S','fieldName':'unit_sales'}]"));
    }

    @Test
    public void testNumericOrderingOfOrderByOperatorTimeExtract() {
        String sqlQuery = "SELECT extract(day from \"timestamp\") as d, extract(month from \"timestamp\") as m,  year(\"timestamp\") as y , count(*) as c, SUM(\"unit_sales\")  as s FROM \"foodmart\" group by  extract(day from \"timestamp\"), extract(month from \"timestamp\"), year(\"timestamp\")  order by d DESC, m ASC, y DESC LIMIT 5";
        String druidSubQuery = "'limitSpec':{'type':'default','limit':5,'columns':[{'dimension':'extract_day','direction':'descending','dimensionOrder':'numeric'},{'dimension':'extract_month','direction':'ascending','dimensionOrder':'numeric'},{'dimension':'extract_year','direction':'descending','dimensionOrder':'numeric'}]}";
        this.sql("SELECT extract(day from \"timestamp\") as d, extract(month from \"timestamp\") as m,  year(\"timestamp\") as y , count(*) as c, SUM(\"unit_sales\")  as s FROM \"foodmart\" group by  extract(day from \"timestamp\"), extract(month from \"timestamp\"), year(\"timestamp\")  order by d DESC, m ASC, y DESC LIMIT 5").returnsOrdered(new String[]{"D=30; M=3; Y=1997; C=114; S=351\nD=30; M=5; Y=1997; C=24; S=34\nD=30; M=6; Y=1997; C=73; S=183\nD=30; M=7; Y=1997; C=29; S=54\nD=30; M=8; Y=1997; C=137; S=422"}).queryContains(DruidAdapterIT.druidChecker("'limitSpec':{'type':'default','limit':5,'columns':[{'dimension':'extract_day','direction':'descending','dimensionOrder':'numeric'},{'dimension':'extract_month','direction':'ascending','dimensionOrder':'numeric'},{'dimension':'extract_year','direction':'descending','dimensionOrder':'numeric'}]}"));
    }

    @Test
    public void testNumericOrderingOfOrderByOperatorStringDims() {
        String sqlQuery = "SELECT \"brand_name\", count(*) as c, SUM(\"unit_sales\")  as s FROM \"foodmart\" group by \"brand_name\" order by \"brand_name\"  DESC LIMIT 5";
        String druidSubQuery = "'limitSpec':{'type':'default','limit':5,'columns':[{'dimension':'brand_name','direction':'descending','dimensionOrder':'lexicographic'}]}";
        this.sql("SELECT \"brand_name\", count(*) as c, SUM(\"unit_sales\")  as s FROM \"foodmart\" group by \"brand_name\" order by \"brand_name\"  DESC LIMIT 5").returnsOrdered(new String[]{"brand_name=Washington; C=576; S=1775\nbrand_name=Walrus; C=457; S=1399\nbrand_name=Urban; C=299; S=924\nbrand_name=Tri-State; C=2339; S=7270\nbrand_name=Toucan; C=123; S=380"}).queryContains(DruidAdapterIT.druidChecker("'limitSpec':{'type':'default','limit':5,'columns':[{'dimension':'brand_name','direction':'descending','dimensionOrder':'lexicographic'}]}"));
    }

    @Test
    public void testGroupByWeekExtract() {
        String sql = "SELECT extract(week from \"timestamp\") from \"foodmart\" where \"product_id\" = 1558 and extract(week from \"timestamp\") IN (10, 11) group by extract(week from \"timestamp\")";
        String druidQuery = "{'queryType':'groupBy','dataSource':'foodmart','granularity':'all','dimensions':[{'type':'extraction','dimension':'__time','outputName':'extract_week','extractionFn':{'type':'timeFormat','format':'w','timeZone':'UTC','locale':'en-US'}}],'limitSpec':{'type':'default'},'filter':{'type':'and','fields':[{'type':'bound','dimension':'product_id','lower':'1558','lowerStrict':false,'upper':'1558','upperStrict':false,'ordering':'numeric'},{'type':'or','fields':[{'type':'bound','dimension':'__time','lower':'10','lowerStrict':false,'upper':'10','upperStrict':false,'ordering':'numeric','extractionFn':{'type':'timeFormat','format':'w','timeZone':'UTC','locale':'en-US'}},{'type':'bound','dimension':'__time','lower':'11','lowerStrict':false,'upper':'11','upperStrict':false,'ordering':'numeric','extractionFn':{'type':'timeFormat','format':'w','timeZone':'UTC','locale':'en-US'}}]}]},'aggregations':[],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z']}";
        this.sql("SELECT extract(week from \"timestamp\") from \"foodmart\" where \"product_id\" = 1558 and extract(week from \"timestamp\") IN (10, 11) group by extract(week from \"timestamp\")").returnsOrdered(new String[]{"EXPR$0=10\nEXPR$0=11"}).queryContains(DruidAdapterIT.druidChecker("{'queryType':'groupBy','dataSource':'foodmart','granularity':'all','dimensions':[{'type':'extraction','dimension':'__time','outputName':'extract_week','extractionFn':{'type':'timeFormat','format':'w','timeZone':'UTC','locale':'en-US'}}],'limitSpec':{'type':'default'},'filter':{'type':'and','fields':[{'type':'bound','dimension':'product_id','lower':'1558','lowerStrict':false,'upper':'1558','upperStrict':false,'ordering':'numeric'},{'type':'or','fields':[{'type':'bound','dimension':'__time','lower':'10','lowerStrict':false,'upper':'10','upperStrict':false,'ordering':'numeric','extractionFn':{'type':'timeFormat','format':'w','timeZone':'UTC','locale':'en-US'}},{'type':'bound','dimension':'__time','lower':'11','lowerStrict':false,'upper':'11','upperStrict':false,'ordering':'numeric','extractionFn':{'type':'timeFormat','format':'w','timeZone':'UTC','locale':'en-US'}}]}]},'aggregations':[],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z']}"));
    }

    @Test
    public void testTimeExtractThatCannotBePushed() {
        String sql = "SELECT extract(CENTURY from \"timestamp\") from \"foodmart\" where \"product_id\" = 1558 group by extract(CENTURY from \"timestamp\")";
        String plan = "PLAN=EnumerableInterpreter\n  BindableAggregate(group=[{0}])\n    BindableProject(EXPR$0=[EXTRACT(FLAG(CENTURY), $0)])\n      DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[=($1, 1558)], projects=[[$0]])\n";
        this.sql("SELECT extract(CENTURY from \"timestamp\") from \"foodmart\" where \"product_id\" = 1558 group by extract(CENTURY from \"timestamp\")").explainContains("PLAN=EnumerableInterpreter\n  BindableAggregate(group=[{0}])\n    BindableProject(EXPR$0=[EXTRACT(FLAG(CENTURY), $0)])\n      DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[=($1, 1558)], projects=[[$0]])\n").queryContains(DruidAdapterIT.druidChecker("'queryType':'scan'")).returnsUnordered(new String[]{"EXPR$0=20"});
    }

    @Test
    public void testPushCast() {
        String sql = "SELECT \"product_id\"\nfrom \"foodmart\"\nwhere \"product_id\" = cast(NULL as varchar)\ngroup by \"product_id\" order by \"product_id\" limit 5";
        String plan = "PLAN=EnumerableInterpreter\n  BindableSort(sort0=[$0], dir0=[ASC], fetch=[5])\n    BindableFilter(condition=[=($0, null)])\n      DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], groups=[{1}], aggs=[[]])";
        String query = "{\"queryType\":\"groupBy\"";
        this.sql("SELECT \"product_id\"\nfrom \"foodmart\"\nwhere \"product_id\" = cast(NULL as varchar)\ngroup by \"product_id\" order by \"product_id\" limit 5").explainContains("PLAN=EnumerableInterpreter\n  BindableSort(sort0=[$0], dir0=[ASC], fetch=[5])\n    BindableFilter(condition=[=($0, null)])\n      DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], groups=[{1}], aggs=[[]])").queryContains(DruidAdapterIT.druidChecker("{\"queryType\":\"groupBy\""));
    }

    @Test
    public void testFalseFilter() {
        String sql = "Select count(*) as c from \"foodmart\" where false";
        this.sql(sql).queryContains(DruidAdapterIT.druidChecker("\"filter\":{\"type\":\"expression\",\"expression\":\"1 == 2\"}")).returnsUnordered(new String[]{"C=0"});
    }

    @Test
    public void testTrueFilter() {
        String sql = "Select count(*) as c from \"foodmart\" where true";
        this.sql(sql).returnsUnordered(new String[]{"C=86829"});
    }

    @Test
    public void testFalseFilterCaseConjectionWithTrue() {
        String sql = "Select count(*) as c from \"foodmart\" where \"product_id\" = 1558 and (true or false)";
        this.sql(sql).returnsUnordered(new String[]{"C=60"}).queryContains(DruidAdapterIT.druidChecker("'queryType':'timeseries'"));
    }

    @Test
    public void testPushCastNumeric() {
        String druidQuery = "'filter':{'type':'bound','dimension':'product_id','upper':'10','upperStrict':true,'ordering':'numeric'}";
        this.sql("?").withRel(b -> {
            RelDataType intType = b.getTypeFactory().createSqlType(SqlTypeName.INTEGER);
            return b.scan(new String[]{"foodmart", "foodmart"}).filter(new RexNode[]{b.call((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{b.getRexBuilder().makeCall(intType, (SqlOperator)SqlStdOperatorTable.CAST, (List)ImmutableList.of((Object)b.field("product_id"))), b.getRexBuilder().makeCall(intType, (SqlOperator)SqlStdOperatorTable.CAST, (List)ImmutableList.of((Object)b.literal((Object)"10")))})}).project(new RexNode[]{b.field("product_id")}).build();
        }).queryContains(DruidAdapterIT.druidChecker(druidQuery));
    }

    @Test
    public void testPushFieldEqualsLiteral() {
        this.sql("?").withRel(b -> b.scan(new String[]{"foodmart", "foodmart"}).filter(new RexNode[]{b.call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{b.field("product_id"), b.literal((Object)"id")})}).aggregate(b.groupKey(), new RelBuilder.AggCall[]{b.countStar("c")}).build()).returnsUnordered(new String[]{"c=0"}).queryContains(DruidAdapterIT.druidChecker("'queryType':'timeseries'"));
    }

    @Test
    public void testPlusArithmeticOperation() {
        String sqlQuery = "select sum(\"store_sales\") + sum(\"store_cost\") as a, \"store_state\" from \"foodmart\"  group by \"store_state\" order by a desc";
        String postAggString = "type':'expression','name':'A','expression':'(\\'$f1\\' + \\'$f2\\')'}]";
        String plan = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$63, $90, $91]], groups=[{0}], aggs=[[SUM($1), SUM($2)]], post_projects=[[+($1, $2), $0]], sort0=[0], dir0=[DESC])";
        this.sql("select sum(\"store_sales\") + sum(\"store_cost\") as a, \"store_state\" from \"foodmart\"  group by \"store_state\" order by a desc", FOODMART).returnsOrdered(new String[]{"A=369117.52790000016; store_state=WA", "A=222698.26509999996; store_state=CA", "A=199049.57059999998; store_state=OR"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$63, $90, $91]], groups=[{0}], aggs=[[SUM($1), SUM($2)]], post_projects=[[+($1, $2), $0]], sort0=[0], dir0=[DESC])").queryContains(DruidAdapterIT.druidChecker(postAggString));
    }

    @Test
    public void testDivideArithmeticOperation() {
        String sqlQuery = "select \"store_state\", sum(\"store_sales\") / sum(\"store_cost\") as a from \"foodmart\"  group by \"store_state\" order by a desc";
        String postAggString = "[{'type':'expression','name':'A','expression':'(\\'$f1\\' / \\'$f2\\')";
        String plan = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$63, $90, $91]], groups=[{0}], aggs=[[SUM($1), SUM($2)]], post_projects=[[$0, /($1, $2)]], sort0=[1], dir0=[DESC])";
        this.sql("select \"store_state\", sum(\"store_sales\") / sum(\"store_cost\") as a from \"foodmart\"  group by \"store_state\" order by a desc", FOODMART).returnsOrdered(new String[]{"store_state=OR; A=2.506091302943239", "store_state=CA; A=2.505379741272971", "store_state=WA; A=2.5045806163801996"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$63, $90, $91]], groups=[{0}], aggs=[[SUM($1), SUM($2)]], post_projects=[[$0, /($1, $2)]], sort0=[1], dir0=[DESC])").queryContains(DruidAdapterIT.druidChecker(postAggString));
    }

    @Test
    public void testMultiplyArithmeticOperation() {
        String sqlQuery = "select \"store_state\", sum(\"store_sales\") * sum(\"store_cost\") as a from \"foodmart\"  group by \"store_state\" order by a desc";
        String postAggString = "{'type':'expression','name':'A','expression':'(\\'$f1\\' * \\'$f2\\')'";
        String plan = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$63, $90, $91]], groups=[{0}], aggs=[[SUM($1), SUM($2)]], post_projects=[[$0, *($1, $2)]], sort0=[1], dir0=[DESC])";
        this.sql("select \"store_state\", sum(\"store_sales\") * sum(\"store_cost\") as a from \"foodmart\"  group by \"store_state\" order by a desc", FOODMART).returnsOrdered(new String[]{"store_state=WA; A=2.7783838325212463E10", "store_state=CA; A=1.0112000537448784E10", "store_state=OR; A=8.077425041941243E9"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$63, $90, $91]], groups=[{0}], aggs=[[SUM($1), SUM($2)]], post_projects=[[$0, *($1, $2)]], sort0=[1], dir0=[DESC])").queryContains(DruidAdapterIT.druidChecker(postAggString));
    }

    @Test
    public void testMinusArithmeticOperation() {
        String sqlQuery = "select \"store_state\", sum(\"store_sales\") - sum(\"store_cost\") as a from \"foodmart\"  group by \"store_state\" order by a desc";
        String postAggString = "'postAggregations':[{'type':'expression','name':'A','expression':'(\\'$f1\\' - \\'$f2\\')'}]";
        String plan = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$63, $90, $91]], groups=[{0}], aggs=[[SUM($1), SUM($2)]], post_projects=[[$0, -($1, $2)]], sort0=[1], dir0=[DESC])";
        this.sql("select \"store_state\", sum(\"store_sales\") - sum(\"store_cost\") as a from \"foodmart\"  group by \"store_state\" order by a desc", FOODMART).returnsOrdered(new String[]{"store_state=WA; A=158468.91210000002", "store_state=CA; A=95637.41489999992", "store_state=OR; A=85504.56939999988"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$63, $90, $91]], groups=[{0}], aggs=[[SUM($1), SUM($2)]], post_projects=[[$0, -($1, $2)]], sort0=[1], dir0=[DESC])").queryContains(DruidAdapterIT.druidChecker(postAggString));
    }

    @Test
    public void testConstantPostAggregator() {
        String sqlQuery = "select \"store_state\", sum(\"store_sales\") + 100 as a from \"foodmart\"  group by \"store_state\" order by a desc";
        String postAggString = "{'type':'expression','name':'A','expression':'(\\'$f1\\' + 100)'}";
        String plan = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$63, $90]], groups=[{0}], aggs=[[SUM($1)]], post_projects=[[$0, +($1, 100)]], sort0=[1], dir0=[DESC])";
        this.sql("select \"store_state\", sum(\"store_sales\") + 100 as a from \"foodmart\"  group by \"store_state\" order by a desc", FOODMART).returnsOrdered(new String[]{"store_state=WA; A=263893.2200000001", "store_state=CA; A=159267.83999999994", "store_state=OR; A=142377.06999999992"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$63, $90]], groups=[{0}], aggs=[[SUM($1)]], post_projects=[[$0, +($1, 100)]], sort0=[1], dir0=[DESC])").queryContains(DruidAdapterIT.druidChecker(postAggString));
    }

    @Test
    public void testRecursiveArithmeticOperation() {
        String sqlQuery = "select \"store_state\", -1 * (a + b) as c from (select (sum(\"store_sales\")-sum(\"store_cost\")) / (count(*) * 3) AS a,sum(\"unit_sales\") AS b, \"store_state\"  from \"foodmart\"  group by \"store_state\") order by c desc";
        String postAggString = "'postAggregations':[{'type':'expression','name':'C','expression':'(-1 * (((\\'$f1\\' - \\'$f2\\') / (\\'$f3\\' * 3)) + \\'B\\'))'}]";
        String plan = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$63, $89, $90, $91]], groups=[{0}], aggs=[[SUM($2), SUM($3), COUNT(), SUM($1)]], post_projects=[[$0, *(-1, +(/(-($1, $2), *($3, 3)), $4))]], sort0=[1], dir0=[DESC])";
        this.sql("select \"store_state\", -1 * (a + b) as c from (select (sum(\"store_sales\")-sum(\"store_cost\")) / (count(*) * 3) AS a,sum(\"unit_sales\") AS b, \"store_state\"  from \"foodmart\"  group by \"store_state\") order by c desc", FOODMART).returnsOrdered(new String[]{"store_state=OR; C=-67660.31890435601", "store_state=CA; C=-74749.30433035882", "store_state=WA; C=-124367.29537914316"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$63, $89, $90, $91]], groups=[{0}], aggs=[[SUM($2), SUM($3), COUNT(), SUM($1)]], post_projects=[[$0, *(-1, +(/(-($1, $2), *($3, 3)), $4))]], sort0=[1], dir0=[DESC])").queryContains(DruidAdapterIT.druidChecker(postAggString));
    }

    @Test
    public void testHyperUniquePostAggregator() {
        String sqlQuery = "select \"store_state\", sum(\"store_cost\") / count(distinct \"brand_name\") as a from \"foodmart\"  group by \"store_state\" order by a desc";
        String postAggString = "[{'type':'expression','name':'A','expression':'(\\'$f1\\' / \\'$f2\\')'}]";
        String plan = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$2, $63, $91]], groups=[{1}], aggs=[[SUM($2), COUNT(DISTINCT $0)]], post_projects=[[$0, /($1, $2)]], sort0=[1], dir0=[DESC])";
        this.foodmartApprox("select \"store_state\", sum(\"store_cost\") / count(distinct \"brand_name\") as a from \"foodmart\"  group by \"store_state\" order by a desc").runs().explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$2, $63, $91]], groups=[{1}], aggs=[[SUM($2), COUNT(DISTINCT $0)]], post_projects=[[$0, /($1, $2)]], sort0=[1], dir0=[DESC])").queryContains(DruidAdapterIT.druidChecker("[{'type':'expression','name':'A','expression':'(\\'$f1\\' / \\'$f2\\')'}]"));
    }

    @Test
    public void testExtractFilterWorkWithPostAggregations() {
        String sql = "SELECT \"store_state\", \"brand_name\", sum(\"store_sales\") - sum(\"store_cost\") as a  from \"foodmart\" where extract (week from \"timestamp\") IN (10,11) and \"brand_name\"='Bird Call' group by \"store_state\", \"brand_name\"";
        String druidQuery = "\"postAggregations\":[{\"type\":\"expression\",\"name\":\"A\",\"expression\":\"(\\\"$f2\\\" - \\\"$f3\\\")\"}]";
        String plan = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[AND(=(";
        this.sql("SELECT \"store_state\", \"brand_name\", sum(\"store_sales\") - sum(\"store_cost\") as a  from \"foodmart\" where extract (week from \"timestamp\") IN (10,11) and \"brand_name\"='Bird Call' group by \"store_state\", \"brand_name\"", FOODMART).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[AND(=(").returnsOrdered(new String[]{"store_state=CA; brand_name=Bird Call; A=34.364599999999996", "store_state=OR; brand_name=Bird Call; A=39.16359999999999", "store_state=WA; brand_name=Bird Call; A=53.742500000000014"}).queryContains(DruidAdapterIT.druidChecker("\"postAggregations\":[{\"type\":\"expression\",\"name\":\"A\",\"expression\":\"(\\\"$f2\\\" - \\\"$f3\\\")\"}]"));
    }

    @Test
    public void testExtractFilterWorkWithPostAggregationsWithConstant() {
        String sql = "SELECT \"store_state\", 'Bird Call' as \"brand_name\", sum(\"store_sales\") - sum(\"store_cost\") as a  from \"foodmart\" where extract (week from \"timestamp\") IN (10,11) and \"brand_name\"='Bird Call' group by \"store_state\"";
        String druidQuery = "type':'expression','name':'A','expression':'(\\'$f1\\' - \\'$f2\\')";
        String plan = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[AND(=($2, 'Bird Call'), OR(=(EXTRACT(FLAG(WEEK), $0), 10), =(EXTRACT(FLAG(WEEK), $0), 11)))], projects=[[$0, $2, $63, $90, $91]], groups=[{2}], aggs=[[SUM($3), SUM($4)]], post_projects=[[$0, 'Bird Call', -($1, $2)]])";
        this.sql("SELECT \"store_state\", 'Bird Call' as \"brand_name\", sum(\"store_sales\") - sum(\"store_cost\") as a  from \"foodmart\" where extract (week from \"timestamp\") IN (10,11) and \"brand_name\"='Bird Call' group by \"store_state\"", FOODMART).returnsOrdered(new String[]{"store_state=CA; brand_name=Bird Call; A=34.364599999999996", "store_state=OR; brand_name=Bird Call; A=39.16359999999999", "store_state=WA; brand_name=Bird Call; A=53.742500000000014"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[AND(=($2, 'Bird Call'), OR(=(EXTRACT(FLAG(WEEK), $0), 10), =(EXTRACT(FLAG(WEEK), $0), 11)))], projects=[[$0, $2, $63, $90, $91]], groups=[{2}], aggs=[[SUM($3), SUM($4)]], post_projects=[[$0, 'Bird Call', -($1, $2)]])").queryContains(DruidAdapterIT.druidChecker("type':'expression','name':'A','expression':'(\\'$f1\\' - \\'$f2\\')"));
    }

    @Test
    public void testSingleAverageFunction() {
        String sqlQuery = "select \"store_state\", sum(\"store_cost\") / count(*) as a from \"foodmart\" group by \"store_state\" order by a desc";
        String postAggString = "\"postAggregations\":[{\"type\":\"expression\",\"name\":\"A\",\"expression\":\"(\\\"$f1\\\" / \\\"$f2\\\")";
        String plan = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$63, $91]], groups=[{0}], aggs=[[SUM($1), COUNT()]], post_projects=[[$0, /($1, $2)]], sort0=[1], dir0=[DESC])";
        this.sql("select \"store_state\", sum(\"store_cost\") / count(*) as a from \"foodmart\" group by \"store_state\" order by a desc", FOODMART).returnsOrdered(new String[]{"store_state=OR; A=2.6271402406293403", "store_state=CA; A=2.599338206292706", "store_state=WA; A=2.5828708592868717"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$63, $91]], groups=[{0}], aggs=[[SUM($1), COUNT()]], post_projects=[[$0, /($1, $2)]], sort0=[1], dir0=[DESC])").queryContains(DruidAdapterIT.druidChecker(postAggString));
    }

    @Test
    public void testPartiallyPostAggregation() {
        String sqlQuery = "select \"store_state\", sum(\"store_sales\") / sum(\"store_cost\") as a, case when sum(\"unit_sales\")=0 then 1.0 else sum(\"unit_sales\") end as b from \"foodmart\"  group by \"store_state\" order by a desc";
        String postAggString = "'postAggregations':[{'type':'expression','name':'A','expression':'(\\'$f1\\' / \\'$f2\\')'},{'type':'expression','name':'B','expression':'case_searched((\\'$f3\\' == 0),1.0,CAST(\\'$f3\\'";
        String plan = "DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$63, $89, $90, $91]], groups=[{0}], aggs=[[SUM($2), SUM($3), SUM($1)]], post_projects=[[$0, /($1, $2), CASE(=($3, 0), 1.0, CAST($3):DECIMAL(19, 0))]], sort0=[1], dir0=[DESC])";
        this.sql("select \"store_state\", sum(\"store_sales\") / sum(\"store_cost\") as a, case when sum(\"unit_sales\")=0 then 1.0 else sum(\"unit_sales\") end as b from \"foodmart\"  group by \"store_state\" order by a desc", FOODMART).returnsOrdered(new String[]{"store_state=OR; A=2.506091302943239; B=67659.0", "store_state=CA; A=2.505379741272971; B=74748.0", "store_state=WA; A=2.5045806163801996; B=124366.0"}).explainContains("DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$63, $89, $90, $91]], groups=[{0}], aggs=[[SUM($2), SUM($3), SUM($1)]], post_projects=[[$0, /($1, $2), CASE(=($3, 0), 1.0, CAST($3):DECIMAL(19, 0))]], sort0=[1], dir0=[DESC])").queryContains(DruidAdapterIT.druidChecker("'postAggregations':[{'type':'expression','name':'A','expression':'(\\'$f1\\' / \\'$f2\\')'},{'type':'expression','name':'B','expression':'case_searched((\\'$f3\\' == 0),1.0,CAST(\\'$f3\\'"));
    }

    @Test
    public void testDuplicateReferenceOnPostAggregation() {
        String sqlQuery = "select \"store_state\", a, a - b as c from (select \"store_state\", sum(\"store_sales\") + 100 as a, sum(\"store_cost\") as b from \"foodmart\"  group by \"store_state\") order by a desc";
        String postAggString = "[{'type':'expression','name':'A','expression':'(\\'$f1\\' + 100)'},{'type':'expression','name':'C','expression':'((\\'$f1\\' + 100) - \\'B\\')'}]";
        String plan = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], groups=[{63}], aggs=[[SUM($90), SUM($91)]], post_projects=[[$0, +($1, 100), -(+($1, 100), $2)]], sort0=[1], dir0=[DESC]";
        this.sql("select \"store_state\", a, a - b as c from (select \"store_state\", sum(\"store_sales\") + 100 as a, sum(\"store_cost\") as b from \"foodmart\"  group by \"store_state\") order by a desc", FOODMART).returnsOrdered(new String[]{"store_state=WA; A=263893.2200000001; C=158568.91210000002", "store_state=CA; A=159267.83999999994; C=95737.41489999992", "store_state=OR; A=142377.06999999992; C=85604.56939999988"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], groups=[{63}], aggs=[[SUM($90), SUM($91)]], post_projects=[[$0, +($1, 100), -(+($1, 100), $2)]], sort0=[1], dir0=[DESC]").queryContains(DruidAdapterIT.druidChecker(postAggString));
    }

    @Test
    public void testDivideByZeroDoubleTypeInfinity() {
        String sqlQuery = "select \"store_state\", sum(\"store_cost\") / 0 as a from \"foodmart\"  group by \"store_state\" order by a desc";
        String postAggString = "'type':'expression','name':'A','expression':'(\\'$f1\\' / 0)'}]";
        String plan = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$63, $91]], groups=[{0}], aggs=[[SUM($1)]], post_projects=[[$0, /($1, 0)]], sort0=[1], dir0=[DESC])";
        this.sql("select \"store_state\", sum(\"store_cost\") / 0 as a from \"foodmart\"  group by \"store_state\" order by a desc", FOODMART).returnsOrdered(new String[]{"store_state=CA; A=Infinity", "store_state=OR; A=Infinity", "store_state=WA; A=Infinity"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$63, $91]], groups=[{0}], aggs=[[SUM($1)]], post_projects=[[$0, /($1, 0)]], sort0=[1], dir0=[DESC])").queryContains(DruidAdapterIT.druidChecker(postAggString));
    }

    @Test
    public void testDivideByZeroDoubleTypeNegInfinity() {
        String sqlQuery = "select \"store_state\", -1.0 * sum(\"store_cost\") / 0 as a from \"foodmart\"  group by \"store_state\" order by a desc";
        String postAggString = "\"postAggregations\":[{\"type\":\"expression\",\"name\":\"A\",\"expression\":\"((-1.0 * \\\"$f1\\\") / 0)\"}],";
        String plan = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$63, $91]], groups=[{0}], aggs=[[SUM($1)]], post_projects=[[$0, /(*(-1.0, $1), 0)]], sort0=[1], dir0=[DESC])";
        this.sql("select \"store_state\", -1.0 * sum(\"store_cost\") / 0 as a from \"foodmart\"  group by \"store_state\" order by a desc", FOODMART).returnsOrdered(new String[]{"store_state=CA; A=-Infinity", "store_state=OR; A=-Infinity", "store_state=WA; A=-Infinity"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$63, $91]], groups=[{0}], aggs=[[SUM($1)]], post_projects=[[$0, /(*(-1.0, $1), 0)]], sort0=[1], dir0=[DESC])").queryContains(DruidAdapterIT.druidChecker(postAggString));
    }

    @Test
    public void testDivideByZeroDoubleTypeNaN() {
        String sqlQuery = "select \"store_state\", (sum(\"store_cost\") - sum(\"store_cost\")) / 0 as a from \"foodmart\"  group by \"store_state\" order by a desc";
        String postAggString = "'postAggregations':[{'type':'expression','name':'A','expression':'((\\'$f1\\' - \\'$f1\\') / 0)'}";
        String plan = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$63, $91]], groups=[{0}], aggs=[[SUM($1)]], post_projects=[[$0, /(-($1, $1), 0)]], sort0=[1], dir0=[DESC])";
        this.sql("select \"store_state\", (sum(\"store_cost\") - sum(\"store_cost\")) / 0 as a from \"foodmart\"  group by \"store_state\" order by a desc", FOODMART).returnsOrdered(new String[]{"store_state=CA; A=NaN", "store_state=OR; A=NaN", "store_state=WA; A=NaN"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$63, $91]], groups=[{0}], aggs=[[SUM($1)]], post_projects=[[$0, /(-($1, $1), 0)]], sort0=[1], dir0=[DESC])").queryContains(DruidAdapterIT.druidChecker("'postAggregations':[{'type':'expression','name':'A','expression':'((\\'$f1\\' - \\'$f1\\') / 0)'}"));
    }

    @Test
    public void testDivideByZeroIntegerType() {
        String sqlQuery = "select \"store_state\", (count(*) - count(*)) / 0 as a from \"foodmart\"  group by \"store_state\" order by a desc";
        String plan = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$63]], groups=[{0}], aggs=[[COUNT()]], post_projects=[[$0, /(-($1, $1), 0)]], sort0=[1], dir0=[DESC])";
        this.sql("select \"store_state\", (count(*) - count(*)) / 0 as a from \"foodmart\"  group by \"store_state\" order by a desc", FOODMART).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$63]], groups=[{0}], aggs=[[COUNT()]], post_projects=[[$0, /(-($1, $1), 0)]], sort0=[1], dir0=[DESC])").throws_("Server returned HTTP response code: 500");
    }

    @Test
    public void testInterleaveBetweenAggregateAndGroupOrderByOnMetrics() {
        String sqlQuery = "select \"store_state\", \"brand_name\", \"A\" from (\n  select sum(\"store_sales\")-sum(\"store_cost\") as a, \"store_state\", \"brand_name\"\n  from \"foodmart\"\n  group by \"store_state\", \"brand_name\" ) subq\norder by \"A\" limit 5";
        String postAggString = "\"postAggregations\":[{\"type\":\"expression\",\"name\":\"A\",\"expression\":\"(\\\"$f2\\\" - \\\"$f3\\\")\"}";
        String plan = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$63, $2, $90, $91]], groups=[{0, 1}], aggs=[[SUM($2), SUM($3)]], post_projects=[[$0, $1, -($2, $3)]], sort0=[2], dir0=[ASC], fetch=[5])";
        this.sql("select \"store_state\", \"brand_name\", \"A\" from (\n  select sum(\"store_sales\")-sum(\"store_cost\") as a, \"store_state\", \"brand_name\"\n  from \"foodmart\"\n  group by \"store_state\", \"brand_name\" ) subq\norder by \"A\" limit 5", FOODMART).returnsOrdered(new String[]{"store_state=CA; brand_name=King; A=21.4632", "store_state=OR; brand_name=Symphony; A=32.176", "store_state=CA; brand_name=Toretti; A=32.24650000000001", "store_state=WA; brand_name=King; A=34.6104", "store_state=OR; brand_name=Toretti; A=36.3"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$63, $2, $90, $91]], groups=[{0, 1}], aggs=[[SUM($2), SUM($3)]], post_projects=[[$0, $1, -($2, $3)]], sort0=[2], dir0=[ASC], fetch=[5])").queryContains(DruidAdapterIT.druidChecker(postAggString));
    }

    @Test
    public void testInterleaveBetweenAggregateAndGroupOrderByOnDimension() {
        String sqlQuery = "select \"store_state\", \"brand_name\", \"A\" from \n(select \"store_state\", sum(\"store_sales\")+sum(\"store_cost\") as a, \"brand_name\" from \"foodmart\" group by \"store_state\", \"brand_name\") order by \"brand_name\", \"store_state\" limit 5";
        String postAggString = "'postAggregations':[{'type':'expression','name':'A','expression':'(\\'$f2\\' + \\'$f3\\')'}]";
        String plan = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], groups=[{2, 63}], aggs=[[SUM($90), SUM($91)]], post_projects=[[$1, $0, +($2, $3)]], sort0=[1], sort1=[0], dir0=[ASC], dir1=[ASC], fetch=[5])";
        this.sql("select \"store_state\", \"brand_name\", \"A\" from \n(select \"store_state\", sum(\"store_sales\")+sum(\"store_cost\") as a, \"brand_name\" from \"foodmart\" group by \"store_state\", \"brand_name\") order by \"brand_name\", \"store_state\" limit 5", FOODMART).returnsOrdered(new String[]{"store_state=CA; brand_name=ADJ; A=222.1524", "store_state=OR; brand_name=ADJ; A=186.60359999999997", "store_state=WA; brand_name=ADJ; A=216.9912", "store_state=CA; brand_name=Akron; A=250.349", "store_state=OR; brand_name=Akron; A=278.69720000000007"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], groups=[{2, 63}], aggs=[[SUM($90), SUM($91)]], post_projects=[[$1, $0, +($2, $3)]], sort0=[1], sort1=[0], dir0=[ASC], dir1=[ASC], fetch=[5])").queryContains(DruidAdapterIT.druidChecker("'postAggregations':[{'type':'expression','name':'A','expression':'(\\'$f2\\' + \\'$f3\\')'}]"));
    }

    @Test
    public void testOrderByOnMetricsInSelectDruidQuery() {
        String sqlQuery = "select \"store_sales\" as a, \"store_cost\" as b, \"store_sales\" - \"store_cost\" as c from \"foodmart\" where \"timestamp\" >= '1997-01-01 00:00:00 UTC' and \"timestamp\" < '1997-09-01 00:00:00 UTC' order by c limit 5";
        String queryType = "'queryType':'scan'";
        String plan = "PLAN=EnumerableInterpreter\n  BindableSort(sort0=[$2], dir0=[ASC], fetch=[5])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1997-01-01T00:00:00.000Z/1997-09-01T00:00:00.000Z]], projects=[[$90, $91, -($90, $91)]])";
        this.sql("select \"store_sales\" as a, \"store_cost\" as b, \"store_sales\" - \"store_cost\" as c from \"foodmart\" where \"timestamp\" >= '1997-01-01 00:00:00 UTC' and \"timestamp\" < '1997-09-01 00:00:00 UTC' order by c limit 5", FOODMART).returnsOrdered(new String[]{"A=0.51; B=0.2448; C=0.2652", "A=0.51; B=0.2397; C=0.2703", "A=0.57; B=0.285; C=0.285", "A=0.5; B=0.21; C=0.29000000000000004", "A=0.57; B=0.2793; C=0.29069999999999996"}).explainContains("PLAN=EnumerableInterpreter\n  BindableSort(sort0=[$2], dir0=[ASC], fetch=[5])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1997-01-01T00:00:00.000Z/1997-09-01T00:00:00.000Z]], projects=[[$90, $91, -($90, $91)]])").queryContains(DruidAdapterIT.druidChecker(queryType));
    }

    @Test
    public void testFilterClauseFactoredOut() {
        String sql = "select sum(\"store_sales\") filter (where \"the_year\" >= 1997) from \"foodmart\"";
        String expectedQuery = "{'queryType':'timeseries','dataSource':'foodmart','descending':false,'granularity':'all','filter':{'type':'bound','dimension':'the_year','lower':'1997','lowerStrict':false,'ordering':'numeric'},'aggregations':[{'type':'doubleSum','name':'EXPR$0','fieldName':'store_sales'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'context':{'skipEmptyBuckets':false}}";
        this.sql(sql).queryContains(DruidAdapterIT.druidChecker(expectedQuery));
    }

    @Test
    public void testFilterClauseAlwaysTrueGone() {
        String sql = "select sum(\"store_sales\") filter (where 1 = 1) from \"foodmart\"";
        String expectedQuery = "{'queryType':'timeseries','dataSource':'foodmart','descending':false,'granularity':'all','aggregations':[{'type':'doubleSum','name':'EXPR$0','fieldName':'store_sales'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'context':{'skipEmptyBuckets':false}}";
        this.sql(sql).queryContains(DruidAdapterIT.druidChecker(expectedQuery));
    }

    @Test
    public void testFilterClauseAlwaysTrueWithAggGone1() {
        String sql = "select sum(\"store_sales\") filter (where 1 = 1), sum(\"store_cost\") from \"foodmart\"";
        String expectedQuery = "{'queryType':'timeseries','dataSource':'foodmart','descending':false,'granularity':'all','aggregations':[{'type':'doubleSum','name':'EXPR$0','fieldName':'store_sales'},{'type':'doubleSum','name':'EXPR$1','fieldName':'store_cost'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'context':{'skipEmptyBuckets':false}}";
        this.sql(sql).queryContains(DruidAdapterIT.druidChecker(expectedQuery));
    }

    @Test
    public void testFilterClauseAlwaysTrueWithAggGone2() {
        String sql = "select sum(\"store_sales\") filter (where 1 = 1), sum(\"store_cost\") filter (where \"store_state\" = 'CA') from \"foodmart\"";
        String expectedQuery = "{'queryType':'timeseries','dataSource':'foodmart','descending':false,'granularity':'all','aggregations':[{'type':'doubleSum','name':'EXPR$0','fieldName':'store_sales'},{'type':'filtered','filter':{'type':'selector','dimension':'store_state','value':'CA'},'aggregator':{'type':'doubleSum','name':'EXPR$1','fieldName':'store_cost'}}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'context':{'skipEmptyBuckets':false}}";
        this.sql(sql).queryContains(DruidAdapterIT.druidChecker(expectedQuery));
    }

    @Test
    public void testOuterFilterRemainsWithAlwaysTrueClause() {
        String sql = "select sum(\"store_sales\") filter (where 1 = 1), sum(\"store_cost\") from \"foodmart\" where \"store_city\" = 'Seattle'";
        String expectedQuery = "{'queryType':'timeseries','dataSource':'foodmart','descending':false,'granularity':'all','filter':{'type':'selector','dimension':'store_city','value':'Seattle'},'aggregations':[{'type':'doubleSum','name':'EXPR$0','fieldName':'store_sales'},{'type':'doubleSum','name':'EXPR$1','fieldName':'store_cost'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'context':{'skipEmptyBuckets':false}}";
        this.sql(sql).queryContains(DruidAdapterIT.druidChecker(expectedQuery));
    }

    @Test
    public void testFilterClauseAlwaysFalseNotPushed() {
        String sql = "select sum(\"store_sales\") filter (where 1 > 1) from \"foodmart\"";
        String expectedSubExplain = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[false], projects=[[$90, false]], groups=[{}], aggs=[[SUM($0)]])";
        this.sql(sql).queryContains(DruidAdapterIT.druidChecker("{\"queryType\":\"timeseries\",\"dataSource\":\"foodmart\",\"descending\":false,\"granularity\":\"all\",\"filter\":{\"type\":\"expression\",\"expression\":\"1 == 2\"},\"aggregations\":[{\"type\":\"doubleSum\",\"name\":\"EXPR$0\",\"fieldName\":\"store_sales\"}],\"intervals\":[\"1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z\"],\"context\":{\"skipEmptyBuckets\":false}}")).explainContains(expectedSubExplain);
    }

    @Test
    public void testFilterClauseAlwaysFalseNotPushedWithFilter() {
        String sql = "select sum(\"store_sales\") filter (where 1 > 1) from \"foodmart\" where \"store_city\" = 'Seattle'";
        String expectedSubExplain = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[AND(false, =($62, 'Seattle'))], projects=[[$90, false]], groups=[{}], aggs=[[SUM($0)]])";
        this.sql(sql).explainContains(expectedSubExplain).queryContains(DruidAdapterIT.druidChecker("\"filter\":{\"type\":\"and\",\"fields\":[{\"type\":\"expression\",\"expression\":\"1 == 2\"},{\"type\":\"selector\",\"dimension\":\"store_city\",\"value\":\"Seattle\"}]}"));
    }

    @Test
    public void testFilterClauseSameAsOuterFilterGone() {
        String sql = "select sum(\"store_sales\") filter (where \"store_city\" = 'Seattle') from \"foodmart\" where \"store_city\" = 'Seattle'";
        String expectedQuery = "{'queryType':'timeseries','dataSource':'foodmart','descending':false,'granularity':'all','filter':{'type':'selector','dimension':'store_city','value':'Seattle'},'aggregations':[{'type':'doubleSum','name':'EXPR$0','fieldName':'store_sales'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'context':{'skipEmptyBuckets':false}}";
        this.sql(sql).queryContains(DruidAdapterIT.druidChecker(expectedQuery)).returnsUnordered(new String[]{"EXPR$0=52644.07000000001"});
    }

    @Test
    public void testFilterClauseNotFactoredOut1() {
        String sql = "select sum(\"store_sales\") filter (where \"store_state\" = 'CA'), sum(\"store_cost\") from \"foodmart\"";
        String expectedQuery = "{'queryType':'timeseries','dataSource':'foodmart','descending':false,'granularity':'all','aggregations':[{'type':'filtered','filter':{'type':'selector','dimension':'store_state','value':'CA'},'aggregator':{'type':'doubleSum','name':'EXPR$0','fieldName':'store_sales'}},{'type':'doubleSum','name':'EXPR$1','fieldName':'store_cost'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'context':{'skipEmptyBuckets':false}}";
        this.sql(sql).queryContains(DruidAdapterIT.druidChecker(expectedQuery));
    }

    @Test
    public void testFilterClauseNotFactoredOut2() {
        String sql = "select sum(\"store_sales\") filter (where \"store_state\" = 'CA'), sum(\"store_cost\") from \"foodmart\" where \"the_year\" >= 1997";
        String expectedQuery = "{'queryType':'timeseries','dataSource':'foodmart','descending':false,'granularity':'all','filter':{'type':'bound','dimension':'the_year','lower':'1997','lowerStrict':false,'ordering':'numeric'},'aggregations':[{'type':'filtered','filter':{'type':'selector','dimension':'store_state','value':'CA'},'aggregator':{'type':'doubleSum','name':'EXPR$0','fieldName':'store_sales'}},{'type':'doubleSum','name':'EXPR$1','fieldName':'store_cost'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'context':{'skipEmptyBuckets':false}}";
        this.sql(sql).queryContains(DruidAdapterIT.druidChecker(expectedQuery));
    }

    @Test
    public void testFilterClausesFactoredForPruning1() {
        String sql = "select sum(\"store_sales\") filter (where \"store_state\" = 'CA'), sum(\"store_sales\") filter (where \"store_state\" = 'WA') from \"foodmart\"";
        String expectedQuery = "{'queryType':'timeseries','dataSource':'foodmart','descending':false,'granularity':'all','filter':{'type':'or','fields':[{'type':'selector','dimension':'store_state','value':'CA'},{'type':'selector','dimension':'store_state','value':'WA'}]},'aggregations':[{'type':'filtered','filter':{'type':'selector','dimension':'store_state','value':'CA'},'aggregator':{'type':'doubleSum','name':'EXPR$0','fieldName':'store_sales'}},{'type':'filtered','filter':{'type':'selector','dimension':'store_state','value':'WA'},'aggregator':{'type':'doubleSum','name':'EXPR$1','fieldName':'store_sales'}}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'context':{'skipEmptyBuckets':false}}";
        this.sql(sql).queryContains(DruidAdapterIT.druidChecker(expectedQuery)).returnsUnordered(new String[]{"EXPR$0=159167.83999999994; EXPR$1=263793.2200000001"});
    }

    @Test
    public void testFilterClausesFactoredForPruning2() {
        String sql = "select sum(\"store_sales\") filter (where \"store_state\" = 'CA'), sum(\"store_sales\") filter (where \"store_state\" = 'WA') from \"foodmart\" where \"brand_name\" = 'Super'";
        String expectedQuery = "{'queryType':'timeseries','dataSource':'foodmart','descending':false,'granularity':'all','filter':{'type':'and','fields':[{'type':'or','fields':[{'type':'selector','dimension':'store_state','value':'CA'},{'type':'selector','dimension':'store_state','value':'WA'}]},{'type':'selector','dimension':'brand_name','value':'Super'}]},'aggregations':[{'type':'filtered','filter':{'type':'selector','dimension':'store_state','value':'CA'},'aggregator':{'type':'doubleSum','name':'EXPR$0','fieldName':'store_sales'}},{'type':'filtered','filter':{'type':'selector','dimension':'store_state','value':'WA'},'aggregator':{'type':'doubleSum','name':'EXPR$1','fieldName':'store_sales'}}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'context':{'skipEmptyBuckets':false}}";
        this.sql(sql).queryContains(DruidAdapterIT.druidChecker(expectedQuery)).returnsUnordered(new String[]{"EXPR$0=2600.01; EXPR$1=4486.4400000000005"});
    }

    @Test
    public void testMultipleFiltersFactoredOutWithOuterFilter() {
        String sql = "select sum(\"store_sales\") filter (where \"store_state\" = 'CA'), sum(\"store_cost\") filter (where \"store_state\" = 'CA') from \"foodmart\" where \"brand_name\" = 'Super'";
        String expectedAggregateExplain = "aggs=[[SUM($0), SUM($2)]]";
        String expectedQuery = "{'queryType':'timeseries','dataSource':'foodmart','descending':false,'granularity':'all','filter':{'type':'and','fields':[{'type':'selector','dimension':'store_state','value':'CA'},{'type':'selector','dimension':'brand_name','value':'Super'}]},'aggregations':[{'type':'doubleSum','name':'EXPR$0','fieldName':'store_sales'},{'type':'doubleSum','name':'EXPR$1','fieldName':'store_cost'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'context':{'skipEmptyBuckets':false}}";
        this.sql(sql).queryContains(DruidAdapterIT.druidChecker(expectedQuery)).explainContains(expectedAggregateExplain).returnsUnordered(new String[]{"EXPR$0=2600.01; EXPR$1=1013.162"});
    }

    @Test
    public void testOuterFilterFalseAfterFactorSimplification() {
        String sql = "select sum(\"store_sales\") filter (where \"the_year\" > 1997) from \"foodmart\" where \"the_year\" <= 1997";
        String expectedFilter = "filter':{'type':'and','fields':[{'type':'bound','dimension':'the_year','lower':'1997','lowerStrict':true,'ordering':'numeric'},{'type':'bound','dimension':'the_year','upper':'1997','upperStrict':false,'ordering':'numeric'}]}";
        String context = "'skipEmptyBuckets':false";
        this.sql(sql).queryContains(DruidAdapterIT.druidChecker(expectedFilter, context));
    }

    @Test
    public void testFilterClauseNotPushable() {
        String sql = "select sum(\"store_sales\") filter (where \"the_year\" like '199_') from \"foodmart\"";
        String expectedSubExplain = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[LIKE($83, '199_')], projects=[[$90, IS TRUE(LIKE($83, '199_'))]], groups=[{}], aggs=[[SUM($0)]])";
        this.sql(sql).explainContains(expectedSubExplain).queryContains(DruidAdapterIT.druidChecker("\"filter\":{\"type\":\"expression\",\"expression\":\"like(\\\"the_year\\\","));
    }

    @Test
    public void testFilterClauseWithMetricRef() {
        String sql = "select sum(\"store_sales\") filter (where \"store_cost\" > 10) from \"foodmart\"";
        String expectedSubExplain = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[>($91, 10)], projects=[[$90, IS TRUE(>($91, 10))]], groups=[{}], aggs=[[SUM($0)]])";
        this.sql(sql).explainContains(expectedSubExplain).queryContains(DruidAdapterIT.druidChecker("\"queryType\":\"timeseries\"", "\"filter\":{\"type\":\"bound\",\"dimension\":\"store_cost\",\"lower\":\"10\",\"lowerStrict\":true,\"ordering\":\"numeric\"}")).returnsUnordered(new String[]{"EXPR$0=25.060000000000002"});
    }

    @Test
    public void testFilterClauseWithMetricRefAndAggregates() {
        String sql = "select sum(\"store_sales\"), \"product_id\" from \"foodmart\" where \"product_id\" > 1553 and \"store_cost\" > 5 group by \"product_id\"";
        String expectedSubExplain = "PLAN=EnumerableInterpreter\n  BindableProject(EXPR$0=[$1], product_id=[$0])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[AND(>(CAST($1):BIGINT, 1553), >($91, 5))], groups=[{1}], aggs=[[SUM($90)]])";
        this.sql(sql).explainContains(expectedSubExplain).queryContains(DruidAdapterIT.druidChecker("\"queryType\":\"groupBy\"", "{\"type\":\"bound\",\"dimension\":\"store_cost\",\"lower\":\"5\",\"lowerStrict\":true,\"ordering\":\"numeric\"}")).returnsUnordered(new String[]{"EXPR$0=10.16; product_id=1554\nEXPR$0=45.05; product_id=1556\nEXPR$0=88.5; product_id=1555"});
    }

    @Test
    public void testFilterClauseWithMetricAndTimeAndAggregates() {
        String sql = "select sum(\"store_sales\"), \"product_id\"from \"foodmart\" where \"product_id\" > 1555 and \"store_cost\" > 5 and extract(year from \"timestamp\") = 1997 group by floor(\"timestamp\" to DAY),\"product_id\"";
        this.sql(sql).queryContains(DruidAdapterIT.druidChecker("\"queryType\":\"groupBy\"", "{\"type\":\"bound\",\"dimension\":\"store_cost\",\"lower\":\"5\",\"lowerStrict\":true,\"ordering\":\"numeric\"}")).returnsUnordered(new String[]{"EXPR$0=10.6; product_id=1556\nEXPR$0=10.6; product_id=1556\nEXPR$0=10.6; product_id=1556\nEXPR$0=13.25; product_id=1556"});
    }

    @Test
    public void testNestedFilterClauseFactored() {
        String sql = "select sum(\"store_sales\") filter (where \"store_state\" = 'CA' or \"store_state\" = 'OR') from \"foodmart\"";
        String expectedFilterJson = "filter':{'type':'or','fields':[{'type':'selector','dimension':'store_state','value':'CA'},{'type':'selector','dimension':'store_state','value':'OR'}]}";
        String expectedAggregateJson = "'aggregations':[{'type':'doubleSum','name':'EXPR$0','fieldName':'store_sales'}]";
        this.sql(sql).queryContains(DruidAdapterIT.druidChecker(expectedFilterJson)).queryContains(DruidAdapterIT.druidChecker(expectedAggregateJson)).returnsUnordered(new String[]{"EXPR$0=301444.9099999999"});
    }

    @Test
    public void testNestedFilterClauseInAggregates() {
        String sql = "select sum(\"store_sales\") filter (where \"store_state\" = 'CA' and \"the_month\" = 'October'), sum(\"store_cost\") filter (where \"store_state\" = 'CA' and \"the_day\" = 'Monday') from \"foodmart\"";
        String expectedFilterJson = "filter':{'type':'or','fields':[{'type':'and','fields':[{'type':'selector','dimension':'store_state','value':'CA'},{'type':'selector','dimension':'the_month','value':'October'}]},{'type':'and','fields':[{'type':'selector','dimension':'store_state','value':'CA'},{'type':'selector','dimension':'the_day','value':'Monday'}]}]}";
        String expectedAggregatesJson = "'aggregations':[{'type':'filtered','filter':{'type':'and','fields':[{'type':'selector','dimension':'store_state','value':'CA'},{'type':'selector','dimension':'the_month','value':'October'}]},'aggregator':{'type':'doubleSum','name':'EXPR$0','fieldName':'store_sales'}},{'type':'filtered','filter':{'type':'and','fields':[{'type':'selector','dimension':'store_state','value':'CA'},{'type':'selector','dimension':'the_day','value':'Monday'}]},'aggregator':{'type':'doubleSum','name':'EXPR$1','fieldName':'store_cost'}}]";
        this.sql(sql).queryContains(DruidAdapterIT.druidChecker(expectedFilterJson)).queryContains(DruidAdapterIT.druidChecker(expectedAggregatesJson)).returnsUnordered(new String[]{"EXPR$0=13077.789999999992; EXPR$1=9830.7799"});
    }

    @Test
    public void testCountColumn() {
        String sql = "SELECT count(\"countryName\") FROM (SELECT \"countryName\" FROM \"wikiticker\" WHERE \"countryName\"  IS NOT NULL) as a";
        this.sql("SELECT count(\"countryName\") FROM (SELECT \"countryName\" FROM \"wikiticker\" WHERE \"countryName\"  IS NOT NULL) as a", WIKI_AUTO2).returnsUnordered(new String[]{"EXPR$0=3799"});
        String sql2 = "SELECT count(\"countryName\") FROM (SELECT \"countryName\" FROM \"wikiticker\") as a";
        String plan2 = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[wiki, wikiticker]], intervals=[[1900-01-01T00:00:00.000Z/3000-01-01T00:00:00.000Z]], projects=[[$7]], groups=[{}], aggs=[[COUNT($0)]])";
        this.sql("SELECT count(\"countryName\") FROM (SELECT \"countryName\" FROM \"wikiticker\") as a", WIKI_AUTO2).returnsUnordered(new String[]{"EXPR$0=3799"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[wiki, wikiticker]], intervals=[[1900-01-01T00:00:00.000Z/3000-01-01T00:00:00.000Z]], projects=[[$7]], groups=[{}], aggs=[[COUNT($0)]])");
        String sql3 = "SELECT count(*), count(\"countryName\") FROM \"wikiticker\"";
        String plan3 = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[wiki, wikiticker]], intervals=[[1900-01-01T00:00:00.000Z/3000-01-01T00:00:00.000Z]], projects=[[$7]], groups=[{}], aggs=[[COUNT(), COUNT($0)]])";
        this.sql("SELECT count(*), count(\"countryName\") FROM \"wikiticker\"", WIKI_AUTO2).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[wiki, wikiticker]], intervals=[[1900-01-01T00:00:00.000Z/3000-01-01T00:00:00.000Z]], projects=[[$7]], groups=[{}], aggs=[[COUNT(), COUNT($0)]])");
    }

    @Test
    public void testCountColumn2() {
        String sql = "SELECT count(\"countryName\") FROM (SELECT \"countryName\" FROM \"wikiticker\" WHERE \"countryName\"  IS NOT NULL) as a";
        this.sql("SELECT count(\"countryName\") FROM (SELECT \"countryName\" FROM \"wikiticker\" WHERE \"countryName\"  IS NOT NULL) as a", WIKI_AUTO2).queryContains(DruidAdapterIT.druidChecker("timeseries")).returnsUnordered(new String[]{"EXPR$0=3799"});
    }

    @Test
    public void testCountWithNonNull() {
        String sql = "select count(\"timestamp\") from \"foodmart\"\n";
        String druidQuery = "{'queryType':'timeseries','dataSource':'foodmart'";
        this.sql("select count(\"timestamp\") from \"foodmart\"\n").returnsUnordered(new String[]{"EXPR$0=86829"}).queryContains(DruidAdapterIT.druidChecker("{'queryType':'timeseries','dataSource':'foodmart'"));
    }

    @Test
    public void testNotFilterForm() {
        String sql = "select count(distinct \"the_month\") from \"foodmart\" where \"the_month\" <> 'October'";
        String druidFilter = "'filter':{'type':'not','field':{'type':'selector','dimension':'the_month','value':'October'}}";
        this.sql(sql, FOODMART).queryContains(DruidAdapterIT.druidChecker(druidFilter)).returnsOrdered(new String[]{"EXPR$0=11"});
    }

    @Test
    public void testDistinctCountWhenApproxResultsAccepted() {
        String sql = "select count(distinct \"store_state\") from \"foodmart\"";
        String expectedSubExplain = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$63]], groups=[{}], aggs=[[COUNT(DISTINCT $0)]])";
        String expectedAggregate = "{'type':'cardinality','name':'EXPR$0','fieldNames':['store_state']}";
        this.testCountWithApproxDistinct(true, sql, expectedSubExplain, expectedAggregate);
    }

    @Test
    public void testDistinctCountWhenApproxResultsNotAccepted() {
        String sql = "select count(distinct \"store_state\") from \"foodmart\"";
        String expectedSubExplain = "  BindableAggregate(group=[{}], EXPR$0=[COUNT($0)])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], groups=[{63}], aggs=[[]])";
        this.testCountWithApproxDistinct(false, sql, expectedSubExplain);
    }

    @Test
    public void testDistinctCountOnMetric() {
        String sql = "select count(distinct \"store_sales\") from \"foodmart\" where \"store_state\" = 'WA'";
        String expectedSubExplainNoApprox = "PLAN=EnumerableInterpreter\n  BindableAggregate(group=[{}], EXPR$0=[COUNT($0)])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[=($63, 'WA')], groups=[{90}], aggs=[[]])";
        String expectedSubPlanWithApprox = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[=($63, 'WA')], groups=[{}], aggs=[[COUNT(DISTINCT $90)]])";
        this.testCountWithApproxDistinct(true, "select count(distinct \"store_sales\") from \"foodmart\" where \"store_state\" = 'WA'", "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[=($63, 'WA')], groups=[{}], aggs=[[COUNT(DISTINCT $90)]])", "'queryType':'timeseries'");
        this.testCountWithApproxDistinct(false, "select count(distinct \"store_sales\") from \"foodmart\" where \"store_state\" = 'WA'", "PLAN=EnumerableInterpreter\n  BindableAggregate(group=[{}], EXPR$0=[COUNT($0)])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[=($63, 'WA')], groups=[{90}], aggs=[[]])", "'queryType':'groupBy'");
    }

    @Test
    public void testCountOnMetric() {
        String sql = "select \"brand_name\", count(\"store_sales\") from \"foodmart\" group by \"brand_name\"";
        String expectedSubExplain = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], groups=[{2}], aggs=[[COUNT($90)]])";
        this.testCountWithApproxDistinct(true, sql, expectedSubExplain, "\"queryType\":\"groupBy\"");
        this.testCountWithApproxDistinct(false, sql, expectedSubExplain, "\"queryType\":\"groupBy\"");
    }

    @Test
    public void testCountStar() {
        String sql = "select count(*) from \"foodmart\"";
        String expectedSubExplain = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[0]], groups=[{}], aggs=[[COUNT()]])";
        this.sql(sql).explainContains(expectedSubExplain);
    }

    @Test
    public void testCountOnMetricRenamed() {
        String sql = "select \"B\", count(\"A\") from (select \"unit_sales\" as \"A\", \"store_state\" as \"B\" from \"foodmart\") group by \"B\"";
        String expectedSubExplain = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], groups=[{63}], aggs=[[COUNT($89)]])";
        this.testCountWithApproxDistinct(true, sql, expectedSubExplain);
        this.testCountWithApproxDistinct(false, sql, expectedSubExplain);
    }

    @Test
    public void testDistinctCountOnMetricRenamed() {
        String sql = "select \"B\", count(distinct \"A\") from (select \"unit_sales\" as \"A\", \"store_state\" as \"B\" from \"foodmart\") group by \"B\"";
        String expectedSubExplainNoApprox = "PLAN=EnumerableInterpreter\n  BindableAggregate(group=[{0}], EXPR$1=[COUNT($1)])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$63, $89]], groups=[{0, 1}], aggs=[[]])";
        String expectedPlanWithApprox = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], groups=[{63}], aggs=[[COUNT(DISTINCT $89)]])";
        this.testCountWithApproxDistinct(true, "select \"B\", count(distinct \"A\") from (select \"unit_sales\" as \"A\", \"store_state\" as \"B\" from \"foodmart\") group by \"B\"", "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], groups=[{63}], aggs=[[COUNT(DISTINCT $89)]])", "'queryType':'groupBy'");
        this.testCountWithApproxDistinct(false, "select \"B\", count(distinct \"A\") from (select \"unit_sales\" as \"A\", \"store_state\" as \"B\" from \"foodmart\") group by \"B\"", "PLAN=EnumerableInterpreter\n  BindableAggregate(group=[{0}], EXPR$1=[COUNT($1)])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$63, $89]], groups=[{0, 1}], aggs=[[]])", "'queryType':'groupBy'");
    }

    private void testCountWithApproxDistinct(boolean approx, String sql, String expectedExplain) {
        this.testCountWithApproxDistinct(approx, sql, expectedExplain, "");
    }

    private void testCountWithApproxDistinct(boolean approx, String sql, String expectedExplain, String expectedDruidQuery) {
        CalciteAssert.that().enable(this.enabled()).withModel(FOODMART).with((ConnectionProperty)CalciteConnectionProperty.APPROXIMATE_DISTINCT_COUNT, (Object)approx).query(sql).runs().explainContains(expectedExplain).queryContains(DruidAdapterIT.druidChecker(expectedDruidQuery));
    }

    @Test
    public void testCountDistinctOnComplexColumn() {
        this.sql("select count(distinct \"user_id\") from \"wiki\"", WIKI).failsAtValidation("Rolled up column 'user_id' is not allowed in COUNT");
        this.foodmartApprox("select count(distinct \"customer_id\") from \"foodmart\"").queryContains(DruidAdapterIT.druidChecker("{'queryType':'timeseries','dataSource':'foodmart','descending':false,'granularity':'all','aggregations':[{'type':'thetaSketch','name':'EXPR$0','fieldName':'customer_id_ts'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'context':{'skipEmptyBuckets':false}}")).returnsUnordered(new String[]{"EXPR$0=5581"});
        this.foodmartApprox("select sum(\"store_sales\"), count(distinct \"customer_id\") filter (where \"store_state\" = 'CA') from \"foodmart\" where \"the_month\" = 'October'").queryContains(DruidAdapterIT.druidChecker("{'type':'filtered','filter':{'type':'selector','dimension':'store_state','value':'CA'},'aggregator':{'type':'thetaSketch','name':'EXPR$1','fieldName':'customer_id_ts'}}]")).returnsUnordered(new String[]{"EXPR$0=42342.26999999995; EXPR$1=459"});
    }

    @Test
    public void testAggregationsWithComplexColumns() {
        this.wikiApprox("select count(\"user_id\") from \"wiki\"").failsAtValidation("Rolled up column 'user_id' is not allowed in COUNT");
        this.wikiApprox("select sum(\"user_id\") from \"wiki\"").failsAtValidation("Cannot apply 'SUM' to arguments of type 'SUM(<VARBINARY>)'. Supported form(s): 'SUM(<NUMERIC>)'");
        this.wikiApprox("select avg(\"user_id\") from \"wiki\"").failsAtValidation("Cannot apply 'AVG' to arguments of type 'AVG(<VARBINARY>)'. Supported form(s): 'AVG(<NUMERIC>)'");
        this.wikiApprox("select max(\"user_id\") from \"wiki\"").failsAtValidation("Rolled up column 'user_id' is not allowed in MAX");
        this.wikiApprox("select min(\"user_id\") from \"wiki\"").failsAtValidation("Rolled up column 'user_id' is not allowed in MIN");
    }

    @Test
    public void testPostAggregationWithComplexColumns() {
        this.foodmartApprox("select (count(distinct \"customer_id\") * 2) + count(distinct \"customer_id\") - (3 * count(distinct \"customer_id\")) from \"foodmart\"").queryContains(DruidAdapterIT.druidChecker("\"postAggregations\":[{\"type\":\"expression\",\"name\":\"EXPR$0\",\"expression\":\"(((\\\"$f0\\\" * 2) + \\\"$f0\\\") - (3 * \\\"$f0\\\"))\"}]")).returnsUnordered(new String[]{"EXPR$0=0"});
        this.foodmartApprox("select \"the_month\" as \"month\", sum(\"store_sales\") / count(distinct \"customer_id\") as \"avg$\" from \"foodmart\" group by \"the_month\"").queryContains(DruidAdapterIT.druidChecker("'postAggregations':[{'type':'expression','name':'avg$','expression':'(\\'$f1\\' / \\'$f2\\')'}]")).returnsUnordered(new String[]{"month=January; avg$=32.62155444126063", "month=February; avg$=33.102021036814484", "month=March; avg$=33.84970906630567", "month=April; avg$=32.557517084282296", "month=May; avg$=32.42617797228287", "month=June; avg$=33.93093562874239", "month=July; avg$=34.36859097127213", "month=August; avg$=32.81181818181806", "month=September; avg$=33.327733840304155", "month=October; avg$=32.74730858468674", "month=November; avg$=34.51727684346705", "month=December; avg$=33.62788665879565"});
        String druid = "'postAggregations':[{'type':'expression','name':'EXPR$0','expression':'((\\'$f0\\' + 100) - (\\'$f0\\' * 2))'}]";
        String sql = "select (count(distinct \"user_id\") + 100) - (count(distinct \"user_id\") * 2) from \"wiki\"";
        this.wikiApprox("select (count(distinct \"user_id\") + 100) - (count(distinct \"user_id\") * 2) from \"wiki\"").queryContains(DruidAdapterIT.druidChecker("'postAggregations':[{'type':'expression','name':'EXPR$0','expression':'((\\'$f0\\' + 100) - (\\'$f0\\' * 2))'}]")).returnsUnordered(new String[]{"EXPR$0=-10590"});
        String sql2 = "select (approx_count_distinct(\"user_id\") + 100) - (approx_count_distinct(\"user_id\") * 2) from \"wiki\"";
        this.sql("select (approx_count_distinct(\"user_id\") + 100) - (approx_count_distinct(\"user_id\") * 2) from \"wiki\"", WIKI).queryContains(DruidAdapterIT.druidChecker("'postAggregations':[{'type':'expression','name':'EXPR$0','expression':'((\\'$f0\\' + 100) - (\\'$f0\\' * 2))'}]")).returnsUnordered(new String[]{"EXPR$0=-10590"});
    }

    @Test
    public void testComplexMetricAlsoDimension() {
        this.foodmartApprox("select \"customer_id\" from \"foodmart\"").runs();
        this.foodmartApprox("select count(distinct \"the_month\"), \"customer_id\" from \"foodmart\" group by \"customer_id\"").queryContains(DruidAdapterIT.druidChecker("{'queryType':'groupBy','dataSource':'foodmart','granularity':'all','dimensions':[{'type':'default','dimension':'customer_id','outputName':'customer_id','outputType':'STRING'}],'limitSpec':{'type':'default'},'aggregations':[{'type':'cardinality','name':'EXPR$0','fieldNames':['the_month']}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z']}"));
    }

    @Test
    public void testSelectStarWithRollUp() {
        String sql = "select * from \"wiki\" limit 5";
        this.sql("select * from \"wiki\" limit 5", WIKI).queryContains(DruidAdapterIT.druidChecker("{'queryType':'scan','dataSource':'wikiticker','intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'virtualColumns':[{'type':'expression','name':'vc','expression':'\\'__time\\'','outputType':'LONG'}],'columns':['vc','channel','cityName','comment','countryIsoCode','countryName','isAnonymous','isMinor','isNew','isRobot','isUnpatrolled','metroCode','namespace','page','regionIsoCode','regionName','count','added','deleted','delta'],'resultFormat':'compactedList','limit':5}"));
    }

    @Test
    public void testTableMapReused() {
        DruidSchema schema = new DruidSchema("http://localhost:8082", "http://localhost:8081", true);
        Assert.assertSame((Object)schema.getTable("wikiticker"), (Object)schema.getTable("wikiticker"));
    }

    @Test
    public void testPushEqualsCastDimension() {
        String sqlQuery = "select sum(\"store_cost\") as a from \"foodmart\" where cast(\"product_id\" as double) = 1016.0";
        String plan = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[=(CAST($1):DOUBLE, 1016.0)], groups=[{}], aggs=[[SUM($91)]])";
        String druidQuery = "{'queryType':'timeseries','dataSource':'foodmart','descending':false,'granularity':'all','filter':{'type':'bound','dimension':'product_id','lower':'1016.0','lowerStrict':false,'upper':'1016.0','upperStrict':false,'ordering':'numeric'},'aggregations':[{'type':'doubleSum','name':'A','fieldName':'store_cost'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'context':{'skipEmptyBuckets':false}}";
        this.sql("select sum(\"store_cost\") as a from \"foodmart\" where cast(\"product_id\" as double) = 1016.0", FOODMART).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[=(CAST($1):DOUBLE, 1016.0)], groups=[{}], aggs=[[SUM($91)]])").queryContains(DruidAdapterIT.druidChecker("{'queryType':'timeseries','dataSource':'foodmart','descending':false,'granularity':'all','filter':{'type':'bound','dimension':'product_id','lower':'1016.0','lowerStrict':false,'upper':'1016.0','upperStrict':false,'ordering':'numeric'},'aggregations':[{'type':'doubleSum','name':'A','fieldName':'store_cost'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'context':{'skipEmptyBuckets':false}}")).returnsUnordered(new String[]{"A=85.31639999999999"});
        String sqlQuery2 = "select sum(\"store_cost\") as a from \"foodmart\" where cast(\"product_id\" as double) <= 1016.0 and cast(\"product_id\" as double) >= 1016.0";
        this.sql("select sum(\"store_cost\") as a from \"foodmart\" where cast(\"product_id\" as double) <= 1016.0 and cast(\"product_id\" as double) >= 1016.0", FOODMART).returnsUnordered(new String[]{"A=85.31639999999999"});
    }

    @Test
    public void testPushNotEqualsCastDimension() {
        String sqlQuery = "select sum(\"store_cost\") as a from \"foodmart\" where cast(\"product_id\" as double) <> 1016.0";
        String plan = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[<>(CAST($1):DOUBLE, 1016.0)], groups=[{}], aggs=[[SUM($91)]])";
        String druidQuery = "{'queryType':'timeseries','dataSource':'foodmart','descending':false,'granularity':'all','filter':{'type':'not','field':{'type':'bound','dimension':'product_id','lower':'1016.0','lowerStrict':false,'upper':'1016.0','upperStrict':false,'ordering':'numeric'}},'aggregations':[{'type':'doubleSum','name':'A','fieldName':'store_cost'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'context':{'skipEmptyBuckets':false}}";
        this.sql("select sum(\"store_cost\") as a from \"foodmart\" where cast(\"product_id\" as double) <> 1016.0", FOODMART).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[<>(CAST($1):DOUBLE, 1016.0)], groups=[{}], aggs=[[SUM($91)]])").returnsUnordered(new String[]{"A=225541.91720000014"}).queryContains(DruidAdapterIT.druidChecker("{'queryType':'timeseries','dataSource':'foodmart','descending':false,'granularity':'all','filter':{'type':'not','field':{'type':'bound','dimension':'product_id','lower':'1016.0','lowerStrict':false,'upper':'1016.0','upperStrict':false,'ordering':'numeric'}},'aggregations':[{'type':'doubleSum','name':'A','fieldName':'store_cost'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'context':{'skipEmptyBuckets':false}}"));
        String sqlQuery2 = "select sum(\"store_cost\") as a from \"foodmart\" where cast(\"product_id\" as double) < 1016.0 or cast(\"product_id\" as double) > 1016.0";
        this.sql("select sum(\"store_cost\") as a from \"foodmart\" where cast(\"product_id\" as double) < 1016.0 or cast(\"product_id\" as double) > 1016.0", FOODMART).returnsUnordered(new String[]{"A=225541.91720000014"});
    }

    @Test
    public void testIsNull() {
        String sql = "select count(*) as c from \"foodmart\" where \"product_id\" is null";
        String druidQuery = "{'queryType':'timeseries','dataSource':'foodmart','descending':false,'granularity':'all','filter':{'type':'selector','dimension':'product_id','value':null},'aggregations':[{'type':'count','name':'C'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'context':{'skipEmptyBuckets':false}}";
        this.sql("select count(*) as c from \"foodmart\" where \"product_id\" is null", FOODMART).queryContains(DruidAdapterIT.druidChecker("{'queryType':'timeseries','dataSource':'foodmart','descending':false,'granularity':'all','filter':{'type':'selector','dimension':'product_id','value':null},'aggregations':[{'type':'count','name':'C'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'context':{'skipEmptyBuckets':false}}")).returnsUnordered(new String[]{"C=0"}).returnsCount(1);
    }

    @Test
    public void testIsNotNull() {
        String sql = "select count(*) as c from \"foodmart\" where \"product_id\" is not null";
        String druidQuery = "{'queryType':'timeseries','dataSource':'foodmart','descending':false,'granularity':'all','filter':{'type':'not','field':{'type':'selector','dimension':'product_id','value':null}},'aggregations':[{'type':'count','name':'C'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'context':{'skipEmptyBuckets':false}}";
        this.sql("select count(*) as c from \"foodmart\" where \"product_id\" is not null", FOODMART).queryContains(DruidAdapterIT.druidChecker("{'queryType':'timeseries','dataSource':'foodmart','descending':false,'granularity':'all','filter':{'type':'not','field':{'type':'selector','dimension':'product_id','value':null}},'aggregations':[{'type':'count','name':'C'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'context':{'skipEmptyBuckets':false}}")).returnsUnordered(new String[]{"C=86829"});
    }

    @Test
    public void testFilterWithFloorOnTime() {
        String sql = "Select cast(floor(\"timestamp\" to MONTH) as timestamp) as t from \"foodmart\" where floor(\"timestamp\" to MONTH) between '1997-01-01 00:00:00 UTC'and '1997-03-01 00:00:00 UTC' order by t limit 2";
        String druidQuery = "{'queryType':'scan','dataSource':'foodmart','intervals':['1997-01-01T00:00:00.000Z/1997-04-01T00:00:00.000Z'],'virtualColumns':[{'type':'expression','name':'vc','expression':'timestamp_floor(";
        this.sql("Select cast(floor(\"timestamp\" to MONTH) as timestamp) as t from \"foodmart\" where floor(\"timestamp\" to MONTH) between '1997-01-01 00:00:00 UTC'and '1997-03-01 00:00:00 UTC' order by t limit 2", FOODMART).returnsOrdered(new String[]{"T=1997-01-01 00:00:00", "T=1997-01-01 00:00:00"}).queryContains(DruidAdapterIT.druidChecker("{'queryType':'scan','dataSource':'foodmart','intervals':['1997-01-01T00:00:00.000Z/1997-04-01T00:00:00.000Z'],'virtualColumns':[{'type':'expression','name':'vc','expression':'timestamp_floor("));
    }

    @Test
    public void testSelectFloorOnTimeWithFilterOnFloorOnTime() {
        String sql = "Select cast(floor(\"timestamp\" to MONTH) as timestamp) as t from \"foodmart\" where floor(\"timestamp\" to MONTH) >= '1997-05-01 00:00:00 UTC' order by t limit 1";
        String plan = "PLAN=EnumerableInterpreter\n  BindableSort(sort0=[$0], dir0=[ASC], fetch=[1])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[>=(FLOOR($0, FLAG(MONTH)), 1997-05-01 00:00:00)], projects=[[CAST(FLOOR($0, FLAG(MONTH))):TIMESTAMP(0) NOT NULL]])";
        this.sql("Select cast(floor(\"timestamp\" to MONTH) as timestamp) as t from \"foodmart\" where floor(\"timestamp\" to MONTH) >= '1997-05-01 00:00:00 UTC' order by t limit 1", FOODMART).returnsOrdered(new String[]{"T=1997-05-01 00:00:00"}).explainContains("PLAN=EnumerableInterpreter\n  BindableSort(sort0=[$0], dir0=[ASC], fetch=[1])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[>=(FLOOR($0, FLAG(MONTH)), 1997-05-01 00:00:00)], projects=[[CAST(FLOOR($0, FLAG(MONTH))):TIMESTAMP(0) NOT NULL]])");
    }

    @Test
    public void testTimeWithFilterOnFloorOnTimeAndCastToTimestamp() {
        String sql = "Select cast(floor(\"timestamp\" to MONTH) as timestamp) as t from \"foodmart\" where floor(\"timestamp\" to MONTH) >= cast('1997-05-01 00:00:00' as TIMESTAMP) order by t limit 1";
        String druidQuery = "{'queryType':'scan','dataSource':'foodmart','intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'filter':{'type':'bound','dimension':'__time','lower':'1997-05-01T00:00:00.000Z','lowerStrict':false,'ordering':'lexicographic','";
        this.sql("Select cast(floor(\"timestamp\" to MONTH) as timestamp) as t from \"foodmart\" where floor(\"timestamp\" to MONTH) >= cast('1997-05-01 00:00:00' as TIMESTAMP) order by t limit 1", FOODMART).returnsOrdered(new String[]{"T=1997-05-01 00:00:00"}).queryContains(DruidAdapterIT.druidChecker("{'queryType':'scan','dataSource':'foodmart','intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'filter':{'type':'bound','dimension':'__time','lower':'1997-05-01T00:00:00.000Z','lowerStrict':false,'ordering':'lexicographic','"));
    }

    @Test
    public void testTimeWithFilterOnFloorOnTimeWithTimezone() {
        String sql = "Select cast(\"__time\" as timestamp) as t from \"wikiticker\" where floor(\"__time\" to HOUR) >= cast('2015-09-12 08:00:00' as TIMESTAMP) order by t limit 1";
        String druidQueryPart1 = "filter\":{\"type\":\"bound\",\"dimension\":\"__time\",\"lower\":\"2015-09-12T08:00:00.000Z\",\"lowerStrict\":false,\"ordering\":\"lexicographic\",\"extractionFn\":{\"type\":\"timeFormat\",\"format\":\"yyyy-MM-dd";
        String druidQueryPart2 = "\"granularity\":{\"type\":\"period\",\"period\":\"PT1H\",\"timeZone\":\"Asia/Kolkata\"},\"timeZone\":\"UTC\",\"locale\":\"und\"}}";
        CalciteAssert.that().enable(this.enabled()).withModel(WIKI_AUTO2).with((ConnectionProperty)CalciteConnectionProperty.TIME_ZONE, (Object)"Asia/Kolkata").query("Select cast(\"__time\" as timestamp) as t from \"wikiticker\" where floor(\"__time\" to HOUR) >= cast('2015-09-12 08:00:00' as TIMESTAMP) order by t limit 1").runs().queryContains(DruidAdapterIT.druidChecker("filter\":{\"type\":\"bound\",\"dimension\":\"__time\",\"lower\":\"2015-09-12T08:00:00.000Z\",\"lowerStrict\":false,\"ordering\":\"lexicographic\",\"extractionFn\":{\"type\":\"timeFormat\",\"format\":\"yyyy-MM-dd", "\"granularity\":{\"type\":\"period\",\"period\":\"PT1H\",\"timeZone\":\"Asia/Kolkata\"},\"timeZone\":\"UTC\",\"locale\":\"und\"}}")).returnsOrdered(new String[]{"T=2015-09-12 14:00:01"});
    }

    @Test
    public void testTimeWithFilterOnFloorOnTimeWithTimezoneConversion() {
        String sql = "Select cast(\"__time\" as timestamp) as t, \"countryName\" as s, count(*) as c from \"wikiticker\" where floor(\"__time\" to HOUR) >= '2015-09-12 08:00:00 Asia/Kolkata' group by cast(\"__time\" as timestamp), \"countryName\" order by t limit 4";
        String druidQueryPart1 = "filter\":{\"type\":\"bound\",\"dimension\":\"__time\",\"lower\":\"2015-09-12T02:30:00.000Z\",\"lowerStrict\":false,\"ordering\":\"lexicographic\",\"extractionFn\":{\"type\":\"timeFormat\",\"format\":\"yyyy-MM-dd";
        String druidQueryPart2 = "\"granularity\":{\"type\":\"period\",\"period\":\"PT1H\",\"timeZone\":\"Asia/Kolkata\"},\"timeZone\":\"UTC\",\"locale\":\"und\"}}";
        CalciteAssert.that().enable(this.enabled()).withModel(WIKI_AUTO2).with(CalciteConnectionProperty.TIME_ZONE.camelName(), (Object)"Asia/Kolkata").query("Select cast(\"__time\" as timestamp) as t, \"countryName\" as s, count(*) as c from \"wikiticker\" where floor(\"__time\" to HOUR) >= '2015-09-12 08:00:00 Asia/Kolkata' group by cast(\"__time\" as timestamp), \"countryName\" order by t limit 4").runs().queryContains(DruidAdapterIT.druidChecker("filter\":{\"type\":\"bound\",\"dimension\":\"__time\",\"lower\":\"2015-09-12T02:30:00.000Z\",\"lowerStrict\":false,\"ordering\":\"lexicographic\",\"extractionFn\":{\"type\":\"timeFormat\",\"format\":\"yyyy-MM-dd", "\"granularity\":{\"type\":\"period\",\"period\":\"PT1H\",\"timeZone\":\"Asia/Kolkata\"},\"timeZone\":\"UTC\",\"locale\":\"und\"}}")).returnsOrdered(new String[]{"T=2015-09-12 08:00:02; S=null; C=1", "T=2015-09-12 08:00:04; S=null; C=1", "T=2015-09-12 08:00:05; S=null; C=1", "T=2015-09-12 08:00:07; S=null; C=1"});
    }

    @Test
    public void testTimeWithFilterOnFloorOnTimeWithTimezoneConversionCast() {
        String sql = "Select cast(\"__time\" as timestamp) as t, \"countryName\" as s, count(*) as c from \"wikiticker\" where floor(\"__time\" to HOUR) >= '2015-09-12 08:00:00 Asia/Kolkata' group by cast(\"__time\" as timestamp), \"countryName\" order by t limit 4";
        String druidQueryPart1 = "filter\":{\"type\":\"bound\",\"dimension\":\"__time\",\"lower\":\"2015-09-12T02:30:00.000Z\",\"lowerStrict\":false,\"ordering\":\"lexicographic\",\"extractionFn\":{\"type\":\"timeFormat\",\"format\":\"yyyy-MM-dd";
        String druidQueryPart2 = "\"granularity\":{\"type\":\"period\",\"period\":\"PT1H\",\"timeZone\":\"Asia/Kolkata\"},\"timeZone\":\"UTC\",\"locale\":\"und\"}}";
        CalciteAssert.that().enable(this.enabled()).withModel(WIKI_AUTO2).with((ConnectionProperty)CalciteConnectionProperty.TIME_ZONE, (Object)"Asia/Kolkata").query("Select cast(\"__time\" as timestamp) as t, \"countryName\" as s, count(*) as c from \"wikiticker\" where floor(\"__time\" to HOUR) >= '2015-09-12 08:00:00 Asia/Kolkata' group by cast(\"__time\" as timestamp), \"countryName\" order by t limit 4").runs().queryContains(DruidAdapterIT.druidChecker("filter\":{\"type\":\"bound\",\"dimension\":\"__time\",\"lower\":\"2015-09-12T02:30:00.000Z\",\"lowerStrict\":false,\"ordering\":\"lexicographic\",\"extractionFn\":{\"type\":\"timeFormat\",\"format\":\"yyyy-MM-dd", "\"granularity\":{\"type\":\"period\",\"period\":\"PT1H\",\"timeZone\":\"Asia/Kolkata\"},\"timeZone\":\"UTC\",\"locale\":\"und\"}}")).returnsOrdered(new String[]{"T=2015-09-12 08:00:02; S=null; C=1", "T=2015-09-12 08:00:04; S=null; C=1", "T=2015-09-12 08:00:05; S=null; C=1", "T=2015-09-12 08:00:07; S=null; C=1"});
    }

    @Test
    public void testCombinationOfValidAndNotValidAndInterval() {
        String sql = "SELECT COUNT(*) FROM \"foodmart\" WHERE  \"timestamp\" < CAST('1998-01-02' as TIMESTAMP) AND EXTRACT(MONTH FROM \"timestamp\") = 01 AND EXTRACT(YEAR FROM \"timestamp\") = 1996 ";
        this.sql("SELECT COUNT(*) FROM \"foodmart\" WHERE  \"timestamp\" < CAST('1998-01-02' as TIMESTAMP) AND EXTRACT(MONTH FROM \"timestamp\") = 01 AND EXTRACT(YEAR FROM \"timestamp\") = 1996 ", FOODMART).runs().queryContains(DruidAdapterIT.druidChecker("{\"queryType\":\"timeseries\""));
    }

    @Test
    public void testFloorToDateRangeWithTimeZone() {
        String sql = "Select cast(floor(\"timestamp\" to MONTH) as timestamp) as t from \"foodmart\" where floor(\"timestamp\" to MONTH) >= '1997-05-01 00:00:00 Asia/Kolkata' and floor(\"timestamp\" to MONTH) < '1997-05-02 00:00:00 Asia/Kolkata' order by t limit 1";
        String druidQuery = "{\"queryType\":\"scan\",\"dataSource\":\"foodmart\",\"intervals\":[\"1997-04-30T18:30:00.000Z/1997-05-31T18:30:00.000Z\"],\"virtualColumns\":[{\"type\":\"expression\",\"name\":\"vc\",\"expression\":\"timestamp_parse";
        CalciteAssert.that().enable(this.enabled()).withModel(FOODMART).with(CalciteConnectionProperty.TIME_ZONE.camelName(), (Object)"Asia/Kolkata").query("Select cast(floor(\"timestamp\" to MONTH) as timestamp) as t from \"foodmart\" where floor(\"timestamp\" to MONTH) >= '1997-05-01 00:00:00 Asia/Kolkata' and floor(\"timestamp\" to MONTH) < '1997-05-02 00:00:00 Asia/Kolkata' order by t limit 1").runs().queryContains(DruidAdapterIT.druidChecker("{\"queryType\":\"scan\",\"dataSource\":\"foodmart\",\"intervals\":[\"1997-04-30T18:30:00.000Z/1997-05-31T18:30:00.000Z\"],\"virtualColumns\":[{\"type\":\"expression\",\"name\":\"vc\",\"expression\":\"timestamp_parse")).returnsOrdered(new String[]{"T=1997-05-01 00:00:00"});
    }

    @Test
    public void testExpressionsFilter() {
        String sql = "SELECT COUNT(*) FROM \"foodmart\"  where ABS(-EXP(LN(SQRT(\"store_sales\")))) = 1";
        this.sql("SELECT COUNT(*) FROM \"foodmart\"  where ABS(-EXP(LN(SQRT(\"store_sales\")))) = 1", FOODMART).queryContains(DruidAdapterIT.druidChecker("pow(\\\"store_sales\\\"")).returnsUnordered(new String[]{"EXPR$0=32"});
    }

    @Test
    public void testExpressionsFilter2() {
        String sql = "SELECT COUNT(*) FROM \"foodmart\"  where CAST(SQRT(ABS(-\"store_sales\")) /2 as INTEGER) = 1";
        this.sql("SELECT COUNT(*) FROM \"foodmart\"  where CAST(SQRT(ABS(-\"store_sales\")) /2 as INTEGER) = 1", FOODMART).queryContains(DruidAdapterIT.druidChecker("(CAST((pow(abs((- \\\"store_sales\\\")),0.5) / 2),")).returnsUnordered(new String[]{"EXPR$0=62449"});
    }

    @Test
    public void testExpressionsLikeFilter() {
        String sql = "SELECT COUNT(*) FROM \"foodmart\"  where \"product_id\" LIKE '1%'";
        this.sql("SELECT COUNT(*) FROM \"foodmart\"  where \"product_id\" LIKE '1%'", FOODMART).queryContains(DruidAdapterIT.druidChecker("\"filter\":{\"type\":\"expression\",\"expression\":\"like")).returnsUnordered(new String[]{"EXPR$0=36839"});
    }

    @Test
    public void testExpressionsSTRLENFilter() {
        String sql = "SELECT COUNT(*) FROM \"foodmart\"  where CHAR_LENGTH(\"product_id\") = 2";
        this.sql("SELECT COUNT(*) FROM \"foodmart\"  where CHAR_LENGTH(\"product_id\") = 2", FOODMART).queryContains(DruidAdapterIT.druidChecker("\"expression\":\"(strlen(\\\"product_id\\\") == 2")).returnsUnordered(new String[]{"EXPR$0=4876"});
    }

    @Test
    public void testExpressionsUpperLowerFilter() {
        String sql = "SELECT COUNT(*) FROM \"foodmart\"  where upper(lower(\"city\")) = 'SPOKANE'";
        this.sql("SELECT COUNT(*) FROM \"foodmart\"  where upper(lower(\"city\")) = 'SPOKANE'", FOODMART).queryContains(DruidAdapterIT.druidChecker("\"filter\":{\"type\":\"expression\",\"expression\":\"(upper(lower(\\\"city\\\")) ==", "SPOKANE")).returnsUnordered(new String[]{"EXPR$0=7394"});
    }

    @Test
    public void testExpressionsLowerUpperFilter() {
        String sql = "SELECT COUNT(*) FROM \"foodmart\"  where lower(upper(\"city\")) = 'spokane'";
        this.sql("SELECT COUNT(*) FROM \"foodmart\"  where lower(upper(\"city\")) = 'spokane'", FOODMART).queryContains(DruidAdapterIT.druidChecker("\"filter\":{\"type\":\"expression\",\"expression\":\"(lower(upper(\\\"city\\\")) ==", "spokane")).returnsUnordered(new String[]{"EXPR$0=7394"});
    }

    @Test
    public void testExpressionsLowerFilterNotMatching() {
        String sql = "SELECT COUNT(*) FROM \"foodmart\"  where lower(\"city\") = 'Spokane'";
        this.sql("SELECT COUNT(*) FROM \"foodmart\"  where lower(\"city\") = 'Spokane'", FOODMART).queryContains(DruidAdapterIT.druidChecker("\"filter\":{\"type\":\"expression\",\"expression\":\"(lower(\\\"city\\\") ==", "Spokane")).returnsUnordered(new String[]{"EXPR$0=0"});
    }

    @Test
    public void testExpressionsLowerFilterMatching() {
        String sql = "SELECT COUNT(*) FROM \"foodmart\"  where lower(\"city\") = 'spokane'";
        this.sql("SELECT COUNT(*) FROM \"foodmart\"  where lower(\"city\") = 'spokane'", FOODMART).queryContains(DruidAdapterIT.druidChecker("\"filter\":{\"type\":\"expression\",\"expression\":\"(lower(\\\"city\\\") ==", "spokane")).returnsUnordered(new String[]{"EXPR$0=7394"});
    }

    @Test
    public void testExpressionsUpperFilterNotMatching() {
        String sql = "SELECT COUNT(*) FROM \"foodmart\"  where upper(\"city\") = 'Spokane'";
        this.sql("SELECT COUNT(*) FROM \"foodmart\"  where upper(\"city\") = 'Spokane'", FOODMART).queryContains(DruidAdapterIT.druidChecker("\"filter\":{\"type\":\"expression\",\"expression\":\"(upper(\\\"city\\\") ==", "Spokane")).returnsUnordered(new String[]{"EXPR$0=0"});
    }

    @Test
    public void testExpressionsUpperFilterMatching() {
        String sql = "SELECT COUNT(*) FROM \"foodmart\"  where upper(\"city\") = 'SPOKANE'";
        this.sql("SELECT COUNT(*) FROM \"foodmart\"  where upper(\"city\") = 'SPOKANE'", FOODMART).queryContains(DruidAdapterIT.druidChecker("\"filter\":{\"type\":\"expression\",\"expression\":\"(upper(\\\"city\\\") ==", "SPOKANE")).returnsUnordered(new String[]{"EXPR$0=7394"});
    }

    @Test
    public void testExpressionsConcatFilter() {
        String sql = "SELECT COUNT(*) FROM \"foodmart\"  where (\"city\" || '_extra') = 'Spokane_extra'";
        this.sql("SELECT COUNT(*) FROM \"foodmart\"  where (\"city\" || '_extra') = 'Spokane_extra'", FOODMART).queryContains(DruidAdapterIT.druidChecker("{\"type\":\"expression\",\"expression\":\"(concat(\\\"city\\\",", "Spokane_extra")).returnsUnordered(new String[]{"EXPR$0=7394"});
    }

    @Test
    public void testExpressionsNotNull() {
        String sql = "SELECT COUNT(*) FROM \"foodmart\"  where (\"city\" || 'extra') IS NOT NULL";
        this.sql("SELECT COUNT(*) FROM \"foodmart\"  where (\"city\" || 'extra') IS NOT NULL", FOODMART).queryContains(DruidAdapterIT.druidChecker("{\"type\":\"expression\",\"expression\":\"(concat(\\\"city\\\",", "!= null")).returnsUnordered(new String[]{"EXPR$0=86829"});
    }

    @Test
    public void testComplexExpressionsIsNull() {
        String sql = "SELECT COUNT(*) FROM \"foodmart\"  where ( cast(null as INTEGER) + cast(\"city\" as INTEGER)) IS NULL";
        this.sql("SELECT COUNT(*) FROM \"foodmart\"  where ( cast(null as INTEGER) + cast(\"city\" as INTEGER)) IS NULL", FOODMART).explainContains("PLAN=EnumerableInterpreter\n  BindableAggregate(group=[{}], EXPR$0=[$SUM0($1)])\n    BindableFilter(condition=[IS NULL(+(null, CAST($0):INTEGER))])\n      DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], groups=[{29}], aggs=[[COUNT()]])").queryContains(DruidAdapterIT.druidChecker("{\"queryType\":\"groupBy\",\"dataSource\":\"foodmart\",\"granularity\":\"all\",\"dimensions\":[{\"type\":\"default\",\"dimension\":\"city\",\"outputName\":\"city\",\"outputType\":\"STRING\"}],\"limitSpec\":{\"type\":\"default\"},\"aggregations\":[{\"type\":\"count\",\"name\":\"EXPR$0\"}],\"intervals\":[\"1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z\"]}")).returnsUnordered(new String[]{"EXPR$0=86829"});
    }

    @Test
    public void testExpressionsConcatFilterMultipleColumns() {
        String sql = "SELECT COUNT(*) FROM \"foodmart\"  where (\"city\" || \"state_province\") = 'SpokaneWA'";
        this.sql("SELECT COUNT(*) FROM \"foodmart\"  where (\"city\" || \"state_province\") = 'SpokaneWA'", FOODMART).queryContains(DruidAdapterIT.druidChecker("(concat(\\\"city\\\",\\\"state_province\\\") ==", "SpokaneWA")).returnsUnordered(new String[]{"EXPR$0=7394"});
    }

    @Test
    public void testAndCombinationOfExpAndSimpleFilter() {
        String sql = "SELECT COUNT(*) FROM \"foodmart\"  where (\"city\" || \"state_province\") = 'SpokaneWA' AND \"state_province\" = 'WA'";
        this.sql("SELECT COUNT(*) FROM \"foodmart\"  where (\"city\" || \"state_province\") = 'SpokaneWA' AND \"state_province\" = 'WA'", FOODMART).queryContains(DruidAdapterIT.druidChecker("(concat(\\\"city\\\",\\\"state_province\\\") ==", "SpokaneWA", "{\"type\":\"selector\",\"dimension\":\"state_province\",\"value\":\"WA\"}]}")).returnsUnordered(new String[]{"EXPR$0=7394"});
    }

    @Test
    public void testOrCombinationOfExpAndSimpleFilter() {
        String sql = "SELECT COUNT(*) FROM \"foodmart\"  where (\"city\" || \"state_province\") = 'SpokaneWA' OR (\"state_province\" = 'CA' AND \"city\" IS NOT NULL)";
        this.sql("SELECT COUNT(*) FROM \"foodmart\"  where (\"city\" || \"state_province\") = 'SpokaneWA' OR (\"state_province\" = 'CA' AND \"city\" IS NOT NULL)", FOODMART).queryContains(DruidAdapterIT.druidChecker("(concat(\\\"city\\\",\\\"state_province\\\") ==", "SpokaneWA", "{\"type\":\"and\",\"fields\":[{\"type\":\"selector\",\"dimension\":\"state_province\",\"value\":\"CA\"},{\"type\":\"not\",\"field\":{\"type\":\"selector\",\"dimension\":\"city\",\"value\":null}}]}")).returnsUnordered(new String[]{"EXPR$0=31835"});
    }

    @Test
    public void testColumnAEqColumnB() {
        String sql = "SELECT COUNT(*) FROM \"foodmart\"  where \"city\" = \"state_province\"";
        this.sql("SELECT COUNT(*) FROM \"foodmart\"  where \"city\" = \"state_province\"", FOODMART).queryContains(DruidAdapterIT.druidChecker("\"filter\":{\"type\":\"expression\",\"expression\":\"(\\\"city\\\" == \\\"state_province\\\")\"}")).returnsUnordered(new String[]{"EXPR$0=0"});
    }

    @Test
    public void testColumnANotEqColumnB() {
        String sql = "SELECT COUNT(*) FROM \"foodmart\"  where \"city\" <> \"state_province\"";
        this.sql("SELECT COUNT(*) FROM \"foodmart\"  where \"city\" <> \"state_province\"", FOODMART).queryContains(DruidAdapterIT.druidChecker("\"filter\":{\"type\":\"expression\",\"expression\":\"(\\\"city\\\" != \\\"state_province\\\")\"}")).returnsUnordered(new String[]{"EXPR$0=86829"});
    }

    @Test
    public void testAndCombinationOfComplexExpAndSimpleFilter() {
        String sql = "SELECT COUNT(*) FROM \"foodmart\"  where ((\"city\" || \"state_province\") = 'SpokaneWA' OR (\"city\" || '_extra') = 'Spokane_extra') AND \"state_province\" = 'WA'";
        this.sql("SELECT COUNT(*) FROM \"foodmart\"  where ((\"city\" || \"state_province\") = 'SpokaneWA' OR (\"city\" || '_extra') = 'Spokane_extra') AND \"state_province\" = 'WA'", FOODMART).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[AND(OR(=(||($29, $30), 'SpokaneWA'), =(||($29, '_extra'), 'Spokane_extra')), =($30, 'WA'))], groups=[{}], aggs=[[COUNT()]])").queryContains(DruidAdapterIT.druidChecker("(concat(\\\"city\\\",\\\"state_province\\\") ==", "SpokaneWA", "{\"type\":\"selector\",\"dimension\":\"state_province\",\"value\":\"WA\"}]}")).returnsUnordered(new String[]{"EXPR$0=7394"});
    }

    @Test
    public void testExpressionsFilterWithCast() {
        String sql = "SELECT COUNT(*) FROM \"foodmart\" where CAST(( SQRT(\"store_sales\") - 1 ) / 3 + 1 AS INTEGER) > 1";
        this.sql("SELECT COUNT(*) FROM \"foodmart\" where CAST(( SQRT(\"store_sales\") - 1 ) / 3 + 1 AS INTEGER) > 1", FOODMART).queryContains(DruidAdapterIT.druidChecker("(CAST((((pow(\\\"store_sales\\\",0.5) - 1) / 3) + 1)", "LONG")).returnsUnordered(new String[]{"EXPR$0=476"});
    }

    @Test
    public void testExpressionsFilterWithCastTimeToDateToChar() {
        String sql = "SELECT COUNT(*) FROM \"foodmart\" where CAST(CAST(\"timestamp\" as DATE) as VARCHAR) = '1997-01-01'";
        this.sql("SELECT COUNT(*) FROM \"foodmart\" where CAST(CAST(\"timestamp\" as DATE) as VARCHAR) = '1997-01-01'", FOODMART).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[=(CAST(CAST($0):DATE NOT NULL):VARCHAR CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\" NOT NULL, '1997-01-01')], groups=[{}], aggs=[[COUNT()]])").queryContains(DruidAdapterIT.druidChecker("{\"type\":\"expression\",\"expression\":\"(timestamp_format(timestamp_floor(")).returnsUnordered(new String[]{"EXPR$0=117"});
    }

    @Test
    public void testExpressionsFilterWithExtract() {
        String sql = "SELECT COUNT(*) FROM \"foodmart\"  where CAST((EXTRACT(MONTH FROM \"timestamp\") - 1 ) / 3 + 1 AS INTEGER) = 1";
        this.sql("SELECT COUNT(*) FROM \"foodmart\"  where CAST((EXTRACT(MONTH FROM \"timestamp\") - 1 ) / 3 + 1 AS INTEGER) = 1", FOODMART).queryContains(DruidAdapterIT.druidChecker(",\"filter\":{\"type\":\"expression\",\"expression\":\"((((timestamp_extract(\\\"__time\\\"", "MONTH", ") - 1) / 3) + 1) == 1")).returnsUnordered(new String[]{"EXPR$0=21587"});
    }

    @Test
    public void testExtractYearFilterExpression() {
        String sql = "SELECT count(*) from \"foodmart\" WHERE EXTRACT(YEAR from \"timestamp\") + 1 > 1997";
        String filterPart1 = "'filter':{'type':'expression','expression':'((timestamp_extract(\\'__time\\'";
        String filterTimezoneName = "America/Los_Angeles";
        CalciteAssert.that().enable(this.enabled()).withModel(FOODMART).with(CalciteConnectionProperty.TIME_ZONE.camelName(), (Object)"America/Los_Angeles").query("SELECT count(*) from \"foodmart\" WHERE EXTRACT(YEAR from \"timestamp\") + 1 > 1997").runs().returnsOrdered(new String[]{"EXPR$0=86712"}).queryContains(DruidAdapterIT.druidChecker("'filter':{'type':'expression','expression':'((timestamp_extract(\\'__time\\'", "America/Los_Angeles"));
    }

    @Test
    public void testExtractMonthFilterExpression() {
        String sql = "SELECT count(*) from \"foodmart\" WHERE EXTRACT(MONTH from \"timestamp\") + 1 = 02";
        String filterPart1 = "'filter':{'type':'expression','expression':'((timestamp_extract(\\'__time\\'";
        String filterTimezoneName = "America/Los_Angeles";
        CalciteAssert.that().enable(this.enabled()).withModel(FOODMART).with(CalciteConnectionProperty.TIME_ZONE.camelName(), (Object)"America/Los_Angeles").query("SELECT count(*) from \"foodmart\" WHERE EXTRACT(MONTH from \"timestamp\") + 1 = 02").runs().returnsOrdered(new String[]{"EXPR$0=7043"}).queryContains(DruidAdapterIT.druidChecker("'filter':{'type':'expression','expression':'((timestamp_extract(\\'__time\\'", "America/Los_Angeles", "MONTH", "== 2"));
    }

    @Test
    public void testExtractHourFilterExpression() {
        String sql = "SELECT EXTRACT(HOUR from \"timestamp\") from \"foodmart\" WHERE EXTRACT(HOUR from \"timestamp\") = 17 group by EXTRACT(HOUR from \"timestamp\") ";
        CalciteAssert.that().enable(this.enabled()).withModel(FOODMART).with(CalciteConnectionProperty.TIME_ZONE.camelName(), (Object)"America/Los_Angeles").query("SELECT EXTRACT(HOUR from \"timestamp\") from \"foodmart\" WHERE EXTRACT(HOUR from \"timestamp\") = 17 group by EXTRACT(HOUR from \"timestamp\") ").runs().returnsOrdered(new String[]{"EXPR$0=17"});
        String sql2 = "SELECT EXTRACT(HOUR from \"timestamp\") from \"foodmart\" WHERE EXTRACT(HOUR from \"timestamp\") = 19 group by EXTRACT(HOUR from \"timestamp\") ";
        CalciteAssert.that().enable(this.enabled()).withModel(FOODMART).with(CalciteConnectionProperty.TIME_ZONE.camelName(), (Object)"EST").query("SELECT EXTRACT(HOUR from \"timestamp\") from \"foodmart\" WHERE EXTRACT(HOUR from \"timestamp\") = 19 group by EXTRACT(HOUR from \"timestamp\") ").runs().returnsOrdered(new String[]{"EXPR$0=19"});
        String sql3 = "SELECT EXTRACT(HOUR from \"timestamp\") from \"foodmart\" WHERE EXTRACT(HOUR from \"timestamp\") = 0 group by EXTRACT(HOUR from \"timestamp\") ";
        CalciteAssert.that().enable(this.enabled()).withModel(FOODMART).with(CalciteConnectionProperty.TIME_ZONE.camelName(), (Object)"UTC").query("SELECT EXTRACT(HOUR from \"timestamp\") from \"foodmart\" WHERE EXTRACT(HOUR from \"timestamp\") = 0 group by EXTRACT(HOUR from \"timestamp\") ").runs().returnsOrdered(new String[]{"EXPR$0=0"});
    }

    @Test
    public void testExtractHourFilterExpressionWithCast() {
        String sql = "SELECT EXTRACT(HOUR from CAST(\"timestamp\" AS TIMESTAMP)) from \"foodmart\" WHERE EXTRACT(HOUR from \"timestamp\") = 17 group by EXTRACT(HOUR from CAST(\"timestamp\" AS TIMESTAMP)) ";
        CalciteAssert.that().enable(this.enabled()).withModel(FOODMART).with(CalciteConnectionProperty.TIME_ZONE.camelName(), (Object)"America/Los_Angeles").query("SELECT EXTRACT(HOUR from CAST(\"timestamp\" AS TIMESTAMP)) from \"foodmart\" WHERE EXTRACT(HOUR from \"timestamp\") = 17 group by EXTRACT(HOUR from CAST(\"timestamp\" AS TIMESTAMP)) ").runs().returnsOrdered(new String[]{"EXPR$0=17"});
        String sql2 = "SELECT EXTRACT(HOUR from CAST(\"timestamp\" AS TIMESTAMP)) from \"foodmart\" WHERE EXTRACT(HOUR from CAST(\"timestamp\" AS TIMESTAMP)) = 19 group by EXTRACT(HOUR from CAST(\"timestamp\" AS TIMESTAMP)) ";
        CalciteAssert.that().enable(this.enabled()).withModel(FOODMART).with(CalciteConnectionProperty.TIME_ZONE.camelName(), (Object)"EST").query("SELECT EXTRACT(HOUR from CAST(\"timestamp\" AS TIMESTAMP)) from \"foodmart\" WHERE EXTRACT(HOUR from CAST(\"timestamp\" AS TIMESTAMP)) = 19 group by EXTRACT(HOUR from CAST(\"timestamp\" AS TIMESTAMP)) ").runs().returnsOrdered(new String[]{"EXPR$0=19"});
        String sql3 = "SELECT EXTRACT(HOUR from CAST(\"timestamp\" AS TIMESTAMP)) from \"foodmart\" WHERE EXTRACT(HOUR from CAST(\"timestamp\" AS TIMESTAMP)) = 0 group by EXTRACT(HOUR from CAST(\"timestamp\" AS TIMESTAMP)) ";
        CalciteAssert.that().enable(this.enabled()).withModel(FOODMART).with(CalciteConnectionProperty.TIME_ZONE.camelName(), (Object)"UTC").query("SELECT EXTRACT(HOUR from CAST(\"timestamp\" AS TIMESTAMP)) from \"foodmart\" WHERE EXTRACT(HOUR from CAST(\"timestamp\" AS TIMESTAMP)) = 0 group by EXTRACT(HOUR from CAST(\"timestamp\" AS TIMESTAMP)) ").runs().returnsOrdered(new String[]{"EXPR$0=0"});
    }

    @Test
    public void testTimeFloorExpressions() {
        String sql = "SELECT CAST(FLOOR(\"timestamp\" to DAY) as TIMESTAMP) as d from \"foodmart\" WHERE CAST(FLOOR(CAST(\"timestamp\" AS DATE) to MONTH) AS DATE) =  CAST('1997-01-01' as DATE) GROUP BY  floor(\"timestamp\" to DAY) order by d limit 3";
        String plan = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[=(CAST(FLOOR(CAST($0):DATE NOT NULL, FLAG(MONTH))):DATE NOT NULL, 1997-01-01)], projects=[[FLOOR($0, FLAG(DAY))]], groups=[{0}], aggs=[[]], post_projects=[[CAST($0):TIMESTAMP(0) NOT NULL]], sort0=[0], dir0=[ASC], fetch=[3])";
        this.sql("SELECT CAST(FLOOR(\"timestamp\" to DAY) as TIMESTAMP) as d from \"foodmart\" WHERE CAST(FLOOR(CAST(\"timestamp\" AS DATE) to MONTH) AS DATE) =  CAST('1997-01-01' as DATE) GROUP BY  floor(\"timestamp\" to DAY) order by d limit 3", FOODMART).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[=(CAST(FLOOR(CAST($0):DATE NOT NULL, FLAG(MONTH))):DATE NOT NULL, 1997-01-01)], projects=[[FLOOR($0, FLAG(DAY))]], groups=[{0}], aggs=[[]], post_projects=[[CAST($0):TIMESTAMP(0) NOT NULL]], sort0=[0], dir0=[ASC], fetch=[3])").returnsOrdered(new String[]{"D=1997-01-01 00:00:00", "D=1997-01-02 00:00:00", "D=1997-01-03 00:00:00"});
    }

    @Test
    public void testDruidTimeFloorAndTimeParseExpressions() {
        String sql = "SELECT CAST(\"timestamp\" AS TIMESTAMP), count(*) from \"foodmart\" WHERE CAST(('1997' || '-01' || '-01') AS DATE) = CAST(\"timestamp\" AS DATE) GROUP BY \"timestamp\"";
        this.sql("SELECT CAST(\"timestamp\" AS TIMESTAMP), count(*) from \"foodmart\" WHERE CAST(('1997' || '-01' || '-01') AS DATE) = CAST(\"timestamp\" AS DATE) GROUP BY \"timestamp\"", FOODMART).returnsOrdered(new String[]{"EXPR$0=1997-01-01 00:00:00; EXPR$1=117"}).queryContains(DruidAdapterIT.druidChecker("\"filter\":{\"type\":\"expression\",\"expression\":\"(timestamp_floor(timestamp_parse(concat(concat(", "== timestamp_floor("));
    }

    @Test
    public void testDruidTimeFloorAndTimeParseExpressions2() {
        String sql = "SELECT CAST(\"timestamp\" AS TIMESTAMP), count(*) from \"foodmart\" WHERE CAST(('1997' || '-01' || '-01') AS TIMESTAMP) = CAST(\"timestamp\" AS TIMESTAMP) GROUP BY \"timestamp\"";
        this.sql("SELECT CAST(\"timestamp\" AS TIMESTAMP), count(*) from \"foodmart\" WHERE CAST(('1997' || '-01' || '-01') AS TIMESTAMP) = CAST(\"timestamp\" AS TIMESTAMP) GROUP BY \"timestamp\"", FOODMART).queryContains(DruidAdapterIT.druidChecker("\"filter\":{\"type\":\"expression\",\"expression\":\"(timestamp_parse(concat(concat(")).returnsOrdered(new String[]{"EXPR$0=1997-01-01 00:00:00; EXPR$1=117"});
    }

    @Test
    public void testFilterFloorOnMetricColumn() {
        String sql = "SELECT count(*) from \"foodmart\" WHERE floor(\"store_sales\") = 23";
        String plan = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[=(FLOOR($90), 23)], groups=[{}], aggs=[[COUNT()]]";
        this.sql("SELECT count(*) from \"foodmart\" WHERE floor(\"store_sales\") = 23", FOODMART).returnsOrdered(new String[]{"EXPR$0=2"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[=(FLOOR($90), 23)], groups=[{}], aggs=[[COUNT()]]").queryContains(DruidAdapterIT.druidChecker("\"queryType\":\"timeseries\""));
    }

    @Test
    public void testExpressionFilterSimpleColumnAEqColumnB() {
        String sql = "SELECT count(*) from \"foodmart\" where \"product_id\" = \"city\"";
        this.sql("SELECT count(*) from \"foodmart\" where \"product_id\" = \"city\"", FOODMART).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[=($1, $29)], groups=[{}], aggs=[[COUNT()]])").queryContains(DruidAdapterIT.druidChecker("\"filter\":{\"type\":\"expression\",\"expression\":\"(\\\"product_id\\\" == \\\"city\\\")\"}")).returnsOrdered(new String[]{"EXPR$0=0"});
    }

    @Test
    public void testCastPlusMathOps() {
        String sql = "SELECT COUNT(*) FROM \"foodmart\"WHERE (CAST(\"product_id\" AS INTEGER) + 1 * \"store_sales\")/(\"store_cost\" - 5) <= floor(\"store_sales\") * 25 + 2";
        this.sql("SELECT COUNT(*) FROM \"foodmart\"WHERE (CAST(\"product_id\" AS INTEGER) + 1 * \"store_sales\")/(\"store_cost\" - 5) <= floor(\"store_sales\") * 25 + 2", FOODMART).queryContains(DruidAdapterIT.druidChecker("\"filter\":{\"type\":\"expression\",\"expression\":\"(((CAST(\\\"product_id\\\", ", "LONG", ") + (1 * \\\"store_sales\\\")) / (\\\"store_cost\\\" - 5))", " <= ((floor(\\\"store_sales\\\") * 25) + 2))\"}")).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[<=(/(+(CAST($1):INTEGER, *(1, $90)), -($91, 5)), +(*(FLOOR($90), 25), 2))], groups=[{}], aggs=[[COUNT()]])").returnsOrdered(new String[]{"EXPR$0=82129"});
    }

    @Test
    public void testBooleanFilterExpressions() {
        String sql = "SELECT count(*) from \"foodmart\" WHERE (CAST((\"product_id\" <> '1') AS BOOLEAN)) IS TRUE";
        this.sql("SELECT count(*) from \"foodmart\" WHERE (CAST((\"product_id\" <> '1') AS BOOLEAN)) IS TRUE", FOODMART).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[IS TRUE(CAST(<>($1, '1')):BOOLEAN)], groups=[{}], aggs=[[COUNT()]])").queryContains(DruidAdapterIT.druidChecker("\"queryType\":\"timeseries\"")).returnsOrdered(new String[]{"EXPR$0=86803"});
    }

    @Test
    public void testCombinationOfValidAndNotValidFilters() {
        String sql = "SELECT COUNT(*) FROM \"foodmart\"WHERE ((CAST(\"product_id\" AS INTEGER) + 1 * \"store_sales\")/(\"store_cost\" - 5) <= floor(\"store_sales\") * 25 + 2) AND \"timestamp\" < CAST('1997-01-02' as TIMESTAMP)AND CAST(\"store_sales\" > 0 AS BOOLEAN) IS TRUE AND \"product_id\" like '1%' AND \"store_cost\" > 1 AND EXTRACT(MONTH FROM \"timestamp\") = 01 AND EXTRACT(DAY FROM \"timestamp\") = 01 AND EXTRACT(MONTH FROM \"timestamp\") / 4 + 1 = 1 ";
        String queryType = "{'queryType':'timeseries','dataSource':'foodmart'";
        String filterExp1 = "{'type':'expression','expression':'(((CAST(\\'product_id\\'";
        String filterExpPart2 = " (1 * \\'store_sales\\')) / (\\'store_cost\\' - 5)) <= ((floor(\\'store_sales\\') * 25) + 2))'}";
        String likeExpressionFilter = "{'type':'expression','expression':'like(\\'product_id\\'";
        String likeExpressionFilter2 = "1%";
        String simpleBound = "{'type':'bound','dimension':'store_cost','lower':'1','lowerStrict':true,'ordering':'numeric'}";
        String timeSimpleFilter = "{'type':'bound','dimension':'__time','upper':'1997-01-02T00:00:00.000Z','upperStrict':true,'ordering':'lexicographic','extractionFn':{'type':'timeFormat','format':'yyyy-MM-dd";
        String simpleExtractFilterMonth = "{'type':'bound','dimension':'__time','lower':'1','lowerStrict':false,'upper':'1','upperStrict':false,'ordering':'numeric','extractionFn':{'type':'timeFormat','format':'M','timeZone':'UTC','locale':'en-US'}}";
        String simpleExtractFilterDay = "{'type':'bound','dimension':'__time','lower':'1','lowerStrict':false,'upper':'1','upperStrict':false,'ordering':'numeric','extractionFn':{'type':'timeFormat','format':'d','timeZone':'UTC','locale':'en-US'}}";
        String quarterAsExpressionFilter = "{'type':'expression','expression':'(((timestamp_extract(\\'__time\\'";
        String quarterAsExpressionFilter2 = "MONTH";
        String quarterAsExpressionFilterTimeZone = "UTC";
        String quarterAsExpressionFilter3 = "/ 4) + 1) == 1)'}]}";
        String booleanAsFilter = "> 0";
        String plan = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[AND(<=(/(+(CAST($1):INTEGER, *(1, $90)), -($91, 5)), +(*(FLOOR($90), 25), 2)), IS TRUE(CAST(>($90, 0)):BOOLEAN), LIKE($1, '1%'), >($91, 1), <($0, 1997-01-02 00:00:00), =(EXTRACT(FLAG(MONTH), $0), 1), =(EXTRACT(FLAG(DAY), $0), 1), =(+(/(EXTRACT(FLAG(MONTH), $0), 4), 1), 1))], groups=[{}], aggs=[[COUNT()]])";
        this.sql("SELECT COUNT(*) FROM \"foodmart\"WHERE ((CAST(\"product_id\" AS INTEGER) + 1 * \"store_sales\")/(\"store_cost\" - 5) <= floor(\"store_sales\") * 25 + 2) AND \"timestamp\" < CAST('1997-01-02' as TIMESTAMP)AND CAST(\"store_sales\" > 0 AS BOOLEAN) IS TRUE AND \"product_id\" like '1%' AND \"store_cost\" > 1 AND EXTRACT(MONTH FROM \"timestamp\") = 01 AND EXTRACT(DAY FROM \"timestamp\") = 01 AND EXTRACT(MONTH FROM \"timestamp\") / 4 + 1 = 1 ", FOODMART).returnsOrdered(new String[]{"EXPR$0=36"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[AND(<=(/(+(CAST($1):INTEGER, *(1, $90)), -($91, 5)), +(*(FLOOR($90), 25), 2)), IS TRUE(CAST(>($90, 0)):BOOLEAN), LIKE($1, '1%'), >($91, 1), <($0, 1997-01-02 00:00:00), =(EXTRACT(FLAG(MONTH), $0), 1), =(EXTRACT(FLAG(DAY), $0), 1), =(+(/(EXTRACT(FLAG(MONTH), $0), 4), 1), 1))], groups=[{}], aggs=[[COUNT()]])").queryContains(DruidAdapterIT.druidChecker("{'queryType':'timeseries','dataSource':'foodmart'", "{'type':'expression','expression':'(((CAST(\\'product_id\\'", " (1 * \\'store_sales\\')) / (\\'store_cost\\' - 5)) <= ((floor(\\'store_sales\\') * 25) + 2))'}", "{'type':'expression','expression':'like(\\'product_id\\'", "1%", "{'type':'bound','dimension':'store_cost','lower':'1','lowerStrict':true,'ordering':'numeric'}", "{'type':'bound','dimension':'__time','upper':'1997-01-02T00:00:00.000Z','upperStrict':true,'ordering':'lexicographic','extractionFn':{'type':'timeFormat','format':'yyyy-MM-dd", "{'type':'bound','dimension':'__time','lower':'1','lowerStrict':false,'upper':'1','upperStrict':false,'ordering':'numeric','extractionFn':{'type':'timeFormat','format':'M','timeZone':'UTC','locale':'en-US'}}", "{'type':'bound','dimension':'__time','lower':'1','lowerStrict':false,'upper':'1','upperStrict':false,'ordering':'numeric','extractionFn':{'type':'timeFormat','format':'d','timeZone':'UTC','locale':'en-US'}}", "{'type':'expression','expression':'(((timestamp_extract(\\'__time\\'", "UTC", "MONTH", "/ 4) + 1) == 1)'}]}", "> 0"));
    }

    @Test
    public void testCeilFilterExpression() {
        String sql = "SELECT COUNT(*) FROM \"foodmart\" WHERE ceil(\"store_sales\") > 1 AND ceil(\"timestamp\" TO DAY) < CAST('1997-01-05' AS TIMESTAMP) AND ceil(\"timestamp\" TO MONTH) < CAST('1997-03-01' AS TIMESTAMP) AND ceil(\"timestamp\" TO HOUR) > CAST('1997-01-01' AS TIMESTAMP)  AND ceil(\"timestamp\" TO MINUTE) > CAST('1997-01-01' AS TIMESTAMP)  AND ceil(\"timestamp\" TO SECOND) > CAST('1997-01-01' AS TIMESTAMP) ";
        String plan = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1997-01-01T00:00:00.001Z/1997-01-04T00:00:00.001Z]], filter=[>(CEIL($90), 1)], groups=[{}], aggs=[[COUNT()]])";
        this.sql("SELECT COUNT(*) FROM \"foodmart\" WHERE ceil(\"store_sales\") > 1 AND ceil(\"timestamp\" TO DAY) < CAST('1997-01-05' AS TIMESTAMP) AND ceil(\"timestamp\" TO MONTH) < CAST('1997-03-01' AS TIMESTAMP) AND ceil(\"timestamp\" TO HOUR) > CAST('1997-01-01' AS TIMESTAMP)  AND ceil(\"timestamp\" TO MINUTE) > CAST('1997-01-01' AS TIMESTAMP)  AND ceil(\"timestamp\" TO SECOND) > CAST('1997-01-01' AS TIMESTAMP) ", FOODMART).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1997-01-01T00:00:00.001Z/1997-01-04T00:00:00.001Z]], filter=[>(CEIL($90), 1)], groups=[{}], aggs=[[COUNT()]])").returnsOrdered(new String[]{"EXPR$0=408"});
    }

    @Test
    public void testSubStringExpressionFilter() {
        String sql = "SELECT COUNT(*) AS C, SUBSTRING(\"product_id\" from 1 for 4) FROM \"foodmart\" WHERE SUBSTRING(\"product_id\" from 1 for 4) like '12%'  AND CHARACTER_LENGTH(\"product_id\") = 4 AND SUBSTRING(\"product_id\" from 3 for 1) = '2' AND CAST(SUBSTRING(\"product_id\" from 2 for 1) AS INTEGER) = 2 AND CAST(SUBSTRING(\"product_id\" from 4 for 1) AS INTEGER) = 7 AND CAST(SUBSTRING(\"product_id\" from 4) AS INTEGER) = 7 Group by SUBSTRING(\"product_id\" from 1 for 4)";
        String plan = "PLAN=EnumerableInterpreter\n  BindableProject(C=[$1], EXPR$1=[$0])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[AND(LIKE(SUBSTRING($1, 1, 4), '12%'), =(CHAR_LENGTH($1), 4), =(SUBSTRING($1, 3, 1), '2'), =(CAST(SUBSTRING($1, 2, 1)):INTEGER, 2), =(CAST(SUBSTRING($1, 4, 1)):INTEGER, 7), =(CAST(SUBSTRING($1, 4)):INTEGER, 7))], projects=[[SUBSTRING($1, 1, 4)]], groups=[{0}], aggs=[[COUNT()]])";
        this.sql("SELECT COUNT(*) AS C, SUBSTRING(\"product_id\" from 1 for 4) FROM \"foodmart\" WHERE SUBSTRING(\"product_id\" from 1 for 4) like '12%'  AND CHARACTER_LENGTH(\"product_id\") = 4 AND SUBSTRING(\"product_id\" from 3 for 1) = '2' AND CAST(SUBSTRING(\"product_id\" from 2 for 1) AS INTEGER) = 2 AND CAST(SUBSTRING(\"product_id\" from 4 for 1) AS INTEGER) = 7 AND CAST(SUBSTRING(\"product_id\" from 4) AS INTEGER) = 7 Group by SUBSTRING(\"product_id\" from 1 for 4)", FOODMART).returnsOrdered(new String[]{"C=60; EXPR$1=1227"}).explainContains("PLAN=EnumerableInterpreter\n  BindableProject(C=[$1], EXPR$1=[$0])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[AND(LIKE(SUBSTRING($1, 1, 4), '12%'), =(CHAR_LENGTH($1), 4), =(SUBSTRING($1, 3, 1), '2'), =(CAST(SUBSTRING($1, 2, 1)):INTEGER, 2), =(CAST(SUBSTRING($1, 4, 1)):INTEGER, 7), =(CAST(SUBSTRING($1, 4)):INTEGER, 7))], projects=[[SUBSTRING($1, 1, 4)]], groups=[{0}], aggs=[[COUNT()]])").queryContains(DruidAdapterIT.druidChecker("\"queryType\":\"groupBy\"", "substring(\\\"product_id\\\"", "\"(strlen(\\\"product_id\\\")", ",\"virtualColumns\":[{\"type\":\"expression\",\"name\":\"vc\",\"expression\":\"substring(\\\"product_id\\\", 0, 4)\",\"outputType\":\"STRING\"}]"));
    }

    @Test
    public void testSubStringWithNonConstantIndexes() {
        String sql = "SELECT COUNT(*) FROM \"foodmart\" WHERE SUBSTRING(\"product_id\" from CAST(\"store_cost\" as INT)/1000 + 2  for CAST(\"product_id\" as INT)) like '1%'";
        this.sql("SELECT COUNT(*) FROM \"foodmart\" WHERE SUBSTRING(\"product_id\" from CAST(\"store_cost\" as INT)/1000 + 2  for CAST(\"product_id\" as INT)) like '1%'", FOODMART).returnsOrdered(new String[]{"EXPR$0=10893"}).queryContains(DruidAdapterIT.druidChecker("\"queryType\":\"timeseries\"", "like(substring(\\\"product_id\\\"")).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[LIKE(SUBSTRING($1, +(/(CAST($91):INTEGER, 1000), 2), CAST($1):INTEGER), '1%')], groups=[{}], aggs=[[COUNT()]])\n\n");
    }

    @Test
    public void testSubStringWithNonConstantIndex() {
        String sql = "SELECT COUNT(*) FROM \"foodmart\" WHERE SUBSTRING(\"product_id\" from CAST(\"store_cost\" as INT)/1000 + 1) like '1%'";
        this.sql("SELECT COUNT(*) FROM \"foodmart\" WHERE SUBSTRING(\"product_id\" from CAST(\"store_cost\" as INT)/1000 + 1) like '1%'", FOODMART).returnsOrdered(new String[]{"EXPR$0=36839"}).queryContains(DruidAdapterIT.druidChecker("like(substring(\\\"product_id\\\"")).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[LIKE(SUBSTRING($1, +(/(CAST($91):INTEGER, 1000), 1)), '1%')], groups=[{}], aggs=[[COUNT()]])\n\n");
    }

    @Test
    public void testFilterClauseWithNoConjunction() {
        String sql = "select sum(\"store_sales\")from \"foodmart\" where \"product_id\" > 1555 or \"store_cost\" > 5 or extract(year from \"timestamp\") = 1997 group by floor(\"timestamp\" to DAY),\"product_id\"";
        this.sql(sql).queryContains(DruidAdapterIT.druidChecker("\"queryType\":\"groupBy\"", "{\"type\":\"bound\",\"dimension\":\"store_cost\",\"lower\":\"5\",\"lowerStrict\":true,\"ordering\":\"numeric\"}")).runs();
    }

    @Test
    public void testBetweenFilterWithCastOverNumeric() {
        String sql = "SELECT COUNT(*) FROM \"foodmart\" WHERE \"product_id\" = 16.0";
        this.sql("SELECT COUNT(*) FROM \"foodmart\" WHERE \"product_id\" = 16.0", FOODMART).runs().queryContains(DruidAdapterIT.druidChecker("\"filter\":{\"type\":\"bound\",\"dimension\":\"product_id\",\"lower\":\"16.0\",\"lowerStrict\":false,\"upper\":\"16.0\",\"upperStrict\":false,\"ordering\":\"numeric\"}"));
    }

    @Test
    public void testTrigonometryMathFunctions() {
        String sql = "SELECT COUNT(*) FROM \"foodmart\"WHERE SIN(\"store_cost\") > SIN(20) AND COS(\"store_sales\") > COS(20) AND FLOOR(TAN(\"store_cost\")) = 2 AND ABS(TAN(\"store_cost\") - SIN(\"store_cost\") / COS(\"store_cost\")) < 10e-7";
        this.sql("SELECT COUNT(*) FROM \"foodmart\"WHERE SIN(\"store_cost\") > SIN(20) AND COS(\"store_sales\") > COS(20) AND FLOOR(TAN(\"store_cost\")) = 2 AND ABS(TAN(\"store_cost\") - SIN(\"store_cost\") / COS(\"store_cost\")) < 10e-7", FOODMART).returnsOrdered(new String[]{"EXPR$0=2"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[AND(>(SIN($91), SIN(20)), >(COS($90), COS(20)), =(FLOOR(TAN($91)), 2), <(ABS(-(TAN($91), /(SIN($91), COS($91)))), 1.0E-6))], groups=[{}], aggs=[[COUNT()]])");
    }

    @Test
    public void testCastLiteralToTimestamp() {
        String sql = "SELECT COUNT(*) FROM \"foodmart\" WHERE \"timestamp\" < CAST('1997-01-02' as TIMESTAMP) AND EXTRACT(MONTH FROM \"timestamp\") / 4 + 1 = 1 ";
        this.sql("SELECT COUNT(*) FROM \"foodmart\" WHERE \"timestamp\" < CAST('1997-01-02' as TIMESTAMP) AND EXTRACT(MONTH FROM \"timestamp\") / 4 + 1 = 1 ", FOODMART).returnsOrdered(new String[]{"EXPR$0=117"}).queryContains(DruidAdapterIT.druidChecker("{'queryType':'timeseries','dataSource':'foodmart','descending':false,'granularity':'all','filter':{'type':'and','fields':[{'type':'bound','dimension':'__time','upper':'1997-01-02T00:00:00.000Z','upperStrict':true,'ordering':'lexicographic','extractionFn':{'type':'timeFormat','format':'yyyy-MM-dd", "{'type':'expression','expression':'(((timestamp_extract(\\'__time\\',", "/ 4) + 1) == 1)'}]},", "'aggregations':[{'type':'count','name':'EXPR$0'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'context':{'skipEmptyBuckets':false}}"));
    }

    @Test
    public void testNotTrueSimpleFilter() {
        String sql = "SELECT COUNT(*) FROM \"foodmart\"WHERE (\"product_id\" = 1020 ) IS NOT TRUE AND (\"product_id\" = 1020 ) IS FALSE";
        String result = "EXPR$0=86773";
        this.sql("SELECT COUNT(*) FROM \"foodmart\"WHERE (\"product_id\" = 1020 ) IS NOT TRUE AND (\"product_id\" = 1020 ) IS FALSE", FOODMART).returnsOrdered(new String[]{"EXPR$0=86773"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[AND(IS NOT TRUE(=($1, 1020)), IS FALSE(=($1, 1020)))], groups=[{}], aggs=[[COUNT()]])");
        String sql2 = "SELECT COUNT(*) FROM \"foodmart\"WHERE \"product_id\" <> 1020";
        this.sql("SELECT COUNT(*) FROM \"foodmart\"WHERE \"product_id\" <> 1020", FOODMART).returnsOrdered(new String[]{"EXPR$0=86773"});
    }

    @Test
    public void testPushOfSimpleMathOps() {
        String sql = "SELECT COS(\"store_sales\") + 1, SIN(\"store_cost\"), EXTRACT(DAY from \"timestamp\") + 1  as D FROM \"foodmart\"WHERE \"store_sales\" < 20 order by D limit 3";
        this.sql("SELECT COS(\"store_sales\") + 1, SIN(\"store_cost\"), EXTRACT(DAY from \"timestamp\") + 1  as D FROM \"foodmart\"WHERE \"store_sales\" < 20 order by D limit 3", FOODMART).runs().returnsOrdered(new String[]{"EXPR$0=1.060758881219386; EXPR$1=0.5172204046388567; D=2\nEXPR$0=0.8316025520509229; EXPR$1=0.6544084288365644; D=2\nEXPR$0=0.24267723077545622; EXPR$1=0.9286289016881148; D=2"}).explainContains("PLAN=EnumerableInterpreter\n  BindableSort(sort0=[$2], dir0=[ASC], fetch=[3])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[<($90, 20)], projects=[[+(COS($90), 1), SIN($91), +(EXTRACT(FLAG(DAY), $0), 1)]])");
    }

    @Test
    public void testPushOfSimpleColumnAPlusColumnB() {
        String sql = "SELECT COS(\"store_sales\" + \"store_cost\") + 1, EXTRACT(DAY from \"timestamp\") + 1  as D FROM \"foodmart\"WHERE \"store_sales\" < 20 order by D limit 3";
        this.sql("SELECT COS(\"store_sales\" + \"store_cost\") + 1, EXTRACT(DAY from \"timestamp\") + 1  as D FROM \"foodmart\"WHERE \"store_sales\" < 20 order by D limit 3", FOODMART).runs().returnsOrdered(new String[]{"EXPR$0=0.5357357987441458; D=2\nEXPR$0=0.22760480207557643; D=2\nEXPR$0=0.11259322182897047; D=2"}).explainContains("PLAN=EnumerableInterpreter\n  BindableSort(sort0=[$1], dir0=[ASC], fetch=[3])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[<($90, 20)], projects=[[+(COS(+($90, $91)), 1), +(EXTRACT(FLAG(DAY), $0), 1)]])");
    }

    @Test
    public void testSelectExtractMonth() {
        String sql = "SELECT  EXTRACT(YEAR FROM \"timestamp\") FROM \"foodmart\"";
        this.sql("SELECT  EXTRACT(YEAR FROM \"timestamp\") FROM \"foodmart\"", FOODMART).limit(1).returnsOrdered(new String[]{"EXPR$0=1997"}).explainContains("DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[EXTRACT(FLAG(YEAR), $0)]])").queryContains(DruidAdapterIT.druidChecker("\"virtualColumns\":[{\"type\":\"expression\",\"name\":\"vc\",\"expression\":\"timestamp_extract(\\\"__time\\\""));
    }

    @Test
    public void testAggOnArithmeticProject() {
        String sql = "SELECT SUM(\"store_sales\" + 1) FROM \"foodmart\"";
        this.sql("SELECT SUM(\"store_sales\" + 1) FROM \"foodmart\"", FOODMART).returnsOrdered(new String[]{"EXPR$0=652067.1299999984"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[+($90, 1)]], groups=[{}], aggs=[[SUM($0)]])").queryContains(DruidAdapterIT.druidChecker("\"queryType\":\"timeseries\"", "\"doubleSum\",\"name\":\"EXPR$0\",\"expression\":\"(\\\"store_sales\\\" + 1)\""));
    }

    @Test
    public void testAggOnArithmeticProject2() {
        String sql = "SELECT SUM(-\"store_sales\" * 2) as S FROM \"foodmart\"Group by \"timestamp\" order by s LIMIT 2";
        this.sql("SELECT SUM(-\"store_sales\" * 2) as S FROM \"foodmart\"Group by \"timestamp\" order by s LIMIT 2", FOODMART).returnsOrdered(new String[]{"S=-15918.020000000002\nS=-14115.959999999988"}).explainContains("BindableProject(S=[$1])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$0, *(-($90), 2)]], groups=[{0}], aggs=[[SUM($1)]], sort0=[1], dir0=[ASC], fetch=[2])").queryContains(DruidAdapterIT.druidChecker("'queryType':'groupBy'", "'granularity':'all'", "{'dimension':'S','direction':'ascending','dimensionOrder':'numeric'}", "{'type':'doubleSum','name':'S','expression':'((- \\'store_sales\\') * 2)'}]"));
    }

    @Test
    public void testAggOnArithmeticProject3() {
        String sql = "SELECT SUM(-\"store_sales\" * 2)-Max(\"store_cost\" * \"store_cost\") AS S,Min(\"store_sales\" + \"store_cost\") as S2 FROM \"foodmart\"Group by \"timestamp\" order by s LIMIT 2";
        this.sql("SELECT SUM(-\"store_sales\" * 2)-Max(\"store_cost\" * \"store_cost\") AS S,Min(\"store_sales\" + \"store_cost\") as S2 FROM \"foodmart\"Group by \"timestamp\" order by s LIMIT 2", FOODMART).returnsOrdered(new String[]{"S=-16003.314460250002; S2=1.4768000000000001", "S=-14181.569999999989; S2=0.8093999999999999"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$0, *(-($90), 2), *($91, $91), +($90, $91)]], groups=[{0}], aggs=[[SUM($1), MAX($2), MIN($3)]], post_projects=[[-($1, $2), $3]], sort0=[0], dir0=[ASC], fetch=[2])").queryContains(DruidAdapterIT.druidChecker(",\"aggregations\":[{\"type\":\"doubleSum\",\"name\":\"$f1\",\"expression\":\"((- \\\"store_sales\\\") * 2)\"},{\"type\":\"doubleMax\",\"name\":\"$f2\",\"expression\":\"(\\\"store_cost\\\" * \\\"store_cost\\\")\"},{\"type\":\"doubleMin\",\"name\":\"S2\",\"expression\":\"(\\\"store_sales\\\" + \\\"store_cost\\\")\"}],\"postAggregations\":[{\"type\":\"expression\",\"name\":\"S\",\"expression\":\"(\\\"$f1\\\" - \\\"$f2\\\")\"}]"));
    }

    @Test
    public void testGroupByVirtualColumn() {
        String sql = "SELECT \"product_id\" || '_' ||\"city\", SUM(\"store_sales\" + CAST(\"cost\" AS DOUBLE)) as S FROM \"foodmart\"GROUP BY \"product_id\" || '_' || \"city\" LIMIT 2";
        this.sql("SELECT \"product_id\" || '_' ||\"city\", SUM(\"store_sales\" + CAST(\"cost\" AS DOUBLE)) as S FROM \"foodmart\"GROUP BY \"product_id\" || '_' || \"city\" LIMIT 2", FOODMART).returnsOrdered(new String[]{"EXPR$0=1000_Albany; S=12385.21", "EXPR$0=1000_Altadena; S=8.07"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[||(||($1, '_'), $29), +($90, CAST($53):DOUBLE)]], groups=[{0}], aggs=[[SUM($1)]], fetch=[2])").queryContains(DruidAdapterIT.druidChecker("'queryType':'groupBy'", "{'type':'doubleSum','name':'S','expression':'(\\'store_sales\\' + CAST(\\'cost\\'", "'expression':'concat(concat(\\'product_id\\'", "{'type':'default','dimension':'vc','outputName':'vc','outputType':'STRING'}],'virtualColumns':[{'type':'expression','name':'vc"));
    }

    @Test
    public void testCountOverVirtualColumn() {
        String sql = "SELECT COUNT(\"product_id\" || '_' || \"city\") FROM \"foodmart\"WHERE \"state_province\" = 'CA'";
        this.sql("SELECT COUNT(\"product_id\" || '_' || \"city\") FROM \"foodmart\"WHERE \"state_province\" = 'CA'", FOODMART).returnsOrdered(new String[]{"EXPR$0=24441"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[=($30, 'CA')], projects=[[||(||($1, '_'), $29)]], groups=[{}], aggs=[[COUNT($0)]])").queryContains(DruidAdapterIT.druidChecker("\"queryType\":\"timeseries\"", "\"aggregator\":{\"type\":\"count\",\"name\":\"EXPR$0\",\"expression\":\"concat(concat(\\\"product_id\\\"", "\"aggregations\":[{\"type\":\"filtered\",\"filter\":{\"type\":\"not\",\"field\":{\"type\":\"expression\",\"expression\":\"concat(concat(\\\"product_id\\\""));
    }

    @Test
    public void testAggOverStringToLong() {
        String sql = "SELECT SUM(cast(\"product_id\" AS INTEGER)) FROM \"foodmart\"";
        this.sql("SELECT SUM(cast(\"product_id\" AS INTEGER)) FROM \"foodmart\"", FOODMART).queryContains(DruidAdapterIT.druidChecker("{'queryType':'timeseries','dataSource':'foodmart','descending':false,'granularity':'all','aggregations':[{'type':'longSum','name':'EXPR$0','expression':'CAST(\\'product_id\\'", "LONG")).returnsOrdered(new String[]{"EXPR$0=68222919"});
    }

    @Test
    public void testAggOnTimeExtractColumn() {
        String sql = "SELECT SUM(EXTRACT(MONTH FROM \"__time\")) FROM \"wikiticker\"";
        this.sql("SELECT SUM(EXTRACT(MONTH FROM \"__time\")) FROM \"wikiticker\"", WIKI_AUTO2).returnsOrdered(new String[]{"EXPR$0=353196"}).queryContains(DruidAdapterIT.druidChecker("{'queryType':'timeseries','dataSource':'wikiticker','descending':false,'granularity':'all','aggregations':[{'type':'longSum','name':'EXPR$0','expression':'timestamp_extract(\\'__time\\'"));
    }

    @Test
    public void testAggOnTimeExtractColumn2() {
        String sql = "SELECT MAX(EXTRACT(MONTH FROM \"timestamp\")) FROM \"foodmart\"";
        this.sql("SELECT MAX(EXTRACT(MONTH FROM \"timestamp\")) FROM \"foodmart\"", FOODMART).returnsOrdered(new String[]{"EXPR$0=12"}).queryContains(DruidAdapterIT.druidChecker("{'queryType':'timeseries','dataSource':'foodmart','descending':false,'granularity':'all','aggregations':[{'type':'longMax','name':'EXPR$0','expression':'timestamp_extract(\\'__time\\'"));
    }

    @Test
    public void testStackedAggregateFilters() {
        String sql = "SELECT COUNT(\"product_id\") filter (WHERE \"state_province\" = 'CA' OR \"store_sales\" > 100 AND \"product_id\" <> '100'), count(*) FROM \"foodmart\"";
        String query = "{'queryType':'timeseries','dataSource':'foodmart','descending':false,'granularity':'all','aggregations':[{'type':'filtered','filter':{'type':'or','fields':[{'type':'selector','dimension':'state_province','value':'CA'},{'type':'and','fields':[{'type':'bound','dimension':'store_sales','lower':'100','lowerStrict':true,'ordering':'numeric'},{'type':'not','field':{'type':'selector','dimension':'product_id','value':'100'}}]}]},'aggregator':{'type':'filtered','filter':{'type':'not','field':{'type':'selector','dimension':'product_id','value':null}},'aggregator':{'type':'count','name':'EXPR$0','fieldName':'product_id'}}},{'type':'count','name':'EXPR$1'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'context':{'skipEmptyBuckets':false}}";
        this.sql("SELECT COUNT(\"product_id\") filter (WHERE \"state_province\" = 'CA' OR \"store_sales\" > 100 AND \"product_id\" <> '100'), count(*) FROM \"foodmart\"", FOODMART).returnsOrdered(new String[]{"EXPR$0=24441; EXPR$1=86829"}).queryContains(DruidAdapterIT.druidChecker("{'queryType':'timeseries','dataSource':'foodmart','descending':false,'granularity':'all','aggregations':[{'type':'filtered','filter':{'type':'or','fields':[{'type':'selector','dimension':'state_province','value':'CA'},{'type':'and','fields':[{'type':'bound','dimension':'store_sales','lower':'100','lowerStrict':true,'ordering':'numeric'},{'type':'not','field':{'type':'selector','dimension':'product_id','value':'100'}}]}]},'aggregator':{'type':'filtered','filter':{'type':'not','field':{'type':'selector','dimension':'product_id','value':null}},'aggregator':{'type':'count','name':'EXPR$0','fieldName':'product_id'}}},{'type':'count','name':'EXPR$1'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'context':{'skipEmptyBuckets':false}}"));
    }

    @Test
    public void testCastOverPostAggregates() {
        String sql = "SELECT CAST(COUNT(*) + SUM(\"store_sales\") as INTEGER) FROM \"foodmart\"";
        this.sql("SELECT CAST(COUNT(*) + SUM(\"store_sales\") as INTEGER) FROM \"foodmart\"", FOODMART).returnsOrdered(new String[]{"EXPR$0=652067"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$90]], groups=[{}], aggs=[[COUNT(), SUM($0)]], post_projects=[[CAST(+($0, $1)):INTEGER]])");
    }

    @Test
    public void testSubStringOverPostAggregates() {
        String sql = "SELECT \"product_id\", SUBSTRING(\"product_id\" from 1 for 2) FROM \"foodmart\" GROUP BY \"product_id\"";
        this.sql("SELECT \"product_id\", SUBSTRING(\"product_id\" from 1 for 2) FROM \"foodmart\" GROUP BY \"product_id\"", FOODMART).limit(3).returnsOrdered(new String[]{"product_id=1; EXPR$1=1\nproduct_id=10; EXPR$1=10\nproduct_id=100; EXPR$1=10"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$1]], groups=[{0}], aggs=[[]], post_projects=[[$0, SUBSTRING($0, 1, 2)]])");
    }

    @Test
    public void testTableQueryExtractYearQuarter() {
        String sql = "SELECT * FROM (SELECT CAST((MONTH(\"timestamp\") - 1) / 3 + 1 AS BIGINT)AS qr_timestamp_ok,  SUM(\"store_sales\") AS sum_store_sales, YEAR(\"timestamp\") AS yr_timestamp_ok FROM \"foodmart\" GROUP BY CAST((MONTH(\"timestamp\") - 1) / 3 + 1 AS BIGINT), YEAR(\"timestamp\")) LIMIT_ZERO LIMIT 1";
        String extract_year = "{\"type\":\"extraction\",\"dimension\":\"__time\",\"outputName\":\"extract_year\",\"extractionFn\":{\"type\":\"timeFormat\",\"format\":\"yyyy\",\"timeZone\":\"UTC\",\"locale\":\"en-US\"}}";
        String extract_expression = "\"expression\":\"(((timestamp_extract(\\\"__time\\\",";
        this.sql("SELECT * FROM (SELECT CAST((MONTH(\"timestamp\") - 1) / 3 + 1 AS BIGINT)AS qr_timestamp_ok,  SUM(\"store_sales\") AS sum_store_sales, YEAR(\"timestamp\") AS yr_timestamp_ok FROM \"foodmart\" GROUP BY CAST((MONTH(\"timestamp\") - 1) / 3 + 1 AS BIGINT), YEAR(\"timestamp\")) LIMIT_ZERO LIMIT 1", FOODMART).returnsOrdered(new String[]{"QR_TIMESTAMP_OK=1; SUM_STORE_SALES=139628.34999999971; YR_TIMESTAMP_OK=1997"}).queryContains(DruidAdapterIT.druidChecker("\"queryType\":\"groupBy\"", "{\"type\":\"extraction\",\"dimension\":\"__time\",\"outputName\":\"extract_year\",\"extractionFn\":{\"type\":\"timeFormat\",\"format\":\"yyyy\",\"timeZone\":\"UTC\",\"locale\":\"en-US\"}}", "\"expression\":\"(((timestamp_extract(\\\"__time\\\",")).explainContains("BindableProject(QR_TIMESTAMP_OK=[$0], SUM_STORE_SALES=[$2], YR_TIMESTAMP_OK=[$1])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[CAST(+(/(-(EXTRACT(FLAG(MONTH), $0), 1), 3), 1)):BIGINT NOT NULL, EXTRACT(FLAG(YEAR), $0), $90]], groups=[{0, 1}], aggs=[[SUM($2)]], fetch=[1])");
    }

    @Test
    public void testTableauQueryExtractMonthDayYear() {
        String sql = "SELECT * FROM (SELECT (((YEAR(\"foodmart\".\"timestamp\") * 10000) + (MONTH(\"foodmart\".\"timestamp\") * 100)) + EXTRACT(DAY FROM \"foodmart\".\"timestamp\")) AS md_t_timestamp_ok,\n  SUM(\"foodmart\".\"store_sales\") AS sum_t_other_ok\nFROM \"foodmart\"\nGROUP BY (((YEAR(\"foodmart\".\"timestamp\") * 10000) + (MONTH(\"foodmart\".\"timestamp\") * 100)) + EXTRACT(DAY FROM\"foodmart\".\"timestamp\"))) LIMIT 1";
        this.sql("SELECT * FROM (SELECT (((YEAR(\"foodmart\".\"timestamp\") * 10000) + (MONTH(\"foodmart\".\"timestamp\") * 100)) + EXTRACT(DAY FROM \"foodmart\".\"timestamp\")) AS md_t_timestamp_ok,\n  SUM(\"foodmart\".\"store_sales\") AS sum_t_other_ok\nFROM \"foodmart\"\nGROUP BY (((YEAR(\"foodmart\".\"timestamp\") * 10000) + (MONTH(\"foodmart\".\"timestamp\") * 100)) + EXTRACT(DAY FROM\"foodmart\".\"timestamp\"))) LIMIT 1", FOODMART).returnsOrdered(new String[]{"MD_T_TIMESTAMP_OK=19970101; SUM_T_OTHER_OK=706.34"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[+(+(*(EXTRACT(FLAG(YEAR), $0), 10000), *(EXTRACT(FLAG(MONTH), $0), 100)), EXTRACT(FLAG(DAY), $0)), $90]], groups=[{0}], aggs=[[SUM($1)]], fetch=[1])").queryContains(DruidAdapterIT.druidChecker("\"queryType\":\"groupBy\""));
    }

    @Test
    public void testTableauQuerySubStringHourMinutes() {
        String sql = "SELECT * FROM (SELECT CAST(SUBSTRING(CAST(CAST(\"foodmart\".\"timestamp\" AS TIMESTAMP) AS VARCHAR) from 12 for 2) AS INT) AS hr_t_timestamp_ok,\n  MINUTE(\"foodmart\".\"timestamp\") AS mi_t_timestamp_ok,\n  SUM(\"foodmart\".\"store_sales\") AS sum_t_other_ok, EXTRACT(HOUR FROM \"timestamp\")  AS hr_t_timestamp_ok2 FROM  \"foodmart\" GROUP BY  CAST(SUBSTRING(CAST(CAST(\"foodmart\".\"timestamp\" AS TIMESTAMP) AS VARCHAR) from 12 for 2 ) AS INT),  MINUTE(\"foodmart\".\"timestamp\"), EXTRACT(HOUR FROM \"timestamp\")) LIMIT 1";
        this.sql("SELECT * FROM (SELECT CAST(SUBSTRING(CAST(CAST(\"foodmart\".\"timestamp\" AS TIMESTAMP) AS VARCHAR) from 12 for 2) AS INT) AS hr_t_timestamp_ok,\n  MINUTE(\"foodmart\".\"timestamp\") AS mi_t_timestamp_ok,\n  SUM(\"foodmart\".\"store_sales\") AS sum_t_other_ok, EXTRACT(HOUR FROM \"timestamp\")  AS hr_t_timestamp_ok2 FROM  \"foodmart\" GROUP BY  CAST(SUBSTRING(CAST(CAST(\"foodmart\".\"timestamp\" AS TIMESTAMP) AS VARCHAR) from 12 for 2 ) AS INT),  MINUTE(\"foodmart\".\"timestamp\"), EXTRACT(HOUR FROM \"timestamp\")) LIMIT 1", FOODMART).returnsOrdered(new String[]{"HR_T_TIMESTAMP_OK=0; MI_T_TIMESTAMP_OK=0; SUM_T_OTHER_OK=565238.1299999986; HR_T_TIMESTAMP_OK2=0"}).explainContains("BindableProject(HR_T_TIMESTAMP_OK=[$0], MI_T_TIMESTAMP_OK=[$1], SUM_T_OTHER_OK=[$3], HR_T_TIMESTAMP_OK2=[$2])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[CAST(SUBSTRING(CAST(CAST($0):TIMESTAMP(0) NOT NULL):VARCHAR NOT NULL, 12, 2)):INTEGER NOT NULL, EXTRACT(FLAG(MINUTE), $0), EXTRACT(FLAG(HOUR), $0), $90]], groups=[{0, 1, 2}], aggs=[[SUM($3)]], fetch=[1])").queryContains(DruidAdapterIT.druidChecker("\"queryType\":\"groupBy\""));
    }

    @Test
    public void testTableauQueryMinutesSecondsExtract() {
        String sql = "SELECT * FROM (SELECT SECOND(\"timestamp\") AS sc_t_timestamp_ok,MINUTE(\"timestamp\") AS mi_t_timestamp_ok,  SUM(\"store_sales\") AS sum_store_sales  FROM \"foodmart\" GROUP BY SECOND(\"timestamp\"), MINUTE(\"timestamp\")) LIMIT_ZERO LIMIT 1";
        this.sql("SELECT * FROM (SELECT SECOND(\"timestamp\") AS sc_t_timestamp_ok,MINUTE(\"timestamp\") AS mi_t_timestamp_ok,  SUM(\"store_sales\") AS sum_store_sales  FROM \"foodmart\" GROUP BY SECOND(\"timestamp\"), MINUTE(\"timestamp\")) LIMIT_ZERO LIMIT 1", FOODMART).returnsOrdered(new String[]{"SC_T_TIMESTAMP_OK=0; MI_T_TIMESTAMP_OK=0; SUM_STORE_SALES=565238.1299999986"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[EXTRACT(FLAG(SECOND), $0), EXTRACT(FLAG(MINUTE), $0), $90]], groups=[{0, 1}], aggs=[[SUM($2)]], fetch=[1])").queryContains(DruidAdapterIT.druidChecker("\"queryType\":\"groupBy\""));
    }

    @Test
    public void testQueryWithExtractsTimes() {
        String sql = "SELECT * FROM (SELECT QUARTER(\"__time\") AS QUARTER ,EXTRACT(WEEK FROM \"__time\") AS WEEK, DAYOFWEEK(\"__time\") AS DAYOFWEEK, DAYOFMONTH(\"__time\") AS DAYOFMONTH, DAYOFYEAR(\"__time\") AS DAYOFYEAR, SUM(\"added\") AS sum_added  FROM \"wikiticker\" GROUP BY EXTRACT(WEEK FROM \"__time\"), DAYOFWEEK(\"__time\"), DAYOFMONTH(\"__time\"), DAYOFYEAR(\"__time\") , QUARTER(\"__time\") order by sum_added) LIMIT_ZERO LIMIT 1";
        this.sql("SELECT * FROM (SELECT QUARTER(\"__time\") AS QUARTER ,EXTRACT(WEEK FROM \"__time\") AS WEEK, DAYOFWEEK(\"__time\") AS DAYOFWEEK, DAYOFMONTH(\"__time\") AS DAYOFMONTH, DAYOFYEAR(\"__time\") AS DAYOFYEAR, SUM(\"added\") AS sum_added  FROM \"wikiticker\" GROUP BY EXTRACT(WEEK FROM \"__time\"), DAYOFWEEK(\"__time\"), DAYOFMONTH(\"__time\"), DAYOFYEAR(\"__time\") , QUARTER(\"__time\") order by sum_added) LIMIT_ZERO LIMIT 1", WIKI_AUTO2).returnsOrdered(new String[]{"QUARTER=3; WEEK=37; DAYOFWEEK=6; DAYOFMONTH=12; DAYOFYEAR=255; SUM_ADDED=9385573"}).explainContains("PLAN=EnumerableInterpreter\n  BindableProject(QUARTER=[$4], WEEK=[$0], DAYOFWEEK=[$1], DAYOFMONTH=[$2], DAYOFYEAR=[$3], SUM_ADDED=[$5])\n    BindableSort(fetch=[1])\n      DruidQuery(table=[[wiki, wikiticker]], intervals=[[1900-01-01T00:00:00.000Z/3000-01-01T00:00:00.000Z]], projects=[[EXTRACT(FLAG(WEEK), $0), EXTRACT(FLAG(DOW), $0), EXTRACT(FLAG(DAY), $0), EXTRACT(FLAG(DOY), $0), EXTRACT(FLAG(QUARTER), $0), $1]], groups=[{0, 1, 2, 3, 4}], aggs=[[SUM($5)]], sort0=[5], dir0=[ASC])").queryContains(DruidAdapterIT.druidChecker("\"queryType\":\"groupBy\""));
    }

    @Test
    public void testCastConcatOverPostAggregates() {
        String sql = "SELECT CAST(COUNT(*) + SUM(\"store_sales\") as VARCHAR) || '_' || CAST(SUM(\"store_cost\") AS VARCHAR) FROM \"foodmart\"";
        this.sql("SELECT CAST(COUNT(*) + SUM(\"store_sales\") as VARCHAR) || '_' || CAST(SUM(\"store_cost\") AS VARCHAR) FROM \"foodmart\"", FOODMART).returnsOrdered(new String[]{"EXPR$0=652067.1299999986_225627.2336000002"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$90, $91]], groups=[{}], aggs=[[COUNT(), SUM($0), SUM($1)]], post_projects=[[||(||(CAST(+($0, $1)):VARCHAR CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\", '_'), CAST($2):VARCHAR)]])");
    }

    @Test
    public void testHavingSpecs() {
        String sql = "SELECT \"product_id\" AS P, SUM(\"store_sales\") AS S FROM \"foodmart\"  GROUP BY  \"product_id\" HAVING  SUM(\"store_sales\") > 220  ORDER BY P LIMIT 2";
        this.sql("SELECT \"product_id\" AS P, SUM(\"store_sales\") AS S FROM \"foodmart\"  GROUP BY  \"product_id\" HAVING  SUM(\"store_sales\") > 220  ORDER BY P LIMIT 2", FOODMART).returnsOrdered(new String[]{"P=1; S=236.55", "P=10; S=230.04"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$1, $90]], groups=[{0}], aggs=[[SUM($1)]], filter=[>($1, 220)], sort0=[0], dir0=[ASC], fetch=[2])").queryContains(DruidAdapterIT.druidChecker("'having':{'type':'filter','filter':{'type':'bound','dimension':'S','lower':'220','lowerStrict':true,'ordering':'numeric'}}"));
    }

    @Test
    public void testTransposableHavingFilter() {
        String sql = "SELECT \"product_id\" AS P, SUM(\"store_sales\") AS S FROM \"foodmart\"  GROUP BY  \"product_id\" HAVING  SUM(\"store_sales\") > 220 AND \"product_id\" > '10'  ORDER BY P LIMIT 2";
        this.sql("SELECT \"product_id\" AS P, SUM(\"store_sales\") AS S FROM \"foodmart\"  GROUP BY  \"product_id\" HAVING  SUM(\"store_sales\") > 220 AND \"product_id\" > '10'  ORDER BY P LIMIT 2", FOODMART).returnsOrdered(new String[]{"P=100; S=343.19999999999993", "P=1000; S=532.62"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[>($1, '10')], projects=[[$1, $90]], groups=[{0}], aggs=[[SUM($1)]], filter=[>($1, 220)], sort0=[0], dir0=[ASC], fetch=[2])\n").queryContains(DruidAdapterIT.druidChecker("{'queryType':'groupBy','dataSource':'foodmart','granularity':'all'"));
    }

    @Test
    public void testProjectSameColumnMultipleTimes() {
        String sql = "SELECT \"product_id\" as prod_id1, \"product_id\" as prod_id2, \"store_sales\" as S1, \"store_sales\" as S2 FROM \"foodmart\" order by prod_id1 LIMIT 1";
        this.sql("SELECT \"product_id\" as prod_id1, \"product_id\" as prod_id2, \"store_sales\" as S1, \"store_sales\" as S2 FROM \"foodmart\" order by prod_id1 LIMIT 1", FOODMART).explainContains("PLAN=EnumerableInterpreter\n  BindableSort(sort0=[$0], dir0=[ASC], fetch=[1])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$1, $1, $90, $90]])").queryContains(DruidAdapterIT.druidChecker("{'queryType':'scan','dataSource':'foodmart','intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'virtualColumns':[{'type':'expression','name':'vc','expression':'\\'product_id\\'','outputType':'STRING'},{'type':'expression','name':'vc0','expression':'\\'store_sales\\'','outputType':'DOUBLE'}],'columns':['product_id','vc','store_sales','vc0'],'resultFormat':'compactedList'}")).returnsOrdered(new String[]{"PROD_ID1=1; PROD_ID2=1; S1=11.4; S2=11.4"});
    }

    @Test
    public void testProjectSameMetricsColumnMultipleTimes() {
        String sql = "SELECT \"product_id\" as prod_id1, \"product_id\" as prod_id2, \"store_sales\" as S1, \"store_sales\" as S2 FROM \"foodmart\" order by prod_id1 LIMIT 1";
        this.sql("SELECT \"product_id\" as prod_id1, \"product_id\" as prod_id2, \"store_sales\" as S1, \"store_sales\" as S2 FROM \"foodmart\" order by prod_id1 LIMIT 1", FOODMART).explainContains("PLAN=EnumerableInterpreter\n  BindableSort(sort0=[$0], dir0=[ASC], fetch=[1])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$1, $1, $90, $90]])").queryContains(DruidAdapterIT.druidChecker("{\"queryType\":\"scan\",\"dataSource\":\"foodmart\",\"intervals\":[\"1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z\"],\"virtualColumns\":[{\"type\":\"expression\",\"name\":\"vc\",\"expression\":\"\\\"product_id\\\"\",\"outputType\":\"STRING\"},{\"type\":\"expression\",\"name\":\"vc0\",\"expression\":\"\\\"store_sales\\\"\",\"outputType\":\"DOUBLE\"}],\"columns\":[\"product_id\",\"vc\",\"store_sales\",\"vc0\"],\"resultFormat\":\"compactedList\"}")).returnsOrdered(new String[]{"PROD_ID1=1; PROD_ID2=1; S1=11.4; S2=11.4"});
    }

    @Test
    public void testAggSameColumnMultipleTimes() {
        String sql = "SELECT \"product_id\" as prod_id1, \"product_id\" as prod_id2, SUM(\"store_sales\") as S1, SUM(\"store_sales\") as S2 FROM \"foodmart\" GROUP BY \"product_id\" ORDER BY prod_id2 LIMIT 1";
        this.sql("SELECT \"product_id\" as prod_id1, \"product_id\" as prod_id2, SUM(\"store_sales\") as S1, SUM(\"store_sales\") as S2 FROM \"foodmart\" GROUP BY \"product_id\" ORDER BY prod_id2 LIMIT 1", FOODMART).explainContains("BindableProject(PROD_ID1=[$0], PROD_ID2=[$0], S1=[$1], S2=[$1])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$1, $90]], groups=[{0}], aggs=[[SUM($1)]], sort0=[0], dir0=[ASC], fetch=[1])").queryContains(DruidAdapterIT.druidChecker("\"queryType\":\"groupBy\"")).returnsOrdered(new String[]{"PROD_ID1=1; PROD_ID2=1; S1=236.55; S2=236.55"});
    }

    @Test
    public void testGroupBy1() {
        String sql = "SELECT SUM(\"store_sales\") FROM \"foodmart\" GROUP BY 1 HAVING (COUNT(1) > 0)";
        this.sql("SELECT SUM(\"store_sales\") FROM \"foodmart\" GROUP BY 1 HAVING (COUNT(1) > 0)", FOODMART).returnsOrdered(new String[]{"EXPR$0=565238.1299999986"}).queryContains(DruidAdapterIT.druidChecker("{'queryType':'groupBy','dataSource':'foodmart','granularity':'all','dimensions':[{'type':'default','dimension':'vc','outputName':'vc','outputType':'LONG'}],'virtualColumns':[{'type':'expression','name':'vc','expression':'1','outputType':'LONG'}],'limitSpec':{'type':'default'},'aggregations':[{'type':'doubleSum','name':'EXPR$0','fieldName':'store_sales'},{'type':'count','name':'$f2'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'having':{'type':'filter','filter':{'type':'bound','dimension':'$f2','lower':'0','lowerStrict':true,'ordering':'numeric'}}}"));
    }

    @Test
    public void testFloorQuarter() {
        String sql = "SELECT floor(\"timestamp\" TO quarter), SUM(\"store_sales\") FROM \"foodmart\" GROUP BY floor(\"timestamp\" TO quarter)";
        this.sql(sql, FOODMART).queryContains(DruidAdapterIT.druidChecker("{\"queryType\":\"timeseries\",\"dataSource\":\"foodmart\",\"descending\":false,\"granularity\":{\"type\":\"period\",\"period\":\"P3M\",\"timeZone\":\"UTC\"},\"aggregations\":[{\"type\":\"doubleSum\",\"name\":\"EXPR$1\",\"fieldName\":\"store_sales\"}],\"intervals\":[\"1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z\"],\"context\":{\"skipEmptyBuckets\":true}}"));
    }

    @Test
    public void testFloorQuarterPlusDim() {
        String sql = "SELECT floor(\"timestamp\" TO quarter),\"product_id\",  SUM(\"store_sales\") FROM \"foodmart\" GROUP BY floor(\"timestamp\" TO quarter), \"product_id\"";
        this.sql(sql, FOODMART).queryContains(DruidAdapterIT.druidChecker("{\"queryType\":\"groupBy\",\"dataSource\":\"foodmart\",\"granularity\":\"all\",\"dimensions\":[{\"type\":\"extraction\",\"dimension\":\"__time\",\"outputName\":\"floor_quarter\",\"extractionFn\":{\"type\":\"timeFormat\"", "\"granularity\":{\"type\":\"period\",\"period\":\"P3M\",\"timeZone\":\"UTC\"},\"timeZone\":\"UTC\",\"locale\":\"und\"}},{\"type\":\"default\",\"dimension\":\"product_id\",\"outputName\":\"product_id\",\"outputType\":\"STRING\"}],\"limitSpec\":{\"type\":\"default\"},\"aggregations\":[{\"type\":\"doubleSum\",\"name\":\"EXPR$2\",\"fieldName\":\"store_sales\"}],\"intervals\":[\"1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z\"]}"));
    }

    @Test
    public void testExtractQuarterPlusDim() {
        String sql = "SELECT EXTRACT(quarter from \"timestamp\"),\"product_id\",  SUM(\"store_sales\") FROM \"foodmart\" WHERE \"product_id\" = 1 GROUP BY EXTRACT(quarter from \"timestamp\"), \"product_id\"";
        this.sql(sql, FOODMART).returnsOrdered(new String[]{"EXPR$0=1; product_id=1; EXPR$2=37.050000000000004\nEXPR$0=2; product_id=1; EXPR$2=62.7\nEXPR$0=3; product_id=1; EXPR$2=88.35\nEXPR$0=4; product_id=1; EXPR$2=48.45"}).queryContains(DruidAdapterIT.druidChecker("{\"queryType\":\"groupBy\",\"dataSource\":\"foodmart\",\"granularity\":\"all\",\"dimensions\":[{\"type\":\"default\",\"dimension\":\"vc\",\"outputName\":\"vc\",\"outputType\":\"LONG\"},{\"type\":\"default\",\"dimension\":\"product_id\",\"outputName\":\"product_id\",\"outputType\":\"STRING\"}],\"virtualColumns\":[{\"type\":\"expression\",\"name\":\"vc\",\"expression\":\"timestamp_extract(\\\"__time\\\",", "QUARTER"));
    }

    @Test
    public void testExtractQuarter() {
        String sql = "SELECT EXTRACT(quarter from \"timestamp\"),  SUM(\"store_sales\") FROM \"foodmart\" GROUP BY EXTRACT(quarter from \"timestamp\")";
        this.sql(sql, FOODMART).returnsOrdered(new String[]{"EXPR$0=1; EXPR$1=139628.34999999971\nEXPR$0=2; EXPR$1=132666.26999999944\nEXPR$0=3; EXPR$1=140271.88999999964\nEXPR$0=4; EXPR$1=152671.61999999985"}).queryContains(DruidAdapterIT.druidChecker("{\"queryType\":\"groupBy\",\"dataSource\":\"foodmart\",\"granularity\":\"all\",\"dimensions\":[{\"type\":\"default\",\"dimension\":\"vc\",\"outputName\":\"vc\",\"outputType\":\"LONG\"}],\"virtualColumns\":[{\"type\":\"expression\",\"name\":\"vc\",\"expression\":\"timestamp_extract(\\\"__time\\\",", "QUARTER"));
    }

    @Test
    public void testSelectCountStarPlusOtherAggs() {
        String sql = "SELECT COUNT(*), SUM(\"store_sales\"), COUNT(\"store_sales\") FROM \"foodmart\"";
        this.sql("SELECT COUNT(*), SUM(\"store_sales\"), COUNT(\"store_sales\") FROM \"foodmart\"", FOODMART).returnsOrdered(new String[]{"EXPR$0=86829; EXPR$1=565238.1299999986; EXPR$2=86829"}).queryContains(DruidAdapterIT.druidChecker("{'queryType':'timeseries'", "'context':{'skipEmptyBuckets':false}}"));
    }

    @Test
    public void testGroupByWithBooleanExpression() {
        String sql = "SELECT \"product_id\" > 1000 as pid_category, COUNT(\"store_sales\") FROM \"foodmart\"GROUP BY \"product_id\" > 1000";
        this.sql("SELECT \"product_id\" > 1000 as pid_category, COUNT(\"store_sales\") FROM \"foodmart\"GROUP BY \"product_id\" > 1000", FOODMART).returnsOrdered(new String[]{"PID_CATEGORY=0; EXPR$1=55789", "PID_CATEGORY=1; EXPR$1=31040"}).queryContains(DruidAdapterIT.druidChecker("{\"queryType\":\"groupBy\"", "\"dimension\":\"vc\",\"outputName\":\"vc\",\"outputType\":\"LONG\"}]"));
    }
}

