/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.jdbc;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.calcite.adapter.jdbc.JdbcConvention;
import org.apache.calcite.adapter.jdbc.JdbcImplementor;
import org.apache.calcite.adapter.jdbc.JdbcRel;
import org.apache.calcite.adapter.jdbc.JdbcToEnumerableConverterRule;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Intersect;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Minus;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rel2sql.SqlImplementor;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexMultisetUtil;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.schema.ModifiableTable;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.trace.CalciteTrace;
import org.slf4j.Logger;

public class JdbcRules {
    protected static final Logger LOGGER = CalciteTrace.getPlannerTracer();
    static final RelFactories.ProjectFactory PROJECT_FACTORY = (input, projects, fieldNames) -> {
        RelOptCluster cluster = input.getCluster();
        RelDataType rowType = RexUtil.createStructType(cluster.getTypeFactory(), projects, fieldNames, SqlValidatorUtil.F_SUGGESTER);
        return new JdbcProject(cluster, input.getTraitSet(), input, projects, rowType);
    };
    static final RelFactories.FilterFactory FILTER_FACTORY = (input, condition) -> new JdbcFilter(input.getCluster(), input.getTraitSet(), input, condition);
    static final RelFactories.JoinFactory JOIN_FACTORY = (left, right, condition, variablesSet, joinType, semiJoinDone) -> {
        RelOptCluster cluster = left.getCluster();
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)left.getConvention());
        try {
            return new JdbcJoin(cluster, traitSet, left, right, condition, variablesSet, joinType);
        }
        catch (InvalidRelException e) {
            throw new AssertionError((Object)e);
        }
    };
    static final RelFactories.CorrelateFactory CORRELATE_FACTORY = (left, right, correlationId, requiredColumns, joinType) -> {
        throw new UnsupportedOperationException("JdbcCorrelate");
    };
    public static final RelFactories.SortFactory SORT_FACTORY = (input, collation, offset, fetch) -> {
        throw new UnsupportedOperationException("JdbcSort");
    };
    public static final RelFactories.ExchangeFactory EXCHANGE_FACTORY = (input, distribution) -> {
        throw new UnsupportedOperationException("JdbcExchange");
    };
    public static final RelFactories.SortExchangeFactory SORT_EXCHANGE_FACTORY = (input, distribution, collation) -> {
        throw new UnsupportedOperationException("JdbcSortExchange");
    };
    public static final RelFactories.AggregateFactory AGGREGATE_FACTORY = (input, groupSet, groupSets, aggCalls) -> {
        RelOptCluster cluster = input.getCluster();
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)input.getConvention());
        try {
            return new JdbcAggregate(cluster, traitSet, input, groupSet, (List<ImmutableBitSet>)groupSets, aggCalls);
        }
        catch (InvalidRelException e) {
            throw new AssertionError((Object)e);
        }
    };
    public static final RelFactories.MatchFactory MATCH_FACTORY = (input, pattern, rowType, strictStart, strictEnd, patternDefinitions, measures, after, subsets, allRows, partitionKeys, orderKeys, interval) -> {
        throw new UnsupportedOperationException("JdbcMatch");
    };
    public static final RelFactories.SetOpFactory SET_OP_FACTORY = (kind, inputs, all) -> {
        RelNode input = (RelNode)inputs.get(0);
        RelOptCluster cluster = input.getCluster();
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)input.getConvention());
        switch (kind) {
            case UNION: {
                return new JdbcUnion(cluster, traitSet, inputs, all);
            }
            case INTERSECT: {
                return new JdbcIntersect(cluster, traitSet, inputs, all);
            }
            case EXCEPT: {
                return new JdbcMinus(cluster, traitSet, inputs, all);
            }
        }
        throw new AssertionError((Object)("unknown: " + (Object)((Object)kind)));
    };
    public static final RelFactories.ValuesFactory VALUES_FACTORY = (cluster, rowType, tuples) -> {
        throw new UnsupportedOperationException();
    };
    public static final RelFactories.TableScanFactory TABLE_SCAN_FACTORY = (cluster, table) -> {
        throw new UnsupportedOperationException();
    };
    public static final RelFactories.SnapshotFactory SNAPSHOT_FACTORY = (input, period) -> {
        throw new UnsupportedOperationException();
    };
    public static final RelBuilderFactory JDBC_BUILDER = RelBuilder.proto(Contexts.of(PROJECT_FACTORY, FILTER_FACTORY, JOIN_FACTORY, SORT_FACTORY, EXCHANGE_FACTORY, SORT_EXCHANGE_FACTORY, AGGREGATE_FACTORY, MATCH_FACTORY, SET_OP_FACTORY, VALUES_FACTORY, TABLE_SCAN_FACTORY, SNAPSHOT_FACTORY));

    private JdbcRules() {
    }

    public static List<RelOptRule> rules(JdbcConvention out) {
        return JdbcRules.rules(out, RelFactories.LOGICAL_BUILDER);
    }

    public static List<RelOptRule> rules(JdbcConvention out, RelBuilderFactory relBuilderFactory) {
        return ImmutableList.of((Object)new JdbcToEnumerableConverterRule(out, relBuilderFactory), (Object)new JdbcJoinRule(out, relBuilderFactory), (Object)new JdbcCalcRule(out, relBuilderFactory), (Object)new JdbcProjectRule(out, relBuilderFactory), (Object)new JdbcFilterRule(out, relBuilderFactory), (Object)new JdbcAggregateRule(out, relBuilderFactory), (Object)new JdbcSortRule(out, relBuilderFactory), (Object)new JdbcUnionRule(out, relBuilderFactory), (Object)new JdbcIntersectRule(out, relBuilderFactory), (Object)new JdbcMinusRule(out, relBuilderFactory), (Object)new JdbcTableModificationRule(out, relBuilderFactory), (Object)new JdbcValuesRule(out, relBuilderFactory), (Object[])new RelOptRule[0]);
    }

    private static boolean canImplement(SqlAggFunction aggregation, SqlDialect sqlDialect) {
        return sqlDialect.supportsAggregateFunction(aggregation.getKind());
    }

    private static class CheckingUserDefinedFunctionVisitor
    extends RexVisitorImpl<Void> {
        private boolean containsUsedDefinedFunction = false;

        CheckingUserDefinedFunctionVisitor() {
            super(true);
        }

        public boolean containsUserDefinedFunction() {
            return this.containsUsedDefinedFunction;
        }

        @Override
        public Void visitCall(RexCall call) {
            SqlOperator operator = call.getOperator();
            if (operator instanceof SqlFunction && ((SqlFunction)operator).getFunctionType().isUserDefined()) {
                this.containsUsedDefinedFunction |= true;
            }
            return (Void)super.visitCall(call);
        }
    }

    public static class JdbcValues
    extends Values
    implements JdbcRel {
        JdbcValues(RelOptCluster cluster, RelDataType rowType, ImmutableList<ImmutableList<RexLiteral>> tuples, RelTraitSet traitSet) {
            super(cluster, rowType, tuples, traitSet);
        }

        @Override
        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            assert (inputs.isEmpty());
            return new JdbcValues(this.getCluster(), this.rowType, (ImmutableList<ImmutableList<RexLiteral>>)this.tuples, traitSet);
        }

        @Override
        public SqlImplementor.Result implement(JdbcImplementor implementor) {
            return implementor.implement(this);
        }
    }

    public static class JdbcValuesRule
    extends JdbcConverterRule {
        private JdbcValuesRule(JdbcConvention out, RelBuilderFactory relBuilderFactory) {
            super(Values.class, (? super R r) -> true, (RelTrait)Convention.NONE, out, relBuilderFactory, "JdbcValuesRule");
        }

        @Override
        public RelNode convert(RelNode rel) {
            Values values = (Values)rel;
            return new JdbcValues(values.getCluster(), values.getRowType(), values.getTuples(), values.getTraitSet().replace(this.out));
        }
    }

    public static class JdbcTableModify
    extends TableModify
    implements JdbcRel {
        private final Expression expression;

        public JdbcTableModify(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, Prepare.CatalogReader catalogReader, RelNode input, TableModify.Operation operation, List<String> updateColumnList, List<RexNode> sourceExpressionList, boolean flattened) {
            super(cluster, traitSet, table, catalogReader, input, operation, updateColumnList, sourceExpressionList, flattened);
            assert (input.getConvention() instanceof JdbcConvention);
            assert (this.getConvention() instanceof JdbcConvention);
            ModifiableTable modifiableTable = table.unwrap(ModifiableTable.class);
            if (modifiableTable == null) {
                throw new AssertionError();
            }
            this.expression = table.getExpression(Queryable.class);
            if (this.expression == null) {
                throw new AssertionError();
            }
        }

        @Override
        public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
            return super.computeSelfCost(planner, mq).multiplyBy(0.1);
        }

        @Override
        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            return new JdbcTableModify(this.getCluster(), traitSet, this.getTable(), this.getCatalogReader(), JdbcTableModify.sole(inputs), this.getOperation(), this.getUpdateColumnList(), this.getSourceExpressionList(), this.isFlattened());
        }

        @Override
        public SqlImplementor.Result implement(JdbcImplementor implementor) {
            return implementor.implement(this);
        }
    }

    public static class JdbcTableModificationRule
    extends JdbcConverterRule {
        private JdbcTableModificationRule(JdbcConvention out, RelBuilderFactory relBuilderFactory) {
            super(TableModify.class, (? super R r) -> true, (RelTrait)Convention.NONE, out, relBuilderFactory, "JdbcTableModificationRule");
        }

        @Override
        public RelNode convert(RelNode rel) {
            TableModify modify = (TableModify)rel;
            ModifiableTable modifiableTable = modify.getTable().unwrap(ModifiableTable.class);
            if (modifiableTable == null) {
                return null;
            }
            RelTraitSet traitSet = modify.getTraitSet().replace(this.out);
            return new JdbcTableModify(modify.getCluster(), traitSet, modify.getTable(), modify.getCatalogReader(), JdbcTableModificationRule.convert(modify.getInput(), traitSet), modify.getOperation(), modify.getUpdateColumnList(), modify.getSourceExpressionList(), modify.isFlattened());
        }
    }

    public static class JdbcMinus
    extends Minus
    implements JdbcRel {
        public JdbcMinus(RelOptCluster cluster, RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            super(cluster, traitSet, inputs, all);
            assert (!all);
        }

        @Override
        public JdbcMinus copy(RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            return new JdbcMinus(this.getCluster(), traitSet, inputs, all);
        }

        @Override
        public SqlImplementor.Result implement(JdbcImplementor implementor) {
            return implementor.implement(this);
        }
    }

    public static class JdbcMinusRule
    extends JdbcConverterRule {
        private JdbcMinusRule(JdbcConvention out, RelBuilderFactory relBuilderFactory) {
            super(Minus.class, (? super R r) -> true, (RelTrait)Convention.NONE, out, relBuilderFactory, "JdbcMinusRule");
        }

        @Override
        public RelNode convert(RelNode rel) {
            Minus minus = (Minus)rel;
            if (minus.all) {
                return null;
            }
            RelTraitSet traitSet = rel.getTraitSet().replace(this.out);
            return new JdbcMinus(rel.getCluster(), traitSet, JdbcMinusRule.convertList(minus.getInputs(), this.out), false);
        }
    }

    public static class JdbcIntersect
    extends Intersect
    implements JdbcRel {
        public JdbcIntersect(RelOptCluster cluster, RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            super(cluster, traitSet, inputs, all);
            assert (!all);
        }

        @Override
        public JdbcIntersect copy(RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            return new JdbcIntersect(this.getCluster(), traitSet, inputs, all);
        }

        @Override
        public SqlImplementor.Result implement(JdbcImplementor implementor) {
            return implementor.implement(this);
        }
    }

    public static class JdbcIntersectRule
    extends JdbcConverterRule {
        private JdbcIntersectRule(JdbcConvention out, RelBuilderFactory relBuilderFactory) {
            super(Intersect.class, (? super R r) -> true, (RelTrait)Convention.NONE, out, relBuilderFactory, "JdbcIntersectRule");
        }

        @Override
        public RelNode convert(RelNode rel) {
            Intersect intersect = (Intersect)rel;
            if (intersect.all) {
                return null;
            }
            RelTraitSet traitSet = intersect.getTraitSet().replace(this.out);
            return new JdbcIntersect(rel.getCluster(), traitSet, JdbcIntersectRule.convertList(intersect.getInputs(), this.out), false);
        }
    }

    public static class JdbcUnion
    extends Union
    implements JdbcRel {
        public JdbcUnion(RelOptCluster cluster, RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            super(cluster, traitSet, inputs, all);
        }

        @Override
        public JdbcUnion copy(RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            return new JdbcUnion(this.getCluster(), traitSet, inputs, all);
        }

        @Override
        public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
            return super.computeSelfCost(planner, mq).multiplyBy(0.1);
        }

        @Override
        public SqlImplementor.Result implement(JdbcImplementor implementor) {
            return implementor.implement(this);
        }
    }

    public static class JdbcUnionRule
    extends JdbcConverterRule {
        @Deprecated
        public JdbcUnionRule(JdbcConvention out) {
            this(out, RelFactories.LOGICAL_BUILDER);
        }

        public JdbcUnionRule(JdbcConvention out, RelBuilderFactory relBuilderFactory) {
            super(Union.class, (? super R r) -> true, (RelTrait)Convention.NONE, out, relBuilderFactory, "JdbcUnionRule");
        }

        @Override
        public RelNode convert(RelNode rel) {
            Union union = (Union)rel;
            RelTraitSet traitSet = union.getTraitSet().replace(this.out);
            return new JdbcUnion(rel.getCluster(), traitSet, JdbcUnionRule.convertList(union.getInputs(), this.out), union.all);
        }
    }

    public static class JdbcSort
    extends Sort
    implements JdbcRel {
        public JdbcSort(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RelCollation collation, RexNode offset, RexNode fetch) {
            super(cluster, traitSet, input, collation, offset, fetch);
            assert (this.getConvention() instanceof JdbcConvention);
            assert (this.getConvention() == input.getConvention());
        }

        @Override
        public JdbcSort copy(RelTraitSet traitSet, RelNode newInput, RelCollation newCollation, RexNode offset, RexNode fetch) {
            return new JdbcSort(this.getCluster(), traitSet, newInput, newCollation, offset, fetch);
        }

        @Override
        public SqlImplementor.Result implement(JdbcImplementor implementor) {
            return implementor.implement(this);
        }
    }

    public static class JdbcSortRule
    extends JdbcConverterRule {
        @Deprecated
        public JdbcSortRule(JdbcConvention out) {
            this(out, RelFactories.LOGICAL_BUILDER);
        }

        public JdbcSortRule(JdbcConvention out, RelBuilderFactory relBuilderFactory) {
            super(Sort.class, (? super R r) -> true, (RelTrait)Convention.NONE, out, relBuilderFactory, "JdbcSortRule");
        }

        @Override
        public RelNode convert(RelNode rel) {
            return this.convert((Sort)rel, true);
        }

        public RelNode convert(Sort sort, boolean convertInputTraits) {
            RelTraitSet traitSet = sort.getTraitSet().replace(this.out);
            RelNode input = convertInputTraits ? JdbcSortRule.convert(sort.getInput(), traitSet) : sort.getInput();
            return new JdbcSort(sort.getCluster(), traitSet, input, sort.getCollation(), sort.offset, sort.fetch);
        }
    }

    public static class JdbcAggregate
    extends Aggregate
    implements JdbcRel {
        public JdbcAggregate(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) throws InvalidRelException {
            super(cluster, traitSet, input, groupSet, groupSets, aggCalls);
            assert (this.getConvention() instanceof JdbcConvention);
            assert (this.groupSets.size() == 1) : "Grouping sets not supported";
            SqlDialect dialect = ((JdbcConvention)this.getConvention()).dialect;
            for (AggregateCall aggCall : aggCalls) {
                if (JdbcRules.canImplement(aggCall.getAggregation(), dialect)) continue;
                throw new InvalidRelException("cannot implement aggregate function " + aggCall.getAggregation());
            }
        }

        @Deprecated
        public JdbcAggregate(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, boolean indicator, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) throws InvalidRelException {
            this(cluster, traitSet, input, groupSet, groupSets, aggCalls);
            JdbcAggregate.checkIndicator(indicator);
        }

        @Override
        public JdbcAggregate copy(RelTraitSet traitSet, RelNode input, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
            try {
                return new JdbcAggregate(this.getCluster(), traitSet, input, groupSet, groupSets, aggCalls);
            }
            catch (InvalidRelException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public SqlImplementor.Result implement(JdbcImplementor implementor) {
            return implementor.implement(this);
        }
    }

    public static class JdbcAggregateRule
    extends JdbcConverterRule {
        @Deprecated
        public JdbcAggregateRule(JdbcConvention out) {
            this(out, RelFactories.LOGICAL_BUILDER);
        }

        public JdbcAggregateRule(JdbcConvention out, RelBuilderFactory relBuilderFactory) {
            super(Aggregate.class, (? super R r) -> true, (RelTrait)Convention.NONE, out, relBuilderFactory, "JdbcAggregateRule");
        }

        @Override
        public RelNode convert(RelNode rel) {
            Aggregate agg = (Aggregate)rel;
            if (agg.getGroupSets().size() != 1) {
                return null;
            }
            RelTraitSet traitSet = agg.getTraitSet().replace(this.out);
            try {
                return new JdbcAggregate(rel.getCluster(), traitSet, JdbcAggregateRule.convert(agg.getInput(), this.out), false, agg.getGroupSet(), (List<ImmutableBitSet>)agg.getGroupSets(), agg.getAggCallList());
            }
            catch (InvalidRelException e) {
                LOGGER.debug(e.toString());
                return null;
            }
        }
    }

    public static class JdbcFilter
    extends Filter
    implements JdbcRel {
        public JdbcFilter(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RexNode condition) {
            super(cluster, traitSet, input, condition);
            assert (this.getConvention() instanceof JdbcConvention);
        }

        @Override
        public JdbcFilter copy(RelTraitSet traitSet, RelNode input, RexNode condition) {
            return new JdbcFilter(this.getCluster(), traitSet, input, condition);
        }

        @Override
        public SqlImplementor.Result implement(JdbcImplementor implementor) {
            return implementor.implement(this);
        }
    }

    public static class JdbcFilterRule
    extends JdbcConverterRule {
        @Deprecated
        public JdbcFilterRule(JdbcConvention out) {
            this(out, RelFactories.LOGICAL_BUILDER);
        }

        public JdbcFilterRule(JdbcConvention out, RelBuilderFactory relBuilderFactory) {
            super(Filter.class, (? super R r) -> !JdbcFilterRule.userDefinedFunctionInFilter(r), (RelTrait)Convention.NONE, out, relBuilderFactory, "JdbcFilterRule");
        }

        private static boolean userDefinedFunctionInFilter(Filter filter) {
            CheckingUserDefinedFunctionVisitor visitor = new CheckingUserDefinedFunctionVisitor();
            filter.getCondition().accept(visitor);
            return visitor.containsUserDefinedFunction();
        }

        @Override
        public RelNode convert(RelNode rel) {
            Filter filter = (Filter)rel;
            return new JdbcFilter(rel.getCluster(), rel.getTraitSet().replace(this.out), JdbcFilterRule.convert(filter.getInput(), filter.getInput().getTraitSet().replace(this.out)), filter.getCondition());
        }
    }

    public static class JdbcProject
    extends Project
    implements JdbcRel {
        public JdbcProject(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, List<? extends RexNode> projects, RelDataType rowType) {
            super(cluster, traitSet, input, projects, rowType);
            assert (this.getConvention() instanceof JdbcConvention);
        }

        @Deprecated
        public JdbcProject(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, List<RexNode> projects, RelDataType rowType, int flags) {
            this(cluster, traitSet, input, projects, rowType);
            Util.discard(flags);
        }

        @Override
        public JdbcProject copy(RelTraitSet traitSet, RelNode input, List<RexNode> projects, RelDataType rowType) {
            return new JdbcProject(this.getCluster(), traitSet, input, projects, rowType);
        }

        @Override
        public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
            return super.computeSelfCost(planner, mq).multiplyBy(0.8);
        }

        @Override
        public SqlImplementor.Result implement(JdbcImplementor implementor) {
            return implementor.implement(this);
        }
    }

    public static class JdbcProjectRule
    extends JdbcConverterRule {
        @Deprecated
        public JdbcProjectRule(JdbcConvention out) {
            this(out, RelFactories.LOGICAL_BUILDER);
        }

        public JdbcProjectRule(JdbcConvention out, RelBuilderFactory relBuilderFactory) {
            super(Project.class, (? super R project) -> (out.dialect.supportsWindowFunctions() || !RexOver.containsOver(project.getProjects(), null)) && !JdbcProjectRule.userDefinedFunctionInProject(project), (RelTrait)Convention.NONE, out, relBuilderFactory, "JdbcProjectRule");
        }

        private static boolean userDefinedFunctionInProject(Project project) {
            CheckingUserDefinedFunctionVisitor visitor = new CheckingUserDefinedFunctionVisitor();
            for (RexNode node : project.getChildExps()) {
                node.accept(visitor);
                if (!visitor.containsUserDefinedFunction()) continue;
                return true;
            }
            return false;
        }

        @Override
        public RelNode convert(RelNode rel) {
            Project project = (Project)rel;
            return new JdbcProject(rel.getCluster(), rel.getTraitSet().replace(this.out), JdbcProjectRule.convert(project.getInput(), project.getInput().getTraitSet().replace(this.out)), project.getProjects(), project.getRowType());
        }
    }

    public static class JdbcCalc
    extends SingleRel
    implements JdbcRel {
        private final RexProgram program;

        public JdbcCalc(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RexProgram program) {
            super(cluster, traitSet, input);
            assert (this.getConvention() instanceof JdbcConvention);
            this.program = program;
            this.rowType = program.getOutputRowType();
        }

        @Deprecated
        public JdbcCalc(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RexProgram program, int flags) {
            this(cluster, traitSet, input, program);
            Util.discard(flags);
        }

        @Override
        public RelWriter explainTerms(RelWriter pw) {
            return this.program.explainCalc(super.explainTerms(pw));
        }

        @Override
        public double estimateRowCount(RelMetadataQuery mq) {
            return RelMdUtil.estimateFilteredRows(this.getInput(), this.program, mq);
        }

        @Override
        public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
            double dRows = mq.getRowCount(this);
            double dCpu = mq.getRowCount(this.getInput()) * (double)this.program.getExprCount();
            double dIo = 0.0;
            return planner.getCostFactory().makeCost(dRows, dCpu, dIo);
        }

        @Override
        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            return new JdbcCalc(this.getCluster(), traitSet, JdbcCalc.sole(inputs), this.program);
        }

        @Override
        public SqlImplementor.Result implement(JdbcImplementor implementor) {
            return implementor.implement(this);
        }
    }

    private static class JdbcCalcRule
    extends JdbcConverterRule {
        private JdbcCalcRule(JdbcConvention out, RelBuilderFactory relBuilderFactory) {
            super(Calc.class, (? super R r) -> true, (RelTrait)Convention.NONE, out, relBuilderFactory, "JdbcCalcRule");
        }

        @Override
        public RelNode convert(RelNode rel) {
            Calc calc = (Calc)rel;
            if (RexMultisetUtil.containsMultiset(calc.getProgram())) {
                return null;
            }
            return new JdbcCalc(rel.getCluster(), rel.getTraitSet().replace(this.out), JdbcCalcRule.convert(calc.getInput(), calc.getTraitSet().replace(this.out)), calc.getProgram());
        }
    }

    public static class JdbcJoin
    extends Join
    implements JdbcRel {
        public JdbcJoin(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, RexNode condition, Set<CorrelationId> variablesSet, JoinRelType joinType) throws InvalidRelException {
            super(cluster, traitSet, left, right, condition, variablesSet, joinType);
        }

        @Deprecated
        protected JdbcJoin(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, RexNode condition, JoinRelType joinType, Set<String> variablesStopped) throws InvalidRelException {
            this(cluster, traitSet, left, right, condition, (Set<CorrelationId>)CorrelationId.setOf(variablesStopped), joinType);
        }

        @Override
        public JdbcJoin copy(RelTraitSet traitSet, RexNode condition, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
            try {
                return new JdbcJoin(this.getCluster(), traitSet, left, right, condition, (Set<CorrelationId>)this.variablesSet, joinType);
            }
            catch (InvalidRelException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
            double rowCount = mq.getRowCount(this);
            return planner.getCostFactory().makeCost(rowCount, 0.0, 0.0);
        }

        @Override
        public double estimateRowCount(RelMetadataQuery mq) {
            double leftRowCount = this.left.estimateRowCount(mq);
            double rightRowCount = this.right.estimateRowCount(mq);
            return Math.max(leftRowCount, rightRowCount);
        }

        @Override
        public SqlImplementor.Result implement(JdbcImplementor implementor) {
            return implementor.implement(this);
        }
    }

    public static class JdbcJoinRule
    extends JdbcConverterRule {
        @Deprecated
        public JdbcJoinRule(JdbcConvention out) {
            this(out, RelFactories.LOGICAL_BUILDER);
        }

        public JdbcJoinRule(JdbcConvention out, RelBuilderFactory relBuilderFactory) {
            super(Join.class, (? super R r) -> true, (RelTrait)Convention.NONE, out, relBuilderFactory, "JdbcJoinRule");
        }

        @Override
        public RelNode convert(RelNode rel) {
            Join join = (Join)rel;
            switch (join.getJoinType()) {
                case SEMI: 
                case ANTI: {
                    return null;
                }
            }
            return this.convert(join, true);
        }

        public RelNode convert(Join join, boolean convertInputTraits) {
            ArrayList<RelNode> newInputs = new ArrayList<RelNode>();
            for (RelNode input : join.getInputs()) {
                if (convertInputTraits && input.getConvention() != this.getOutTrait()) {
                    input = JdbcJoinRule.convert(input, input.getTraitSet().replace(this.out));
                }
                newInputs.add(input);
            }
            if (convertInputTraits && !this.canJoinOnCondition(join.getCondition())) {
                return null;
            }
            try {
                return new JdbcJoin(join.getCluster(), join.getTraitSet().replace(this.out), (RelNode)newInputs.get(0), (RelNode)newInputs.get(1), join.getCondition(), join.getVariablesSet(), join.getJoinType());
            }
            catch (InvalidRelException e) {
                LOGGER.debug(e.toString());
                return null;
            }
        }

        private boolean canJoinOnCondition(RexNode node) {
            switch (node.getKind()) {
                case AND: 
                case OR: {
                    List<RexNode> operands = ((RexCall)node).getOperands();
                    for (RexNode operand : operands) {
                        if (this.canJoinOnCondition(operand)) continue;
                        return false;
                    }
                    return true;
                }
                case EQUALS: 
                case IS_NOT_DISTINCT_FROM: 
                case NOT_EQUALS: 
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL: 
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: {
                    List<RexNode> operands = ((RexCall)node).getOperands();
                    if (!(operands.get(0) instanceof RexInputRef) || !(operands.get(1) instanceof RexInputRef)) break;
                    return true;
                }
            }
            return false;
        }
    }

    static abstract class JdbcConverterRule
    extends ConverterRule {
        protected final JdbcConvention out;

        @Deprecated
        JdbcConverterRule(Class<? extends RelNode> clazz, RelTrait in, JdbcConvention out, String description) {
            this(clazz, (? super R r) -> true, in, out, RelFactories.LOGICAL_BUILDER, description);
        }

        <R extends RelNode> JdbcConverterRule(Class<R> clazz, Predicate<? super R> predicate, RelTrait in, JdbcConvention out, RelBuilderFactory relBuilderFactory, String description) {
            super(clazz, predicate, in, (RelTrait)out, relBuilderFactory, description);
            this.out = out;
        }

        @Deprecated
        <R extends RelNode> JdbcConverterRule(Class<R> clazz, com.google.common.base.Predicate<? super R> predicate, RelTrait in, JdbcConvention out, RelBuilderFactory relBuilderFactory, String description) {
            this(clazz, (Predicate)predicate, in, out, relBuilderFactory, description);
        }
    }
}

