/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.tools;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableTableScan;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptAbstractTable;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.volcano.AbstractConverter;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelDistributionTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelDataTypeSystemImpl;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.ModifiableTable;
import org.apache.calcite.schema.Path;
import org.apache.calcite.schema.ProjectableFilterableTable;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Statistics;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.calcite.server.CalciteServerStatement;
import org.apache.calcite.sql.SqlExplainFormat;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.dialect.AnsiSqlDialect;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.Planner;
import org.apache.calcite.tools.Program;
import org.apache.calcite.tools.Programs;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelConversionException;
import org.apache.calcite.tools.RelRunner;
import org.apache.calcite.tools.RuleSet;
import org.apache.calcite.tools.RuleSets;
import org.apache.calcite.tools.ValidationException;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.TestUtil;
import org.apache.calcite.util.Util;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class FrameworksTest {
    @Test
    public void testOptimize() {
        RelNode x = (RelNode)Frameworks.withPlanner((cluster, relOptSchema, rootSchema) -> {
            LogicalFilter filter;
            RelDataTypeFactory typeFactory = cluster.getTypeFactory();
            AbstractTable table = new AbstractTable(){

                public RelDataType getRowType(RelDataTypeFactory typeFactory) {
                    RelDataType stringType = typeFactory.createJavaType(String.class);
                    RelDataType integerType = typeFactory.createJavaType(Integer.class);
                    return typeFactory.builder().add("s", stringType).add("i", integerType).build();
                }
            };
            RelOptAbstractTable relOptTable = new RelOptAbstractTable(relOptSchema, "myTable", table.getRowType(typeFactory)){};
            EnumerableTableScan tableRel = EnumerableTableScan.create((RelOptCluster)cluster, (RelOptTable)relOptTable);
            RexBuilder rexBuilder = cluster.getRexBuilder();
            RexNode condition = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{rexBuilder.makeFieldAccess(rexBuilder.makeRangeReference((RelNode)tableRel), "i", true), rexBuilder.makeExactLiteral(BigDecimal.ONE)});
            LogicalFilter rootRel = filter = LogicalFilter.create((RelNode)tableRel, (RexNode)condition);
            RelOptPlanner planner = cluster.getPlanner();
            RelTraitSet desiredTraits = cluster.traitSet().replace((RelTrait)EnumerableConvention.INSTANCE);
            RelNode rootRel2 = planner.changeTraits((RelNode)rootRel, desiredTraits);
            planner.setRoot(rootRel2);
            return planner.findBestExp();
        });
        String s = RelOptUtil.dumpPlan((String)"", (RelNode)x, (SqlExplainFormat)SqlExplainFormat.TEXT, (SqlExplainLevel)SqlExplainLevel.DIGEST_ATTRIBUTES);
        Assert.assertThat((Object)Util.toLinux((String)s), (Matcher)CoreMatchers.equalTo((Object)"EnumerableFilter(condition=[>($1, 1)])\n  EnumerableTableScan(table=[[myTable]])\n"));
    }

    @Test
    public void testCreateRootSchemaWithNoMetadataSchema() {
        SchemaPlus rootSchema = Frameworks.createRootSchema((boolean)false);
        Assert.assertThat((Object)rootSchema.getSubSchemaNames().size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void testTypeSystem() {
        this.checkTypeSystem(19, Frameworks.newConfigBuilder().build());
        this.checkTypeSystem(25, Frameworks.newConfigBuilder().typeSystem(HiveLikeTypeSystem.INSTANCE).build());
        this.checkTypeSystem(31, Frameworks.newConfigBuilder().typeSystem((RelDataTypeSystem)new HiveLikeTypeSystem2()).build());
    }

    private void checkTypeSystem(final int expected, FrameworkConfig config) {
        Frameworks.withPrepare((Frameworks.PrepareAction)new Frameworks.PrepareAction<Void>(config){

            public Void apply(RelOptCluster cluster, RelOptSchema relOptSchema, SchemaPlus rootSchema, CalciteServerStatement statement) {
                RelDataType type = cluster.getTypeFactory().createSqlType(SqlTypeName.DECIMAL, 30, 2);
                RexLiteral literal = cluster.getRexBuilder().makeExactLiteral(BigDecimal.ONE, type);
                RexNode call = cluster.getRexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{literal, literal});
                Assert.assertEquals((long)expected, (long)call.getType().getPrecision());
                return null;
            }
        });
    }

    @Test
    public void testFrameworksValidatorWithIdentifierExpansion() throws Exception {
        SchemaPlus rootSchema = Frameworks.createRootSchema((boolean)true);
        FrameworkConfig config = Frameworks.newConfigBuilder().defaultSchema(CalciteAssert.addSchema(rootSchema, CalciteAssert.SchemaSpec.HR)).build();
        Planner planner = Frameworks.getPlanner((FrameworkConfig)config);
        SqlNode parse = planner.parse("select * from \"emps\" ");
        SqlNode val = planner.validate(parse);
        String valStr = val.toSqlString(AnsiSqlDialect.DEFAULT, false).getSql();
        String expandedStr = "SELECT `emps`.`empid`, `emps`.`deptno`, `emps`.`name`, `emps`.`salary`, `emps`.`commission`\nFROM `hr`.`emps` AS `emps`";
        Assert.assertThat((Object)Util.toLinux((String)valStr), (Matcher)CoreMatchers.equalTo((Object)expandedStr));
    }

    @Test
    public void testSchemaPath() {
        SchemaPlus rootSchema = Frameworks.createRootSchema((boolean)true);
        FrameworkConfig config = Frameworks.newConfigBuilder().defaultSchema(CalciteAssert.addSchema(rootSchema, CalciteAssert.SchemaSpec.HR)).build();
        Path path = Schemas.path((SchemaPlus)config.getDefaultSchema());
        Assert.assertThat((Object)path.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((Pair)path.get((int)0)).left, (Matcher)CoreMatchers.is((Object)""));
        Assert.assertThat((Object)((Pair)path.get((int)1)).left, (Matcher)CoreMatchers.is((Object)"hr"));
        Assert.assertThat((Object)path.names().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat(path.names().get(0), (Matcher)CoreMatchers.is((Object)"hr"));
        Assert.assertThat((Object)path.schemas().size(), (Matcher)CoreMatchers.is((Object)2));
        Path parent = path.parent();
        Assert.assertThat((Object)parent.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)parent.names().size(), (Matcher)CoreMatchers.is((Object)0));
        Path grandparent = parent.parent();
        Assert.assertThat((Object)grandparent.size(), (Matcher)CoreMatchers.is((Object)0));
        try {
            Path o = grandparent.parent();
            Assert.fail((String)("expected exception, got " + o));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testJdbcValues() throws Exception {
        CalciteAssert.that().with(CalciteAssert.SchemaSpec.JDBC_SCOTT).doWithConnection(connection -> {
            try {
                FrameworkConfig config = Frameworks.newConfigBuilder().defaultSchema(connection.getRootSchema()).build();
                RelBuilder builder = RelBuilder.create((FrameworkConfig)config);
                RelRunner runner = (RelRunner)connection.unwrap(RelRunner.class);
                RelNode values = builder.values(new String[]{"a", "b"}, new Object[]{"X", 1, "Y", 2}).project(new RexNode[]{builder.field("a")}).build();
                RelNode scan = builder.scan(new String[]{"JDBC_SCOTT", "EMP"}).build();
                runner.prepare(scan).executeQuery();
                builder.clear();
                RelRunner runner2 = (RelRunner)connection.unwrap(RelRunner.class);
                runner2.prepare(values).executeQuery();
            }
            catch (Exception e) {
                throw TestUtil.rethrow(e);
            }
        });
    }

    @Test
    public void testUpdate() throws Exception {
        TableImpl table = new TableImpl();
        SchemaPlus rootSchema = Frameworks.createRootSchema((boolean)true);
        SchemaPlus schema = rootSchema.add("x", (Schema)new AbstractSchema());
        schema.add("MYTABLE", (Table)table);
        ArrayList<Object> traitDefs = new ArrayList<Object>();
        traitDefs.add(ConventionTraitDef.INSTANCE);
        traitDefs.add(RelDistributionTraitDef.INSTANCE);
        SqlParser.Config parserConfig = SqlParser.configBuilder((SqlParser.Config)SqlParser.Config.DEFAULT).setCaseSensitive(false).build();
        FrameworkConfig config = Frameworks.newConfigBuilder().parserConfig(parserConfig).defaultSchema(schema).traitDefs(traitDefs).ruleSets(new RuleSet[]{RuleSets.ofList((RelOptRule[])new RelOptRule[]{AbstractConverter.ExpandConversionRule.INSTANCE})}).programs(new Program[]{Programs.ofRules((Iterable)Programs.RULE_SET)}).build();
        this.executeQuery(config, " UPDATE MYTABLE set id=7 where id=1", (Boolean)CalciteSystemProperty.DEBUG.value());
    }

    private void executeQuery(FrameworkConfig config, String query, boolean debug) throws RelConversionException, SqlParseException, ValidationException {
        Planner planner = Frameworks.getPlanner((FrameworkConfig)config);
        if (debug) {
            System.out.println("Query:" + query);
        }
        SqlNode n = planner.parse(query);
        n = planner.validate(n);
        RelNode root = planner.rel(n).project();
        if (debug) {
            System.out.println(RelOptUtil.dumpPlan((String)"-- Logical Plan", (RelNode)root, (SqlExplainFormat)SqlExplainFormat.TEXT, (SqlExplainLevel)SqlExplainLevel.DIGEST_ATTRIBUTES));
        }
        RelOptCluster cluster = root.getCluster();
        RelOptPlanner optPlanner = cluster.getPlanner();
        RelTraitSet desiredTraits = cluster.traitSet().replace((RelTrait)EnumerableConvention.INSTANCE);
        RelNode newRoot = optPlanner.changeTraits(root, desiredTraits);
        if (debug) {
            System.out.println(RelOptUtil.dumpPlan((String)"-- Mid Plan", (RelNode)newRoot, (SqlExplainFormat)SqlExplainFormat.TEXT, (SqlExplainLevel)SqlExplainLevel.DIGEST_ATTRIBUTES));
        }
        optPlanner.setRoot(newRoot);
        RelNode bestExp = optPlanner.findBestExp();
        if (debug) {
            System.out.println(RelOptUtil.dumpPlan((String)"-- Best Plan", (RelNode)bestExp, (SqlExplainFormat)SqlExplainFormat.TEXT, (SqlExplainLevel)SqlExplainLevel.DIGEST_ATTRIBUTES));
        }
    }

    public static class HiveLikeTypeSystem2
    extends RelDataTypeSystemImpl {
        public int getMaxNumericPrecision() {
            assert (super.getMaxNumericPrecision() == 19);
            return 38;
        }
    }

    public static class HiveLikeTypeSystem
    extends RelDataTypeSystemImpl {
        public static final RelDataTypeSystem INSTANCE = new HiveLikeTypeSystem();

        private HiveLikeTypeSystem() {
        }

        public int getMaxNumericPrecision() {
            assert (super.getMaxNumericPrecision() == 19);
            return 25;
        }
    }

    private static class TableImpl
    extends AbstractTable
    implements ModifiableTable,
    ProjectableFilterableTable {
        TableImpl() {
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return typeFactory.builder().add("id", typeFactory.createSqlType(SqlTypeName.INTEGER)).add("name", typeFactory.createSqlType(SqlTypeName.INTEGER)).build();
        }

        public Statistic getStatistic() {
            return Statistics.of((double)15.0, (List)ImmutableList.of((Object)ImmutableBitSet.of((int[])new int[]{0})), (List)ImmutableList.of());
        }

        public Enumerable<Object[]> scan(DataContext root, List<RexNode> filters, int[] projects) {
            throw new UnsupportedOperationException();
        }

        public Collection getModifiableCollection() {
            throw new UnsupportedOperationException();
        }

        public TableModify toModificationRel(RelOptCluster cluster, RelOptTable table, Prepare.CatalogReader catalogReader, RelNode child, TableModify.Operation operation, List<String> updateColumnList, List<RexNode> sourceExpressionList, boolean flattened) {
            return LogicalTableModify.create((RelOptTable)table, (Prepare.CatalogReader)catalogReader, (RelNode)child, (TableModify.Operation)operation, updateColumnList, sourceExpressionList, (boolean)flattened);
        }

        public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
            throw new UnsupportedOperationException();
        }

        public Type getElementType() {
            return Object.class;
        }

        public Expression getExpression(SchemaPlus schema, String tableName, Class clazz) {
            throw new UnsupportedOperationException();
        }
    }
}

