/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test.fuzzer;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;

public class RexToTestCodeShuttle
extends RexVisitorImpl<String> {
    private static final Map<SqlOperator, String> OP_METHODS = ImmutableMap.builder().put((Object)SqlStdOperatorTable.AND, (Object)"and").put((Object)SqlStdOperatorTable.OR, (Object)"or").put((Object)SqlStdOperatorTable.CASE, (Object)"case_").put((Object)SqlStdOperatorTable.COALESCE, (Object)"coalesce").put((Object)SqlStdOperatorTable.IS_NULL, (Object)"isNull").put((Object)SqlStdOperatorTable.IS_NOT_NULL, (Object)"isNotNull").put((Object)SqlStdOperatorTable.IS_UNKNOWN, (Object)"isUnknown").put((Object)SqlStdOperatorTable.IS_TRUE, (Object)"isTrue").put((Object)SqlStdOperatorTable.IS_NOT_TRUE, (Object)"isNotTrue").put((Object)SqlStdOperatorTable.IS_FALSE, (Object)"isFalse").put((Object)SqlStdOperatorTable.IS_NOT_FALSE, (Object)"isNotFalse").put((Object)SqlStdOperatorTable.IS_DISTINCT_FROM, (Object)"isDistinctFrom").put((Object)SqlStdOperatorTable.IS_NOT_DISTINCT_FROM, (Object)"isNotDistinctFrom").put((Object)SqlStdOperatorTable.NULLIF, (Object)"nullIf").put((Object)SqlStdOperatorTable.NOT, (Object)"not").put((Object)SqlStdOperatorTable.GREATER_THAN, (Object)"gt").put((Object)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, (Object)"ge").put((Object)SqlStdOperatorTable.LESS_THAN, (Object)"lt").put((Object)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Object)"le").put((Object)SqlStdOperatorTable.EQUALS, (Object)"eq").put((Object)SqlStdOperatorTable.NOT_EQUALS, (Object)"ne").put((Object)SqlStdOperatorTable.PLUS, (Object)"plus").put((Object)SqlStdOperatorTable.UNARY_PLUS, (Object)"unaryPlus").put((Object)SqlStdOperatorTable.MINUS, (Object)"sub").put((Object)SqlStdOperatorTable.UNARY_MINUS, (Object)"unaryMinus").put((Object)SqlStdOperatorTable.MULTIPLY, (Object)"mul").build();

    protected RexToTestCodeShuttle() {
        super(true);
    }

    public String visitCall(RexCall call) {
        SqlOperator operator = call.getOperator();
        String method = OP_METHODS.get(operator);
        StringBuilder sb = new StringBuilder();
        if (method != null) {
            sb.append(method);
            sb.append('(');
        } else {
            sb.append("rexBuilder.makeCall(");
            sb.append("SqlStdOperatorTable.");
            sb.append(operator.getName().replace(' ', '_'));
            sb.append(", ");
        }
        List operands = call.getOperands();
        for (int i = 0; i < operands.size(); ++i) {
            RexNode operand = (RexNode)operands.get(i);
            if (i > 0) {
                sb.append(", ");
            }
            sb.append((String)operand.accept((RexVisitor)this));
        }
        sb.append(')');
        return sb.toString();
    }

    public String visitLiteral(RexLiteral literal) {
        RelDataType type = literal.getType();
        if (type.getSqlTypeName() == SqlTypeName.BOOLEAN) {
            if (literal.isNull()) {
                return "nullBool";
            }
            return literal.toString() + "Literal";
        }
        if (type.getSqlTypeName() == SqlTypeName.INTEGER) {
            if (literal.isNull()) {
                return "nullInt";
            }
            return "literal(" + literal.getValue() + ")";
        }
        if (type.getSqlTypeName() == SqlTypeName.VARCHAR && literal.isNull()) {
            return "nullVarchar";
        }
        return "/*" + literal.getTypeName().getName() + "*/" + literal.toString();
    }

    public String visitFieldAccess(RexFieldAccess fieldAccess) {
        StringBuilder sb = new StringBuilder();
        sb.append("v");
        RelDataType type = fieldAccess.getType();
        switch (type.getSqlTypeName()) {
            case BOOLEAN: {
                sb.append("Bool");
                break;
            }
            case INTEGER: {
                sb.append("Int");
                break;
            }
            case VARCHAR: {
                sb.append("Varchar");
            }
        }
        if (!type.isNullable()) {
            sb.append("NotNull");
        }
        sb.append("(");
        sb.append(fieldAccess.getField().getIndex() % 10);
        sb.append(")");
        return sb.toString();
    }
}

