/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test.fuzzer;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.Random;
import javax.annotation.Nonnull;
import org.apache.calcite.plan.Strong;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUnknownAs;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.test.RexProgramBuilderBase;
import org.apache.calcite.test.fuzzer.RexFuzzer;
import org.apache.calcite.test.fuzzer.RexToTestCodeShuttle;
import org.apache.calcite.test.fuzzer.SimplifyTask;
import org.apache.calcite.util.ImmutableBitSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RexProgramFuzzyTest
extends RexProgramBuilderBase {
    protected static final Logger LOGGER = LoggerFactory.getLogger(RexProgramFuzzyTest.class);
    private static final Duration TEST_DURATION = Duration.of(Integer.getInteger("rex.fuzzing.duration", 5).intValue(), ChronoUnit.SECONDS);
    private static final long TEST_ITERATIONS = Long.getLong("rex.fuzzing.iterations", 18L);
    private static final int MAX_FAILURES = Integer.getInteger("rex.fuzzing.max.failures", 1);
    private static final int TOPN_SLOWEST = Integer.getInteger("rex.fuzzing.max.slowest", 0);
    private static final long SEED = Long.getLong("rex.fuzzing.seed", 44L);
    private static final long DEFAULT_FUZZ_TEST_SEED = Long.getLong("rex.fuzzing.default.seed", 0L);
    private static final Duration DEFAULT_FUZZ_TEST_DURATION = Duration.of(Integer.getInteger("rex.fuzzing.default.duration", 5).intValue(), ChronoUnit.SECONDS);
    private static final long DEFAULT_FUZZ_TEST_ITERATIONS = Long.getLong("rex.fuzzing.default.iterations", 0L);
    private static final boolean DEFAULT_FUZZ_TEST_FAIL = Boolean.getBoolean("rex.fuzzing.default.fail");
    private PriorityQueue<SimplifyTask> slowestTasks;
    private long currentSeed = 0L;
    private static final Strong STRONG = Strong.of((ImmutableBitSet)ImmutableBitSet.of());

    @Override
    @Before
    public void setUp() {
        super.setUp();
    }

    @Test
    public void testNestedCalls() {
        this.nestedCalls((RexNode)this.trueLiteral);
        this.nestedCalls((RexNode)this.falseLiteral);
        this.nestedCalls((RexNode)this.nullBool);
        this.nestedCalls(this.vBool());
        this.nestedCalls(this.vBoolNotNull());
    }

    private void nestedCalls(RexNode arg) {
        SqlOperator[] operators;
        for (SqlOperator op1 : operators = new SqlOperator[]{SqlStdOperatorTable.NOT, SqlStdOperatorTable.IS_FALSE, SqlStdOperatorTable.IS_NOT_FALSE, SqlStdOperatorTable.IS_TRUE, SqlStdOperatorTable.IS_NOT_TRUE, SqlStdOperatorTable.IS_NULL, SqlStdOperatorTable.IS_NOT_NULL, SqlStdOperatorTable.IS_UNKNOWN, SqlStdOperatorTable.IS_NOT_UNKNOWN}) {
            RexNode n1 = this.rexBuilder.makeCall(op1, new RexNode[]{arg});
            this.checkUnknownAs(n1);
            for (SqlOperator op2 : operators) {
                RexNode n2 = this.rexBuilder.makeCall(op2, new RexNode[]{n1});
                this.checkUnknownAs(n2);
                for (SqlOperator op3 : operators) {
                    RexNode n3 = this.rexBuilder.makeCall(op3, new RexNode[]{n2});
                    this.checkUnknownAs(n3);
                    for (SqlOperator op4 : operators) {
                        RexNode n4 = this.rexBuilder.makeCall(op4, new RexNode[]{n3});
                        this.checkUnknownAs(n4);
                    }
                }
            }
        }
    }

    private void checkUnknownAs(RexNode node) {
        this.checkUnknownAs(node, RexUnknownAs.FALSE);
        this.checkUnknownAs(node, RexUnknownAs.UNKNOWN);
        this.checkUnknownAs(node, RexUnknownAs.TRUE);
    }

    private void checkUnknownAs(RexNode node, RexUnknownAs unknownAs) {
        RexNode opt;
        String uaf = this.unknownAsString(unknownAs);
        try {
            long start = System.nanoTime();
            opt = this.simplify.simplifyUnknownAs(node, unknownAs);
            long end = System.nanoTime();
            if (end - start > 1000L && this.slowestTasks != null) {
                this.slowestTasks.add(new SimplifyTask(node, this.currentSeed, opt, end - start));
            }
        }
        catch (AssertionError a) {
            String message = ((Throwable)((Object)a)).getMessage();
            if (message != null && message.startsWith("result mismatch")) {
                throw a;
            }
            throw new IllegalStateException("Unable to simplify " + uaf + RexProgramFuzzyTest.nodeToString(node), (Throwable)((Object)a));
        }
        catch (Throwable t) {
            throw new IllegalStateException("Unable to simplify " + uaf + RexProgramFuzzyTest.nodeToString(node), t);
        }
        if (this.trueLiteral.equals((Object)opt) && node.isAlwaysFalse()) {
            String msg = RexProgramFuzzyTest.nodeToString(node);
            Assert.fail((String)(msg + " optimizes to TRUE, isAlwaysFalse MUST not be true " + uaf));
        }
        if (this.falseLiteral.equals((Object)opt) && node.isAlwaysTrue()) {
            String msg = RexProgramFuzzyTest.nodeToString(node);
            Assert.fail((String)(msg + " optimizes to FALSE, isAlwaysTrue MUST not be true " + uaf));
        }
        if (STRONG.isNull(opt)) {
            if (node.isAlwaysTrue()) {
                Assert.fail((String)(RexProgramFuzzyTest.nodeToString(node) + " optimizes to NULL: " + RexProgramFuzzyTest.nodeToString(opt) + ", isAlwaysTrue MUST be FALSE " + uaf));
            }
            if (node.isAlwaysFalse()) {
                Assert.fail((String)(RexProgramFuzzyTest.nodeToString(node) + " optimizes to NULL: " + RexProgramFuzzyTest.nodeToString(opt) + ", isAlwaysFalse MUST be FALSE " + uaf));
            }
        }
        if (node.isAlwaysTrue() && !this.trueLiteral.equals((Object)opt)) {
            Assert.assertEquals((String)(RexProgramFuzzyTest.nodeToString(node) + " isAlwaysTrue, so it should simplify to TRUE " + uaf), (Object)this.trueLiteral, (Object)opt);
        }
        if (node.isAlwaysFalse() && !this.falseLiteral.equals((Object)opt)) {
            Assert.assertEquals((String)(RexProgramFuzzyTest.nodeToString(node) + " isAlwaysFalse, so it should simplify to FALSE " + uaf), (Object)this.falseLiteral, (Object)opt);
        }
        if (STRONG.isNull(node)) {
            switch (unknownAs) {
                case FALSE: {
                    if (node.getType().getSqlTypeName() == SqlTypeName.BOOLEAN) {
                        if (this.falseLiteral.equals((Object)opt)) break;
                        Assert.assertEquals((String)(RexProgramFuzzyTest.nodeToString(node) + " is always null boolean, so it should simplify to FALSE " + uaf), (Object)this.falseLiteral, (Object)opt);
                        break;
                    }
                    if (RexLiteral.isNullLiteral((RexNode)opt)) break;
                    Assert.assertEquals((String)(RexProgramFuzzyTest.nodeToString(node) + " is always null (non boolean), so it should simplify to NULL " + uaf), (Object)this.rexBuilder.makeNullLiteral(node.getType()), (Object)opt);
                    break;
                }
                case TRUE: {
                    if (node.getType().getSqlTypeName() == SqlTypeName.BOOLEAN) {
                        if (this.trueLiteral.equals((Object)opt)) break;
                        Assert.assertEquals((String)(RexProgramFuzzyTest.nodeToString(node) + " is always null boolean, so it should simplify to TRUE " + uaf), (Object)this.trueLiteral, (Object)opt);
                        break;
                    }
                    if (RexLiteral.isNullLiteral((RexNode)opt)) break;
                    Assert.assertEquals((String)(RexProgramFuzzyTest.nodeToString(node) + " is always null (non boolean), so it should simplify to NULL " + uaf), (Object)this.rexBuilder.makeNullLiteral(node.getType()), (Object)opt);
                    break;
                }
                case UNKNOWN: {
                    if (RexUtil.isNull((RexNode)opt)) break;
                    Assert.assertEquals((String)(RexProgramFuzzyTest.nodeToString(node) + " is always null, so it should simplify to NULL " + uaf), (Object)this.nullBool, (Object)opt);
                }
            }
        }
        if (unknownAs == RexUnknownAs.UNKNOWN && opt.getType().isNullable() && !node.getType().isNullable()) {
            Assert.fail((String)(RexProgramFuzzyTest.nodeToString(node) + " had non-nullable type " + opt.getType() + ", and it was optimized to " + RexProgramFuzzyTest.nodeToString(opt) + " that has nullable type " + opt.getType()));
        }
        if (!SqlTypeUtil.equalSansNullability((RelDataTypeFactory)this.typeFactory, (RelDataType)node.getType(), (RelDataType)opt.getType())) {
            Assert.assertEquals((String)(RexProgramFuzzyTest.nodeToString(node) + " has different type after simplification to " + RexProgramFuzzyTest.nodeToString(opt)), (Object)node.getType(), (Object)opt.getType());
        }
    }

    @Nonnull
    private String unknownAsString(RexUnknownAs unknownAs) {
        switch (unknownAs) {
            default: {
                return "";
            }
            case FALSE: {
                return "unknownAsFalse";
            }
            case TRUE: 
        }
        return "unknownAsTrue";
    }

    private static String nodeToString(RexNode node) {
        return node + "\n" + (String)node.accept((RexVisitor)new RexToTestCodeShuttle());
    }

    private static void trimStackTrace(Throwable t, int maxStackLines) {
        StackTraceElement[] stackTrace = t.getStackTrace();
        if (stackTrace == null || stackTrace.length <= maxStackLines) {
            return;
        }
        stackTrace = Arrays.copyOf(stackTrace, maxStackLines);
        t.setStackTrace(stackTrace);
    }

    @Test
    public void defaultFuzzTest() {
        try {
            this.runRexFuzzer(DEFAULT_FUZZ_TEST_SEED, DEFAULT_FUZZ_TEST_DURATION, 1, DEFAULT_FUZZ_TEST_ITERATIONS, 0);
        }
        catch (Throwable e) {
            for (Throwable t = e; t != null; t = t.getCause()) {
                RexProgramFuzzyTest.trimStackTrace(t, DEFAULT_FUZZ_TEST_FAIL ? 8 : 4);
            }
            if (DEFAULT_FUZZ_TEST_FAIL) {
                throw e;
            }
            LOGGER.info("Randomized test identified a potential defect. Feel free to fix that issue", e);
        }
    }

    @Test
    public void testFuzzy() {
        this.runRexFuzzer(SEED, TEST_DURATION, MAX_FAILURES, TEST_ITERATIONS, TOPN_SLOWEST);
    }

    private void runRexFuzzer(long startSeed, Duration testDuration, int maxFailures, long testIterations, int topnSlowest) {
        if (testDuration.toMillis() == 0L) {
            return;
        }
        this.slowestTasks = new TopN<SimplifyTask>(topnSlowest > 0 ? topnSlowest : 1);
        Random r = new Random();
        if (startSeed != 0L) {
            LOGGER.info("Using seed {} for rex fuzzing", (Object)startSeed);
            r.setSeed(startSeed);
        }
        long start = System.currentTimeMillis();
        long deadline = start + testDuration.toMillis();
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        HashSet<String> duplicates = new HashSet<String>();
        long total = 0L;
        int dup = 0;
        int fail = 0;
        RexFuzzer fuzzer = new RexFuzzer(this.rexBuilder, this.typeFactory);
        while (System.currentTimeMillis() < deadline && exceptions.size() < maxFailures && (testIterations == 0L || total < testIterations)) {
            long seed;
            this.currentSeed = seed = r.nextLong();
            r.setSeed(seed);
            try {
                ++total;
                this.generateRexAndCheckTrueFalse(fuzzer, r);
            }
            catch (Throwable e) {
                if (!duplicates.add(e.getMessage())) {
                    ++dup;
                    continue;
                }
                ++fail;
                StackTraceElement[] stackTrace = e.getStackTrace();
                for (int j = 0; j < stackTrace.length; ++j) {
                    if (!stackTrace[j].getClassName().endsWith("RexProgramTest")) continue;
                    e.setStackTrace(Arrays.copyOf(stackTrace, j + 1));
                    break;
                }
                e.addSuppressed(new Throwable("seed " + seed){

                    @Override
                    public synchronized Throwable fillInStackTrace() {
                        return this;
                    }
                });
                exceptions.add(e);
            }
        }
        long rate = total * 1000L / (System.currentTimeMillis() - start);
        LOGGER.info("Rex fuzzing results: number of cases tested={}, failed cases={}, duplicate failures={}, fuzz rate={} per second", new Object[]{total, fail, dup, rate});
        if (topnSlowest > 0) {
            SimplifyTask task;
            LOGGER.info("The 5 slowest to simplify nodes were");
            RexToTestCodeShuttle v = new RexToTestCodeShuttle();
            while ((task = this.slowestTasks.poll()) != null) {
                LOGGER.info(task.duration / 1000L + " us (" + task.seed + ")");
                LOGGER.info("      " + task.node.toString());
                LOGGER.info("      " + (String)task.node.accept((RexVisitor)v));
                LOGGER.info("    =>" + task.result.toString());
            }
        }
        if (exceptions.isEmpty()) {
            return;
        }
        exceptions.sort(Comparator.comparingInt(t -> t.getMessage() == null ? -1 : t.getMessage().length()).thenComparing(Throwable::getMessage));
        for (int i = 1; i < exceptions.size() && i < 100; ++i) {
            Throwable exception = (Throwable)exceptions.get(i);
            exception.printStackTrace();
        }
        Throwable ex = (Throwable)exceptions.get(0);
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        throw new RuntimeException("Exception in runRexFuzzer", ex);
    }

    private void generateRexAndCheckTrueFalse(RexFuzzer fuzzer, Random r) {
        RexNode expression = fuzzer.getExpression(r, r.nextInt(10));
        this.checkUnknownAs(expression);
    }

    @Ignore(value="This is just a scaffold for quick investigation of a single fuzz test")
    @Test
    public void singleFuzzyTest() {
        Random r = new Random();
        r.setSeed(-179916965778405462L);
        RexFuzzer fuzzer = new RexFuzzer(this.rexBuilder, this.typeFactory);
        this.generateRexAndCheckTrueFalse(fuzzer, r);
    }

    private static class TopN<E extends Comparable<E>>
    extends PriorityQueue<E> {
        private final int n;

        private TopN(int n) {
            this.n = n;
        }

        @Override
        public boolean offer(E o) {
            if (this.size() == this.n) {
                Comparable peek = (Comparable)this.peek();
                if (peek != null && peek.compareTo(o) > 0) {
                    return false;
                }
                this.poll();
            }
            return super.offer(o);
        }

        @Override
        public Iterator<E> iterator() {
            throw new UnsupportedOperationException("Order of elements is not defined, please use .peek");
        }
    }
}

