/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test.enumerable;

import java.util.Arrays;
import java.util.function.Function;
import net.jcip.annotations.NotThreadSafe;
import org.apache.calcite.adapter.java.ReflectiveSchema;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.test.HierarchySchema;
import org.apache.calcite.tools.RelBuilder;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@NotThreadSafe
public class EnumerableRepeatUnionHierarchyTest {
    private static final String EMP1 = "empid=1; name=Emp1";
    private static final String EMP2 = "empid=2; name=Emp2";
    private static final String EMP3 = "empid=3; name=Emp3";
    private static final String EMP4 = "empid=4; name=Emp4";
    private static final String EMP5 = "empid=5; name=Emp5";
    private final int startId;
    private final int maxDepth;
    private final String fromField;
    private final String toField;
    private final String[] expected;

    @Parameterized.Parameters(name="{index} : hierarchy(startId:{0}, ascendant:{1}, maxDepth:{2})")
    public static Iterable<Object[]> data() {
        return Arrays.asList({1, true, -1, new String[]{EMP1}}, {2, true, -1, new String[]{EMP2, EMP1}}, {3, true, -1, new String[]{EMP3, EMP2, EMP1}}, {4, true, -1, new String[]{EMP4, EMP1}}, {5, true, -1, new String[]{EMP5, EMP2, EMP1}}, {3, true, 0, new String[]{EMP3}}, {3, true, 1, new String[]{EMP3, EMP2}}, {3, true, 2, new String[]{EMP3, EMP2, EMP1}}, {3, true, 10, new String[]{EMP3, EMP2, EMP1}}, {1, false, -1, new String[]{EMP1, EMP2, EMP4, EMP3, EMP5}}, {2, false, -1, new String[]{EMP2, EMP3, EMP5}}, {3, false, -1, new String[]{EMP3}}, {4, false, -1, new String[]{EMP4}}, {1, false, 0, new String[]{EMP1}}, {1, false, 1, new String[]{EMP1, EMP2, EMP4}}, {1, false, 2, new String[]{EMP1, EMP2, EMP4, EMP3, EMP5}}, {1, false, 20, new String[]{EMP1, EMP2, EMP4, EMP3, EMP5}});
    }

    public EnumerableRepeatUnionHierarchyTest(int startId, boolean ascendant, int maxDepth, String[] expected) {
        this.startId = startId;
        this.maxDepth = maxDepth;
        this.expected = expected;
        if (ascendant) {
            this.fromField = "subordinateid";
            this.toField = "managerid";
        } else {
            this.fromField = "managerid";
            this.toField = "subordinateid";
        }
    }

    @Test
    public void testHierarchy() {
        ReflectiveSchema schema = new ReflectiveSchema((Object)new HierarchySchema());
        CalciteAssert.that().withSchema("s", (Schema)schema).query("?").withRel(this.hierarchy()).returnsOrdered(this.expected);
    }

    private Function<RelBuilder, RelNode> hierarchy() {
        return builder -> builder.scan(new String[]{"s", "emps"}).filter(new RexNode[]{builder.equals((RexNode)builder.field("empid"), builder.literal((Object)this.startId))}).project(new RexNode[]{builder.field("emps", "empid"), builder.field("emps", "name")}).transientScan("#DELTA#").scan(new String[]{"s", "hierarchies"}).join(JoinRelType.INNER, builder.equals(builder.field(2, "#DELTA#", "empid"), builder.field(2, "hierarchies", this.fromField))).scan(new String[]{"s", "emps"}).join(JoinRelType.INNER, builder.equals(builder.field(2, "hierarchies", this.toField), builder.field(2, "emps", "empid"))).project(new RexNode[]{builder.field("emps", "empid"), builder.field("emps", "name")}).repeatUnion("#DELTA#", true, this.maxDepth).build();
    }
}

