/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test.enumerable;

import org.apache.calcite.adapter.java.ReflectiveSchema;
import org.apache.calcite.avatica.ConnectionProperty;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.config.Lex;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.test.JdbcTest;
import org.junit.Test;

public class EnumerableJoinTest {
    @Test
    public void equiAntiJoin() {
        this.tester(false, new JdbcTest.HrSchema()).query("?").withRel(builder -> builder.scan(new String[]{"s", "depts"}).as("d").scan(new String[]{"s", "emps"}).as("e").antiJoin(new RexNode[]{builder.equals(builder.field(2, "d", "deptno"), builder.field(2, "e", "deptno"))}).project(new RexNode[]{builder.field("deptno"), builder.field("name")}).build()).returnsUnordered("deptno=30; name=Marketing", "deptno=40; name=HR");
    }

    @Test
    public void nonEquiAntiJoin() {
        this.tester(false, new JdbcTest.HrSchema()).query("?").withRel(builder -> builder.scan(new String[]{"s", "emps"}).as("e").scan(new String[]{"s", "emps"}).as("e2").antiJoin(new RexNode[]{builder.and(new RexNode[]{builder.equals(builder.field(2, "e", "deptno"), builder.field(2, "e2", "deptno")), builder.call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{builder.field(2, "e2", "salary"), builder.field(2, "e", "salary")})})}).project(new RexNode[]{builder.field("name"), builder.field("salary")}).build()).returnsUnordered("name=Theodore; salary=11500.0", "name=Eric; salary=8000.0");
    }

    @Test
    public void equiAntiJoinWithNullValues() {
        Integer salesDeptNo = 10;
        this.tester(false, new JdbcTest.HrSchema()).query("?").withRel(builder -> builder.scan(new String[]{"s", "emps"}).as("empOther").filter(new RexNode[]{builder.notEquals(builder.field("empOther", "deptno"), builder.literal((Object)salesDeptNo))}).scan(new String[]{"s", "emps"}).as("empSales").filter(new RexNode[]{builder.equals(builder.field("empSales", "deptno"), builder.literal((Object)salesDeptNo))}).antiJoin(new RexNode[]{builder.equals(builder.field(2, "empOther", "commission"), builder.field(2, "empSales", "commission"))}).project(new RexNode[]{builder.field("empid"), builder.field("name")}).build()).returnsUnordered("empid=200; name=Eric");
    }

    private CalciteAssert.AssertThat tester(boolean forceDecorrelate, Object schema) {
        return CalciteAssert.that().with((ConnectionProperty)CalciteConnectionProperty.LEX, (Object)Lex.JAVA).with((ConnectionProperty)CalciteConnectionProperty.FORCE_DECORRELATE, (Object)forceDecorrelate).withSchema("s", (Schema)new ReflectiveSchema(schema));
    }
}

